/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.preferences;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectArrayAssert;
import org.eclipse.core.internal.preferences.EclipsePreferences;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IExportedPreferences;
import org.eclipse.core.runtime.preferences.IPreferenceFilter;
import org.eclipse.core.runtime.preferences.IPreferenceNodeVisitor;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.core.runtime.preferences.PreferenceFilterEntry;
import org.eclipse.core.tests.harness.FileSystemHelper;
import org.eclipse.core.tests.internal.preferences.TestScope;
import org.junit.Assert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.osgi.service.prefs.BackingStoreException;

public class PreferencesServiceTest {
    @AfterEach
    public void tearDown() throws Exception {
        Platform.getPreferencesService().getRootNode().node("test").removeNode();
    }

    @Test
    public void testImportExportBasic() throws Exception {
        ByteArrayInputStream input;
        byte[] bytes;
        IPreferencesService service = Platform.getPreferencesService();
        String qualifier = PreferencesServiceTest.getUniqueString() + "1";
        IEclipsePreferences test = new TestScope().getNode(qualifier);
        String key = PreferencesServiceTest.getUniqueString() + "k";
        String value = PreferencesServiceTest.getUniqueString() + "v";
        String key1 = "http://eclipse.org:24";
        String value1 = PreferencesServiceTest.getUniqueString() + "v1";
        String actual = test.get(key, null);
        Assert.assertNull((String)"1.0", (Object)actual);
        test.put(key, value);
        test.put(key1, value1);
        actual = test.get(key, null);
        Assert.assertEquals((String)"1.1", (Object)value, (Object)actual);
        actual = test.get(key1, null);
        Assert.assertEquals((String)"1.2", (Object)value1, (Object)actual);
        Throwable throwable = null;
        Object var11_11 = null;
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            service.exportPreferences(test, (OutputStream)output, null);
            bytes = output.toByteArray();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        String newKey = PreferencesServiceTest.getUniqueString() + "3";
        String newValue = PreferencesServiceTest.getUniqueString() + "4";
        actual = test.get(newKey, null);
        Assert.assertNull((String)"3.0", (Object)actual);
        test.put(newKey, newValue);
        actual = test.get(newKey, null);
        Assert.assertEquals((String)"3.1", (Object)newValue, (Object)actual);
        String newOldValue = PreferencesServiceTest.getUniqueString() + "5";
        test.put(key, newOldValue);
        actual = test.get(key, null);
        Assert.assertEquals((String)"3.2", (Object)newOldValue, (Object)actual);
        Throwable throwable3 = null;
        Object var14_18 = null;
        try {
            input = new ByteArrayInputStream(bytes);
            try {
                service.importPreferences((InputStream)input);
            }
            finally {
                if (input != null) {
                    input.close();
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable3 == null) {
                throwable3 = throwable4;
            } else if (throwable3 != throwable4) {
                throwable3.addSuppressed(throwable4);
            }
            throw throwable3;
        }
        test = new TestScope().getNode(qualifier);
        actual = test.get(key, null);
        Assert.assertEquals((String)"5.0", (Object)value, (Object)actual);
        actual = test.get(key1, null);
        Assert.assertEquals((String)"5.1", (Object)value1, (Object)actual);
        actual = test.get(newKey, null);
        Assert.assertNull((String)"5.2", (Object)actual);
        Assert.assertTrue((String)"5.3", (boolean)(test instanceof EclipsePreferences));
        Assert.assertTrue((String)"5.4", (!((EclipsePreferences)test).isDirty() ? 1 : 0) != 0);
        test.clear();
        actual = test.get(key, null);
        Assert.assertNull((String)"6.1", (Object)actual);
        actual = test.get(key1, null);
        Assert.assertNull((String)"6.2", (Object)actual);
        actual = test.get(newKey, null);
        Assert.assertNull((String)"6.3", (Object)actual);
        throwable3 = null;
        var14_18 = null;
        try {
            input = new ByteArrayInputStream(bytes);
            try {
                service.importPreferences((InputStream)input);
            }
            finally {
                if (input != null) {
                    input.close();
                }
            }
        }
        catch (Throwable throwable5) {
            if (throwable3 == null) {
                throwable3 = throwable5;
            } else if (throwable3 != throwable5) {
                throwable3.addSuppressed(throwable5);
            }
            throw throwable3;
        }
        test = new TestScope().getNode(qualifier);
        actual = test.get(key, null);
        Assert.assertEquals((String)"8.0", (Object)value, (Object)actual);
        actual = test.get(key1, null);
        Assert.assertEquals((String)"8.1", (Object)value1, (Object)actual);
        actual = test.get(newKey, null);
        Assert.assertNull((String)"8.2", (Object)actual);
    }

    @Test
    public void testLookupOrder() {
        IPreferencesService service = Platform.getPreferencesService();
        Object[] defaultOrder = new String[]{"project", "instance", "configuration", "user", "default"};
        Object[] fullOrder = new String[]{"a", "b", "c"};
        Object[] nullKeyOrder = new String[]{"e", "f", "g"};
        String qualifier = PreferencesServiceTest.getUniqueString();
        String key = PreferencesServiceTest.getUniqueString();
        Assert.assertThrows(IllegalArgumentException.class, () -> PreferencesServiceTest.lambda$0(service, key, (String[])fullOrder));
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            String[] stringArray = new String[3];
            stringArray[0] = "a";
            stringArray[2] = "b";
            service.setDefaultLookupOrder(qualifier, key, stringArray);
        });
        Assertions.assertThat((Object[])service.getDefaultLookupOrder(qualifier, key)).isNull();
        Assertions.assertThat((Object[])service.getLookupOrder(qualifier, key)).containsExactly(defaultOrder);
        Assertions.assertThat((Object[])service.getDefaultLookupOrder(qualifier, null)).isNull();
        Assertions.assertThat((Object[])service.getLookupOrder(qualifier, null)).containsExactly(defaultOrder);
        service.setDefaultLookupOrder(qualifier, key, (String[])fullOrder);
        Assertions.assertThat((Object[])service.getDefaultLookupOrder(qualifier, key)).containsExactly(fullOrder);
        Assertions.assertThat((Object[])service.getLookupOrder(qualifier, key)).containsExactly(fullOrder);
        Assertions.assertThat((Object[])service.getDefaultLookupOrder(qualifier, null)).isNull();
        Assertions.assertThat((Object[])service.getLookupOrder(qualifier, null)).containsExactly(defaultOrder);
        service.setDefaultLookupOrder(qualifier, null, (String[])nullKeyOrder);
        Assertions.assertThat((Object[])service.getDefaultLookupOrder(qualifier, null)).containsExactly(nullKeyOrder);
        Assertions.assertThat((Object[])service.getLookupOrder(qualifier, null)).containsExactly(nullKeyOrder);
        Assertions.assertThat((Object[])service.getDefaultLookupOrder(qualifier, key)).containsExactly(fullOrder);
        Assertions.assertThat((Object[])service.getLookupOrder(qualifier, key)).containsExactly(fullOrder);
        service.setDefaultLookupOrder(qualifier, key, null);
        Assertions.assertThat((Object[])service.getDefaultLookupOrder(qualifier, key)).isNull();
        Assertions.assertThat((Object[])service.getLookupOrder(qualifier, key)).containsExactly(nullKeyOrder);
        service.setDefaultLookupOrder(qualifier, null, null);
        Assertions.assertThat((Object[])service.getDefaultLookupOrder(qualifier, key)).isNull();
        Assertions.assertThat((Object[])service.getLookupOrder(qualifier, key)).containsExactly(defaultOrder);
        Assertions.assertThat((Object[])service.getDefaultLookupOrder(qualifier, null)).isNull();
        Assertions.assertThat((Object[])service.getLookupOrder(qualifier, null)).containsExactly(defaultOrder);
    }

    @Test
    public void testGetWithNodes() {
        IPreferencesService service = Platform.getPreferencesService();
        String qualifier = PreferencesServiceTest.getUniqueString();
        String key = PreferencesServiceTest.getUniqueString();
        String expected = PreferencesServiceTest.getUniqueString();
        org.osgi.service.prefs.Preferences node = service.getRootNode().node("test").node(qualifier);
        String actual = node.get(key, null);
        Assert.assertNull((String)"10", (Object)actual);
        actual = service.get(key, null, new org.osgi.service.prefs.Preferences[]{node});
        Assert.assertNull((String)"2.0", (Object)actual);
        node.put(key, expected);
        actual = node.get(key, null);
        Assert.assertNotNull((String)"3.0", (Object)actual);
        Assert.assertEquals((String)"3.1", (Object)expected, (Object)actual);
        actual = service.get(key, null, new org.osgi.service.prefs.Preferences[]{node});
        Assert.assertNotNull((String)"4.0", (Object)actual);
        Assert.assertEquals((String)"4.1", (Object)expected, (Object)actual);
        actual = service.get(key, null, null);
        Assert.assertNull((String)"5.0", (Object)actual);
        org.osgi.service.prefs.Preferences[] preferencesArray = new org.osgi.service.prefs.Preferences[2];
        preferencesArray[1] = node;
        actual = service.get(key, null, preferencesArray);
        Assert.assertNotNull((String)"6.0", (Object)actual);
        Assert.assertEquals((String)"6.1", (Object)expected, (Object)actual);
        org.osgi.service.prefs.Preferences defaultNode = service.getRootNode().node("default").node(qualifier);
        String defaultValue = PreferencesServiceTest.getUniqueString();
        defaultNode.put(key, defaultValue);
        actual = defaultNode.get(key, null);
        Assert.assertNotNull((String)"7.0", (Object)actual);
        Assert.assertEquals((String)"7.1", (Object)defaultValue, (Object)actual);
        actual = service.get(key, null, new org.osgi.service.prefs.Preferences[]{node, defaultNode});
        Assert.assertNotNull((String)"8.0", (Object)actual);
        Assert.assertEquals((String)"8.1", (Object)expected, (Object)actual);
        org.osgi.service.prefs.Preferences[] preferencesArray2 = new org.osgi.service.prefs.Preferences[5];
        preferencesArray2[1] = node;
        preferencesArray2[3] = defaultNode;
        actual = service.get(key, null, preferencesArray2);
        Assert.assertNotNull((String)"8.2", (Object)actual);
        Assert.assertEquals((String)"8.3", (Object)expected, (Object)actual);
        actual = service.get(key, null, new org.osgi.service.prefs.Preferences[]{defaultNode, node});
        Assert.assertNotNull((String)"8.4", (Object)actual);
        Assert.assertEquals((String)"8.5", (Object)defaultValue, (Object)actual);
        org.osgi.service.prefs.Preferences[] preferencesArray3 = new org.osgi.service.prefs.Preferences[6];
        preferencesArray3[2] = defaultNode;
        preferencesArray3[4] = node;
        actual = service.get(key, null, preferencesArray3);
        Assert.assertNotNull((String)"8.6", (Object)actual);
        Assert.assertEquals((String)"8.7", (Object)defaultValue, (Object)actual);
    }

    @Test
    public void testSearchingStringBasics() {
        IPreferencesService service = Platform.getPreferencesService();
        String qualifier = PreferencesServiceTest.getUniqueString();
        String key = PreferencesServiceTest.getUniqueString();
        org.osgi.service.prefs.Preferences node = service.getRootNode().node("test").node(qualifier);
        org.osgi.service.prefs.Preferences defaultNode = service.getRootNode().node("default").node(qualifier);
        String value = PreferencesServiceTest.getUniqueString();
        String defaultValue = PreferencesServiceTest.getUniqueString() + "1";
        String actual = null;
        ArrayList<IScopeContext[]> list = new ArrayList<IScopeContext[]>();
        list.add(null);
        list.add(new IScopeContext[0]);
        list.add(new IScopeContext[1]);
        list.add(new IScopeContext[]{new TestScope()});
        list.add(new IScopeContext[]{new TestScope(), DefaultScope.INSTANCE});
        list.add(new IScopeContext[]{DefaultScope.INSTANCE, new TestScope()});
        list.add(new IScopeContext[]{DefaultScope.INSTANCE});
        IScopeContext[][] contexts = (IScopeContext[][])list.toArray((T[])new IScopeContext[list.size()][]);
        int i = 0;
        while (i < contexts.length) {
            actual = service.getString(qualifier, key, null, contexts[i]);
            Assert.assertNull((String)("1.0." + i), (Object)actual);
            ++i;
        }
        defaultNode.put(key, defaultValue);
        actual = defaultNode.get(key, null);
        Assert.assertNotNull((String)"2.0", (Object)actual);
        Assert.assertEquals((String)"2.1", (Object)defaultValue, (Object)actual);
        i = 0;
        while (i < contexts.length) {
            actual = service.getString(qualifier, key, null, contexts[i]);
            Assert.assertNotNull((String)("3.0." + i), (Object)actual);
            Assert.assertEquals((String)("3.1." + i), (Object)defaultValue, (Object)actual);
            ++i;
        }
        node.put(key, value);
        actual = node.get(key, null);
        Assert.assertNotNull((String)"4.0", (Object)actual);
        Assert.assertEquals((String)"4.1", (Object)value, (Object)actual);
        i = 0;
        while (i < contexts.length) {
            actual = service.getString(qualifier, key, null, contexts[i]);
            Assert.assertNotNull((String)("5.0." + i), (Object)actual);
            Assert.assertEquals((String)("5.1." + i), (Object)defaultValue, (Object)actual);
            ++i;
        }
        Object[] setOrder = new String[]{"test", "default"};
        service.setDefaultLookupOrder(qualifier, null, (String[])setOrder);
        Object[] order = service.getLookupOrder(qualifier, null);
        Assertions.assertThat((Object[])order).containsExactly(setOrder);
        int i2 = 0;
        while (i2 < contexts.length) {
            actual = service.getString(qualifier, key, null, contexts[i2]);
            Assert.assertNotNull((String)("7.0." + i2), (Object)actual);
            Assert.assertEquals((String)("7.1." + i2), (Object)value, (Object)actual);
            ++i2;
        }
        setOrder = new String[]{"default", "test"};
        service.setDefaultLookupOrder(qualifier, key, (String[])setOrder);
        order = service.getLookupOrder(qualifier, key);
        Assertions.assertThat((Object[])order).containsExactly(setOrder);
        i2 = 0;
        while (i2 < contexts.length) {
            actual = service.getString(qualifier, key, null, contexts[i2]);
            Assert.assertNotNull((String)("9.0." + i2), (Object)actual);
            Assert.assertEquals((String)("9.1." + i2), (Object)defaultValue, (Object)actual);
            ++i2;
        }
    }

    @Test
    public void testGet() {
        IPreferencesService service = Platform.getPreferencesService();
        String qualifier = PreferencesServiceTest.getUniqueString();
        org.osgi.service.prefs.Preferences node = service.getRootNode().node("test").node(qualifier);
        service.setDefaultLookupOrder(qualifier, null, new String[]{"test"});
        String searchPath = "a";
        node.put("a", searchPath);
        Assert.assertEquals((String)"3.0", (Object)searchPath, (Object)service.getString(qualifier, searchPath, null, null));
        searchPath = "a/b";
        node.node("a").put("b", searchPath);
        Assert.assertEquals((String)"4.0", (Object)searchPath, (Object)service.getString(qualifier, searchPath, null, null));
        searchPath = "a//b";
        node.node("a").put("b", searchPath);
        Assert.assertEquals((String)"5.0", (Object)searchPath, (Object)service.getString(qualifier, searchPath, null, null));
        searchPath = "a/b//c";
        node.node("a").node("b").put("c", searchPath);
        Assert.assertEquals((String)"6.0", (Object)searchPath, (Object)service.getString(qualifier, searchPath, null, null));
        searchPath = "a/b//c/d";
        node.node("a").node("b").put("c/d", searchPath);
        Assert.assertEquals((String)"7.0", (Object)searchPath, (Object)service.getString(qualifier, searchPath, null, null));
        searchPath = "/a";
        node.put("a", searchPath);
        Assert.assertEquals((String)"8.0", (Object)searchPath, (Object)service.getString(qualifier, searchPath, null, null));
        searchPath = "/a/b";
        node.node("a").put("b", searchPath);
        Assert.assertEquals((String)"9.0", (Object)searchPath, (Object)service.getString(qualifier, searchPath, null, null));
        searchPath = "///a";
        node.put("/a", searchPath);
        Assert.assertEquals((String)"10.0", (Object)searchPath, (Object)service.getString(qualifier, searchPath, null, null));
    }

    @Test
    public void testImportExceptions() {
        IPreferencesService service = Platform.getPreferencesService();
        BufferedInputStream input = new BufferedInputStream(new ByteArrayInputStream(new byte[0]));
        Assert.assertThrows(CoreException.class, () -> {
            IStatus iStatus = service.importPreferences(input);
        });
    }

    @Test
    public void testImportLegacy() throws Exception {
        String newKey;
        String actual;
        String oldKey;
        int n;
        int n2;
        String[] stringArray;
        org.osgi.service.prefs.Preferences current;
        Object qualifier;
        IPreferencesService service = Platform.getPreferencesService();
        String[] qualifiers = new String[]{PreferencesServiceTest.getUniqueString() + "1", PreferencesServiceTest.getUniqueString() + "2"};
        String[] oldKeys = new String[]{PreferencesServiceTest.getUniqueString() + "3", PreferencesServiceTest.getUniqueString() + "4"};
        String[] newKeys = new String[]{PreferencesServiceTest.getUniqueString() + "5", PreferencesServiceTest.getUniqueString() + "6"};
        org.osgi.service.prefs.Preferences node = service.getRootNode().node("instance");
        String[] stringArray2 = qualifiers;
        int n3 = qualifiers.length;
        int n4 = 0;
        while (n4 < n3) {
            qualifier = stringArray2[n4];
            Assert.assertTrue((String)"1.0", (!node.nodeExists((String)qualifier) ? 1 : 0) != 0);
            ++n4;
        }
        stringArray2 = qualifiers;
        n3 = qualifiers.length;
        n4 = 0;
        while (n4 < n3) {
            qualifier = stringArray2[n4];
            current = node.node((String)qualifier);
            stringArray = oldKeys;
            n2 = oldKeys.length;
            n = 0;
            while (n < n2) {
                oldKey = stringArray[n];
                current.put(oldKey, PreferencesServiceTest.getUniqueString());
                actual = current.get(oldKey, null);
                Assert.assertNotNull((String)("2.0." + current.absolutePath() + "/" + oldKey), (Object)actual);
                ++n;
            }
            stringArray = newKeys;
            n2 = newKeys.length;
            n = 0;
            while (n < n2) {
                newKey = stringArray[n];
                actual = current.get(newKey, null);
                Assert.assertNull((String)("2.1." + current.absolutePath() + "/" + newKey), (Object)actual);
                ++n;
            }
            ++n4;
        }
        qualifier = null;
        Object var8_11 = null;
        try (InputStream input = this.getLegacyExportFile(qualifiers, newKeys);){
            service.importPreferences(input);
        }
        catch (Throwable throwable) {
            if (qualifier == null) {
                qualifier = throwable;
            } else if (qualifier != throwable) {
                ((Throwable)qualifier).addSuppressed(throwable);
            }
            throw qualifier;
        }
        stringArray2 = qualifiers;
        int n5 = qualifiers.length;
        int n6 = 0;
        while (n6 < n5) {
            qualifier = stringArray2[n6];
            current = node.node((String)qualifier);
            stringArray = oldKeys;
            n2 = oldKeys.length;
            n = 0;
            while (n < n2) {
                oldKey = stringArray[n];
                Assert.assertNull((String)("4.0." + current.absolutePath() + "/" + oldKey), (Object)current.get(oldKey, null));
                ++n;
            }
            stringArray = newKeys;
            n2 = newKeys.length;
            n = 0;
            while (n < n2) {
                newKey = stringArray[n];
                actual = current.get(newKey, null);
                Assert.assertNotNull((String)("4.1." + current.absolutePath() + "/" + newKey), (Object)actual);
                ++n;
            }
            ++n6;
        }
    }

    private InputStream getLegacyExportFile(String[] qualifiers, String[] keys) throws IOException {
        Properties properties = new Properties();
        String[] stringArray = qualifiers;
        int n = qualifiers.length;
        int n2 = 0;
        while (n2 < n) {
            String qualifier = stringArray[n2];
            properties.put(qualifier, "2.1.3");
            String[] stringArray2 = keys;
            int n3 = keys.length;
            int n4 = 0;
            while (n4 < n3) {
                String key = stringArray2[n4];
                properties.put(qualifier + "/" + key, PreferencesServiceTest.getUniqueString());
                ++n4;
            }
            ++n2;
        }
        Throwable throwable = null;
        Object var5_8 = null;
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            properties.store(output, null);
            return new ByteArrayInputStream(output.toByteArray());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testExportExcludes1() throws Exception {
        String qualifier = PreferencesServiceTest.getUniqueString();
        String child = "child";
        IEclipsePreferences node = new TestScope().getNode(qualifier);
        org.osgi.service.prefs.Preferences childNode = node.node(child);
        childNode.put("a", "v1");
        childNode.put("b", "v2");
        childNode.put("c", "v3");
        String[] excludes = new String[]{child};
        ExportVerifier verifier = new ExportVerifier(node, excludes);
        verifier.verify();
        verifier.setExcludes(new String[]{"/" + child});
        verifier.verify();
    }

    @Test
    public void testExportExcludes2() throws Exception {
        String qualifier = PreferencesServiceTest.getUniqueString();
        IEclipsePreferences node = new TestScope().getNode(qualifier);
        String key = PreferencesServiceTest.getUniqueString();
        String value = PreferencesServiceTest.getUniqueString();
        node.put(key, value);
        String[] excludesList = new String[]{};
        ExportVerifier verifier = new ExportVerifier(node, excludesList);
        verifier.addExpected(node.absolutePath(), key);
        verifier.addVersion();
        verifier.addExportRoot(node);
        verifier.verify();
    }

    @Test
    public void testExportExcludes3() throws Exception {
        String qualifier = PreferencesServiceTest.getUniqueString();
        IEclipsePreferences node = new TestScope().getNode(qualifier);
        String k1 = "a";
        String k2 = "b";
        String v1 = "1";
        String v2 = "2";
        node.put(k1, v1);
        node.put(k2, v2);
        String[] excludesList = new String[]{k1};
        ExportVerifier verifier = new ExportVerifier(node, excludesList);
        verifier.addExpected(node.absolutePath(), k2);
        verifier.addVersion();
        verifier.addExportRoot(node);
        verifier.verify();
        verifier.setExcludes(new String[]{"/" + k1});
        verifier.verify();
    }

    @Test
    public void testExportExcludes4() throws Exception {
        String qualifier = PreferencesServiceTest.getUniqueString();
        IEclipsePreferences node = new TestScope().getNode(qualifier);
        String k1 = "a";
        String k2 = "b";
        String v1 = "1";
        String v2 = "2";
        node.put(k1, v1);
        node.put(k2, v2);
        String[] excludesList = new String[]{"bar"};
        ExportVerifier verifier = new ExportVerifier(node, excludesList);
        verifier.addVersion();
        verifier.addExportRoot(node);
        verifier.addExpected(node.absolutePath(), k1);
        verifier.addExpected(node.absolutePath(), k2);
        verifier.verify();
    }

    @Test
    public void testDefaultFromInitializer() {
        String value = Platform.getPreferencesService().getString("org.eclipse.core.tests.runtime", "SomePreference", null, null);
        Assert.assertEquals((String)"1.0", (Object)"Hello", (Object)value);
    }

    @Test
    public void testExportDefaults() throws Exception {
        String qualifier = PreferencesServiceTest.getUniqueString();
        IEclipsePreferences node = DefaultScope.INSTANCE.getNode(qualifier);
        int i = 0;
        while (i < 10) {
            node.put(Integer.toString(i), PreferencesServiceTest.getUniqueString());
            ++i;
        }
        ExportVerifier verifier = new ExportVerifier(node, null);
        verifier.verify();
    }

    @Test
    public void testExportExcludes5() {
        String qualifier = PreferencesServiceTest.getUniqueString();
        IEclipsePreferences node = new TestScope().getNode(qualifier);
        org.osgi.service.prefs.Preferences child1 = node.node("c1");
        org.osgi.service.prefs.Preferences child2 = node.node("c2");
        String k1 = "a";
        String k2 = "b";
        String v1 = "1";
        String v2 = "2";
        child1.put(k1, v1);
        child1.put(k2, v2);
        child2.put(k1, v1);
        child2.put(k2, v2);
        String[] excludes = new String[]{child1.name() + "/" + k2};
        ExportVerifier verifier = new ExportVerifier(node, excludes);
        verifier.addVersion();
        verifier.addExportRoot(node);
        verifier.addExpected(child1.absolutePath(), k1);
        verifier.addExpected(child2.absolutePath(), k1);
        verifier.addExpected(child2.absolutePath(), k2);
    }

    @Deprecated
    @Test
    public void testValidateVersions() throws Exception {
        OutputStream output;
        int BUNDLE_VERSION_PREFIX = 64;
        org.osgi.service.prefs.Preferences scopeRoot = Platform.getPreferencesService().getRootNode().node("instance");
        scopeRoot.node("org.eclipse.core.tests.runtime").put("key", "value");
        IPath path = FileSystemHelper.getRandomLocation();
        IStatus result = Preferences.validatePreferenceVersions((IPath)path);
        Assert.assertTrue((String)"1.0", (boolean)result.isOK());
        Properties properties = new Properties();
        Throwable throwable = null;
        Object var7_10 = null;
        try {
            output = new FileOutputStream(path.toFile());
            try {
                properties.store(output, null);
            }
            finally {
                if (output != null) {
                    output.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        result = Preferences.validatePreferenceVersions((IPath)path);
        Assert.assertTrue((String)"2.0", (!result.isOK() ? 1 : 0) != 0);
        Preferences.exportPreferences((IPath)path);
        result = Preferences.validatePreferenceVersions((IPath)path);
        Assert.assertTrue((String)"3.1", (boolean)result.isOK());
        properties = new Properties();
        throwable = null;
        var7_10 = null;
        try (InputStream input = Files.newInputStream(path.toPath(), new OpenOption[0]);){
            properties.load(input);
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        Enumeration<Object> e = properties.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (key.charAt(0) != '@') continue;
            properties.put(key, "0");
        }
        throwable = null;
        var7_10 = null;
        try {
            output = Files.newOutputStream(path.toPath(), new OpenOption[0]);
            try {
                properties.store(output, null);
            }
            finally {
                if (output != null) {
                    output.close();
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        result = Preferences.validatePreferenceVersions((IPath)path);
        Assert.assertTrue((String)"4.2", (!result.isOK() ? 1 : 0) != 0);
    }

    @Test
    public void testMatches() throws CoreException {
        IPreferencesService service = Platform.getPreferencesService();
        Object[] matching = null;
        final String QUALIFIER = PreferencesServiceTest.getUniqueString();
        matching = service.matches(service.getRootNode(), new IPreferenceFilter[0]);
        Assertions.assertThat((Object[])matching).isEmpty();
        Object filter = new IPreferenceFilter(){

            public Map<String, PreferenceFilterEntry[]> getMapping(String scope) {
                HashMap<String, PreferenceFilterEntry[]> result = new HashMap<String, PreferenceFilterEntry[]>();
                result.put(QUALIFIER, null);
                return result;
            }

            public String[] getScopes() {
                return new String[]{"instance"};
            }
        };
        matching = service.matches(service.getRootNode(), new IPreferenceFilter[]{filter});
        Assertions.assertThat((Object[])matching).isEmpty();
        matching = service.matches(service.getRootNode(), new IPreferenceFilter[]{filter});
        Assertions.assertThat((Object[])matching).isEmpty();
        InstanceScope.INSTANCE.getNode(QUALIFIER).put("key", "value");
        matching = service.matches(service.getRootNode(), new IPreferenceFilter[]{filter});
        Assertions.assertThat((Object[])matching).hasSize(1);
        matching = service.matches(InstanceScope.INSTANCE.getNode(QUALIFIER), new IPreferenceFilter[]{filter});
        Assertions.assertThat((Object[])matching).hasSize(1);
        matching = service.matches(ConfigurationScope.INSTANCE.getNode(QUALIFIER), new IPreferenceFilter[]{filter});
        Assertions.assertThat((Object[])matching).isEmpty();
        filter = new IPreferenceFilter(){

            public Map<String, PreferenceFilterEntry[]> getMapping(String scope) {
                return null;
            }

            public String[] getScopes() {
                return new String[]{"instance"};
            }
        };
        matching = service.matches(InstanceScope.INSTANCE.getNode(QUALIFIER), new IPreferenceFilter[]{filter});
        Assertions.assertThat((Object[])matching).hasSize(1);
        matching = service.matches(ConfigurationScope.INSTANCE.getNode(QUALIFIER), new IPreferenceFilter[]{filter});
        Assertions.assertThat((Object[])matching).isEmpty();
    }

    @Test
    public void testMatches2() throws CoreException {
        IPreferencesService service = Platform.getPreferencesService();
        final String QUALIFIER = PreferencesServiceTest.getUniqueString();
        InstanceScope.INSTANCE.getNode(QUALIFIER).node("child").put("key", "value");
        IPreferenceFilter[] filters = new IPreferenceFilter[]{new IPreferenceFilter(){

            public Map<String, PreferenceFilterEntry[]> getMapping(String scope) {
                HashMap<String, PreferenceFilterEntry[]> result = new HashMap<String, PreferenceFilterEntry[]>();
                result.put(QUALIFIER, null);
                return result;
            }

            public String[] getScopes() {
                return new String[]{"instance"};
            }
        }};
        Assertions.assertThat((Object[])service.matches(service.getRootNode(), filters)).hasSize(1);
    }

    @Test
    public void testExportWithTransfers1() throws Exception {
        final String VALID_QUALIFIER = PreferencesServiceTest.getUniqueString();
        IPreferenceFilter transfer = new IPreferenceFilter(){

            public Map<String, PreferenceFilterEntry[]> getMapping(String scope) {
                HashMap<String, PreferenceFilterEntry[]> result = new HashMap<String, PreferenceFilterEntry[]>();
                result.put(VALID_QUALIFIER, null);
                return result;
            }

            public String[] getScopes() {
                return new String[]{"instance"};
            }
        };
        IPreferencesService service = Platform.getPreferencesService();
        ExportVerifier verifier = new ExportVerifier(service.getRootNode(), new IPreferenceFilter[]{transfer});
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode(VALID_QUALIFIER);
        String VALID_KEY_1 = "key1";
        String VALID_KEY_2 = "key2";
        node.put(VALID_KEY_1, "value1");
        node.put(VALID_KEY_2, "value2");
        verifier.addVersion();
        verifier.addExportRoot(service.getRootNode());
        verifier.addExpected(node.absolutePath(), VALID_KEY_1);
        verifier.addExpected(node.absolutePath(), VALID_KEY_2);
        node = InstanceScope.INSTANCE.getNode(PreferencesServiceTest.getUniqueString());
        node.put("invalidkey1", "value1");
        node.put("invalidkey2", "value2");
        verifier.verify();
    }

    @Test
    public void testExportWithTransfers2() throws Exception {
        String VALID_QUALIFIER = PreferencesServiceTest.getUniqueString();
        IPreferenceFilter transfer = new IPreferenceFilter(){

            public Map<String, PreferenceFilterEntry[]> getMapping(String scope) {
                return null;
            }

            public String[] getScopes() {
                return new String[]{"test"};
            }
        };
        IPreferencesService service = Platform.getPreferencesService();
        ExportVerifier verifier = new ExportVerifier(service.getRootNode(), new IPreferenceFilter[]{transfer});
        IEclipsePreferences testNode = new TestScope().getNode(VALID_QUALIFIER);
        String VALID_KEY_1 = "key1";
        String VALID_KEY_2 = "key2";
        testNode.put(VALID_KEY_1, "value1");
        testNode.put(VALID_KEY_2, "value2");
        IPreferenceNodeVisitor visitor = node -> {
            String[] keys;
            String[] stringArray = keys = node.keys();
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                verifier.addExpected(node.absolutePath(), key);
                ++n2;
            }
            return true;
        };
        ((IEclipsePreferences)service.getRootNode().node("test")).accept(visitor);
        verifier.addVersion();
        verifier.addExportRoot(service.getRootNode());
        testNode = InstanceScope.INSTANCE.getNode(PreferencesServiceTest.getUniqueString());
        testNode.put("invalidkey1", "value1");
        testNode.put("invalidkey2", "value2");
        verifier.verify();
    }

    @Test
    public void testExportWithTransfers3() throws Exception {
        final String QUALIFIER = PreferencesServiceTest.getUniqueString();
        IPreferenceFilter transfer = new IPreferenceFilter(){

            public Map<String, PreferenceFilterEntry[]> getMapping(String scope) {
                HashMap<String, PreferenceFilterEntry[]> result = new HashMap<String, PreferenceFilterEntry[]>();
                result.put(QUALIFIER, null);
                return result;
            }

            public String[] getScopes() {
                return new String[]{"instance"};
            }
        };
        IPreferencesService service = Platform.getPreferencesService();
        ExportVerifier verifier = new ExportVerifier(service.getRootNode(), new IPreferenceFilter[]{transfer});
        org.osgi.service.prefs.Preferences node = InstanceScope.INSTANCE.getNode(QUALIFIER).node("child");
        String VALID_KEY_1 = "key1";
        String VALID_KEY_2 = "key2";
        node.put(VALID_KEY_1, "value1");
        node.put(VALID_KEY_2, "value2");
        verifier.addVersion();
        verifier.addExportRoot(service.getRootNode());
        verifier.addExpected(node.absolutePath(), VALID_KEY_1);
        verifier.addExpected(node.absolutePath(), VALID_KEY_2);
        node = InstanceScope.INSTANCE.getNode(PreferencesServiceTest.getUniqueString());
        node.put("invalidkey1", "value1");
        node.put("invalidkey2", "value2");
        verifier.verify();
    }

    @Test
    public void testExportWithTransfers4() throws Exception {
        final String VALID_QUALIFIER = PreferencesServiceTest.getUniqueString();
        String COMMON_PREFIX = "PREFIX.";
        IPreferenceFilter transfer = new IPreferenceFilter(){
            Map<String, PreferenceFilterEntry[]> result;

            public Map<String, PreferenceFilterEntry[]> getMapping(String scope) {
                if (this.result == null) {
                    this.result = new HashMap<String, PreferenceFilterEntry[]>();
                    this.result.put(VALID_QUALIFIER, new PreferenceFilterEntry[]{new PreferenceFilterEntry("PREFIX.", "prefix")});
                }
                return this.result;
            }

            public String[] getScopes() {
                return new String[]{"instance"};
            }
        };
        Object[] matching = null;
        IPreferencesService service = Platform.getPreferencesService();
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode(VALID_QUALIFIER);
        String VALID_KEY_1 = "PREFIX.key1";
        String VALID_KEY_2 = "PREFIX.key2";
        String VALID_KEY_3 = "key3";
        String VALID_KEY_4 = "key4";
        node.put(VALID_KEY_1, "value1");
        node.put(VALID_KEY_2, "value2");
        node.put(VALID_KEY_3, "value3");
        node.put(VALID_KEY_4, "value4");
        matching = service.matches(service.getRootNode(), new IPreferenceFilter[]{transfer});
        Assertions.assertThat((Object[])matching).hasSize(1);
        ExportVerifier verifier = new ExportVerifier(service.getRootNode(), new IPreferenceFilter[]{transfer});
        verifier.addVersion();
        verifier.addExportRoot(service.getRootNode());
        verifier.addExpected(node.absolutePath(), VALID_KEY_1);
        verifier.addExpected(node.absolutePath(), VALID_KEY_2);
        verifier.verify();
    }

    @Test
    public void testApplyAndExportedPreferencesNotModified() throws BackingStoreException, CoreException {
        IEclipsePreferences toExport = InstanceScope.INSTANCE.getNode("bug418046");
        toExport.put("someKey", "someValue");
        IPreferencesService service = Platform.getPreferencesService();
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Assert.assertTrue((boolean)service.exportPreferences(toExport, (OutputStream)stream, null).isOK());
        IExportedPreferences exported = service.readPreferences((InputStream)new ByteArrayInputStream(stream.toByteArray()));
        this.verifyExportedPreferencesNotModified(exported);
        exported = (IExportedPreferences)exported.node("instance").node("bug418046");
        Assert.assertTrue((boolean)service.applyPreferences(exported).isOK());
        this.verifyExportedPreferencesNotModified(exported);
    }

    private void verifyExportedPreferencesNotModified(IExportedPreferences exported) throws BackingStoreException {
        IExportedPreferences node = exported;
        while (node.parent() != null) {
            node = node.parent();
        }
        String debugString = ((EclipsePreferences)node).toDeepDebugString();
        Object[] children = node.childrenNames();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])children).as(debugString, new Object[0])).hasSize(1);
        Assert.assertEquals((Object)"instance", (Object)children[0]);
        node = node.node((String)children[0]);
        children = node.childrenNames();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])children).as(debugString, new Object[0])).hasSize(1);
        Assert.assertEquals((Object)"bug418046", (Object)children[0]);
        node = node.node((String)children[0]);
        children = node.childrenNames();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])children).as(debugString, new Object[0])).isEmpty();
        Assert.assertEquals((String)debugString, (Object)"someValue", (Object)node.get("someKey", null));
    }

    @Test
    @Disabled(value="not implemented yet")
    public void testApplyWithTransfers() {
    }

    private static String getUniqueString() {
        return UUID.randomUUID().toString();
    }

    private static /* synthetic */ void lambda$0(IPreferencesService iPreferencesService, String string, String[] stringArray) throws Throwable {
        iPreferencesService.setDefaultLookupOrder(null, string, stringArray);
    }

    static class ExportVerifier {
        private final IEclipsePreferences node;
        private final Set<String> expected;
        private String[] excludes;
        private IPreferenceFilter[] transfers;
        private boolean useTransfers;

        public ExportVerifier(IEclipsePreferences node, String[] excludes) {
            this.node = node;
            this.excludes = excludes;
            this.expected = new HashSet<String>();
        }

        public ExportVerifier(IEclipsePreferences node, IPreferenceFilter[] transfers) {
            this.node = node;
            this.transfers = transfers;
            this.expected = new HashSet<String>();
            this.useTransfers = true;
        }

        void addExpected(String path, String key) {
            this.expected.add(EclipsePreferences.encodePath((String)path, (String)key));
        }

        void addVersion() {
            this.expected.add("file_export_version");
        }

        void setExcludes(String[] excludes) {
            this.excludes = excludes;
        }

        void addExportRoot(IEclipsePreferences root) {
            this.expected.add("!" + root.absolutePath());
        }

        void verify() throws Exception {
            IPreferencesService service = Platform.getPreferencesService();
            Properties properties = new Properties();
            Throwable throwable = null;
            Iterator<String> iterator = null;
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
                if (this.useTransfers) {
                    service.exportPreferences(this.node, this.transfers, (OutputStream)output);
                } else {
                    service.exportPreferences(this.node, (OutputStream)output, this.excludes);
                }
                Throwable throwable2 = null;
                Object var7_10 = null;
                try (ByteArrayInputStream input = new ByteArrayInputStream(output.toByteArray());){
                    properties.load(input);
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
            if (properties.isEmpty()) {
                Assert.assertTrue((String)"2.0", (boolean)this.expected.isEmpty());
                return;
            }
            Assert.assertEquals((String)"3.0", (long)this.expected.size(), (long)properties.size());
            for (String key : this.expected) {
                Assert.assertNotNull((String)("4.0." + key), (Object)properties.get(key));
            }
        }
    }
}

