/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.preferences;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.tests.harness.session.ExecuteInHost;
import org.eclipse.core.tests.harness.session.SessionTestExtension;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.jupiter.api.io.TempDir;

public class TestBug380859 {
    private static final String CUSTOMIZATION_FILE_NAME = "plugin_customization_380859.ini";
    private static final String NOT_FOUND = "not_found";
    @TempDir
    static Path tempDirectory;
    @RegisterExtension
    static SessionTestExtension sessionTestExtension;

    static {
        sessionTestExtension = SessionTestExtension.forPlugin((String)"org.eclipse.core.tests.runtime").create();
    }

    @BeforeAll
    @ExecuteInHost
    public static void createCustomizationFile() throws IOException {
        Path customizationFilePath = tempDirectory.resolve(CUSTOMIZATION_FILE_NAME);
        Throwable throwable = null;
        Object var2_3 = null;
        try (BufferedWriter writer = Files.newBufferedWriter(customizationFilePath, new OpenOption[0]);){
            writer.write("org.eclipse.core.tests.runtime/a=v1\n");
            writer.write("org.eclipse.core.tests.runtime//b=v2\n");
            writer.write("org.eclipse.core.tests.runtime///c=v3\n");
            writer.write("org.eclipse.core.tests.runtime////d=v4\n");
            writer.write("org.eclipse.core.tests.runtime/a/b=v5\n");
            writer.write("org.eclipse.core.tests.runtime/c//d=v6\n");
            writer.write("org.eclipse.core.tests.runtime//e//f=v7\n");
            writer.write("org.eclipse.core.tests.runtime/a/b/c=v8\n");
            writer.write("org.eclipse.core.tests.runtime/a/b//c/d=v9\n");
            writer.write("org.eclipse.core.tests.runtime/a/b//c//d=v10\n");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        sessionTestExtension.setEclipseArgument("pluginCustomization", customizationFilePath.toString());
    }

    @Test
    public void testBug() {
        IPreferencesService preferenceService = Platform.getPreferencesService();
        IScopeContext[] defaultScope = new IScopeContext[]{DefaultScope.INSTANCE};
        Assertions.assertEquals((Object)"v1", (Object)preferenceService.getString("org.eclipse.core.tests.runtime", "a", NOT_FOUND, defaultScope));
        Assertions.assertEquals((Object)"v1", (Object)preferenceService.getString("org.eclipse.core.tests.runtime", "/a", NOT_FOUND, defaultScope));
        Assertions.assertEquals((Object)"v1", (Object)preferenceService.getString("org.eclipse.core.tests.runtime", "//a", NOT_FOUND, defaultScope));
        Assertions.assertEquals((Object)"v2", (Object)preferenceService.getString("org.eclipse.core.tests.runtime", "b", NOT_FOUND, defaultScope));
        Assertions.assertEquals((Object)"v2", (Object)preferenceService.getString("org.eclipse.core.tests.runtime", "/b", NOT_FOUND, defaultScope));
        Assertions.assertEquals((Object)"v2", (Object)preferenceService.getString("org.eclipse.core.tests.runtime", "//b", NOT_FOUND, defaultScope));
        Assertions.assertEquals((Object)NOT_FOUND, (Object)preferenceService.getString("org.eclipse.core.tests.runtime", "c", NOT_FOUND, defaultScope));
        Assertions.assertEquals((Object)NOT_FOUND, (Object)preferenceService.getString("org.eclipse.core.tests.runtime", "/c", NOT_FOUND, defaultScope));
        Assertions.assertEquals((Object)NOT_FOUND, (Object)preferenceService.getString("org.eclipse.core.tests.runtime", "//c", NOT_FOUND, defaultScope));
        Assertions.assertEquals((Object)"v3", (Object)preferenceService.getString("org.eclipse.core.tests.runtime", "///c", NOT_FOUND, defaultScope));
        Assertions.assertEquals((Object)NOT_FOUND, (Object)preferenceService.getString("org.eclipse.core.tests.runtime", "d", NOT_FOUND, defaultScope));
        Assertions.assertEquals((Object)NOT_FOUND, (Object)preferenceService.getString("org.eclipse.core.tests.runtime", "/d", NOT_FOUND, defaultScope));
        Assertions.assertEquals((Object)NOT_FOUND, (Object)preferenceService.getString("org.eclipse.core.tests.runtime", "//d", NOT_FOUND, defaultScope));
        Assertions.assertEquals((Object)NOT_FOUND, (Object)preferenceService.getString("org.eclipse.core.tests.runtime", "///d", NOT_FOUND, defaultScope));
        Assertions.assertEquals((Object)"v4", (Object)preferenceService.getString("org.eclipse.core.tests.runtime", "////d", NOT_FOUND, defaultScope));
        Assertions.assertEquals((Object)"v5", (Object)preferenceService.getString("org.eclipse.core.tests.runtime", "a/b", NOT_FOUND, defaultScope));
        Assertions.assertEquals((Object)"v5", (Object)preferenceService.getString("org.eclipse.core.tests.runtime", "/a/b", NOT_FOUND, defaultScope));
        Assertions.assertEquals((Object)"v5", (Object)preferenceService.getString("org.eclipse.core.tests.runtime", "a//b", NOT_FOUND, defaultScope));
        Assertions.assertEquals((Object)"v5", (Object)preferenceService.getString("org.eclipse.core.tests.runtime", "/a//b", NOT_FOUND, defaultScope));
        Assertions.assertEquals((Object)NOT_FOUND, (Object)preferenceService.getString("org.eclipse.core.tests.runtime", "//a//b", NOT_FOUND, defaultScope));
        Assertions.assertEquals((Object)"v6", (Object)preferenceService.getString("org.eclipse.core.tests.runtime", "c/d", NOT_FOUND, defaultScope));
        Assertions.assertEquals((Object)"v6", (Object)preferenceService.getString("org.eclipse.core.tests.runtime", "/c/d", NOT_FOUND, defaultScope));
        Assertions.assertEquals((Object)"v6", (Object)preferenceService.getString("org.eclipse.core.tests.runtime", "c//d", NOT_FOUND, defaultScope));
        Assertions.assertEquals((Object)"v6", (Object)preferenceService.getString("org.eclipse.core.tests.runtime", "/c//d", NOT_FOUND, defaultScope));
        Assertions.assertEquals((Object)NOT_FOUND, (Object)preferenceService.getString("org.eclipse.core.tests.runtime", "//c//d", NOT_FOUND, defaultScope));
        Assertions.assertEquals((Object)NOT_FOUND, (Object)preferenceService.getString("org.eclipse.core.tests.runtime", "e/f", NOT_FOUND, defaultScope));
        Assertions.assertEquals((Object)NOT_FOUND, (Object)preferenceService.getString("org.eclipse.core.tests.runtime", "/e/f", NOT_FOUND, defaultScope));
        Assertions.assertEquals((Object)NOT_FOUND, (Object)preferenceService.getString("org.eclipse.core.tests.runtime", "e//f", NOT_FOUND, defaultScope));
        Assertions.assertEquals((Object)NOT_FOUND, (Object)preferenceService.getString("org.eclipse.core.tests.runtime", "/e//f", NOT_FOUND, defaultScope));
        Assertions.assertEquals((Object)"v7", (Object)preferenceService.getString("org.eclipse.core.tests.runtime", "//e//f", NOT_FOUND, defaultScope));
        Assertions.assertEquals((Object)"v8", (Object)preferenceService.getString("org.eclipse.core.tests.runtime", "a/b/c", NOT_FOUND, defaultScope));
        Assertions.assertEquals((Object)"v8", (Object)preferenceService.getString("org.eclipse.core.tests.runtime", "/a/b/c", NOT_FOUND, defaultScope));
        Assertions.assertEquals((Object)"v8", (Object)preferenceService.getString("org.eclipse.core.tests.runtime", "a/b//c", NOT_FOUND, defaultScope));
        Assertions.assertEquals((Object)"v8", (Object)preferenceService.getString("org.eclipse.core.tests.runtime", "/a/b//c", NOT_FOUND, defaultScope));
        Assertions.assertEquals((Object)"v9", (Object)preferenceService.getString("org.eclipse.core.tests.runtime", "a/b//c/d", NOT_FOUND, defaultScope));
        Assertions.assertEquals((Object)"v9", (Object)preferenceService.getString("org.eclipse.core.tests.runtime", "/a/b//c/d", NOT_FOUND, defaultScope));
        Assertions.assertEquals((Object)"v10", (Object)preferenceService.getString("org.eclipse.core.tests.runtime", "a/b//c//d", NOT_FOUND, defaultScope));
        Assertions.assertEquals((Object)"v10", (Object)preferenceService.getString("org.eclipse.core.tests.runtime", "/a/b//c//d", NOT_FOUND, defaultScope));
    }
}

