/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.preferences;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.tests.harness.session.ExecuteInHost;
import org.eclipse.core.tests.harness.session.SessionTestExtension;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.jupiter.api.io.TempDir;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class TestBug388004 {
    private static final String CUSTOMIZATION_FILE_NAME = "plugin_customization.ini";
    private static final String NODE = "dummy_node";
    private static final String KEY = "key";
    private static final String VALUE = "value";
    @TempDir
    static Path tempDirectory;
    @RegisterExtension
    static SessionTestExtension sessionTestExtension;

    static {
        sessionTestExtension = SessionTestExtension.forPlugin((String)"org.eclipse.core.tests.runtime").create();
    }

    @BeforeAll
    @ExecuteInHost
    public static void createCustomizationFile() throws IOException {
        Path customizationFilePath = tempDirectory.resolve(CUSTOMIZATION_FILE_NAME);
        Throwable throwable = null;
        Object var2_3 = null;
        try (BufferedWriter writer = Files.newBufferedWriter(customizationFilePath, new OpenOption[0]);){
            writer.write("org.eclipse.core.tests.runtime/dummy_node/key=value");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        sessionTestExtension.setEclipseArgument("pluginCustomization", customizationFilePath.toString());
    }

    @Test
    public void testBug() throws BackingStoreException {
        Preferences node = Platform.getPreferencesService().getRootNode().node("default");
        Assertions.assertTrue((boolean)node.nodeExists("org.eclipse.core.tests.runtime"), (String)"This node exists in pluginCustomization file.");
        Assertions.assertTrue((boolean)node.nodeExists("/default/org.eclipse.core.tests.runtime"), (String)"This node exists in pluginCustomization file.");
        Assertions.assertTrue((boolean)node.nodeExists("org.eclipse.core.tests.runtime/dummy_node"), (String)"This node exists in pluginCustomization file.");
        Assertions.assertTrue((boolean)node.nodeExists("/default/org.eclipse.core.tests.runtime/dummy_node"), (String)"This node exists in pluginCustomization file.");
        Assertions.assertFalse((boolean)node.nodeExists("org.eclipse.core.tests.runtime/dummy_node/key"), (String)"This node does not exist in pluginCustomization file.");
        Assertions.assertFalse((boolean)node.nodeExists("/default/org.eclipse.core.tests.runtime/dummy_node/key"), (String)"This node does not exist in pluginCustomization file.");
        node = node.node("org.eclipse.core.tests.runtime/dummy_node");
        String value = node.get(KEY, null);
        Assertions.assertEquals((Object)VALUE, (Object)value);
    }
}

