/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.preferences;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Properties;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.preferences.AbstractPreferenceStorage;
import org.eclipse.core.tests.runtime.RuntimeTestsPlugin;
import org.osgi.service.prefs.BackingStoreException;

public class TestNodeStorage3
extends AbstractPreferenceStorage {
    private static File root;

    static {
        File source = RuntimeTestsPlugin.getTestData("/testData/preferences/test3");
        root = RuntimeTestsPlugin.getTempFolder();
        try {
            RuntimeTestsPlugin.copy(source, root);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.setProperty("equinox.preference.test.TestNodeStorage3,root", root.getAbsolutePath());
    }

    File getLocation(String nodePath) throws BackingStoreException {
        if (root == null) {
            throw new BackingStoreException("Problems getting preference location.");
        }
        IPath path = IPath.fromOSString((String)nodePath);
        return new File(root, path.lastSegment());
    }

    public Properties load(String nodePath) throws BackingStoreException {
        File file = this.getLocation(nodePath);
        if (!file.exists()) {
            return null;
        }
        try {
            InputStream input = Files.newInputStream(file.toPath(), new OpenOption[0]);
            return this.loadProperties(input);
        }
        catch (IOException e) {
            throw new BackingStoreException("Exception while trying to open preference file: " + file.getAbsolutePath(), (Throwable)e);
        }
    }

    public void save(String nodePath, Properties properties) throws BackingStoreException {
        File file = this.getLocation(nodePath);
        if (file == null) {
            return;
        }
        try {
            BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(file));
            this.saveProperties(output, properties);
        }
        catch (FileNotFoundException e) {
            throw new BackingStoreException("Error occurred while saving preference file: " + file.getAbsolutePath(), (Throwable)e);
        }
    }

    public String[] childrenNames(String nodePath) {
        return root == null ? new String[]{} : root.list();
    }

    public void removed(String nodePath) {
        try {
            File file = this.getLocation(nodePath);
            if (file.exists()) {
                file.delete();
            }
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }
}

