/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.runtime;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectArrayAssert;
import org.eclipse.core.internal.runtime.RuntimeLog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.tests.internal.runtime.PlatformLogReader;
import org.junit.Assert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class LogSerializationTest {
    private File logFile = null;

    private void assertStatusEqual(String msg, IStatus[] expected, IStatus[] actual) {
        if (expected == null) {
            Assert.assertNull((String)(msg + " expected null but got: " + Arrays.toString(actual)), (Object)actual);
            return;
        }
        if (actual == null) {
            Assert.assertNull((String)(msg + " expected " + Arrays.toString(expected) + " but got null"), (Object)expected);
        }
        ((ObjectArrayAssert)Assertions.assertThat((Object[])actual).as(msg + " number of statuses", new Object[0])).hasSameSizeAs((Object)expected);
        int i = 0;
        int imax = expected.length;
        while (i < imax) {
            this.assertStatusEquals(msg + " differ at status " + i, expected[i], actual[i]);
            ++i;
        }
    }

    private void assertStatusEquals(String msg, IStatus expected, IStatus actual) {
        Assert.assertEquals((String)(msg + " severity"), (long)expected.getSeverity(), (long)actual.getSeverity());
        Assert.assertEquals((String)(msg + " plugin-id"), (Object)expected.getPlugin(), (Object)actual.getPlugin());
        Assert.assertEquals((String)(msg + " code"), (long)expected.getCode(), (long)actual.getCode());
        Assert.assertEquals((String)(msg + " message"), (Object)expected.getMessage(), (Object)actual.getMessage());
        this.assertExceptionEquals(msg + " exception", expected.getException(), actual.getException());
        this.assertStatusEqual(msg + " children", expected.getChildren(), actual.getChildren());
    }

    private void assertExceptionEquals(String msg, Throwable expected, Throwable actual) {
        if (expected == null) {
            Assert.assertNull((String)(msg + " expected null but got: " + String.valueOf(actual)), (Object)actual);
            return;
        }
        if (actual == null) {
            Assert.assertNull((String)(msg + " expected " + String.valueOf(expected) + " but got null"), (Object)expected);
        }
        Assert.assertEquals((String)(msg + " stack trace"), (Object)this.encodeStackTrace(expected), (Object)this.encodeStackTrace(actual));
        Assert.assertEquals((String)(msg + " message"), (Object)expected.getMessage(), (Object)actual.getMessage());
    }

    protected String encodeStackTrace(Throwable t) {
        StringWriter sWriter = new StringWriter();
        PrintWriter pWriter = new PrintWriter(sWriter);
        pWriter.println();
        t.printStackTrace(pWriter);
        pWriter.flush();
        return this.canonicalizeStackTrace(sWriter.toString());
    }

    protected String canonicalizeStackTrace(String stackTrace) {
        int NEW_LINE = 10;
        int TAB = 9;
        int SPACE = 32;
        String LINE_SEPARATORS = "\r\n\f";
        String SPACES = "\t ";
        StringBuilder sb = new StringBuilder(stackTrace.trim());
        sb.append('\n');
        int lastChar = 0;
        int i = 0;
        while (i < sb.length()) {
            if ("\r\n\f".indexOf(sb.charAt(i)) != -1) {
                if ("\r\n\f".indexOf(lastChar) != -1) {
                    sb.deleteCharAt(i);
                    continue;
                }
                sb.setCharAt(i, '\n');
            } else if (lastChar == 10) {
                sb.insert(i, '\t');
            } else if ("\t ".indexOf(sb.charAt(i)) != -1) {
                if ("\t ".indexOf(lastChar) != -1) {
                    sb.deleteCharAt(i);
                    continue;
                }
                sb.setCharAt(i, ' ');
            }
            lastChar = sb.charAt(i);
            ++i;
        }
        return sb.toString();
    }

    protected IStatus[] getInterestingMultiStatuses() {
        IStatus[] interesting = this.getInterestingStatuses();
        int len = interesting.length;
        IStatus[][] interestingChildren = new IStatus[len][];
        int i = 0;
        while (i < len) {
            IStatus[] subArray = new IStatus[len];
            System.arraycopy(interesting, 0, subArray, 0, len);
            interestingChildren[i] = subArray;
            ++i;
        }
        int childOff = 0;
        return new IStatus[]{new MultiStatus("plugin-id", 1, interestingChildren[childOff++ % len], "message", null), new MultiStatus("org.foo.bar", 5, interestingChildren[childOff++ % len], "message", (Throwable)new TestException()), new MultiStatus("plugin-id", 8, interestingChildren[childOff++ % len], "message", null), new MultiStatus("plugin-id", 0, interestingChildren[childOff++ % len], "message", (Throwable)new TestException()), new MultiStatus("plugin-id", 65756, interestingChildren[childOff++ % len], "message", null), new MultiStatus(".", 1, interestingChildren[childOff++ % len], "message", null), new MultiStatus("org.foo.blaz", 1, interestingChildren[childOff++ % len], "", null), new MultiStatus("plugin-id", 1, interestingChildren[childOff++ % len], "%$(% 98%(%(*^", null), new MultiStatus("plugin-id", 1, "message", null), new MultiStatus("..", 87326, "", null)};
    }

    protected IStatus[] getInterestingStatuses() {
        return new IStatus[]{new Status(2, "(#(*$%#", 1, "../\\\\''\"", (Throwable)new TestException()), new Status(2, "org.foo", 1, "This is the message", null), new Status(4, "org.foo", 1, "This is the message", (Throwable)new TestException()), new Status(0, ".", 1, "This is the message", (Throwable)new TestException()), new Status(1, "org.asdfhsfhsdf976dsf6sd0f6s", 1, "#*&^$(*&#@^$)(#&)(", null)};
    }

    protected void doTest(String msg, IStatus[] oldStats) {
        this.writeLog(oldStats);
        IStatus[] newStats = this.readLog();
        this.assertStatusEqual(msg, oldStats, newStats);
    }

    protected void doTest(String msg, IStatus status) {
        this.doTest(msg, new IStatus[]{status});
    }

    protected IStatus[] readLog() {
        PlatformLogReader reader = new PlatformLogReader();
        return reader.readLogFile(this.logFile.getAbsolutePath());
    }

    @BeforeEach
    public void setUp() throws Exception {
        if (this.logFile == null) {
            this.logFile = Platform.getLogFileLocation().toFile();
        }
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.logFile.delete();
    }

    @Test
    public void testDeepMultiStatus() {
        MultiStatus multi = new MultiStatus("id", 1, this.getInterestingMultiStatuses(), "ok", null);
        int i = 0;
        while (i < 5) {
            multi = new MultiStatus("id", 1, new IStatus[]{multi}, "ok", null);
            this.doTest("1." + i, (IStatus)multi);
            ++i;
        }
    }

    @Test
    public void testMultiMultiStatusSerialize() {
        IStatus[] interesting = this.getInterestingMultiStatuses();
        int len = interesting.length;
        int i = 1;
        while (i < len) {
            IStatus[] subArray = new IStatus[len];
            System.arraycopy(interesting, 0, subArray, 0, len);
            this.doTest("1." + i, subArray);
            ++i;
        }
    }

    @Test
    public void testMultiSerialize() {
        IStatus[] interesting = this.getInterestingStatuses();
        int len = interesting.length;
        int i = 1;
        while (i < len) {
            IStatus[] subArray = new IStatus[len];
            System.arraycopy(interesting, 0, subArray, 0, len);
            this.doTest("1." + i, subArray);
            ++i;
        }
    }

    @Test
    public void testMultiStatus() {
        IStatus[] interesting = this.getInterestingMultiStatuses();
        int i = 0;
        while (i < interesting.length) {
            this.doTest("1." + i, interesting[i]);
            ++i;
        }
    }

    @Test
    public void testSimpleSerialize() {
        IStatus[] interesting = this.getInterestingStatuses();
        int i = 0;
        while (i < interesting.length) {
            this.doTest("1." + i, interesting[i]);
            ++i;
        }
    }

    protected void writeLog(IStatus status) {
        this.writeLog(new IStatus[]{status});
    }

    protected void writeLog(IStatus[] statuses) {
        if (this.logFile.exists()) {
            this.logFile.delete();
        }
        IStatus[] iStatusArray = statuses;
        int n = statuses.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus status = iStatusArray[n2];
            RuntimeLog.log((IStatus)status);
            ++n2;
        }
    }

    static class TestException
    extends Exception {
        private static final long serialVersionUID = 1L;

        TestException() {
        }
    }
}

