/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.runtime;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.internal.runtime.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class PlatformLogReader {
    private ArrayList<IStatus> list = null;
    private String currentLine = "";
    private BufferedReader reader;
    private static final String KEYWORD_SESSION = "!SESSION";
    private static final String KEYWORD_ENTRY = "!ENTRY";
    private static final String KEYWORD_SUBENTRY = "!SUBENTRY";
    private static final String KEYWORD_MESSAGE = "!MESSAGE";
    private static final String KEYWORD_STACK = "!STACK";
    private static final int NULL = -2;
    private static final int SESSION = 1;
    private static final int ENTRY = 2;
    private static final int SUBENTRY = 4;
    private static final int MESSAGE = 8;
    private static final int STACK = 16;
    private static final int UNKNOWN = 32;

    protected void log(Exception ex) {
        String msg = NLS.bind((String)Messages.meta_exceptionParsingLog, (Object)ex.getMessage());
        this.list.add((IStatus)new Status(2, "org.eclipse.core.runtime", 1, msg, (Throwable)ex));
    }

    protected Throwable readException(String message) throws IOException {
        if (this.currentLine == null || this.getLineType() != 16) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(this.currentLine);
        tokenizer.nextToken();
        Integer.parseInt(tokenizer.nextToken());
        this.currentLine = this.reader.readLine();
        return new FakeException(null, this.readText());
    }

    public synchronized IStatus[] readLogFile(String path) {
        block20: {
            this.list = new ArrayList();
            FileInputStream input = null;
            try {
                try {
                    input = new FileInputStream(path);
                    this.reader = new BufferedReader(new InputStreamReader((InputStream)input, StandardCharsets.UTF_8));
                    this.currentLine = this.reader.readLine();
                    while (this.currentLine != null) {
                        switch (this.getLineType()) {
                            case 2: {
                                IStatus status = this.readEntry();
                                if (status == null) break;
                                this.list.add(status);
                                break;
                            }
                            case 1: {
                                this.readSession();
                                break;
                            }
                            case 4: 
                            case 8: 
                            case 16: 
                            case 32: {
                                this.currentLine = this.reader.readLine();
                            }
                        }
                    }
                }
                catch (IOException e) {
                    this.log(e);
                    try {
                        if (input != null) {
                            ((InputStream)input).close();
                        }
                        break block20;
                    }
                    catch (IOException e2) {
                        this.log(e2);
                    }
                    break block20;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        ((InputStream)input).close();
                    }
                }
                catch (IOException e) {
                    this.log(e);
                }
                throw throwable;
            }
            try {
                if (input != null) {
                    ((InputStream)input).close();
                }
            }
            catch (IOException e) {
                this.log(e);
            }
        }
        return this.list.toArray(new IStatus[this.list.size()]);
    }

    protected int getLineType() {
        if (this.currentLine == null) {
            return -2;
        }
        StringTokenizer tokenizer = new StringTokenizer(this.currentLine);
        if (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals(KEYWORD_SESSION)) {
                return 1;
            }
            if (token.equals(KEYWORD_ENTRY)) {
                return 2;
            }
            if (token.equals(KEYWORD_SUBENTRY)) {
                return 4;
            }
            if (token.equals(KEYWORD_MESSAGE)) {
                return 8;
            }
            if (token.equals(KEYWORD_STACK)) {
                return 16;
            }
        }
        return 32;
    }

    protected IStatus readEntry() throws IOException {
        if (this.currentLine == null || this.getLineType() != 2) {
            return null;
        }
        StringTokenizer tokens = new StringTokenizer(this.currentLine);
        tokens.nextToken();
        String pluginID = tokens.nextToken();
        int severity = Integer.parseInt(tokens.nextToken());
        int code = Integer.parseInt(tokens.nextToken());
        this.currentLine = this.reader.readLine();
        String message = this.readMessage();
        Throwable exception = this.readException(message);
        if (this.currentLine == null || this.getLineType() != 4) {
            return new Status(severity, pluginID, code, message, exception);
        }
        MultiStatus parent = new MultiStatus(pluginID, code, message, exception);
        this.readSubEntries(parent);
        return parent;
    }

    protected void readSubEntries(MultiStatus parent) throws IOException {
        while (this.getLineType() == 4) {
            StringTokenizer tokens = new StringTokenizer(this.currentLine);
            tokens.nextToken();
            int currentDepth = Integer.parseInt(tokens.nextToken());
            String pluginID = tokens.nextToken();
            int severity = Integer.parseInt(tokens.nextToken());
            int code = Integer.parseInt(tokens.nextToken());
            this.currentLine = this.reader.readLine();
            String message = this.readMessage();
            Throwable exception = this.readException(message);
            Status current = new Status(severity, pluginID, code, message, exception);
            if (this.currentLine == null || this.getLineType() != 4) {
                parent.add((IStatus)current);
                return;
            }
            tokens = new StringTokenizer(this.currentLine);
            tokens.nextToken();
            int depth = Integer.parseInt(tokens.nextToken());
            if (currentDepth == depth) {
                parent.add((IStatus)current);
                continue;
            }
            if (currentDepth == depth - 1) {
                current = new MultiStatus(pluginID, code, message, exception);
                this.readSubEntries((MultiStatus)current);
                parent.add((IStatus)current);
                continue;
            }
            parent.add((IStatus)current);
            return;
        }
    }

    protected int readDepth() {
        StringTokenizer tokens = new StringTokenizer(this.currentLine);
        tokens.nextToken();
        return Integer.parseInt(tokens.nextToken());
    }

    protected String readMessage() throws IOException {
        if (this.currentLine == null || this.getLineType() != 8) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.currentLine.substring(KEYWORD_MESSAGE.length() + 1));
        this.currentLine = this.reader.readLine();
        buffer.append(this.readText());
        return buffer.toString();
    }

    protected String readSession() throws IOException {
        if (this.currentLine == null || this.getLineType() != 1) {
            return "";
        }
        this.currentLine = this.reader.readLine();
        return this.readText();
    }

    protected String readText() throws IOException {
        StringBuilder buffer = new StringBuilder();
        if (this.currentLine == null || this.getLineType() != 32) {
            return "";
        }
        buffer.append(this.currentLine);
        boolean done = false;
        while (!done) {
            this.currentLine = this.reader.readLine();
            if (this.currentLine == null) {
                done = true;
                continue;
            }
            if (this.getLineType() == 32) {
                buffer.append('\n');
                buffer.append(this.currentLine);
                continue;
            }
            done = true;
        }
        return buffer.toString();
    }

    static class FakeException
    extends Throwable {
        private static final long serialVersionUID = 1L;
        private final String message;
        private final String stackTrace;

        FakeException(String msg, String stack) {
            this.message = msg;
            this.stackTrace = stack;
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        @Override
        public void printStackTrace() {
            this.printStackTrace(System.out);
        }

        @Override
        public void printStackTrace(PrintWriter writer) {
            writer.println(this.stackTrace);
        }

        @Override
        public void printStackTrace(PrintStream stream) {
            stream.println(this.stackTrace);
        }
    }
}

