/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.runtime;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.tests.harness.BundleTestingHelper;
import org.eclipse.core.tests.runtime.RuntimeTestsPlugin;
import org.junit.Assert;
import org.junit.jupiter.api.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class PlatformURLLocalTest {
    public static void assertEquals(String tag, URL expected, URL actual, boolean external) throws MalformedURLException {
        if (external) {
            Assert.assertEquals((String)tag, (Object)expected, (Object)actual);
        } else {
            Assert.assertEquals((String)(tag + ".1"), (Object)new URL(expected.getProtocol(), expected.getHost(), expected.getPort(), expected.getFile()), (Object)new URL(actual.getProtocol(), actual.getHost(), actual.getPort(), actual.getFile()));
        }
    }

    @Test
    public void testPlatformURLConfigResolution() throws IOException {
        URL platformURL = new URL("platform:/config/x");
        URL resolvedURL = FileLocator.resolve((URL)platformURL);
        Assert.assertNotEquals((String)"3.0", (Object)platformURL, (Object)resolvedURL);
        URL expected = new URL(Platform.getConfigurationLocation().getURL(), "x");
        PlatformURLLocalTest.assertEquals("5.0", expected, resolvedURL, false);
    }

    @Test
    public void testPlatformURLMetaResolution() throws Exception {
        URL platformURL = new URL("platform:/meta/org.eclipse.core.tests.runtime/x");
        URL resolvedURL = FileLocator.resolve((URL)platformURL);
        Assert.assertNotEquals((String)"3.0", (Object)platformURL, (Object)resolvedURL);
        URL expected = new URL(RuntimeTestsPlugin.getPlugin().getStateLocation().toFile().toURI().toURL(), "x");
        PlatformURLLocalTest.assertEquals("5.0", expected, resolvedURL, false);
    }

    @Test
    public void testBug155081() throws IOException, BundleException {
        Bundle bundle = null;
        try {
            bundle = BundleTestingHelper.installBundle((String)"0.1", (BundleContext)RuntimeTestsPlugin.getContext(), (String)"Plugin_Testing/platformURL/platform.test.underscore");
            BundleTestingHelper.refreshPackages((BundleContext)RuntimeTestsPlugin.getContext(), (Bundle[])new Bundle[]{bundle});
            URL test = new URL("platform:/plugin/platform.test.underscore_1.1.0.r321_v20060816/test.txt");
            Throwable throwable = null;
            Object var4_4 = null;
            try {
                InputStream in = test.openStream();
                if (in != null) {
                    in.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            if (bundle != null) {
                bundle.uninstall();
            }
        }
    }

    @Test
    public void testBug300197_01() throws IOException, BundleException {
        Bundle bundle = null;
        try {
            bundle = BundleTestingHelper.installBundle((String)"0.1", (BundleContext)RuntimeTestsPlugin.getContext(), (String)"Plugin_Testing/platformURL/platform_test_underscore");
            BundleTestingHelper.refreshPackages((BundleContext)RuntimeTestsPlugin.getContext(), (Bundle[])new Bundle[]{bundle});
            URL test = new URL("platform:/plugin/platform_test_underscore/test.txt");
            Throwable throwable = null;
            Object var4_4 = null;
            try {
                InputStream in = test.openStream();
                if (in != null) {
                    in.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            if (bundle != null) {
                bundle.uninstall();
            }
        }
    }

    @Test
    public void testBug300197_02() throws IOException, BundleException {
        Bundle bundle = null;
        try {
            bundle = BundleTestingHelper.installBundle((String)"0.1", (BundleContext)RuntimeTestsPlugin.getContext(), (String)"Plugin_Testing/platformURL/platform_test_underscore_2.0.0");
            BundleTestingHelper.refreshPackages((BundleContext)RuntimeTestsPlugin.getContext(), (Bundle[])new Bundle[]{bundle});
            URL test = new URL("platform:/plugin/platform_test_underscore_2.0.0/test.txt");
            Throwable throwable = null;
            Object var4_4 = null;
            try {
                InputStream in = test.openStream();
                if (in != null) {
                    in.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            if (bundle != null) {
                bundle.uninstall();
            }
        }
    }
}

