/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.runtime;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.tests.harness.session.SessionTestExtension;
import org.eclipse.osgi.service.datalocation.Location;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.TestMethodOrder;
import org.junit.jupiter.api.extension.RegisterExtension;

@TestMethodOrder(value=MethodOrderer.OrderAnnotation.class)
@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class PlatformURLSessionTest {
    @RegisterExtension
    SessionTestExtension extension = SessionTestExtension.forPlugin((String)"org.eclipse.core.tests.runtime").withCustomization(SessionTestExtension.createCustomConfiguration().setCascaded().setReadOnly()).create();
    private static final String CONFIG_URL = "platform:/config/org.eclipse.core.tests.runtime/";
    private static final String DATA_CHILD = "child";
    private static final String DATA_PARENT = "parent";
    private static final String FILE_ANOTHER_PARENT_ONLY = "parent2.txt";
    private static final String FILE_BOTH_PARENT_AND_CHILD = "both.txt";
    private static final String FILE_CHILD_ONLY = "child.txt";
    private static final String FILE_PARENT_ONLY = "parent.txt";

    @Order(value=0)
    @Test
    public void test0FirstSession() throws IOException {
        this.createData();
        URL configURL = new URL("platform:/config/org.eclipse.core.tests.runtime/parent2.txt");
        URLConnection connection = configURL.openConnection();
        connection.setDoOutput(true);
        Assertions.assertThrows(IOException.class, () -> {
            Throwable throwable = null;
            Object var2_2 = null;
            try {
                OutputStream o = connection.getOutputStream();
                if (o != null) {
                    o.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        });
    }

    private void createData() throws IOException {
        URL childConfigURL = Platform.getConfigurationLocation().getURL();
        Assertions.assertEquals((Object)"file", (Object)childConfigURL.getProtocol());
        File childConfigPrivateDir = new File(childConfigURL.getPath(), "org.eclipse.core.tests.runtime");
        childConfigPrivateDir.mkdirs();
        this.createFileWithContents(new File(childConfigPrivateDir, FILE_CHILD_ONLY), DATA_CHILD);
        this.createFileWithContents(new File(childConfigPrivateDir, FILE_BOTH_PARENT_AND_CHILD), DATA_CHILD);
        Location parent = Platform.getConfigurationLocation().getParentLocation();
        Assertions.assertNotNull((Object)parent);
        URL parentConfigURL = parent.getURL();
        Assertions.assertEquals((Object)"file", (Object)parentConfigURL.getProtocol());
        File parentConfigPrivateDir = new File(parentConfigURL.getPath(), "org.eclipse.core.tests.runtime");
        parentConfigPrivateDir.mkdirs();
        this.createFileWithContents(new File(parentConfigPrivateDir, FILE_PARENT_ONLY), DATA_PARENT);
        this.createFileWithContents(new File(parentConfigPrivateDir, FILE_ANOTHER_PARENT_ONLY), DATA_PARENT);
        this.createFileWithContents(new File(parentConfigPrivateDir, FILE_BOTH_PARENT_AND_CHILD), DATA_PARENT);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createFileWithContents(File file, String contents) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            ByteArrayInputStream input = new ByteArrayInputStream(contents.getBytes());
            try {
                try (FileOutputStream output = new FileOutputStream(file);){
                    ((InputStream)input).transferTo(output);
                }
                if (input == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (input == null) throw throwable;
                ((InputStream)input).close();
                throw throwable;
            }
            ((InputStream)input).close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    @Order(value=1)
    @Test
    public void test1OutputOnReadOnly() throws IOException {
        URL configURL = new URL("platform:/config/org.eclipse.core.tests.runtime/child.txt");
        URLConnection connection = configURL.openConnection();
        connection.setDoOutput(true);
        Assertions.assertThrows(IOException.class, () -> {
            Throwable throwable = null;
            Object var2_2 = null;
            try {
                OutputStream o = connection.getOutputStream();
                if (o != null) {
                    o.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        });
    }

    @Order(value=2)
    @Test
    public void test2Resolution() throws IOException {
        URL parent = new URL("platform:/config/org.eclipse.core.tests.runtime/parent.txt");
        URL child = new URL("platform:/config/org.eclipse.core.tests.runtime/child.txt");
        URL both = new URL("platform:/config/org.eclipse.core.tests.runtime/both.txt");
        URL none = new URL("platform:/config/org.eclipse.core.tests.runtime/none.txt");
        Assertions.assertEquals((Object)DATA_PARENT, (Object)PlatformURLSessionTest.readContents("1.1", parent));
        Assertions.assertEquals((Object)DATA_CHILD, (Object)PlatformURLSessionTest.readContents("2.1", child));
        Assertions.assertEquals((Object)DATA_CHILD, (Object)PlatformURLSessionTest.readContents("3.1", both));
        URL resolvedURL = FileLocator.resolve((URL)none);
        Assertions.assertNotEquals((Object)none, (Object)resolvedURL);
        Assertions.assertTrue((boolean)resolvedURL.toExternalForm().startsWith(Platform.getConfigurationLocation().getURL().toExternalForm()));
    }

    private static String readContents(String tag, URL url) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));){
            return reader.lines().collect(Collectors.joining());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

