/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.runtime;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectArrayAssert;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.tests.runtime.RuntimeTestsPlugin;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.junit.Assert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class PlatformTest {
    private FrameworkLog logService;
    private ServiceReference<FrameworkLog> logRef;
    private File originalLocation;

    @BeforeEach
    public void setUp() throws Exception {
        Platform.getLogFileLocation();
        this.logRef = RuntimeTestsPlugin.getContext().getServiceReference(FrameworkLog.class);
        this.logService = (FrameworkLog)RuntimeTestsPlugin.getContext().getService(this.logRef);
        this.originalLocation = this.logService.getFile();
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.logService.setFile(this.originalLocation, true);
        RuntimeTestsPlugin.getContext().ungetService(this.logRef);
    }

    @Test
    public void testGetSystemCharset() {
        Charset encoding = Platform.getSystemCharset();
        Assert.assertNotNull((Object)encoding);
        String vmSpec = System.getProperty("java.vm.specification.version");
        int version = Integer.parseInt(vmSpec);
        String property = version >= 18 ? System.getProperty("native.encoding") : System.getProperty("sun.jnu.encoding");
        Assert.assertEquals((Object)Charset.forName(property), (Object)encoding);
    }

    @Test
    public void testGetCommandLine() {
        Assert.assertNotNull((String)"1.0", (Object)Platform.getCommandLineArgs());
    }

    @Test
    public void testGetLocation() {
        Assert.assertNotNull((String)"1.0", (Object)Platform.getLocation());
    }

    @Test
    public void testGetResourceBundle() {
        ResourceBundle bundle = Platform.getResourceBundle((Bundle)Platform.getBundle((String)"org.eclipse.core.runtime"));
        Assert.assertNotNull((Object)bundle);
        Assert.assertThrows(MissingResourceException.class, () -> {
            ResourceBundle resourceBundle = Platform.getResourceBundle((Bundle)Platform.getBundle((String)"org.eclipse.core.tests.runtime"));
        });
    }

    @Test
    public void testGetLogLocation() throws IOException {
        IPath initialLocation = Platform.getLogFileLocation();
        Platform.getStateLocation((Bundle)Platform.getBundle((String)"org.eclipse.equinox.common"));
        Assert.assertNotNull((String)"1.0", (Object)initialLocation);
        IPath logPath = IPath.fromOSString((String)this.logService.getFile().getAbsolutePath());
        Assert.assertEquals((String)"2.0", (Object)logPath, (Object)initialLocation);
        File newLocation = File.createTempFile("testGetLogLocation", null);
        this.logService.setFile(newLocation, true);
        Assert.assertEquals((String)"3.0", (Object)IPath.fromOSString((String)newLocation.getAbsolutePath()), (Object)Platform.getLogFileLocation());
        this.logService.setWriter((Writer)new StringWriter(), true);
        Assert.assertEquals((String)"4.0", (Object)initialLocation, (Object)Platform.getLogFileLocation());
    }

    @Test
    public void testRunnable() {
        final ArrayList exceptions = new ArrayList();
        ArrayList collected = new ArrayList();
        ILogListener logListener = (status, plugin) -> {
            boolean bl = collected.add(status);
        };
        Platform.addLogListener((ILogListener)logListener);
        final TestException exception = new TestException();
        ISafeRunnable runnable = new ISafeRunnable(){

            public void handleException(Throwable t) {
                exceptions.add(t);
            }

            public void run() throws Exception {
                throw exception;
            }
        };
        SafeRunner.run((ISafeRunnable)runnable);
        Platform.removeLogListener((ILogListener)logListener);
        Assert.assertEquals((String)"1.0", (long)exceptions.size(), (long)1L);
        Assert.assertEquals((String)"1.1", (Object)exception, exceptions.get(0));
        Assert.assertEquals((String)"2.0", (long)collected.size(), (long)1L);
        Assert.assertEquals((String)"2.1", (Object)"org.eclipse.core.tests.runtime", (Object)((IStatus)collected.get(0)).getPlugin());
    }

    @Test
    public void testIsFragment() throws Exception {
        String bundleName = "testIsFragment";
        File config = RuntimeTestsPlugin.getContext().getDataFile(bundleName);
        Files.createDirectories(config.toPath(), new FileAttribute[0]);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Bundle-SymbolicName", bundleName);
        headers.put("Bundle-Version", "1.0.0");
        File testBundleJarFile = PlatformTest.createBundle(config, bundleName, headers, Collections.emptyMap());
        Bundle hostBundle = this.getContext().installBundle(testBundleJarFile.getName(), Files.newInputStream(testBundleJarFile.toPath(), new OpenOption[0]));
        Assert.assertNotNull((Object)hostBundle);
        Assert.assertFalse((boolean)Platform.isFragment((Bundle)hostBundle));
        String fragmentName = bundleName + "_fragment";
        headers.put("Bundle-SymbolicName", fragmentName);
        headers.put("Bundle-Version", "1.0.0");
        headers.put("Fragment-Host", bundleName);
        testBundleJarFile = PlatformTest.createBundle(config, fragmentName, headers, Collections.emptyMap());
        Bundle fragmentBundle = this.getContext().installBundle(testBundleJarFile.getName(), Files.newInputStream(testBundleJarFile.toPath(), new OpenOption[0]));
        Assert.assertNotNull((Object)fragmentBundle);
        Assert.assertTrue((boolean)Platform.isFragment((Bundle)fragmentBundle));
    }

    @Test
    public void testGetBundle() throws Exception {
        String bundleName = "testGetBundle";
        Map<String, Bundle> bundles = this.createSimpleTestBundles(bundleName, "1.0.0", "2.0.0");
        Bundle bundle = Platform.getBundle((String)bundleName);
        Assert.assertNull((String)(bundleName + " bundle just installed, but not started => expect null result"), (Object)bundle);
        for (Bundle b : bundles.values()) {
            b.start();
        }
        bundle = Platform.getBundle((String)bundleName);
        Assert.assertNotNull((String)"bundle must be available", (Object)bundle);
        Assert.assertEquals((Object)"2.0.0", (Object)bundle.getVersion().toString());
        bundle.uninstall();
        bundle = Platform.getBundle((String)bundleName);
        Assert.assertNotNull((String)"bundle must be available", (Object)bundle);
        Assert.assertEquals((Object)"1.0.0", (Object)bundle.getVersion().toString());
        bundle.uninstall();
        bundle = Platform.getBundle((String)bundleName);
        Assert.assertNull((String)(bundleName + " bundle => expect null result"), (Object)bundle);
    }

    @Test
    public void testILogFactory() {
        ILog staticLog = RuntimeTestsPlugin.getPlugin().getLog();
        Assert.assertNotNull((Object)staticLog);
        tracker.open();
        try (ServiceTracker tracker = new ServiceTracker(RuntimeTestsPlugin.getPlugin().getBundle().getBundleContext(), ILog.class, null);){
            ILog serviceLog = (ILog)tracker.getService();
            Assert.assertEquals((Object)staticLog, (Object)serviceLog);
        }
    }

    @Test
    public void testGetBundles() throws Exception {
        String bundleName = "testGetBundles";
        Map<String, Bundle> bundles = this.createSimpleTestBundles(bundleName, "1.0.0", "3.0.0", "2.0.0");
        Bundle bundle = Platform.getBundle((String)bundleName);
        Assert.assertNull((String)(bundleName + " bundle just installed, but not started => expect null result"), (Object)bundle);
        for (Bundle b : bundles.values()) {
            b.start();
        }
        Object[] result = Platform.getBundles((String)bundleName, null);
        Assert.assertNotNull((String)(bundleName + " bundle not available"), bundles);
        Assertions.assertThat((Object[])result).hasSize(3);
        Assert.assertEquals((long)3L, (long)result[0].getVersion().getMajor());
        Assert.assertEquals((long)1L, (long)result[2].getVersion().getMajor());
        result = Platform.getBundles((String)bundleName, (String)"2.0.0");
        Assertions.assertThat((Object[])result).hasSize(2);
        Assert.assertEquals((long)3L, (long)result[0].getVersion().getMajor());
        Assert.assertEquals((long)2L, (long)result[1].getVersion().getMajor());
        result = Platform.getBundles((String)bundleName, (String)"[1.0.0,2.0.0)");
        Assertions.assertThat((Object[])result).hasSize(1);
        Assert.assertEquals((long)1L, (long)result[0].getVersion().getMajor());
        result = Platform.getBundles((String)bundleName, (String)"[1.1.0,2.0.0)");
        Assert.assertNull((String)"no match => null result", (Object)result);
    }

    @Test
    public void testGetSystemBundle() {
        Bundle expectedSystem = RuntimeTestsPlugin.getContext().getBundle("System Bundle");
        Bundle actualSystem = Platform.getBundle((String)"system.bundle");
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)actualSystem).as("check system bundle", new Object[0])).isEqualTo((Object)expectedSystem);
        Object[] actualSystems = Platform.getBundles((String)"system.bundle", null);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])actualSystems).as("check system bundles", new Object[0])).containsExactly((Object[])new Bundle[]{expectedSystem});
    }

    private Map<String, Bundle> createSimpleTestBundles(String bundleName, String ... versions) throws BundleException, IOException {
        HashMap<String, Bundle> bundles = new HashMap<String, Bundle>();
        File config = RuntimeTestsPlugin.getContext().getDataFile(bundleName);
        Files.createDirectories(config.toPath(), new FileAttribute[0]);
        String[] stringArray = versions;
        int n = versions.length;
        int n2 = 0;
        while (n2 < n) {
            String v = stringArray[n2];
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Bundle-SymbolicName", bundleName);
            headers.put("Bundle-Version", v);
            File testBundleJarFile = PlatformTest.createBundle(config, bundleName + "_" + v, headers, Collections.emptyMap());
            Bundle testBundle = this.getContext().installBundle(testBundleJarFile.getName(), Files.newInputStream(testBundleJarFile.toPath(), new OpenOption[0]));
            Assert.assertNotNull((Object)testBundle);
            bundles.put(v, testBundle);
            ++n2;
        }
        return bundles;
    }

    @SafeVarargs
    static File createBundle(File outputDir, String bundleName, Map<String, String> headers, Map<String, String> ... entries) throws IOException {
        Manifest m = new Manifest();
        Attributes attributes = m.getMainAttributes();
        attributes.putValue("Manifest-Version", "1.0");
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            attributes.putValue(entry.getKey(), entry.getValue());
        }
        File file = new File(outputDir, "bundle" + bundleName + ".jar");
        Object object = null;
        Object var8_9 = null;
        try (JarOutputStream jos = new JarOutputStream(Files.newOutputStream(file.toPath(), new OpenOption[0]), m);){
            if (entries != null) {
                Map<String, String>[] mapArray = entries;
                int n = entries.length;
                int n2 = 0;
                while (n2 < n) {
                    Map<String, String> entryMap = mapArray[n2];
                    for (Map.Entry<String, String> entry : entryMap.entrySet()) {
                        jos.putNextEntry(new JarEntry(entry.getKey()));
                        if (entry.getValue() != null) {
                            jos.write(entry.getValue().getBytes());
                        }
                        jos.closeEntry();
                    }
                    ++n2;
                }
            }
            jos.flush();
        }
        catch (Throwable throwable) {
            if (object == null) {
                object = throwable;
            } else if (object != throwable) {
                ((Throwable)object).addSuppressed(throwable);
            }
            throw object;
        }
        file.deleteOnExit();
        return file;
    }

    @Test
    public void testDebugOption() {
        Assert.assertNull((Object)Platform.getDebugOption((String)"Missing Option"));
        Assert.assertFalse((boolean)Platform.getDebugBoolean((String)"Missing Option"));
        String option = Platform.getDebugOption((String)"org.eclipse.core.runtime/debug-test");
        Assert.assertEquals((Object)"true".equalsIgnoreCase(option), (Object)Platform.getDebugBoolean((String)"org.eclipse.core.runtime/debug-test"));
    }

    private BundleContext getContext() {
        return RuntimeTestsPlugin.getContext();
    }

    static class TestException
    extends Exception {
        private static final long serialVersionUID = 1L;

        TestException() {
        }
    }
}

