/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.runtime;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.tests.runtime.RuntimeTestsPlugin;
import org.junit.Assert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;

@Deprecated
public class PreferenceExportTest {
    @AfterEach
    public void tearDown() throws Exception {
        Plugin testPlugin = RuntimeTestsPlugin.getPlugin();
        Preferences prefs = testPlugin.getPluginPreferences();
        prefs.setDefault("SomeTestKey", "");
        prefs.setDefault("SomeOtherTestKey", "");
        prefs.setToDefault("SomeTestKey");
        prefs.setToDefault("SomeOtherTestKey");
        testPlugin.savePluginPreferences();
    }

    @Test
    public void testExportEmptyPreference() throws CoreException {
        String key1 = "SomeTestKey";
        String key2 = "SomeOtherTestKey";
        String default1 = "SomeTestValue";
        int default2 = 5;
        IPath exportPath = IPath.fromOSString((String)System.getProperty("java.io.tmpdir")).append(Long.toString(System.currentTimeMillis()));
        exportPath.toFile().delete();
        Plugin testPlugin = RuntimeTestsPlugin.getPlugin();
        Preferences prefs = testPlugin.getPluginPreferences();
        try {
            prefs.setDefault("SomeTestKey", "SomeTestValue");
            prefs.setValue("SomeTestKey", "");
            prefs.setDefault("SomeOtherTestKey", 5);
            prefs.setValue("SomeOtherTestKey", 0);
            testPlugin.savePluginPreferences();
            Preferences.exportPreferences((IPath)exportPath);
            prefs.setToDefault("SomeTestKey");
            prefs.setToDefault("SomeOtherTestKey");
            Assert.assertEquals((String)"1.0", (Object)"SomeTestValue", (Object)prefs.getString("SomeTestKey"));
            Assert.assertEquals((String)"1.1", (long)5L, (long)prefs.getInt("SomeOtherTestKey"));
            Preferences.importPreferences((IPath)exportPath);
            Assert.assertEquals((String)"2.0", (Object)"", (Object)prefs.getString("SomeTestKey"));
            Assert.assertEquals((String)"2.1", (long)0L, (long)prefs.getInt("SomeOtherTestKey"));
        }
        finally {
            exportPath.toFile().delete();
        }
    }

    @Test
    public void testKeyIdentityAfterExport() throws CoreException {
        String key = "SomeTestKey";
        String initialValue = "SomeTestValue";
        IPath exportPath = IPath.fromOSString((String)System.getProperty("java.io.tmpdir")).append(Long.toString(System.currentTimeMillis()));
        exportPath.toFile().delete();
        Plugin testPlugin = RuntimeTestsPlugin.getPlugin();
        Preferences prefs = testPlugin.getPluginPreferences();
        Preferences.IPropertyChangeListener listener = event -> Assert.assertSame((String)"1.0", (Object)event.getProperty(), (Object)"SomeTestKey");
        prefs.addPropertyChangeListener(listener);
        try {
            prefs.setValue("SomeTestKey", initialValue);
            testPlugin.savePluginPreferences();
            Preferences.exportPreferences((IPath)exportPath);
            prefs.setValue("SomeTestKey", "SomeOtherValue");
            Preferences.importPreferences((IPath)exportPath);
            prefs.setToDefault("SomeTestKey");
            Preferences.importPreferences((IPath)exportPath);
        }
        finally {
            exportPath.toFile().delete();
            if (prefs != null) {
                prefs.removePropertyChangeListener(listener);
            }
        }
    }
}

