/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.runtime;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import org.assertj.core.api.Assertions;
import org.eclipse.core.runtime.Preferences;
import org.junit.Assert;
import org.junit.jupiter.api.Test;

@Deprecated
public class PreferencesTest {
    @Test
    public void testConstants() {
        Assert.assertEquals((String)"Different values", (Object)false, (Object)false);
        Assert.assertEquals((String)"Different values", (long)0L, (long)0L);
        Assert.assertEquals((String)"Different values", (long)0L, (long)0L);
        Assert.assertEquals((String)"Different values", (float)0.0f, (float)0.0f, (float)0.0f);
        Assert.assertEquals((String)"Different values", (double)0.0, (double)0.0, (double)0.0);
        Assert.assertTrue((boolean)"".isEmpty());
    }

    @Test
    public void testBasics() {
        Preferences ps = new Preferences();
        String k1 = "key1";
        String v1 = "1";
        String v2 = "2";
        String v3 = "3";
        Assert.assertTrue((String)"1.0", (boolean)ps.isDefault("key1"));
        Assert.assertEquals((String)"1.1", (Object)ps.getBoolean("key1"), (Object)false);
        Assert.assertEquals((String)"1.2", (long)ps.getInt("key1"), (long)0L);
        Assert.assertEquals((String)"1.3", (long)ps.getLong("key1"), (long)0L);
        Assert.assertEquals((String)"1.4", (float)ps.getFloat("key1"), (float)0.0f, (float)0.0f);
        Assert.assertEquals((String)"1.5", (double)ps.getDouble("key1"), (double)0.0, (double)0.0);
        Assert.assertTrue((String)"1.6", (boolean)ps.getString("key1").equals(""));
        Assert.assertEquals((String)"1.7", (Object)ps.getDefaultBoolean("key1"), (Object)false);
        Assert.assertEquals((String)"1.8", (long)ps.getDefaultInt("key1"), (long)0L);
        Assert.assertEquals((String)"1.9", (long)ps.getDefaultLong("key1"), (long)0L);
        Assert.assertEquals((String)"1.10", (float)ps.getDefaultFloat("key1"), (float)0.0f, (float)0.0f);
        Assert.assertEquals((String)"1.11", (double)ps.getDefaultDouble("key1"), (double)0.0, (double)0.0);
        Assert.assertTrue((String)"1.12", (boolean)ps.getDefaultString("key1").equals(""));
        ps.setValue("key1", "1");
        Assert.assertFalse((String)"2.0", (boolean)ps.isDefault("key1"));
        Assert.assertTrue((String)"2.1", (boolean)ps.getString("key1").equals("1"));
        Assert.assertTrue((String)"2.2", (boolean)ps.getDefaultString("key1").equals(""));
        ps.setValue("key1", "2");
        Assert.assertFalse((String)"2.3", (boolean)ps.isDefault("key1"));
        Assert.assertTrue((String)"2.4", (boolean)ps.getString("key1").equals("2"));
        Assert.assertTrue((String)"2.5", (boolean)ps.getDefaultString("key1").equals(""));
        ps.setValue("key1", ps.getDefaultString("key1"));
        Assert.assertTrue((String)"2.6", (boolean)ps.isDefault("key1"));
        Assert.assertTrue((String)"2.7", (boolean)ps.getString("key1").equals(ps.getDefaultString("key1")));
        Assert.assertTrue((String)"2.8", (boolean)ps.getDefaultString("key1").equals(""));
        ps.setValue("key1", "2");
        ps.setToDefault("key1");
        Assert.assertTrue((String)"2.9", (boolean)ps.isDefault("key1"));
        Assert.assertTrue((String)"2.10", (boolean)ps.getString("key1").equals(""));
        Assert.assertTrue((String)"2.11", (boolean)ps.getDefaultString("key1").equals(""));
        ps.setDefault("key1", "1");
        Assert.assertTrue((String)"2.12", (boolean)ps.isDefault("key1"));
        Assert.assertTrue((String)"2.13", (boolean)ps.getString("key1").equals("1"));
        Assert.assertTrue((String)"2.14", (boolean)ps.getDefaultString("key1").equals("1"));
        ps.setValue("key1", "2");
        Assert.assertFalse((String)"2.15", (boolean)ps.isDefault("key1"));
        Assert.assertTrue((String)"2.16", (boolean)ps.getString("key1").equals("2"));
        Assert.assertTrue((String)"2.17", (boolean)ps.getDefaultString("key1").equals("1"));
        ps.setValue("key1", ps.getDefaultString("key1"));
        Assert.assertTrue((String)"2.18", (boolean)ps.isDefault("key1"));
        Assert.assertTrue((String)"2.19", (boolean)ps.getString("key1").equals(ps.getDefaultString("key1")));
        Assert.assertTrue((String)"2.20", (boolean)ps.getDefaultString("key1").equals("1"));
        ps.setValue("key1", "2");
        ps.setToDefault("key1");
        Assert.assertTrue((String)"2.21", (boolean)ps.isDefault("key1"));
        Assert.assertTrue((String)"2.22", (boolean)ps.getString("key1").equals("1"));
        Assert.assertTrue((String)"2.23", (boolean)ps.getDefaultString("key1").equals("1"));
        ps.setDefault("key1", "3");
        Assert.assertTrue((String)"2.24", (boolean)ps.isDefault("key1"));
        Assert.assertTrue((String)"2.25", (boolean)ps.getString("key1").equals("3"));
        Assert.assertTrue((String)"2.26", (boolean)ps.getDefaultString("key1").equals("3"));
    }

    @Test
    public void testBoolean() {
        Preferences ps = new Preferences();
        String k1 = "key1";
        Assert.assertEquals((String)"1.0", (Object)false, (Object)false);
        Assert.assertEquals((String)"1.1", (Object)false, (Object)ps.getBoolean("key1"));
        ps.setValue("key1", true);
        Assert.assertEquals((String)"1.2", (Object)true, (Object)ps.getBoolean("key1"));
        ps.setValue("key1", false);
        Assert.assertEquals((String)"1.3", (Object)false, (Object)ps.getBoolean("key1"));
        ps.setDefault("key1", true);
        Assert.assertEquals((String)"1.4", (Object)true, (Object)ps.getDefaultBoolean("key1"));
        ps.setDefault("key1", false);
        Assert.assertEquals((String)"1.5", (Object)false, (Object)ps.getDefaultBoolean("key1"));
    }

    @Test
    public void testInteger() {
        Preferences ps = new Preferences();
        String k1 = "key1";
        int[] nArray = new int[5];
        nArray[1] = 1002;
        nArray[2] = -201788;
        nArray[3] = Integer.MAX_VALUE;
        nArray[4] = Integer.MIN_VALUE;
        int[] values = nArray;
        Assert.assertEquals((String)"1.0", (long)0L, (long)0L);
        Assert.assertEquals((String)"1.1", (long)0L, (long)ps.getInt("key1"));
        int[] nArray2 = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            int v1 = nArray2[n2];
            int v2 = v1 + 1;
            ps.setValue("key1", v1);
            Assert.assertEquals((String)"1.2", (long)v1, (long)ps.getInt("key1"));
            ps.setDefault("key1", v2);
            Assert.assertEquals((String)"1.3", (long)v2, (long)ps.getDefaultInt("key1"));
            ++n2;
        }
    }

    @Test
    public void testLong() {
        Preferences ps = new Preferences();
        String k1 = "key1";
        long[] lArray = new long[5];
        lArray[1] = 1002L;
        lArray[2] = -201788L;
        lArray[3] = Long.MAX_VALUE;
        lArray[4] = Long.MIN_VALUE;
        long[] values = lArray;
        Assert.assertEquals((String)"1.0", (long)0L, (long)0L);
        Assert.assertEquals((String)"1.1", (long)0L, (long)ps.getLong("key1"));
        long[] lArray2 = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            long v1 = lArray2[n2];
            long v2 = v1 + 1L;
            ps.setValue("key1", v1);
            Assert.assertEquals((String)"1.2", (long)v1, (long)ps.getLong("key1"));
            ps.setDefault("key1", v2);
            Assert.assertEquals((String)"1.3", (long)v2, (long)ps.getDefaultLong("key1"));
            ++n2;
        }
    }

    @Test
    public void testFloat() {
        Preferences ps = new Preferences();
        String k1 = "key1";
        float[] values = new float[]{0.0f, 1002.5f, -201788.55f, Float.MAX_VALUE, Float.MIN_VALUE};
        float tol = 1.0E-20f;
        Assert.assertEquals((String)"1.0", (float)0.0f, (float)0.0f, (float)1.0E-20f);
        Assert.assertEquals((String)"1.1", (float)0.0f, (float)ps.getFloat("key1"), (float)1.0E-20f);
        float[] fArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            float v1 = fArray[n2];
            float v2 = v1 + 1.0f;
            ps.setValue("key1", v1);
            Assert.assertEquals((String)"1.2", (float)v1, (float)ps.getFloat("key1"), (float)1.0E-20f);
            ps.setDefault("key1", v2);
            Assert.assertEquals((String)"1.3", (float)v2, (float)ps.getDefaultFloat("key1"), (float)1.0E-20f);
            ++n2;
        }
        Assert.assertThrows((String)"NaNs should be rejected", IllegalArgumentException.class, () -> ps.setValue("key1", Float.NaN));
    }

    @Test
    public void testDouble() {
        Preferences ps = new Preferences();
        String k1 = "key1";
        double[] values = new double[]{0.0, 1002.5, -201788.55, Double.MAX_VALUE, Double.MIN_VALUE};
        double tol = 1.0E-20;
        Assert.assertEquals((String)"1.0", (double)0.0, (double)0.0, (double)1.0E-20);
        Assert.assertEquals((String)"1.1", (double)0.0, (double)ps.getDouble("key1"), (double)1.0E-20);
        double[] dArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            double v1 = dArray[n2];
            double v2 = v1 + 1.0;
            ps.setValue("key1", v1);
            Assert.assertEquals((String)"1.2", (double)v1, (double)ps.getDouble("key1"), (double)1.0E-20);
            ps.setDefault("key1", v2);
            Assert.assertEquals((String)"1.3", (double)v2, (double)ps.getDefaultDouble("key1"), (double)1.0E-20);
            ++n2;
        }
        Assert.assertThrows((String)"NaNs should be rejected", IllegalArgumentException.class, () -> ps.setValue("key1", Float.NaN));
    }

    @Test
    public void testString() {
        Preferences ps = new Preferences();
        String k1 = "key1";
        String[] values = new String[]{"", "hello", " x ", "\n"};
        Assert.assertEquals((String)"1.0", (Object)"", (Object)"");
        Assert.assertEquals((String)"1.1", (Object)ps.getString("key1"), (Object)"");
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String v1 = stringArray[n2];
            String v2 = v1 + "x";
            ps.setValue("key1", v1);
            Assert.assertEquals((String)"1.2", (Object)v1, (Object)ps.getString("key1"));
            ps.setDefault("key1", v2);
            Assert.assertEquals((String)"1.3", (Object)v2, (Object)ps.getDefaultString("key1"));
            ++n2;
        }
    }

    @Test
    public void testPropertyNames() {
        String key;
        String[] keys;
        Preferences ps = new Preferences();
        Assertions.assertThat((Object[])ps.propertyNames()).isEmpty();
        String[] stringArray = keys = new String[]{"a", "b", "c", "d"};
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            key = stringArray[n2];
            ps.setDefault(key, "default");
            ++n2;
        }
        Assertions.assertThat((Object[])ps.propertyNames()).isEmpty();
        stringArray = keys;
        n = keys.length;
        n2 = 0;
        while (n2 < n) {
            key = stringArray[n2];
            ps.setValue(key, "actual");
            ++n2;
        }
        Assertions.assertThat((Object[])ps.propertyNames()).hasSameSizeAs((Object)keys);
        HashSet<String> s1 = new HashSet<String>(Arrays.asList(keys));
        HashSet<String> s2 = new HashSet<String>(Arrays.asList(ps.propertyNames()));
        Assert.assertEquals((String)"1.3", s1, s2);
        String[] stringArray2 = keys;
        int n3 = keys.length;
        int n4 = 0;
        while (n4 < n3) {
            String key2 = stringArray2[n4];
            ps.setToDefault(key2);
            HashSet<String> s = new HashSet<String>(Arrays.asList(ps.propertyNames()));
            Assert.assertTrue((String)"1.4", (!s.contains(key2) ? 1 : 0) != 0);
            ++n4;
        }
        Assertions.assertThat((Object[])ps.propertyNames()).isEmpty();
    }

    @Test
    public void testContains() {
        Preferences ps = new Preferences();
        Assert.assertEquals((String)"1.0", (Object)false, (Object)ps.contains("a"));
        ps.setDefault("a", "default");
        Assert.assertEquals((String)"1.1", (Object)true, (Object)ps.contains("a"));
        Assert.assertEquals((String)"1.2", (Object)false, (Object)ps.contains("b"));
        ps.setValue("b", "any");
        Assert.assertEquals((String)"1.3", (Object)true, (Object)ps.contains("b"));
        ps.setValue("a", "any");
        Assert.assertEquals((String)"1.4", (Object)true, (Object)ps.contains("a"));
        Assert.assertEquals((String)"1.5", (Object)true, (Object)ps.contains("b"));
        ps.setToDefault("b");
        Assert.assertEquals((String)"1.6", (Object)false, (Object)ps.contains("b"));
        ps.setToDefault("a");
        Assert.assertEquals((String)"1.7", (Object)true, (Object)ps.contains("a"));
        Assert.assertTrue((String)"2.0", (!ps.contains("c") ? 1 : 0) != 0);
        ps.setDefault("c", "");
        Assert.assertTrue((String)"2.1", (boolean)ps.contains("c"));
    }

    @Test
    public void testDefaultPropertyNames() {
        HashSet<String> s;
        String key;
        String[] keys;
        Preferences ps = new Preferences();
        Assertions.assertThat((Object[])ps.defaultPropertyNames()).isEmpty();
        String[] stringArray = keys = new String[]{"a", "b", "c", "d"};
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            key = stringArray[n2];
            ps.setValue(key, "actual");
            ++n2;
        }
        Assertions.assertThat((Object[])ps.defaultPropertyNames()).isEmpty();
        stringArray = keys;
        n = keys.length;
        n2 = 0;
        while (n2 < n) {
            key = stringArray[n2];
            ps.setDefault(key, "default");
            ++n2;
        }
        Assertions.assertThat((Object[])ps.defaultPropertyNames()).hasSameSizeAs((Object)keys);
        HashSet<String> s1 = new HashSet<String>(Arrays.asList(keys));
        HashSet<String> s2 = new HashSet<String>(Arrays.asList(ps.defaultPropertyNames()));
        Assert.assertEquals((String)"1.3", s1, s2);
        String[] stringArray2 = keys;
        int n3 = keys.length;
        int n4 = 0;
        while (n4 < n3) {
            String key2 = stringArray2[n4];
            ps.setToDefault(key2);
            s = new HashSet<String>(Arrays.asList(ps.defaultPropertyNames()));
            Assert.assertTrue((String)"1.4", (boolean)s.contains(key2));
            ++n4;
        }
        Assertions.assertThat((Object[])ps.defaultPropertyNames()).hasSameSizeAs((Object)keys);
        stringArray2 = keys;
        n3 = keys.length;
        n4 = 0;
        while (n4 < n3) {
            String key3 = stringArray2[n4];
            ps.setDefault(key3, "");
            s = new HashSet<String>(Arrays.asList(ps.defaultPropertyNames()));
            Assert.assertTrue((String)"1.6.1", (boolean)s.contains(key3));
            ps.setDefault(key3, false);
            s = new HashSet<String>(Arrays.asList(ps.defaultPropertyNames()));
            Assert.assertTrue((String)"1.6.2", (boolean)s.contains(key3));
            ps.setDefault(key3, 0);
            s = new HashSet<String>(Arrays.asList(ps.defaultPropertyNames()));
            Assert.assertTrue((String)"1.6.3", (boolean)s.contains(key3));
            ps.setDefault(key3, 0L);
            s = new HashSet<String>(Arrays.asList(ps.defaultPropertyNames()));
            Assert.assertTrue((String)"1.6.4", (boolean)s.contains(key3));
            ps.setDefault(key3, 0.0f);
            s = new HashSet<String>(Arrays.asList(ps.defaultPropertyNames()));
            Assert.assertTrue((String)"1.6.5", (boolean)s.contains(key3));
            ps.setDefault(key3, 0.0);
            s = new HashSet<String>(Arrays.asList(ps.defaultPropertyNames()));
            Assert.assertTrue((String)"1.6.6", (boolean)s.contains(key3));
            ++n4;
        }
        Assertions.assertThat((Object[])ps.defaultPropertyNames()).hasSameSizeAs((Object)keys);
    }

    @Test
    public void testListeners2() {
        Preferences ps = new Preferences();
        Tracer tracer = new Tracer();
        String key = "a";
        ps.addPropertyChangeListener((Preferences.IPropertyChangeListener)tracer);
        ps.setDefault(key, 1);
        ps.setValue(key, 2);
        Assert.assertEquals((String)"1.0", (Object)"[a:I1->I2]", (Object)tracer.log.toString());
        tracer.log.setLength(0);
        ps.setValue(key, 3);
        Assert.assertEquals((String)"1.1", (Object)"[a:I2->I3]", (Object)tracer.log.toString());
        tracer.log.setLength(0);
        ps.setToDefault(key);
        Assert.assertEquals((String)"1.2", (Object)"[a:S3->S1]", (Object)tracer.log.toString());
        tracer.log.setLength(0);
        ps.setDefault(key, 0);
        ps.setValue(key, 2);
        Assert.assertEquals((String)"1.3", (Object)"[a:I0->I2]", (Object)tracer.log.toString());
        tracer.log.setLength(0);
        ps.setValue(key, ps.getDefaultInt(key));
        Assert.assertEquals((String)"1.4", (Object)"[a:I2->I0]", (Object)tracer.log.toString());
    }

    @Test
    public void testListeners() {
        Preferences ps = new Preferences();
        Tracer tracer1 = new Tracer();
        Tracer tracer2 = new Tracer();
        ps.addPropertyChangeListener((Preferences.IPropertyChangeListener)tracer1);
        Assert.assertEquals((String)"1.0", (Object)"", (Object)tracer1.log.toString());
        ps.setValue("a", "1");
        Assert.assertEquals((String)"1.0.1", (Object)"[a:S->S1]", (Object)tracer1.log.toString());
        ps.setToDefault("a");
        tracer1.log.setLength(0);
        ps.setValue("a", true);
        Assert.assertEquals((String)"1.0.2", (Object)"[a:Bfalse->Btrue]", (Object)tracer1.log.toString());
        ps.setToDefault("a");
        tracer1.log.setLength(0);
        ps.setValue("a", 100);
        Assert.assertEquals((String)"1.0.3", (Object)"[a:I0->I100]", (Object)tracer1.log.toString());
        ps.setToDefault("a");
        tracer1.log.setLength(0);
        ps.setValue("a", 100L);
        Assert.assertEquals((String)"1.0.4", (Object)"[a:L0->L100]", (Object)tracer1.log.toString());
        ps.setToDefault("a");
        tracer1.log.setLength(0);
        ps.setValue("a", 2.0f);
        Assert.assertEquals((String)"1.0.5", (Object)"[a:F0.0->F2.0]", (Object)tracer1.log.toString());
        ps.setToDefault("a");
        tracer1.log.setLength(0);
        ps.setValue("a", 2.0);
        Assert.assertEquals((String)"1.0.6", (Object)"[a:D0.0->D2.0]", (Object)tracer1.log.toString());
        ps.setToDefault("a");
        tracer1.log.setLength(0);
        ps.setValue("a", "1");
        Assert.assertEquals((String)"1.1", (Object)"[a:S->S1]", (Object)tracer1.log.toString());
        ps.setValue("a", "2");
        Assert.assertEquals((String)"1.2", (Object)"[a:S->S1][a:S1->S2]", (Object)tracer1.log.toString());
        ps.setValue("a", ps.getDefaultString("a"));
        Assert.assertEquals((String)"1.2.1", (Object)"[a:S->S1][a:S1->S2][a:S2->S]", (Object)tracer1.log.toString());
        ps.setValue("a", "3");
        Assert.assertEquals((String)"1.2.2", (Object)"[a:S->S1][a:S1->S2][a:S2->S][a:S->S3]", (Object)tracer1.log.toString());
        ps.setToDefault("a");
        Assert.assertEquals((String)"1.2.3", (Object)"[a:S->S1][a:S1->S2][a:S2->S][a:S->S3][a:S3->null]", (Object)tracer1.log.toString());
        ps.setValue("a", "2");
        tracer1.log.setLength(0);
        Assert.assertEquals((String)"1.3", (Object)"", (Object)tracer1.log.toString());
        ps.addPropertyChangeListener((Preferences.IPropertyChangeListener)tracer2);
        ps.setValue("a", "3");
        Assert.assertEquals((String)"1.4", (Object)"[a:S2->S3]", (Object)tracer1.log.toString());
        Assert.assertEquals((String)"1.5", (Object)"[a:S2->S3]", (Object)tracer2.log.toString());
        ps.removePropertyChangeListener((Preferences.IPropertyChangeListener)tracer2);
        tracer1.log.setLength(0);
        tracer2.log.setLength(0);
        ps.setValue("a", "1");
        Assert.assertEquals((String)"1.6", (Object)"[a:S3->S1]", (Object)tracer1.log.toString());
        Assert.assertEquals((String)"1.7", (Object)"", (Object)tracer2.log.toString());
        ps.removePropertyChangeListener((Preferences.IPropertyChangeListener)tracer2);
        tracer1.log.setLength(0);
        tracer2.log.setLength(0);
        ps.setValue("a", "2");
        Assert.assertEquals((String)"1.8", (Object)"[a:S1->S2]", (Object)tracer1.log.toString());
        Assert.assertEquals((String)"1.9", (Object)"", (Object)tracer2.log.toString());
        ps.addPropertyChangeListener((Preferences.IPropertyChangeListener)tracer1);
        tracer1.log.setLength(0);
        ps.setValue("a", "1");
        Assert.assertEquals((String)"1.10", (Object)"[a:S2->S1]", (Object)tracer1.log.toString());
        ps.removePropertyChangeListener((Preferences.IPropertyChangeListener)tracer1);
        tracer1.log.setLength(0);
        ps.setValue("a", "4");
        Assert.assertEquals((String)"1.11", (Object)"", (Object)tracer1.log.toString());
        ps.setValue("a", "0");
        ps.addPropertyChangeListener((Preferences.IPropertyChangeListener)tracer1);
        class Trouble
        implements Preferences.IPropertyChangeListener {
            private final /* synthetic */ Preferences val$ps;
            private final /* synthetic */ Tracer val$tracer1;
            private final /* synthetic */ Tracer val$tracer2;

            Trouble(Preferences preferences, Tracer tracer, Tracer tracer2) {
                this.val$ps = preferences;
                this.val$tracer1 = tracer;
                this.val$tracer2 = tracer2;
            }

            public void propertyChange(Preferences.PropertyChangeEvent event) {
                this.val$ps.removePropertyChangeListener((Preferences.IPropertyChangeListener)this.val$tracer1);
                this.val$ps.addPropertyChangeListener((Preferences.IPropertyChangeListener)this.val$tracer2);
            }
        }
        ps.addPropertyChangeListener((Preferences.IPropertyChangeListener)new Trouble(ps, tracer1, tracer2));
        tracer1.log.setLength(0);
        tracer2.log.setLength(0);
        ps.setValue("a", "1");
        ps.setValue("a", "2");
        Assert.assertEquals((String)"1.12", (Object)"[a:S0->S1]", (Object)tracer1.log.toString());
        Assert.assertEquals((String)"1.13", (Object)"[a:S1->S2]", (Object)tracer2.log.toString());
    }

    @Test
    public void testLoadStore() throws IOException {
        byte[] bytes;
        ByteArrayOutputStream out22;
        Preferences ps = new Preferences();
        ps.setValue("b1", true);
        ps.setValue("i1", 1);
        ps.setValue("l1", 2L);
        ps.setValue("f1", 1.0f);
        ps.setValue("d1", 1.0);
        ps.setValue("s1", "x");
        String[] keys = new String[]{"b1", "i1", "l1", "f1", "d1", "s1"};
        Throwable throwable = null;
        Throwable throwable2 = null;
        try {
            out22 = new ByteArrayOutputStream();
            try {
                ps.store((OutputStream)out22, "test header");
                bytes = out22.toByteArray();
            }
            finally {
                if (out22 != null) {
                    out22.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        Preferences ps2 = new Preferences();
        throwable2 = null;
        out22 = null;
        try (ByteArrayInputStream in = new ByteArrayInputStream(bytes);){
            ps2.load((InputStream)in);
        }
        catch (Throwable out22) {
            if (throwable2 == null) {
                throwable2 = out22;
            } else if (throwable2 != out22) {
                throwable2.addSuppressed(out22);
            }
            throw throwable2;
        }
        Assert.assertEquals((String)"1.1", (Object)true, (Object)ps2.getBoolean("b1"));
        Assert.assertEquals((String)"1.2", (long)1L, (long)ps2.getInt("i1"));
        Assert.assertEquals((String)"1.3", (long)2L, (long)ps2.getLong("l1"));
        Assert.assertEquals((String)"1.4", (float)1.0f, (float)ps2.getFloat("f1"), (float)1.0E-20f);
        Assert.assertEquals((String)"1.5", (double)1.0, (double)ps2.getDouble("d1"), (double)1.0E-20);
        Assert.assertEquals((String)"1.6", (Object)"x", (Object)ps2.getString("s1"));
        HashSet<String> s1 = new HashSet<String>(Arrays.asList(keys));
        HashSet<String> s2 = new HashSet<String>(Arrays.asList(ps2.propertyNames()));
        Assert.assertEquals((String)"1.7", s1, s2);
        Preferences ps3 = new Preferences();
        ps3.setValue("s1", "y");
        Throwable throwable4 = null;
        Object var9_14 = null;
        try (ByteArrayInputStream in = new ByteArrayInputStream(bytes);){
            ps3.load((InputStream)in);
        }
        catch (Throwable throwable5) {
            if (throwable4 == null) {
                throwable4 = throwable5;
            } else if (throwable4 != throwable5) {
                throwable4.addSuppressed(throwable5);
            }
            throw throwable4;
        }
        Assert.assertEquals((String)"1.8", (Object)"x", (Object)ps3.getString("s1"));
        HashSet<String> k1 = new HashSet<String>(Arrays.asList(keys));
        HashSet<String> k2 = new HashSet<String>(Arrays.asList(ps3.propertyNames()));
        Assert.assertEquals((String)"1.9", k1, k2);
    }

    @Test
    public void testNeedsSaving() throws IOException {
        ByteArrayInputStream in;
        Object var6_12;
        Throwable throwable;
        ByteArrayOutputStream out;
        Preferences ps = new Preferences();
        ps = new Preferences();
        Assert.assertEquals((String)"1.0", (Object)false, (Object)ps.needsSaving());
        ps.setValue("b1", true);
        Assert.assertEquals((String)"1.1", (Object)true, (Object)ps.needsSaving());
        ps = new Preferences();
        Assert.assertEquals((String)"2.0", (Object)false, (Object)ps.needsSaving());
        ps.setValue("i1", 1);
        Assert.assertEquals((String)"2.1", (Object)true, (Object)ps.needsSaving());
        ps = new Preferences();
        Assert.assertEquals((String)"3.0", (Object)false, (Object)ps.needsSaving());
        ps.setValue("l1", 2L);
        Assert.assertEquals((String)"3.1", (Object)true, (Object)ps.needsSaving());
        ps = new Preferences();
        Assert.assertEquals((String)"4.0", (Object)false, (Object)ps.needsSaving());
        ps.setValue("f1", 1.0f);
        Assert.assertEquals((String)"4.1", (Object)true, (Object)ps.needsSaving());
        ps = new Preferences();
        Assert.assertEquals((String)"5.0", (Object)false, (Object)ps.needsSaving());
        ps.setValue("d1", 1.0);
        Assert.assertEquals((String)"5.1", (Object)true, (Object)ps.needsSaving());
        ps = new Preferences();
        Assert.assertEquals((String)"6.0", (Object)false, (Object)ps.needsSaving());
        ps.setValue("s1", "x");
        Assert.assertEquals((String)"6.1", (Object)true, (Object)ps.needsSaving());
        ps = new Preferences();
        Assert.assertEquals((String)"7.0", (Object)false, (Object)ps.needsSaving());
        ps.setToDefault("any");
        Assert.assertEquals((String)"7.1", (Object)false, (Object)ps.needsSaving());
        ps = new Preferences();
        Assert.assertEquals((String)"7.2", (Object)false, (Object)ps.needsSaving());
        ps.setValue("any", "x");
        Throwable throwable2 = null;
        Object var3_5 = null;
        try {
            out = new ByteArrayOutputStream();
            try {
                ps.store((OutputStream)out, "test header");
                throwable = null;
                var6_12 = null;
                try {
                    in = new ByteArrayInputStream(out.toByteArray());
                    try {
                        ps.load((InputStream)in);
                    }
                    finally {
                        if (in != null) {
                            in.close();
                        }
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable2 == null) {
                throwable2 = throwable4;
            } else if (throwable2 != throwable4) {
                throwable2.addSuppressed(throwable4);
            }
            throw throwable2;
        }
        Assert.assertEquals((String)"7.3", (Object)false, (Object)ps.needsSaving());
        ps.setToDefault("any");
        Assert.assertEquals((String)"7.4", (Object)true, (Object)ps.needsSaving());
        ps = new Preferences();
        Assert.assertEquals((String)"8.0", (Object)false, (Object)ps.needsSaving());
        ps.setDefault("b1", true);
        ps.getBoolean("b1");
        ps.getDefaultBoolean("b1");
        ps.setDefault("i1", 1);
        ps.getInt("i1");
        ps.getDefaultInt("i1");
        ps.setDefault("l1", 1L);
        ps.getLong("l1");
        ps.getDefaultLong("l1");
        ps.setDefault("f1", 1.0f);
        ps.getFloat("f1");
        ps.getDefaultFloat("f1");
        ps.setDefault("d1", 1.0);
        ps.getDouble("d1");
        ps.getDefaultDouble("d1");
        ps.setDefault("s1", "x");
        ps.getString("s1");
        ps.getDefaultString("s1");
        Assert.assertEquals((String)"8.1", (Object)false, (Object)ps.needsSaving());
        ps = new Preferences();
        Assert.assertEquals((String)"9.1", (Object)false, (Object)ps.needsSaving());
        ps.setValue("b1", true);
        Assert.assertEquals((String)"9.2", (Object)true, (Object)ps.needsSaving());
        throwable2 = null;
        var3_5 = null;
        try {
            out = new ByteArrayOutputStream();
            try {
                ps.store((OutputStream)out, "test header");
                Assert.assertEquals((String)"9.3", (Object)false, (Object)ps.needsSaving());
                ps.setValue("b1", false);
                Assert.assertEquals((String)"9.4", (Object)true, (Object)ps.needsSaving());
                throwable = null;
                var6_12 = null;
                try {
                    in = new ByteArrayInputStream(out.toByteArray());
                    try {
                        ps.load((InputStream)in);
                    }
                    finally {
                        if (in != null) {
                            in.close();
                        }
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable == null) {
                        throwable = throwable5;
                    } else if (throwable != throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    throw throwable;
                }
                Assert.assertEquals((String)"9.5", (Object)false, (Object)ps.needsSaving());
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }
        catch (Throwable throwable6) {
            if (throwable2 == null) {
                throwable2 = throwable6;
            } else if (throwable2 != throwable6) {
                throwable2.addSuppressed(throwable6);
            }
            throw throwable2;
        }
    }

    static class Tracer
    implements Preferences.IPropertyChangeListener {
        public StringBuilder log = new StringBuilder();

        Tracer() {
        }

        private String typeCode(Object value) {
            if (value == null) {
                return "";
            }
            if (value instanceof Boolean) {
                return "B";
            }
            if (value instanceof Integer) {
                return "I";
            }
            if (value instanceof Long) {
                return "L";
            }
            if (value instanceof Float) {
                return "F";
            }
            if (value instanceof Double) {
                return "D";
            }
            if (value instanceof String) {
                return "S";
            }
            Assert.assertTrue((String)"0.0", (boolean)false);
            return null;
        }

        public void propertyChange(Preferences.PropertyChangeEvent event) {
            this.log.append("[");
            this.log.append(event.getProperty());
            this.log.append(":");
            this.log.append(this.typeCode(event.getOldValue()));
            this.log.append(event.getOldValue() == null ? "null" : event.getOldValue());
            this.log.append("->");
            this.log.append(this.typeCode(event.getNewValue()));
            this.log.append(event.getNewValue() == null ? "null" : event.getNewValue());
            this.log.append("]");
        }
    }
}

