/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.runtime;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.BundleContext;

public class RuntimeTestsPlugin
extends Plugin {
    public static final String PI_RUNTIME_TESTS = "org.eclipse.core.tests.runtime";
    public static final String TEST_FILES_ROOT = "Plugin_Testing/";
    private static RuntimeTestsPlugin plugin;
    private BundleContext bundleContext;

    public RuntimeTestsPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.bundleContext = context;
    }

    public void stop(BundleContext context) throws Exception {
        context = null;
    }

    public static BundleContext getContext() {
        return plugin != null ? RuntimeTestsPlugin.plugin.bundleContext : null;
    }

    public static Plugin getPlugin() {
        return plugin;
    }

    public static boolean delete(File file) {
        if (!file.exists()) {
            return true;
        }
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            if (children == null) {
                children = new File[]{};
            }
            File[] fileArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File element = fileArray[n2];
                RuntimeTestsPlugin.delete(element);
                ++n2;
            }
        }
        return file.delete();
    }

    public static String getUniqueString() {
        return System.currentTimeMillis() + "-" + Math.random();
    }

    public static File getTempFolder() {
        String name = RuntimeTestsPlugin.getUniqueString();
        String tempDir = System.getProperty("java.io.tmpdir");
        File testFolder = new File(tempDir, name);
        if (testFolder.exists()) {
            RuntimeTestsPlugin.delete(testFolder);
        }
        testFolder.mkdirs();
        return testFolder;
    }

    public static File getTestData(String entry) {
        if (entry == null) {
            return null;
        }
        URL base = RuntimeTestsPlugin.getContext().getBundle().getEntry(entry);
        if (base == null) {
            return null;
        }
        try {
            String osPath = IPath.fromOSString((String)FileLocator.toFileURL((URL)base).getPath()).toOSString();
            File result = new File(osPath);
            return result.getCanonicalPath().equals(result.getPath()) ? result : null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static void copy(File source, File target) throws IOException {
        RuntimeTestsPlugin.copy(source, target, null);
    }

    public static void copy(File source, File target, FileFilter filter) throws IOException {
        if (!source.exists()) {
            return;
        }
        if (source.isDirectory()) {
            File[] children;
            if (target.exists() && target.isFile()) {
                target.delete();
            }
            if (!target.exists()) {
                target.mkdirs();
            }
            if ((children = source.listFiles(filter)) == null) {
                throw new IOException("Content from directory '" + source.getAbsolutePath() + "' can not be listed.");
            }
            File[] fileArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File element = fileArray[n2];
                RuntimeTestsPlugin.copy(element, new File(target, element.getName()));
                ++n2;
            }
            return;
        }
        Files.copy(source.toPath(), target.toPath(), new CopyOption[0]);
    }
}

