/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.runtime;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.IntFunction;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.assertj.core.api.Assertions;
import org.eclipse.core.internal.runtime.XmlProcessorFactory;
import org.junit.Assert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlProcessorFactoryTest {
    @TempDir
    Path tempFolder;
    static volatile Object sink;

    @Test
    public void testParseXmlWithExternalEntity() throws Exception {
        SAXParser parser = XmlProcessorFactory.createSAXParserWithErrorOnDOCTYPE();
        try {
            this.testParseXmlWithExternalEntity(parser, this::createMalciousXml);
            Assert.assertTrue((String)"SAXParseException expected", (boolean)false);
        }
        catch (SAXParseException e) {
            String message = e.getMessage();
            Assert.assertTrue((String)message, (boolean)message.contains("DOCTYPE"));
            Assert.assertTrue((String)message, (boolean)message.contains("http://apache.org/xml/features/disallow-doctype-decl"));
        }
    }

    @Test
    public void testParseXmlWithExternalEntity2() throws Exception {
        SAXParser parser = XmlProcessorFactory.createSAXParserWithErrorOnDOCTYPE();
        try {
            this.testParseXmlWithExternalEntity(parser, this::createMalciousXml2);
            Assert.assertTrue((String)"SAXParseException expected", (boolean)false);
        }
        catch (SAXParseException e) {
            String message = e.getMessage();
            Assert.assertTrue((String)message, (boolean)message.contains("DOCTYPE"));
            Assert.assertTrue((String)message, (boolean)message.contains("http://apache.org/xml/features/disallow-doctype-decl"));
        }
    }

    @Test
    public void testParseXmlWithoutExternalEntity() throws Exception {
        SAXParser parser = XmlProcessorFactory.createSAXParserWithErrorOnDOCTYPE();
        this.testParseXmlWithExternalEntity(parser, this::createNormalXml);
    }

    @Test
    public void testParseXmlWithIgnoredExternalEntity() throws Exception {
        SAXParser parser = XmlProcessorFactory.createSAXParserIgnoringDOCTYPE();
        this.testParseXmlWithExternalEntity(parser, this::createMalciousXml);
    }

    @Test
    public void testParseXmlWithIgnoredExternalEntity2() throws Exception {
        SAXParser parser = XmlProcessorFactory.createSAXParserIgnoringDOCTYPE();
        this.testParseXmlWithExternalEntity(parser, this::createMalciousXml2);
    }

    @Test
    public void testParseXmlWithoutIgnoredExternalEntity() throws Exception {
        SAXParser parser = XmlProcessorFactory.createSAXParserIgnoringDOCTYPE();
        this.testParseXmlWithExternalEntity(parser, this::createNormalXml);
    }

    public void testParseXmlWithExternalEntity(SAXParser parser, IntFunction<InputStream> xmlSupplier) throws Exception {
        Throwable throwable = null;
        Object var4_5 = null;
        try (Server httpServerThread = new Server();){
            final ArrayList elements = new ArrayList();
            DefaultHandler handler = new DefaultHandler(){

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) {
                    elements.add(qName);
                }

                @Override
                public void characters(char[] ch, int start, int length) {
                    String content = new String(ch, start, length);
                    Assert.assertFalse((String)("Secret was injected into xml: " + content), (boolean)content.contains("secret"));
                }

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
                    try {
                        return new InputSource(URI.create(systemId).toURL().openStream());
                    }
                    catch (IOException exception) {
                        throw new SAXException(exception);
                    }
                }
            };
            Throwable throwable2 = null;
            Object var9_12 = null;
            try (InputStream xmlStream = xmlSupplier.apply(httpServerThread.getLocalPort());){
                parser.parse(xmlStream, handler);
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
            Assert.assertEquals(List.of("Body"), elements);
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    @Test
    public void testDocumentBuilderXmlWithExternalEntity() throws Exception {
        DocumentBuilder documentBuilder = XmlProcessorFactory.createDocumentBuilderWithErrorOnDOCTYPE();
        try {
            this.testParseXmlWithExternalEntity(documentBuilder, this::createMalciousXml);
            Assert.assertTrue((String)"SAXParseException expected", (boolean)false);
        }
        catch (SAXParseException e) {
            String message = e.getMessage();
            Assert.assertTrue((String)message, (boolean)message.contains("DOCTYPE"));
        }
    }

    @Test
    public void testDocumentBuilderXmlWithExternalEntity2() throws Exception {
        DocumentBuilder documentBuilder = XmlProcessorFactory.createDocumentBuilderWithErrorOnDOCTYPE();
        try {
            this.testParseXmlWithExternalEntity(documentBuilder, this::createMalciousXml2);
            Assert.assertTrue((String)"SAXParseException expected", (boolean)false);
        }
        catch (SAXParseException e) {
            String message = e.getMessage();
            Assert.assertTrue((String)message, (boolean)message.contains("DOCTYPE"));
        }
    }

    @Test
    public void testDocumentBuilderFactoryWithoutExternalEntity() throws Exception {
        DocumentBuilderFactory documentBuilderFactory = XmlProcessorFactory.createDocumentBuilderFactoryWithErrorOnDOCTYPE();
        this.testParseXmlWithExternalEntity(documentBuilderFactory.newDocumentBuilder(), this::createNormalXml);
    }

    @Test
    public void testDocumentBuilderWithoutExternalEntity() throws Exception {
        DocumentBuilder documentBuilder = XmlProcessorFactory.createDocumentBuilderWithErrorOnDOCTYPE();
        this.testParseXmlWithExternalEntity(documentBuilder, this::createNormalXml);
    }

    @Test
    public void testDocumentBuilderFactoryIgnoringDoctypeNormal() throws Exception {
        DocumentBuilderFactory documentBuilderFactory = XmlProcessorFactory.createDocumentBuilderFactoryIgnoringDOCTYPE();
        this.testParseXmlWithExternalEntity(documentBuilderFactory.newDocumentBuilder(), this::createNormalXml);
    }

    @Test
    public void testDocumentBuilderFactoryIgnoringDoctypeMalcious() throws Exception {
        DocumentBuilderFactory documentBuilderFactory = XmlProcessorFactory.createDocumentBuilderFactoryIgnoringDOCTYPE();
        this.testParseXmlWithExternalEntity(documentBuilderFactory.newDocumentBuilder(), this::createMalciousXml);
    }

    @Test
    public void testDocumentBuilderFactoryIgnoringDoctypeMalcious2() throws Exception {
        DocumentBuilderFactory documentBuilderFactory = XmlProcessorFactory.createDocumentBuilderFactoryIgnoringDOCTYPE();
        DocumentBuilder builder = documentBuilderFactory.newDocumentBuilder();
        builder.setEntityResolver((publicId, systemId) -> new InputSource(new ByteArrayInputStream(new byte[0])));
        this.testParseXmlWithExternalEntity(builder, this::createMalciousXml2);
    }

    @Test
    public void testDocumentBuilderIgnoringDoctypeNormal() throws Exception {
        this.testParseXmlWithExternalEntity(XmlProcessorFactory.createDocumentBuilderIgnoringDOCTYPE(), this::createNormalXml);
    }

    @Test
    public void testDocumentBuilderIgnoringDoctypeMalcious() throws Exception {
        this.testParseXmlWithExternalEntity(XmlProcessorFactory.createDocumentBuilderIgnoringDOCTYPE(), this::createMalciousXml);
    }

    @Test
    public void testDocumentBuilderIgnoringDoctypeMalcious2() throws Exception {
        this.testParseXmlWithExternalEntity(XmlProcessorFactory.createDocumentBuilderIgnoringDOCTYPE(), this::createMalciousXml2);
    }

    public void testParseXmlWithExternalEntity(DocumentBuilder builder, IntFunction<InputStream> xmlSupplier) throws Exception {
        Throwable throwable = null;
        Object var4_5 = null;
        try (Server httpServerThread = new Server();){
            Document document;
            Throwable throwable2 = null;
            Object var8_10 = null;
            try (InputStream xmlStream = xmlSupplier.apply(httpServerThread.getLocalPort());){
                String s = new String(xmlStream.readAllBytes(), StandardCharsets.UTF_8);
                System.out.println(s);
                document = builder.parse(new ByteArrayInputStream(s.getBytes(StandardCharsets.UTF_8)));
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
            Element root = document.getDocumentElement();
            Assert.assertEquals((Object)"Body", (Object)root.getTagName());
            if (root.getChildNodes().getLength() > 0) {
                String value = root.getChildNodes().item(0).getNodeValue();
                Assert.assertFalse((String)("Parser injected secret: " + value), (boolean)value.contains("secret"));
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    @Test
    public void testTransformXmlWithExternalEntity() throws Exception {
        TransformerFactory transformerFactory = XmlProcessorFactory.createTransformerFactoryWithErrorOnDOCTYPE();
        try {
            this.testParseXmlWithExternalEntity(transformerFactory, this::createMalciousXml);
            Assert.assertTrue((String)"TransformerException expected", (boolean)false);
        }
        catch (TransformerException e) {
            String message = e.getMessage();
            Assert.assertTrue((String)message, (boolean)message.contains("DTD"));
        }
    }

    @Test
    public void testTransformXmlWithExternalEntity2() throws Exception {
        TransformerFactory transformerFactory = XmlProcessorFactory.createTransformerFactoryWithErrorOnDOCTYPE();
        try {
            this.testParseXmlWithExternalEntity(transformerFactory, this::createMalciousXml2);
            Assert.assertTrue((String)"TransformerException expected", (boolean)false);
        }
        catch (TransformerException e) {
            String message = e.getMessage();
            Assert.assertTrue((String)message, (boolean)message.contains("DTD"));
        }
    }

    @Test
    public void testTransformXmlWithoutExternalEntity() throws Exception {
        TransformerFactory transformerFactory = XmlProcessorFactory.createTransformerFactoryWithErrorOnDOCTYPE();
        this.testParseXmlWithExternalEntity(transformerFactory, this::createNormalXml);
    }

    public void testParseXmlWithExternalEntity(TransformerFactory transformerFactory, IntFunction<InputStream> xmlSupplier) throws Exception {
        Throwable throwable = null;
        Object var4_5 = null;
        try (Server httpServerThread = new Server();){
            String formatted;
            Throwable throwable2 = null;
            Object var8_10 = null;
            try (InputStream xmlStream = xmlSupplier.apply(httpServerThread.getLocalPort());){
                Transformer xformer = transformerFactory.newTransformer();
                StreamSource source = new StreamSource(xmlStream);
                Throwable throwable3 = null;
                Object var13_17 = null;
                try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                    StreamResult result = new StreamResult(outputStream);
                    xformer.transform(source, result);
                    formatted = outputStream.toString(StandardCharsets.UTF_8);
                }
                catch (Throwable throwable4) {
                    if (throwable3 == null) {
                        throwable3 = throwable4;
                    } else if (throwable3 != throwable4) {
                        throwable3.addSuppressed(throwable4);
                    }
                    throw throwable3;
                }
            }
            catch (Throwable throwable5) {
                if (throwable2 == null) {
                    throwable2 = throwable5;
                } else if (throwable2 != throwable5) {
                    throwable2.addSuppressed(throwable5);
                }
                throw throwable2;
            }
            Assert.assertTrue((String)formatted, (boolean)formatted.contains("<Body>"));
            Assert.assertFalse((String)("Formatter injected secret: " + formatted), (boolean)formatted.contains("secret"));
        }
        catch (Throwable throwable6) {
            if (throwable == null) {
                throwable = throwable6;
            } else if (throwable != throwable6) {
                throwable.addSuppressed(throwable6);
            }
            throw throwable;
        }
    }

    private InputStream createMalciousXml(int localPort) {
        try {
            Path tempSecret = Files.createFile(this.tempFolder.resolve("test.txt"), new FileAttribute[0]);
            Files.writeString(tempSecret, (CharSequence)"secret", new OpenOption[0]);
            Path tempDtd = Files.createFile(this.tempFolder.resolve("test.dtd"), new FileAttribute[0]);
            URL secretURL = tempSecret.toUri().toURL();
            String dtdContent = "<!ENTITY % var1 SYSTEM \"" + String.valueOf(secretURL) + "\">\n<!ENTITY var4 SYSTEM \"" + String.valueOf(secretURL) + "\">\n<!ENTITY % var2 \"<!ENTITY var3 SYSTEM 'http://localhost:" + localPort + "/?%var1;'>\">\n%var2;\n";
            Files.writeString(tempDtd, (CharSequence)dtdContent, new OpenOption[0]);
            URL dtdURL = tempDtd.toUri().toURL();
            String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE var1 SYSTEM \"" + String.valueOf(dtdURL) + "\">\n<Body>&var3;&var4;</Body>";
            return new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private InputStream createMalciousXml2(int localPort) {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE plist PUBLIC \"test\" \"http://localhost:" + localPort + "/hello\">\n<Body></Body>";
        return new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8));
    }

    private InputStream createNormalXml(int localPort) {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<Body>hello</Body>";
        return new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8));
    }

    public static void main(String[] args) throws Exception {
        int i = 1;
        while (i < 1000) {
            long n0 = System.nanoTime();
            sink = XmlProcessorFactory.createSAXParserIgnoringDOCTYPE();
            long n1 = System.nanoTime();
            System.out.println("createSAXParserIgnoringDOCTYPE run " + i + ": " + (n1 - n0) + "ns");
            n0 = System.nanoTime();
            sink = XmlProcessorFactory.createDocumentBuilderFactoryWithErrorOnDOCTYPE();
            n1 = System.nanoTime();
            System.out.println("createDocumentBuilderFactoryWithErrorOnDOCTYPE run " + i + ": " + (n1 - n0) + "ns");
            n0 = System.nanoTime();
            sink = XmlProcessorFactory.createDocumentBuilderIgnoringDOCTYPE();
            n1 = System.nanoTime();
            System.out.println("createDocumentBuilderIgnoringDOCTYPE run " + i + ": " + (n1 - n0) + "ns");
            n0 = System.nanoTime();
            sink = XmlProcessorFactory.createDocumentBuilderWithErrorOnDOCTYPE();
            n1 = System.nanoTime();
            System.out.println("createDocumentBuilderWithErrorOnDOCTYPE run " + i + ": " + (n1 - n0) + "ns");
            n0 = System.nanoTime();
            sink = XmlProcessorFactory.createTransformerFactoryWithErrorOnDOCTYPE();
            n1 = System.nanoTime();
            System.out.println("createTransformerFactoryWithErrorOnDOCTYPE run " + i + ": " + (n1 - n0) + "ns");
            ++i;
        }
    }

    public static final class Server
    implements AutoCloseable {
        private final ServerSocket serverSocket;
        private final Thread httpServerThread;
        private final Collection<Throwable> exceptionsInOtherThreads = new ConcurrentLinkedQueue<Throwable>();

        private Server() throws IOException {
            this.serverSocket = new ServerSocket(0);
            this.httpServerThread = new Thread("httpServerThread"){

                @Override
                public void run() {
                    try {
                        Throwable throwable = null;
                        Object var2_5 = null;
                        try (Socket socket = serverSocket.accept();){
                            Throwable throwable2 = null;
                            Object var5_10 = null;
                            try (BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));){
                                String firstLine = in.readLine();
                                System.out.println(String.valueOf(socket.getInetAddress()) + ": " + firstLine);
                                Throwable throwable3 = null;
                                Object var9_16 = null;
                                try (OutputStream outputStream = socket.getOutputStream();){
                                    outputStream.write("HTTP/1.1 200 OK\r\n".getBytes(StandardCharsets.UTF_8));
                                }
                                catch (Throwable throwable4) {
                                    if (throwable3 == null) {
                                        throwable3 = throwable4;
                                    } else if (throwable3 != throwable4) {
                                        throwable3.addSuppressed(throwable4);
                                    }
                                    throw throwable3;
                                }
                                Assertions.assertThat((String)firstLine).startsWith((CharSequence)"GET");
                                Assertions.assertThat((String)firstLine).doesNotContain(new CharSequence[]{"secret"});
                                Assert.fail((String)"Server was contacted");
                            }
                            catch (Throwable throwable5) {
                                if (throwable2 == null) {
                                    throwable2 = throwable5;
                                } else if (throwable2 != throwable5) {
                                    throwable2.addSuppressed(throwable5);
                                }
                                throw throwable2;
                            }
                        }
                        catch (Throwable throwable6) {
                            if (throwable == null) {
                                throwable = throwable6;
                            } else if (throwable != throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                            throw throwable;
                        }
                    }
                    catch (SocketException socketException) {
                    }
                    catch (Throwable e) {
                        exceptionsInOtherThreads.add(e);
                    }
                }
            };
            this.httpServerThread.start();
        }

        @Override
        public void close() throws Exception {
            this.serverSocket.close();
            this.httpServerThread.join(5000L);
            Assert.assertFalse((boolean)this.httpServerThread.isAlive());
            Iterator<Throwable> iterator = this.exceptionsInOtherThreads.iterator();
            if (iterator.hasNext()) {
                Throwable e = iterator.next();
                throw new AssertionError(e.getMessage(), e);
            }
        }

        public int getLocalPort() {
            return this.serverSocket.getLocalPort();
        }

        public static void main(String[] args) throws Exception {
            Throwable throwable = null;
            Object var2_3 = null;
            try (Server server = new Server();){
                System.out.println("Server startet on port: " + server.getLocalPort());
                server.httpServerThread.join();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }
}

