/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.runtime.jobs;

import java.time.Duration;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.core.internal.jobs.JobListeners;
import org.eclipse.core.internal.jobs.JobManager;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.ProgressProvider;
import org.eclipse.core.tests.runtime.jobs.FussyProgressProvider;
import org.junit.Assert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;

public class AbstractJobTest {
    protected IJobManager manager;
    private FussyProgressProvider progressProvider;

    protected void sleep(long duration) {
        try {
            Thread.sleep(duration);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void waitForCompletion(Job job, Duration timeoutDuration) {
        Duration startTime = Duration.ofMillis(AbstractJobTest.now());
        Duration timeout = startTime.plus(timeoutDuration);
        while (job.getState() != 0 && !timeout.minusMillis(AbstractJobTest.now()).isNegative()) {
            Thread.yield();
        }
        int finalJobState = job.getState();
        if (finalJobState != 0) {
            this.dumpState();
            ((AbstractIntegerAssert)Assertions.assertThat((int)finalJobState).as("timeout waiting for job to complete", new Object[0])).isEqualTo(0);
        }
    }

    protected void waitForCompletion(Job job) {
        this.waitForCompletion(job, Duration.ofSeconds(1L));
    }

    protected void dumpState() {
        Job[] jobs;
        System.out.println("**** BEGIN DUMP JOB MANAGER INFORMATION ****");
        Job[] jobArray = jobs = Job.getJobManager().find(null);
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            Job job = jobArray[n2];
            System.out.println(String.valueOf(job) + " state: " + JobManager.printState((Job)job));
            ++n2;
        }
        System.out.println("**** END DUMP JOB MANAGER INFORMATION ****");
    }

    public static long now() {
        return ((JobManager)Job.getJobManager()).now();
    }

    @BeforeEach
    public void setProgressProvider() throws Exception {
        this.assertNoTimeoutOccurred();
        this.manager = Job.getJobManager();
        this.progressProvider = new FussyProgressProvider();
        this.manager.setProgressProvider((ProgressProvider)this.progressProvider);
    }

    @AfterEach
    public void resetProgressProvider() throws Exception {
        this.progressProvider.sanityCheck();
        Job.getJobManager().setProgressProvider(null);
        this.assertNoTimeoutOccurred();
    }

    protected final void assertNoTimeoutOccurred() throws Exception {
        int jobListenerTimeout = JobListeners.getJobListenerTimeout();
        JobListeners.resetJobListenerTimeout();
        int defaultTimeout = JobListeners.getJobListenerTimeout();
        Assert.assertEquals((String)"See logfile for TimeoutException to get details.", (long)defaultTimeout, (long)jobListenerTimeout);
    }
}

