/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.runtime.jobs;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.tests.harness.TestBarrier2;

public class AsynchExecThread
extends Thread {
    private final IProgressMonitor current;
    private final Job job;
    private final String jobName;
    private final TestBarrier2 barrier;

    public AsynchExecThread(IProgressMonitor current, Job job, String jobName, TestBarrier2 testBarrier) {
        this.current = current;
        this.job = job;
        this.jobName = jobName;
        this.barrier = testBarrier;
    }

    @Override
    public void run() {
        this.barrier.waitForStatus(2);
        this.job.setThread(Thread.currentThread());
        this.barrier.upgradeTo(3);
        this.barrier.waitForStatus(4);
        this.current.beginTask(this.jobName, 1);
        if (this.current.isCanceled()) {
            this.job.done(Status.CANCEL_STATUS);
        } else {
            this.job.done(Status.OK_STATUS);
        }
        this.barrier.upgradeTo(5);
        this.current.done();
    }
}

