/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.runtime.jobs;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.core.runtime.jobs.ProgressProvider;
import org.eclipse.core.tests.harness.FussyProgressMonitor;
import org.eclipse.core.tests.harness.TestBarrier2;
import org.eclipse.core.tests.runtime.jobs.AbstractJobTest;
import org.eclipse.core.tests.runtime.jobs.IdentityRule;
import org.eclipse.core.tests.runtime.jobs.JobRuleRunner;
import org.eclipse.core.tests.runtime.jobs.PathRule;
import org.eclipse.core.tests.runtime.jobs.SimpleRuleRunner;
import org.junit.Assert;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class BeginEndRuleTest
extends AbstractJobTest {
    private static final long TIMEOUT_IN_MILLIS = 10000L;

    @Test
    public void testRuleCallsProgressProvider_monitorFor() {
        IProgressMonitor[] monitors;
        final AtomicBoolean createdMonitor = new AtomicBoolean();
        final AtomicReference<IProgressMonitor> passedMonitor = new AtomicReference<IProgressMonitor>();
        this.manager.setProgressProvider(new ProgressProvider(){

            public IProgressMonitor createMonitor(Job job) {
                return new NullProgressMonitor();
            }

            public IProgressMonitor monitorFor(IProgressMonitor monitor) {
                Assert.assertEquals(passedMonitor.get(), (Object)monitor);
                createdMonitor.set(true);
                return super.monitorFor(monitor);
            }
        });
        IdentityRule rule = new IdentityRule();
        IProgressMonitor[] iProgressMonitorArray = new IProgressMonitor[3];
        iProgressMonitorArray[1] = new NullProgressMonitor();
        iProgressMonitorArray[2] = SubMonitor.convert(null);
        IProgressMonitor[] iProgressMonitorArray2 = monitors = iProgressMonitorArray;
        int n = monitors.length;
        int n2 = 0;
        while (n2 < n) {
            IProgressMonitor monitor = iProgressMonitorArray2[n2];
            createdMonitor.set(false);
            passedMonitor.set(monitor);
            this.manager.beginRule((ISchedulingRule)rule, monitor);
            try {
                Assert.assertTrue((String)("Monitor not created for " + String.valueOf(monitor)), (boolean)createdMonitor.get());
            }
            finally {
                this.manager.endRule((ISchedulingRule)rule);
            }
            ++n2;
        }
    }

    @Test
    public void testComplexRuleStarting() {
        int NUM_THREADS = 3;
        AtomicIntegerArray status = new AtomicIntegerArray(new int[3]);
        int NUM_REPEATS = 10;
        Job[] jobs = new Job[]{new JobRuleRunner("ComplexJob1", new PathRule("/testComplexRuleStarting"), status, 0, NUM_REPEATS, true), new JobRuleRunner("ComplexJob2", new PathRule("/testComplexRuleStarting/B"), status, 1, NUM_REPEATS, true), new JobRuleRunner("ComplexJob3", new PathRule("/testComplexRuleStarting/B/C"), status, 2, NUM_REPEATS, true)};
        Job[] jobArray = jobs;
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            Job job = jobArray[n2];
            job.schedule();
            ++n2;
        }
        int i = 0;
        while (i < jobs.length) {
            TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)i, (int)1);
            ++i;
        }
        i = 0;
        while (i < status.length()) {
            Assert.assertEquals((String)("1." + i), (long)4L, (long)jobs[i].getState());
            Assert.assertEquals((String)("2." + i), (long)1L, (long)status.get(i));
            ++i;
        }
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        int[] order = nArray;
        int j = 0;
        while (j < NUM_REPEATS) {
            status.set(order[0], 2);
            TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)order[0], (int)3);
            int i2 = 1;
            while (i2 < order.length) {
                status.set(order[i2], 2);
                TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)order[i2], (int)6);
                ++i2;
            }
            Assert.assertEquals((String)"3.0", (long)3L, (long)status.get(order[0]));
            Assert.assertEquals((String)"3.0", (long)6L, (long)status.get(order[1]));
            Assert.assertEquals((String)"3.0", (long)6L, (long)status.get(order[2]));
            status.set(order[0], 4);
            TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)order[0], (int)5);
            int doneCount = 0;
            while (doneCount < 2) {
                if (status.get(order[1]) == 3) {
                    status.set(order[1], 4);
                    TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)order[1], (int)5);
                    ++doneCount;
                }
                if (status.get(order[2]) != 3) continue;
                status.set(order[2], 4);
                TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)order[2], (int)5);
                ++doneCount;
            }
            int temp = order[0];
            order[0] = order[2];
            order[2] = order[1];
            order[1] = temp;
            ++j;
        }
        int[] nArray2 = order;
        int n3 = order.length;
        n = 0;
        while (n < n3) {
            int element = nArray2[n];
            this.waitForEnd(jobs[element]);
            ++n;
        }
        int i3 = 0;
        while (i3 < jobs.length) {
            Assert.assertEquals((String)("9." + i3), (long)5L, (long)status.get(i3));
            Assert.assertEquals((String)("10." + i3), (long)0L, (long)jobs[i3].getState());
            Assert.assertEquals((String)("11." + i3), (long)0L, (long)jobs[i3].getResult().getSeverity());
            ++i3;
        }
    }

    @Test
    public void testSimpleRuleStarting() {
        AtomicIntegerArray status = new AtomicIntegerArray(new int[2]);
        int NUM_REPEATS = 10;
        Job[] jobs = new Job[]{new JobRuleRunner("SimpleJob1", new PathRule("/testSimpleRuleStarting"), status, 0, 10, false), new JobRuleRunner("SimpleJob2", new PathRule("/testSimpleRuleStarting/B"), status, 1, 10, false)};
        jobs[0].schedule();
        jobs[1].schedule();
        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)0, (int)1);
        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)1, (int)1);
        Assert.assertEquals((String)"2.0", (long)4L, (long)jobs[0].getState());
        Assert.assertEquals((String)"2.1", (long)4L, (long)jobs[1].getState());
        Assert.assertEquals((String)"2.2", (long)1L, (long)status.get(0));
        Assert.assertEquals((String)"2.3", (long)1L, (long)status.get(1));
        int first = 0;
        int second = 1;
        int j = 0;
        while (j < 10) {
            status.set(first, 2);
            TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)first, (int)3);
            status.set(second, 2);
            Assert.assertEquals((String)"3.1", (long)3L, (long)status.get(first));
            Assert.assertEquals((String)"3.2", (long)2L, (long)status.get(second));
            status.set(first, 4);
            TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)first, (int)5);
            TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)second, (int)3);
            Assert.assertEquals((String)"4.1", (long)5L, (long)status.get(first));
            Assert.assertEquals((String)"4.2", (long)3L, (long)status.get(second));
            status.set(second, 4);
            TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)second, (int)5);
            Assert.assertEquals((String)"5.1", (long)5L, (long)status.get(first));
            Assert.assertEquals((String)"5.2", (long)5L, (long)status.get(second));
            int temp = first;
            first = second;
            second = temp;
            ++j;
        }
        this.waitForEnd(jobs[second]);
        this.waitForEnd(jobs[first]);
        Assert.assertEquals((String)"6.1", (long)5L, (long)status.get(0));
        Assert.assertEquals((String)"6.2", (long)5L, (long)status.get(1));
        Assert.assertEquals((String)"6.3", (long)0L, (long)jobs[0].getState());
        Assert.assertEquals((String)"6.4", (long)0L, (long)jobs[1].getState());
        Assert.assertEquals((String)"6.5", (long)0L, (long)jobs[0].getResult().getSeverity());
        Assert.assertEquals((String)"6.6", (long)0L, (long)jobs[1].getResult().getSeverity());
    }

    @Test
    public void testComplexRuleContainment() {
        int j;
        ISchedulingRule[] rules = new ISchedulingRule[]{new PathRule("/testComplexRuleContainment"), new PathRule("/testComplexRuleContainment/B"), new PathRule("/testComplexRuleContainment/B/C"), new PathRule("/testComplexRuleContainment/D")};
        int RULE_REPEATS = 10;
        int i = 0;
        while (i < rules.length - 1) {
            j = 0;
            while (j < RULE_REPEATS) {
                this.manager.beginRule(rules[i], null);
                ++j;
            }
            ++i;
        }
        i = rules.length - 1;
        while (i > 0) {
            j = 0;
            while (j < RULE_REPEATS) {
                this.manager.endRule(rules[i - 1]);
                ++j;
            }
            --i;
        }
        ISchedulingRule[] iSchedulingRuleArray = rules;
        int n = rules.length;
        int n2 = 0;
        while (n2 < n) {
            ISchedulingRule rule = iSchedulingRuleArray[n2];
            this.manager.beginRule(rule, null);
            ++n2;
        }
        Assert.assertThrows(RuntimeException.class, () -> this.manager.endRule(rules[2]));
        Assert.assertThrows(RuntimeException.class, () -> this.manager.endRule(rules[1]));
        Assert.assertThrows(RuntimeException.class, () -> this.manager.endRule(rules[0]));
        i = rules.length;
        while (i > 0) {
            this.manager.endRule(rules[i - 1]);
            --i;
        }
    }

    @Test
    @Disabled(value="see bug 43460")
    public void testEndNullRule() {
        Assert.assertThrows(RuntimeException.class, () -> this.manager.endRule(null));
    }

    @Test
    public void testFailureCase() {
        IdentityRule rule1 = new IdentityRule();
        IdentityRule rule2 = new IdentityRule();
        Assert.assertThrows(RuntimeException.class, () -> this.manager.endRule(rule1));
        this.manager.beginRule((ISchedulingRule)rule1, null);
        Assert.assertThrows(RuntimeException.class, () -> this.manager.endRule(rule2));
        this.manager.endRule((ISchedulingRule)rule1);
        this.manager.beginRule((ISchedulingRule)rule1, null);
        Assert.assertThrows(RuntimeException.class, () -> this.manager.endRule(null));
        this.manager.endRule((ISchedulingRule)rule1);
    }

    @Test
    public void testFailedNestRuleInJob() {
        PathRule rule1 = new PathRule("/testFailedNestRuleInJob/A/");
        final PathRule rule2 = new PathRule("/testFailedNestRuleInJob/B/");
        final Exception[] exception = new Exception[1];
        Job job = new Job("testFailedNestRuleInJob"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    try {
                        manager.beginRule(rule2, monitor);
                    }
                    finally {
                        manager.endRule(rule2);
                    }
                }
                catch (RuntimeException e) {
                    exception[0] = e;
                }
                return Status.OK_STATUS;
            }
        };
        job.setRule((ISchedulingRule)rule1);
        job.schedule();
        this.waitForEnd(job);
        Assert.assertNotNull((String)"1.0", (Object)exception[0]);
        Assert.assertTrue((String)"1.1", (exception[0].getMessage().indexOf("does not match outer scope rule") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testNestedCase() {
        PathRule rule1 = new PathRule("/testNestedCase");
        PathRule rule2 = new PathRule("/testNestedCase/B");
        this.manager.beginRule((ISchedulingRule)rule1, null);
        this.manager.beginRule((ISchedulingRule)rule2, null);
        Assert.assertThrows(RuntimeException.class, () -> this.manager.endRule(rule1));
        this.manager.endRule((ISchedulingRule)rule2);
        this.manager.endRule((ISchedulingRule)rule1);
        this.manager.beginRule((ISchedulingRule)rule1, null);
        this.manager.beginRule((ISchedulingRule)rule2, null);
        Assert.assertThrows(RuntimeException.class, () -> this.manager.endRule(null));
        this.manager.endRule((ISchedulingRule)rule2);
        this.manager.endRule((ISchedulingRule)rule1);
        this.manager.beginRule(null, null);
        this.manager.beginRule((ISchedulingRule)rule1, null);
        this.manager.endRule((ISchedulingRule)rule1);
        this.manager.beginRule((ISchedulingRule)rule2, null);
        this.manager.endRule((ISchedulingRule)rule2);
        this.manager.endRule(null);
        int NUM_ADDITIONS = 100;
        int i = 0;
        while (i < NUM_ADDITIONS) {
            this.manager.beginRule((ISchedulingRule)rule1, null);
            ++i;
        }
        i = 0;
        while (i < NUM_ADDITIONS) {
            this.manager.endRule((ISchedulingRule)rule1);
            ++i;
        }
        i = 0;
        while (i < NUM_ADDITIONS) {
            this.manager.beginRule(null, null);
            ++i;
        }
        this.manager.beginRule((ISchedulingRule)rule1, null);
        this.manager.endRule((ISchedulingRule)rule1);
        i = 0;
        while (i < NUM_ADDITIONS) {
            this.manager.endRule(null);
            ++i;
        }
    }

    @Test
    public void testBug44299() {
        IdentityRule rule = new IdentityRule();
        FussyProgressMonitor monitor = new FussyProgressMonitor();
        this.manager.beginRule((ISchedulingRule)rule, (IProgressMonitor)monitor);
        AtomicIntegerArray status = new AtomicIntegerArray(new int[1]);
        SimpleRuleRunner runner = new SimpleRuleRunner(rule, status, (IProgressMonitor)monitor);
        new Thread(runner).start();
        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)3);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        monitor.setCanceled(true);
        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)5);
        if (runner.exception != null) {
            throw runner.exception;
        }
        this.manager.endRule((ISchedulingRule)rule);
    }

    @Test
    public void testRuleContainment() {
        ISchedulingRule[] rules = new ISchedulingRule[]{new PathRule("/testRuleContainment"), new PathRule("/testRuleContainment/B"), new PathRule("/testRuleContainment/B/C"), new PathRule("/testRuleContainment/D")};
        this.manager.beginRule(rules[1], null);
        Assert.assertThrows(RuntimeException.class, () -> this.manager.beginRule(rules[0], null));
        this.manager.endRule(rules[0]);
        this.manager.endRule(rules[1]);
        this.manager.beginRule(rules[1], null);
        this.manager.beginRule(rules[2], null);
        Assert.assertThrows(RuntimeException.class, () -> this.manager.beginRule(rules[3], null));
        this.manager.endRule(rules[3]);
        this.manager.endRule(rules[2]);
        this.manager.endRule(rules[1]);
    }

    @Test
    public void testSimpleOtherThreadAccess() {
        Thread t;
        IdentityRule rule1 = new IdentityRule();
        AtomicIntegerArray status = new AtomicIntegerArray(new int[]{1});
        Thread endingThread = new Thread(new RuleEnder(rule1, status));
        this.manager.beginRule((ISchedulingRule)rule1, null);
        endingThread.start();
        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)3);
        try {
            endingThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertTrue((String)"1.0", (!endingThread.isAlive() ? 1 : 0) != 0);
        this.manager.endRule((ISchedulingRule)rule1);
        ISchedulingRule[] rules = new ISchedulingRule[]{new PathRule("/testSimpleOtherThreadAccess"), new PathRule("/testSimpleOtherThreadAccess/B"), new PathRule("/testSimpleOtherThreadAccess/C")};
        int i = 0;
        while (i < rules.length) {
            this.manager.beginRule(rules[i], null);
            status.set(0, 1);
            t = new Thread(new RuleEnder(rules[i], status));
            t.start();
            TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)3);
            try {
                t.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Assert.assertTrue((String)("2." + i), (!t.isAlive() ? 1 : 0) != 0);
            ++i;
        }
        i = 0;
        while (i < rules.length) {
            status.set(0, 1);
            t = new Thread(new RuleEnder(rules[i], status));
            t.start();
            TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)3);
            try {
                t.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Assert.assertTrue((String)("3." + i), (!t.isAlive() ? 1 : 0) != 0);
            ++i;
        }
        i = rules.length;
        while (i > 0) {
            this.manager.endRule(rules[i - 1]);
            status.set(0, 1);
            t = new Thread(new RuleEnder(rules[i - 1], status));
            t.start();
            TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)3);
            try {
                t.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Assert.assertTrue((String)("4." + i), (!t.isAlive() ? 1 : 0) != 0);
            --i;
        }
    }

    private void waitForEnd(Job job) {
        int i = 0;
        while (job.getState() != 0) {
            Thread.yield();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Thread.yield();
            Assert.assertTrue((String)"Timeout waiting for job to end", (i++ < 100 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testIgnoreScheduleThreadJob() throws Exception {
        final Set jobsStartedRunning = Collections.synchronizedSet(new HashSet());
        JobChangeAdapter runningThreadStoreListener = new JobChangeAdapter(){

            public void running(IJobChangeEvent event) {
                jobsStartedRunning.add(event.getJob());
            }
        };
        Job.getJobManager().addJobChangeListener((IJobChangeListener)runningThreadStoreListener);
        IdentityRule rule = new IdentityRule();
        Job rescheduledJob = null;
        try {
            Job.getJobManager().beginRule((ISchedulingRule)rule, null);
            rescheduledJob = Job.getJobManager().currentJob();
            rescheduledJob.schedule();
        }
        finally {
            Job.getJobManager().endRule((ISchedulingRule)rule);
        }
        rescheduledJob.join(10000L, (IProgressMonitor)new NullProgressMonitor());
        Job.getJobManager().removeJobChangeListener((IJobChangeListener)runningThreadStoreListener);
        ((AbstractIntegerAssert)Assertions.assertThat((int)rescheduledJob.getState()).as("state of job expected to be finished", new Object[0])).isEqualTo(0);
        ((AbstractCollectionAssert)Assertions.assertThat(jobsStartedRunning).as("started jobs", new Object[0])).doesNotContain((Object[])new Job[]{rescheduledJob});
    }

    @Test
    public void testRunThreadJobIsNotRescheduled() throws Exception {
        final Set jobsStartedRunning = Collections.synchronizedSet(new HashSet());
        JobChangeAdapter runningThreadStoreListener = new JobChangeAdapter(){

            public void running(IJobChangeEvent event) {
                jobsStartedRunning.add(event.getJob());
            }
        };
        Job.getJobManager().addJobChangeListener((IJobChangeListener)runningThreadStoreListener);
        IdentityRule rule = new IdentityRule();
        Job scheduledJob = null;
        try {
            Job.getJobManager().beginRule((ISchedulingRule)rule, null);
            scheduledJob = Job.getJobManager().currentJob();
        }
        finally {
            Job.getJobManager().endRule((ISchedulingRule)rule);
        }
        scheduledJob.join(10000L, (IProgressMonitor)new NullProgressMonitor());
        Job.getJobManager().removeJobChangeListener((IJobChangeListener)runningThreadStoreListener);
        ((AbstractIntegerAssert)Assertions.assertThat((int)scheduledJob.getState()).as("state of job expected to be finished", new Object[0])).isEqualTo(0);
        ((AbstractCollectionAssert)Assertions.assertThat(jobsStartedRunning).as("started jobs", new Object[0])).doesNotContain((Object[])new Job[]{scheduledJob});
    }

    @Test
    public void testRunNestedAcquireThreadIsNotRescheduled() throws Exception {
        String name = "test";
        PathRule rule = new PathRule(name);
        final PathRule subRule = new PathRule(name + "/subRule");
        final Set jobsStartedRunning = Collections.synchronizedSet(new HashSet());
        JobChangeAdapter runningThreadStoreListener = new JobChangeAdapter(){

            public void running(IJobChangeEvent event) {
                jobsStartedRunning.add(event.getJob());
            }
        };
        Job.getJobManager().addJobChangeListener((IJobChangeListener)runningThreadStoreListener);
        final TestBarrier2 waitForThreadJob = new TestBarrier2();
        final AtomicReference scheduledJob = new AtomicReference();
        Job job = new Job(name + "acquire"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    Job.getJobManager().beginRule((ISchedulingRule)subRule, null);
                    scheduledJob.set(Job.getJobManager().currentJob());
                    waitForThreadJob.setStatus(5);
                }
                finally {
                    Job.getJobManager().endRule((ISchedulingRule)subRule);
                }
                return Status.OK_STATUS;
            }
        };
        job.setRule((ISchedulingRule)rule);
        job.schedule();
        waitForThreadJob.waitForStatus(5);
        job.join(10000L, (IProgressMonitor)new NullProgressMonitor());
        ((Job)scheduledJob.get()).join(10000L, (IProgressMonitor)new NullProgressMonitor());
        Job.getJobManager().removeJobChangeListener((IJobChangeListener)runningThreadStoreListener);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)((Job)scheduledJob.get())).as("job in nested rule expected to be same as outer job", new Object[0])).isEqualTo((Object)job);
        ((AbstractIntegerAssert)Assertions.assertThat((int)job.getState()).as("state of job expected to be finished", new Object[0])).isEqualTo(0);
    }

    private class RuleEnder
    implements Runnable {
        private final ISchedulingRule rule;
        private final AtomicIntegerArray status;

        public RuleEnder(ISchedulingRule rule, AtomicIntegerArray status) {
            this.rule = rule;
            this.status = status;
        }

        @Override
        public void run() {
            Assert.assertThrows(RuntimeException.class, () -> {
                this.status.set(0, 3);
                BeginEndRuleTest.this.manager.endRule(this.rule);
            });
        }
    }
}

