/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.runtime.jobs;

import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.tests.harness.TestBarrier2;
import org.eclipse.core.tests.harness.TestJob;
import org.eclipse.core.tests.runtime.jobs.AbstractJobTest;
import org.eclipse.core.tests.runtime.jobs.IdentityRule;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Bug_129551
extends AbstractJobTest {
    final boolean[] shouldSleep = new boolean[]{true};
    TestBarrier2 barrier = new TestBarrier2();
    RuntimeException[] failure = new RuntimeException[1];

    @BeforeEach
    public void setUp() {
        this.manager.setProgressProvider(null);
    }

    @Test
    public void testBug() throws InterruptedException {
        IdentityRule rule = new IdentityRule();
        BugJob job = new BugJob();
        job.setRule(rule);
        TestJob other = new TestJob("bug_129551_other", 1, 1L);
        other.setRule((ISchedulingRule)rule);
        job.schedule();
        other.schedule();
        this.barrier.waitForStatus(3);
        Thread.sleep(1000L);
        this.barrier.setStatus(1);
        this.barrier.waitForStatus(5);
        if (this.failure[0] != null) {
            throw this.failure[0];
        }
        this.shouldSleep[0] = false;
        job.wakeUp();
        this.waitForCompletion((Job)job);
        this.waitForCompletion((Job)other);
    }

    class BugJob
    extends TestJob {
        public BugJob() {
            super("Bug_129551", 1, 1L);
        }

        public boolean shouldRun() {
            if (!Bug_129551.this.shouldSleep[0]) {
                return true;
            }
            Bug_129551.this.barrier.setStatus(3);
            Bug_129551.this.barrier.waitForStatus(1);
            try {
                this.sleep();
            }
            catch (RuntimeException e) {
                Bug_129551.this.failure[0] = e;
            }
            Bug_129551.this.barrier.setStatus(5);
            return true;
        }
    }
}

