/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.runtime.jobs;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.tests.runtime.jobs.AbstractJobTest;
import org.eclipse.core.tests.runtime.jobs.IdentityRule;
import org.junit.jupiter.api.Test;

public class Bug_211799
extends AbstractJobTest {
    static final ISchedulingRule rule = new IdentityRule();
    long counter = 0L;
    Exception failure = null;
    final int JOBS_TO_SCHEDULE = 500;
    LinkedList<Long> list = new LinkedList();
    List<Long> runList = new ArrayList<Long>(500);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBug() throws Exception {
        int i = 0;
        while (i < 500) {
            LinkedList<Long> linkedList = this.list;
            synchronized (linkedList) {
                ++this.counter;
                this.list.addLast(this.counter);
                new BugJob(this.counter).schedule(0L);
            }
            ++i;
        }
        while (true) {
            List<Long> list = this.runList;
            synchronized (list) {
                if (this.runList.size() == 500) {
                    break;
                }
            }
        }
        if (this.failure != null) {
            throw this.failure;
        }
    }

    public class BugJob
    extends Job {
        private final long id;

        public BugJob(long id) {
            super("Test Job");
            this.id = id;
            this.setRule(rule);
            this.setPriority(50);
        }

        public Long getId() {
            return this.id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            List<Long> list = Bug_211799.this.list;
            synchronized (list) {
                Long val = Bug_211799.this.list.getFirst();
                if (val != this.id) {
                    Bug_211799.this.failure = new RuntimeException("We broke, running should have been: " + val);
                }
                Bug_211799.this.list.remove(this.id);
            }
            list = Bug_211799.this.runList;
            synchronized (list) {
                Bug_211799.this.runList.add(this.id);
            }
            return Status.OK_STATUS;
        }
    }
}

