/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.runtime.jobs;

import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.tests.harness.TestBarrier2;
import org.eclipse.core.tests.runtime.jobs.AbstractJobTest;
import org.junit.Assert;
import org.junit.jupiter.api.Test;

public class Bug_307282
extends AbstractJobTest {
    @Test
    public void testInterruptDuringLockAcquireint() throws Exception {
        final ILock lock1 = Job.getJobManager().newLock();
        final ILock lock2 = Job.getJobManager().newLock();
        final TestBarrier2 tb1 = new TestBarrier2(-1);
        final TestBarrier2 tb2 = new TestBarrier2(-1);
        int INTERRUPTED = 1000;
        int RELEASE_LOCK = 10001;
        Thread t = new Thread(){

            @Override
            public void run() {
                lock1.acquire();
                tb1.setStatus(0);
                tb1.waitForStatus(1);
                tb1.waitForStatus(10001);
                lock1.release();
                tb1.waitForStatus(4);
                tb1.setStatus(5);
            }
        };
        Thread t2 = new Thread(){

            @Override
            public void run() {
                lock2.acquire();
                tb2.setStatus(0);
                tb2.waitForStatus(1);
                try {
                    Assert.assertTrue((!lock1.acquire(60000L) ? 1 : 0) != 0);
                }
                catch (InterruptedException e) {
                    tb2.setStatus(1000);
                }
                tb2.waitForStatus(10001);
                lock2.release();
                tb2.waitForStatus(4);
                tb2.setStatus(5);
            }
        };
        t.start();
        t2.start();
        tb1.waitForStatus(0);
        tb2.waitForStatus(0);
        tb1.setStatus(1);
        tb2.setStatus(1);
        Thread.sleep(1000L);
        t2.interrupt();
        tb2.waitForStatus(1000);
        tb1.setStatus(10001);
        Assert.assertTrue((boolean)lock1.acquire(1000L));
        Assert.assertTrue((!lock2.acquire(0L) ? 1 : 0) != 0);
        tb2.setStatus(10001);
        Assert.assertTrue((boolean)lock2.acquire(1000L));
        tb1.setStatus(4);
        tb2.setStatus(4);
        tb1.waitForStatus(5);
        tb2.waitForStatus(5);
    }
}

