/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.runtime.jobs;

import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.tests.harness.TestBarrier2;
import org.eclipse.core.tests.runtime.jobs.AbstractJobTest;
import org.eclipse.core.tests.runtime.jobs.IdentityRule;
import org.junit.Assert;
import org.junit.jupiter.api.Test;

public class Bug_311756
extends AbstractJobTest {
    int UNSET = -1;
    int CLEARED = 0;
    int BLOCKED = 1;

    @Test
    public void testBlockingAndUnblockingMonitor() throws Exception {
        final int[] blocked = new int[]{this.UNSET};
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper((IProgressMonitor)new NullProgressMonitor()){

            public void setBlocked(IStatus reason) {
                super.setBlocked(reason);
                blocked[0] = Bug_311756.this.BLOCKED;
            }

            public void clearBlocked() {
                super.clearBlocked();
                if (blocked[0] == Bug_311756.this.BLOCKED) {
                    blocked[0] = Bug_311756.this.CLEARED;
                }
            }
        };
        final TestBarrier2 barrier = new TestBarrier2(1);
        IdentityRule rule = new IdentityRule();
        final AtomicReference exceptionInJob = new AtomicReference();
        Job conflicting = new Job("Conflicting"){

            protected IStatus run(IProgressMonitor monitor) {
                barrier.setStatus(3);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    exceptionInJob.set(e);
                }
                return Status.OK_STATUS;
            }
        };
        conflicting.setRule((ISchedulingRule)rule);
        conflicting.schedule();
        barrier.waitForStatus(3);
        try {
            Job.getJobManager().beginRule((ISchedulingRule)rule, (IProgressMonitor)wrapper);
        }
        finally {
            Job.getJobManager().endRule((ISchedulingRule)rule);
        }
        if (exceptionInJob.get() != null) {
            throw (InterruptedException)exceptionInJob.get();
        }
        Assert.assertEquals((String)(blocked[0] == this.UNSET ? "setBlocked never called" : "clearBlocked never called"), (long)this.CLEARED, (long)blocked[0]);
    }

    @Test
    public void testBlockingAndUnblockingMonitorUsingTransfer() throws Exception {
        final int[] blocked = new int[]{this.UNSET};
        final ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper((IProgressMonitor)new NullProgressMonitor()){

            public void setBlocked(IStatus reason) {
                super.setBlocked(reason);
                blocked[0] = Bug_311756.this.BLOCKED;
            }

            public void clearBlocked() {
                super.clearBlocked();
                if (blocked[0] == Bug_311756.this.BLOCKED) {
                    blocked[0] = Bug_311756.this.CLEARED;
                }
            }
        };
        final TestBarrier2 barrier = new TestBarrier2(1);
        final IdentityRule rule = new IdentityRule();
        final Thread[] destinationThread = new Thread[1];
        final AtomicReference exceptionInJob = new AtomicReference();
        Job conflicting = new Job("Conflicting"){

            protected IStatus run(IProgressMonitor monitor) {
                barrier.setStatus(3);
                barrier.waitForStatus(6);
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    exceptionInJob.set(e);
                    return Status.CANCEL_STATUS;
                }
                4.getJobManager().transferRule((ISchedulingRule)rule, destinationThread[0]);
                return Status.OK_STATUS;
            }
        };
        Job transferTo = new Job("TransferTo"){

            protected IStatus run(IProgressMonitor monitor) {
                destinationThread[0] = this.getThread();
                barrier.setStatus(6);
                5.getJobManager().beginRule((ISchedulingRule)rule, (IProgressMonitor)wrapper);
                5.getJobManager().endRule((ISchedulingRule)rule);
                return Status.OK_STATUS;
            }
        };
        conflicting.setRule((ISchedulingRule)rule);
        conflicting.schedule();
        barrier.waitForStatus(3);
        transferTo.schedule();
        this.waitForCompletion(conflicting);
        this.waitForCompletion(transferTo);
        if (exceptionInJob.get() != null) {
            throw (InterruptedException)exceptionInJob.get();
        }
        Assert.assertEquals((String)(blocked[0] == this.UNSET ? "setBlocked never called" : "clearBlocked never called"), (long)this.CLEARED, (long)blocked[0]);
    }

    @Test
    public void testBlockingAndUnblockingMonitorUsingYield() throws Exception {
        final int[] blocked = new int[]{-1};
        final ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper((IProgressMonitor)new NullProgressMonitor()){

            public void setBlocked(IStatus reason) {
                super.setBlocked(reason);
                blocked[0] = Bug_311756.this.BLOCKED;
            }

            public void clearBlocked() {
                super.clearBlocked();
                if (blocked[0] == Bug_311756.this.BLOCKED) {
                    blocked[0] = Bug_311756.this.CLEARED;
                }
            }
        };
        final TestBarrier2 barrier = new TestBarrier2(1);
        IdentityRule rule = new IdentityRule();
        final AtomicReference exceptionInJob = new AtomicReference();
        Job conflicting = new Job("Conflicting"){

            protected IStatus run(IProgressMonitor monitor) {
                barrier.setStatus(3);
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    exceptionInJob.set(e);
                    return Status.CANCEL_STATUS;
                }
                Job j = null;
                while (j == null) {
                    j = this.yieldRule((IProgressMonitor)wrapper);
                }
                return Status.OK_STATUS;
            }
        };
        conflicting.setRule((ISchedulingRule)rule);
        conflicting.schedule();
        barrier.waitForStatus(3);
        try {
            Job.getJobManager().beginRule((ISchedulingRule)rule, null);
            Thread.sleep(1000L);
        }
        finally {
            Job.getJobManager().endRule((ISchedulingRule)rule);
        }
        conflicting.join();
        if (exceptionInJob.get() != null) {
            throw (InterruptedException)exceptionInJob.get();
        }
        Assert.assertEquals((String)(blocked[0] == this.UNSET ? "setBlocked never called" : "clearBlocked never called"), (long)this.CLEARED, (long)blocked[0]);
    }

    @Test
    public void testBlockingAndUnblockingMonitorUsingYieldAndTransfer() throws Exception {
        final int[] blocked = new int[]{-1};
        final ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper((IProgressMonitor)new NullProgressMonitor()){

            public void setBlocked(IStatus reason) {
                super.setBlocked(reason);
                blocked[0] = Bug_311756.this.BLOCKED;
            }

            public void clearBlocked() {
                super.clearBlocked();
                if (blocked[0] == Bug_311756.this.BLOCKED) {
                    blocked[0] = Bug_311756.this.CLEARED;
                }
            }
        };
        final TestBarrier2 barrier = new TestBarrier2(1);
        IdentityRule rule = new IdentityRule();
        final AtomicReference exceptionInJob = new AtomicReference();
        Job conflicting = new Job("Conflicting"){

            protected IStatus run(IProgressMonitor monitor) {
                barrier.setStatus(3);
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    exceptionInJob.set(e);
                    return Status.CANCEL_STATUS;
                }
                Job j = null;
                while (j == null) {
                    j = this.yieldRule((IProgressMonitor)wrapper);
                }
                return Status.OK_STATUS;
            }
        };
        conflicting.setRule((ISchedulingRule)rule);
        conflicting.schedule();
        barrier.waitForStatus(3);
        Job.getJobManager().beginRule((ISchedulingRule)rule, null);
        Job.getJobManager().transferRule((ISchedulingRule)rule, conflicting.getThread());
        Thread.sleep(1000L);
        conflicting.join();
        if (exceptionInJob.get() != null) {
            throw (InterruptedException)exceptionInJob.get();
        }
        Assert.assertEquals((String)(blocked[0] == this.UNSET ? "setBlocked never called" : "clearBlocked never called"), (long)this.CLEARED, (long)blocked[0]);
    }
}

