/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.runtime.jobs;

import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.tests.harness.TestBarrier2;
import org.eclipse.core.tests.runtime.jobs.AbstractJobTest;
import org.junit.jupiter.api.Test;

public class Bug_311863
extends AbstractJobTest {
    volatile boolean finished = false;
    final int WAIT_ACQUIRE = 10002;
    final int RELEASED = 10013;
    final int DONE = 10023;
    final ILock lock = Job.getJobManager().newLock();

    @Test
    public void testInterruptDuringLockRelease() throws Exception {
        TestBarrier2 tb1 = new TestBarrier2(-1);
        TestBarrier2 tb2 = new TestBarrier2(-1);
        TestBarrier2 tb3 = new TestBarrier2(-1);
        TestThread t1 = new TestThread(tb1, 1);
        TestThread t2 = new TestThread(tb2, 2);
        TestThread t3 = new TestThread(tb3, 3);
        t1.start();
        t2.start();
        t3.start();
        int i = 0;
        while (i < 10) {
            tb1.setStatus(10002);
            tb2.setStatus(10002);
            tb3.setStatus(10002);
            int j = 0;
            while (j < 10) {
                t1.interrupt();
                t2.interrupt();
                t3.interrupt();
                Thread.yield();
                ++j;
            }
            tb1.waitForStatus(10013);
            tb2.waitForStatus(10013);
            tb3.waitForStatus(10013);
            ++i;
        }
        this.finished = true;
        tb1.setStatus(10002);
        tb2.setStatus(10002);
        tb3.setStatus(10002);
        tb1.waitForStatus(10023);
        tb2.waitForStatus(10023);
        tb3.waitForStatus(10023);
    }

    class TestThread
    extends Thread {
        private final TestBarrier2 tb;
        private final int yield_time;

        public TestThread(TestBarrier2 tb, int yield_time) {
            this.tb = tb;
            this.yield_time = yield_time;
        }

        @Override
        public void run() {
            while (true) {
                this.tb.waitForStatus(10002);
                if (Bug_311863.this.finished) break;
                int i = 0;
                while (i < 5) {
                    Bug_311863.this.lock.acquire();
                    try {
                        Thread.sleep(this.yield_time);
                        Thread.yield();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    Bug_311863.this.lock.release();
                    Thread.interrupted();
                    ++i;
                }
                this.tb.setStatus(10013);
            }
            this.tb.setStatus(10023);
        }
    }
}

