/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.runtime.jobs;

import org.eclipse.core.internal.jobs.JobManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.core.tests.harness.TestBarrier2;
import org.eclipse.core.tests.runtime.jobs.AbstractJobTest;
import org.eclipse.core.tests.runtime.jobs.PathRule;
import org.junit.jupiter.api.Test;

public class Bug_316839
extends AbstractJobTest {
    ILock LOCK = Job.getJobManager().newLock();
    TestBarrier2 barrier = new TestBarrier2(0);
    YieldingTestJob yieldingJob;
    TestJob interruptingJob;
    boolean lockGraphWasEmpty = true;

    @Test
    public void testBug() {
        this.yieldingJob = new YieldingTestJob("job with project rule ");
        this.yieldingJob.setTestRule(new PathRule("/pX"));
        this.yieldingJob.schedule();
        this.interruptingJob = new TestJob("job with root rule");
        this.interruptingJob.setRule(new PathRule("/"));
        this.interruptingJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                Bug_316839.this.lockGraphWasEmpty = ((JobManager)Job.getJobManager()).getLockManager().isEmpty();
            }
        });
        this.barrier.waitForStatus(3);
        this.interruptingJob.schedule();
        this.barrier.setStatus(4);
        this.waitForCompletion(this.yieldingJob);
        this.waitForCompletion(this.interruptingJob);
    }

    public static class TestJob
    extends Job {
        public TestJob(String name) {
            super(name);
        }

        protected IStatus run(IProgressMonitor monitor) {
            return Status.OK_STATUS;
        }
    }

    public class YieldingTestJob
    extends Job {
        private ISchedulingRule rule;

        public YieldingTestJob(String name) {
            super(name);
        }

        public void setTestRule(ISchedulingRule rule) {
            this.rule = rule;
        }

        protected IStatus run(IProgressMonitor monitor) {
            YieldingTestJob.getJobManager().beginRule(this.rule, monitor);
            try {
                Bug_316839.this.barrier.setStatus(3);
                Bug_316839.this.barrier.waitForStatus(4);
                this.doYieldRule();
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            finally {
                YieldingTestJob.getJobManager().endRule(this.rule);
            }
        }

        private void doYieldRule() {
            Job current = Job.getJobManager().currentJob();
            if (current != null) {
                current.yieldRule(null);
            }
        }
    }
}

