/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.runtime.jobs;

import java.util.concurrent.Semaphore;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.tests.runtime.jobs.AbstractJobTest;
import org.junit.Assert;
import org.junit.jupiter.api.Test;

public class Bug_366170
extends AbstractJobTest {
    private final Semaphore m_jobBStopHint = new Semaphore(1);

    @Test
    public void testBug() throws Exception {
        System.out.println("--- Running the examle ---");
        this.m_jobBStopHint.acquire();
        this.scheduleJobA(200L);
        this.scheduleJobC(300L);
        Thread.sleep(2000L);
        Assert.assertTrue((String)"Failed: Job C was not run", (boolean)this.m_jobBStopHint.tryAcquire());
    }

    private void scheduleJobA(long delay) throws Exception {
        Job job = new Job("A"){

            public boolean shouldSchedule() {
                System.out.println("schedule " + this.getName());
                return true;
            }

            protected IStatus run(IProgressMonitor monitor) {
                System.out.println("begin " + this.getName());
                try {
                    Bug_366170.this.scheduleJobB(0L).join();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                System.out.println("end   " + this.getName());
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule(delay);
    }

    private Job scheduleJobB(long delay) throws Exception {
        Job job = new Job("B"){

            public boolean shouldSchedule() {
                System.out.println("schedule " + this.getName());
                return true;
            }

            protected IStatus run(IProgressMonitor monitor) {
                System.out.println("begin " + this.getName());
                try {
                    Bug_366170.this.m_jobBStopHint.acquire();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                Bug_366170.this.m_jobBStopHint.release();
                System.out.println("end   " + this.getName());
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule(delay);
        return job;
    }

    private void scheduleJobC(long delay) throws Exception {
        Job job = new Job("C"){

            public boolean shouldSchedule() {
                System.out.println("schedule " + this.getName());
                return true;
            }

            protected IStatus run(IProgressMonitor monitor) {
                System.out.println("begin " + this.getName());
                Bug_366170.this.m_jobBStopHint.release();
                System.out.println("end   " + this.getName());
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule(delay);
    }
}

