/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.runtime.jobs;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.concurrent.atomic.AtomicIntegerArray;
import junit.framework.AssertionFailedError;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.tests.harness.FileSystemHelper;
import org.eclipse.core.tests.harness.TestBarrier2;
import org.eclipse.core.tests.harness.session.SessionShouldError;
import org.eclipse.core.tests.harness.session.SessionTestExtension;
import org.junit.Assert;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;
import org.junit.jupiter.api.extension.RegisterExtension;

@TestMethodOrder(value=MethodOrderer.MethodName.class)
public class Bug_412138 {
    @RegisterExtension
    static SessionTestExtension sessionTestExtension = SessionTestExtension.forPlugin((String)"org.eclipse.core.tests.runtime").create();
    private static final String FILE_NAME = FileSystemHelper.getTempDir().append(Bug_412138.class.getName()).toOSString();

    @Test
    @SessionShouldError
    public void testRunScenario() throws InterruptedException {
        new File(FILE_NAME).delete();
        final AtomicIntegerArray status = new AtomicIntegerArray(new int[]{-1});
        final Job fakeBuild = new Job("Fake AutoBuildJob"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus run(IProgressMonitor monitor) {
                try {
                    1 var2_2 = this;
                    synchronized (var2_2) {
                        status.set(0, 3);
                        Thread.sleep(3000L);
                        this.isBlocking();
                        return Status.OK_STATUS;
                    }
                }
                catch (InterruptedException e) {
                    return new Status(4, "org.eclipse.core.tests.runtime", e.getMessage(), (Throwable)e);
                }
            }
        };
        Job job = new Job("Some job"){

            protected IStatus run(IProgressMonitor monitor) {
                TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)3);
                try {
                    fakeBuild.join();
                    status.set(0, 5);
                    return Status.OK_STATUS;
                }
                catch (InterruptedException e) {
                    return new Status(4, "org.eclipse.core.tests.runtime", e.getMessage(), (Throwable)e);
                }
            }
        };
        try {
            try {
                job.schedule();
                fakeBuild.schedule();
                TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)5);
                job.join();
                fakeBuild.join();
                Assert.assertTrue((job.getResult() != null && job.getResult().isOK() ? 1 : 0) != 0);
                Assert.assertTrue((fakeBuild.getResult() != null && fakeBuild.getResult().isOK() ? 1 : 0) != 0);
            }
            catch (AssertionFailedError e) {
                try {
                    Throwable throwable = null;
                    Object var6_8 = null;
                    try (ObjectOutputStream stream = new ObjectOutputStream(new FileOutputStream(FILE_NAME));){
                        stream.writeObject((Object)e);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e1) {
                    e.printStackTrace();
                }
                System.exit(1);
            }
        }
        finally {
            System.exit(1);
        }
    }

    @Test
    public void testVerifyResult() throws IOException, ClassNotFoundException {
        File file = new File(FILE_NAME);
        if (file.exists()) {
            try {
                AssertionFailedError e;
                Throwable throwable = null;
                Object var4_4 = null;
                try (ObjectInputStream stream = new ObjectInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));){
                    e = (AssertionFailedError)((Object)stream.readObject());
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                throw e;
            }
            catch (Throwable throwable) {
                file.delete();
                throw throwable;
            }
        }
    }
}

