/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.runtime.jobs;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.core.tests.runtime.jobs.AbstractJobTest;
import org.eclipse.core.tests.runtime.jobs.PathRule;
import org.junit.Assert;
import org.junit.jupiter.api.Test;

public class Bug_478634
extends AbstractJobTest {
    PathRule rootRule = new PathRule("/");
    PathRule projectRule = new PathRule("/a");
    IJobManager jobManager = Job.getJobManager();
    ProjectJob projectJob = new ProjectJob();

    @Test
    public void testWaitingThreadJob() {
        this.projectJob.schedule();
        this.waitForCompletion(this.projectJob);
        ShouldNotBeBlockedJob j = new ShouldNotBeBlockedJob();
        j.setRule(this.rootRule);
        j.schedule();
        this.waitForCompletion(j);
        Assert.assertFalse((String)"Job was blocked", (boolean)j.wasBlocked());
    }

    class ProjectJob
    extends Job {
        public ProjectJob() {
            super("ProjectJob");
        }

        protected IStatus run(IProgressMonitor monitor) {
            ThreadJobListener tListener = new ThreadJobListener();
            RootJob rootJob = new RootJob(tListener);
            rootJob.schedule();
            while (!tListener.isBeginRule()) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            Bug_478634.this.jobManager.beginRule((ISchedulingRule)Bug_478634.this.projectRule, (IProgressMonitor)new NullProgressMonitor());
            Bug_478634.this.jobManager.endRule((ISchedulingRule)Bug_478634.this.projectRule);
            Bug_478634.this.jobManager.endRule((ISchedulingRule)Bug_478634.this.rootRule);
            return Status.OK_STATUS;
        }
    }

    class RootJob
    extends Job {
        private final ThreadJobListener listener;

        public RootJob(ThreadJobListener listener) {
            super("RootJob");
            this.listener = listener;
        }

        protected IStatus run(IProgressMonitor monitor) {
            Bug_478634.this.jobManager.beginRule((ISchedulingRule)Bug_478634.this.rootRule, (IProgressMonitor)new NullProgressMonitor());
            this.listener.notifyBeginRule();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Bug_478634.this.jobManager.transferRule((ISchedulingRule)Bug_478634.this.rootRule, Bug_478634.this.projectJob.getThread());
            return Status.OK_STATUS;
        }
    }

    class ShouldNotBeBlockedJob
    extends Job {
        private boolean blocked;

        public ShouldNotBeBlockedJob() {
            super("ShouldNotBeBlockedJob");
        }

        public boolean wasBlocked() {
            return this.blocked;
        }

        protected IStatus run(IProgressMonitor monitor) {
            this.blocked = this.isBlocking();
            return Status.OK_STATUS;
        }
    }

    static class ThreadJobListener
    extends JobChangeAdapter {
        private boolean beginRule = false;

        ThreadJobListener() {
        }

        public void notifyBeginRule() {
            this.beginRule = true;
        }

        public boolean isBeginRule() {
            return this.beginRule;
        }
    }
}

