/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.runtime.jobs;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.core.tests.harness.TestJob;
import org.eclipse.core.tests.runtime.jobs.AbstractJobTest;
import org.junit.Assert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Bug_550738
extends AbstractJobTest {
    @BeforeEach
    public void removeProgressProvider() throws Exception {
        this.manager.setProgressProvider(null);
    }

    @Test
    public void testCancelSchedule() throws InterruptedException {
        BusyLoopJob job = new BusyLoopJob();
        try {
            int i = 0;
            while (i < 10000) {
                CountDownLatch startedLatch = new CountDownLatch(1);
                job.started = startedLatch::countDown;
                job.cancel();
                job.schedule();
                Assert.assertTrue((String)("Job should start after schedule. Iteration " + i), (boolean)startedLatch.await(5L, TimeUnit.SECONDS));
                job.cancel();
                job.schedule();
                job.cancel();
                Assert.assertTrue((String)("Job should stop after cancellation. Iteration " + i), (boolean)job.join(5000L, null));
                ++i;
            }
        }
        finally {
            job.cancelWithoutRelyingOnFramework = true;
            this.waitForCompletion((Job)job);
        }
    }

    @Test
    public void testReportDoneOncePerSchedule() throws InterruptedException {
        BusyLoopJob job = new BusyLoopJob();
        EventCount eventCount = new EventCount();
        job.addJobChangeListener((IJobChangeListener)eventCount);
        try {
            int i = 0;
            while (i < 10000) {
                job.schedule();
                job.cancel();
                ++i;
            }
            Assert.assertTrue((boolean)job.join(5000L, null));
            Thread.sleep(200L);
            Assert.assertEquals((String)"Job should be completed once per schedule.", (long)eventCount.scheduledCount.get(), (long)eventCount.doneCount.get());
        }
        finally {
            job.cancelWithoutRelyingOnFramework = true;
            this.waitForCompletion((Job)job);
        }
    }

    private static final class BusyLoopJob
    extends TestJob {
        public Runnable started = () -> {};
        public volatile boolean cancelWithoutRelyingOnFramework = false;

        public BusyLoopJob() {
            super("Bug_550738", 1, 1L);
        }

        public IStatus run(IProgressMonitor monitor) {
            this.started.run();
            while (!monitor.isCanceled() && !this.cancelWithoutRelyingOnFramework) {
                Thread.yield();
            }
            return super.run(monitor);
        }
    }

    private static final class EventCount
    extends JobChangeAdapter {
        public final AtomicInteger doneCount = new AtomicInteger(0);
        public final AtomicInteger scheduledCount = new AtomicInteger(0);

        private EventCount() {
        }

        public void done(IJobChangeEvent event) {
            super.done(event);
            this.doneCount.incrementAndGet();
        }

        public void scheduled(IJobChangeEvent event) {
            super.scheduled(event);
            this.scheduledCount.incrementAndGet();
        }
    }
}

