/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.runtime.jobs;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.tests.runtime.jobs.AbstractJobTest;
import org.junit.Assert;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;

@TestMethodOrder(value=MethodOrderer.MethodName.class)
public class Bug_574883
extends AbstractJobTest {
    final int RUNS = 100000;
    final int processors = Runtime.getRuntime().availableProcessors();

    @Test
    public void testReschedulingLambda() throws InterruptedException {
        SerialExecutor serialExecutor = new SerialExecutor("test", this);
        AtomicInteger executions = new AtomicInteger();
        int i = 0;
        while (i < 100000) {
            serialExecutor.schedule(() -> {
                int n = executions.incrementAndGet();
            });
            ++i;
        }
        Job.getJobManager().join((Object)this, null);
        Job[] jobs = Job.getJobManager().find((Object)this);
        int length = jobs.length;
        int firstState = executions.get();
        try {
            if (length > 0) {
                Job.getJobManager().join((Object)this, null);
                if (Job.getJobManager().find((Object)this).length > 0) {
                    Assert.fail((String)("Job still running after second join, executed before: " + firstState + ", executed now: " + executions.get() + ", cpu: " + this.processors));
                }
            }
            Assert.assertEquals((String)("Job still running after first join, executed: " + firstState + ", cpu: " + this.processors), (long)0L, (long)length);
            Assert.assertEquals((long)100000L, (long)executions.get());
        }
        catch (Throwable t) {
            Job.getJobManager().cancel((Object)this);
            Thread.sleep(1000L);
            Job.getJobManager().join((Object)this, null);
            throw t;
        }
    }

    @Test
    public void testJoinLambdaOften() throws InterruptedException {
        int l = 0;
        while (l < 100000) {
            SerialExecutor serialExecutor = new SerialExecutor("test", this);
            AtomicInteger executions = new AtomicInteger();
            int INNER_RUNS = 10;
            int i = 0;
            while (i < INNER_RUNS) {
                serialExecutor.schedule(() -> {
                    int n = executions.incrementAndGet();
                });
                ++i;
            }
            Job.getJobManager().join((Object)this, null);
            Job[] jobs = Job.getJobManager().find((Object)this);
            int length = jobs.length;
            int firstState = executions.get();
            try {
                if (executions.get() != INNER_RUNS) {
                    System.out.println("error");
                }
                Assert.assertEquals((String)("after " + l + " tries: Job still running after join, executed: " + firstState + ", cpu: " + this.processors), (long)0L, (long)length);
                Assert.assertEquals((String)("after " + l + " tries"), (long)INNER_RUNS, (long)executions.get());
            }
            catch (Throwable t) {
                Job.getJobManager().cancel((Object)this);
                Thread.sleep(1000L);
                Job.getJobManager().join((Object)this, null);
                throw t;
            }
            ++l;
        }
    }

    @Test
    public void testReschedulingMethodRef() throws InterruptedException {
        SerialExecutor serialExecutor = new SerialExecutor("test", this);
        AtomicInteger executions = new AtomicInteger();
        int i = 0;
        while (i < 100000) {
            serialExecutor.schedule(executions::incrementAndGet);
            ++i;
        }
        Job.getJobManager().join((Object)this, null);
        Job[] jobs = Job.getJobManager().find((Object)this);
        int length = jobs.length;
        int firstState = executions.get();
        try {
            if (length > 0) {
                Job.getJobManager().join((Object)this, null);
                if (Job.getJobManager().find((Object)this).length > 0) {
                    Assert.fail((String)("Job still running after second join, executed before: " + firstState + ", executed now: " + executions.get() + ", cpu: " + this.processors));
                }
            }
            Assert.assertEquals((String)("Job still running after first join, executed: " + firstState + ", cpu: " + this.processors), (long)0L, (long)length);
            Assert.assertEquals((long)100000L, (long)executions.get());
        }
        catch (Throwable t) {
            Job.getJobManager().cancel((Object)this);
            Thread.sleep(1000L);
            Job.getJobManager().join((Object)this, null);
            throw t;
        }
    }

    @Test
    public void testReschedulingSomeMoreWork() throws InterruptedException {
        SerialExecutor serialExecutor = new SerialExecutor("test", this);
        AtomicInteger executions = new AtomicInteger();
        AtomicLong garbage = new AtomicLong(42L);
        int i = 0;
        while (i < 100000) {
            serialExecutor.schedule(() -> {
                executions.incrementAndGet();
                garbage.getAndUpdate(x -> (long)((double)x + Math.sin(x) * 100.0));
            });
            ++i;
        }
        Job.getJobManager().join((Object)this, null);
        Job[] jobs = Job.getJobManager().find((Object)this);
        int length = jobs.length;
        int firstState = executions.get();
        try {
            if (length > 0) {
                Job.getJobManager().join((Object)this, null);
                if (Job.getJobManager().find((Object)this).length > 0) {
                    Assert.fail((String)("Job still running after second join, executed before: " + firstState + ", executed now: " + executions.get() + ", cpu: " + this.processors));
                }
            }
            Assert.assertEquals((String)("Job still running after first join, executed: " + firstState + ", cpu: " + this.processors), (long)0L, (long)length);
            Assert.assertEquals((long)100000L, (long)executions.get());
        }
        catch (Throwable t) {
            Job.getJobManager().cancel((Object)this);
            Thread.sleep(1000L);
            Job.getJobManager().join((Object)this, null);
            throw t;
        }
    }

    @Test
    public void testNow() throws Exception {
        AtomicInteger executions = new AtomicInteger();
        int i = 0;
        while (i < 100000) {
            long t1 = Bug_574883.now();
            ((Runnable)() -> {
                int n = executions.incrementAndGet();
            }).run();
            long t2 = Bug_574883.now();
            long diff = t2 - t1;
            Assert.assertTrue((String)("Time should not go back: " + diff + " at: " + i), (diff >= 0L ? 1 : 0) != 0);
            ++i;
        }
        Assert.assertEquals((long)100000L, (long)executions.get());
    }

    static class SerialExecutor
    extends Job {
        private final Queue<Runnable> queue;
        private final Object myFamily;

        public SerialExecutor(String jobName, Object family) {
            super(jobName);
            org.eclipse.core.runtime.Assert.isNotNull((Object)family);
            this.myFamily = family;
            this.queue = new ConcurrentLinkedQueue<Runnable>();
            this.setSystem(true);
        }

        public boolean belongsTo(Object family) {
            return this.myFamily == family;
        }

        protected IStatus run(IProgressMonitor monitor) {
            Runnable action = this.queue.poll();
            try {
                if (action != null && !monitor.isCanceled()) {
                    action.run();
                }
            }
            finally {
                if (!this.queue.isEmpty() && !monitor.isCanceled()) {
                    this.schedule();
                }
            }
            return Status.OK_STATUS;
        }

        public void schedule(Runnable action) {
            this.queue.add(action);
            this.schedule();
        }
    }
}

