/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.runtime.jobs;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class Bug_574883Join {
    final int RUNS = 100000;
    static volatile int run;

    @Test
    public void testJoinLambdaQuick() throws InterruptedException {
        String firstMessage = null;
        int joinFails = 0;
        int scheduleFails = 0;
        run = 0;
        while (run < 100000) {
            AtomicInteger executions = new AtomicInteger();
            int EXPECTED_RUNS = 2;
            Reference<SerialExecutor> jobReference = this.createAndRunJobTwice(executions);
            Job.getJobManager().join((Object)this, null);
            int executionsAfterJoin = executions.get();
            if (executionsAfterJoin != EXPECTED_RUNS) {
                int waits = 0;
                while (executions.get() != EXPECTED_RUNS) {
                    if (++waits < 10) {
                        Thread.yield();
                        continue;
                    }
                    System.gc();
                    System.runFinalization();
                    SerialExecutor job = jobReference.get();
                    if (job == null) break;
                }
                int executionsCured = executions.get();
                String message = "after " + run + " tries: executionsAfterJoin: " + executionsAfterJoin + "/" + EXPECTED_RUNS;
                if (executionsCured == EXPECTED_RUNS) {
                    if (joinFails == 0) {
                        System.out.println(message + " but did finish with " + executionsCured);
                        firstMessage = message;
                    }
                    ++joinFails;
                } else {
                    if (scheduleFails == 0) {
                        System.out.println(message);
                        firstMessage = message;
                    }
                    ++scheduleFails;
                }
            }
            ++run;
        }
        Assertions.assertEquals((int)0, (int)scheduleFails, (String)("Job was not (re)scheduled " + scheduleFails + "/" + run + " times. example: " + firstMessage));
        Assertions.assertEquals((int)0, (int)joinFails, (String)("Job was not joined " + joinFails + "/" + run + " times. example: " + firstMessage));
    }

    private Reference<SerialExecutor> createAndRunJobTwice(AtomicInteger executions) {
        SerialExecutor serialExecutor = new SerialExecutor("test", this, () -> {
            int n = executions.incrementAndGet();
        });
        serialExecutor.schedule();
        while (executions.get() == 0) {
            Thread.onSpinWait();
        }
        serialExecutor.schedule();
        return new WeakReference<SerialExecutor>(serialExecutor);
    }

    static class SerialExecutor
    extends Job {
        private final Object myFamily;
        final Runnable action;
        AtomicInteger executions = new AtomicInteger();

        public SerialExecutor(String jobName, Object family, Runnable action) {
            super(jobName);
            Assert.isNotNull((Object)family);
            this.myFamily = family;
            this.setSystem(true);
            this.setPriority(10);
            this.action = action;
        }

        public boolean belongsTo(Object family) {
            return this.myFamily == family;
        }

        protected IStatus run(IProgressMonitor monitor) {
            this.action.run();
            this.executions.incrementAndGet();
            return Status.OK_STATUS;
        }

        public String toString() {
            return " executions=" + this.executions.get() + " run " + run;
        }
    }
}

