/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.runtime.jobs;

import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.atomic.AtomicIntegerArray;
import org.eclipse.core.internal.jobs.DeadlockDetector;
import org.eclipse.core.internal.jobs.JobManager;
import org.eclipse.core.internal.jobs.LockManager;
import org.eclipse.core.internal.jobs.OrderedLock;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.tests.harness.FussyProgressMonitor;
import org.eclipse.core.tests.harness.TestBarrier2;
import org.eclipse.core.tests.runtime.jobs.AbstractJobTest;
import org.eclipse.core.tests.runtime.jobs.IdentityRule;
import org.eclipse.core.tests.runtime.jobs.PathRule;
import org.eclipse.core.tests.runtime.jobs.RandomTestRunnable;
import org.eclipse.core.tests.runtime.jobs.TestBlockingMonitor;
import org.junit.Assert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class DeadlockDetectionTest {
    private final IJobManager manager = Job.getJobManager();
    private String testName;

    @BeforeEach
    public void setTestName(TestInfo testInfo) {
        this.testName = testInfo.getDisplayName();
    }

    private void createRunnables(ILock[] locks, int n, ArrayList<RandomTestRunnable> allRunnables, boolean cond) {
        int i = 0;
        while (i < n) {
            allRunnables.add(new RandomTestRunnable(locks, this.testName + " # " + (allRunnables.size() + 1), cond));
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++i;
        }
    }

    private LockManager getLockManager() {
        return ((JobManager)this.manager).getLockManager();
    }

    private void kill(ArrayList<RandomTestRunnable> allRunnables) {
        for (RandomTestRunnable r : allRunnables) {
            r.kill();
        }
    }

    @Test
    public void testComplex() {
        DeadlockDetector.runSilent(() -> {
            ArrayList<RandomTestRunnable> allRunnables = new ArrayList<RandomTestRunnable>();
            LockManager lockManager = new LockManager();
            OrderedLock lock1 = lockManager.newLock();
            OrderedLock lock2 = lockManager.newLock();
            OrderedLock lock3 = lockManager.newLock();
            OrderedLock lock4 = lockManager.newLock();
            OrderedLock lock5 = lockManager.newLock();
            OrderedLock lock6 = lockManager.newLock();
            this.createRunnables(new ILock[]{lock1, lock2, lock3}, 1, allRunnables, true);
            this.createRunnables(new ILock[]{lock2, lock3, lock4}, 1, allRunnables, true);
            this.createRunnables(new ILock[]{lock3, lock4, lock5}, 1, allRunnables, true);
            this.createRunnables(new ILock[]{lock4, lock5, lock6}, 1, allRunnables, true);
            this.createRunnables(new ILock[]{lock5, lock6, lock1}, 1, allRunnables, true);
            this.createRunnables(new ILock[]{lock6, lock1, lock2}, 1, allRunnables, true);
            this.wait(allRunnables, lockManager);
        });
    }

    private void wait(ArrayList<RandomTestRunnable> allRunnables, LockManager lockManager) {
        this.start(allRunnables);
        while (!allRunnables.stream().allMatch(t -> t.runs >= 2)) {
            Thread.yield();
        }
        this.kill(allRunnables);
        int i = 0;
        while (i < allRunnables.size()) {
            try {
                allRunnables.get(i).join(100000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Assert.assertTrue((String)("1." + i), (!allRunnables.get(i).isAlive() ? 1 : 0) != 0);
            ++i;
        }
        Assert.assertTrue((String)"Locks not removed from graph.", (boolean)lockManager.isEmpty());
    }

    @Test
    public void testSimpleDeadlock() {
        DeadlockDetector.runSilent(() -> {
            ArrayList<RandomTestRunnable> allRunnables = new ArrayList<RandomTestRunnable>();
            LockManager localManager = new LockManager();
            OrderedLock lock1 = localManager.newLock();
            OrderedLock lock2 = localManager.newLock();
            this.createRunnables(new ILock[]{lock1, lock2}, 1, allRunnables, false);
            this.createRunnables(new ILock[]{lock2, lock1}, 1, allRunnables, false);
            this.wait(allRunnables, localManager);
        });
    }

    @Test
    public void testThreeLocks() {
        DeadlockDetector.runSilent(() -> {
            ArrayList<RandomTestRunnable> allRunnables = new ArrayList<RandomTestRunnable>();
            LockManager lockManager = new LockManager();
            OrderedLock lock1 = lockManager.newLock();
            OrderedLock lock2 = lockManager.newLock();
            OrderedLock lock3 = lockManager.newLock();
            this.createRunnables(new ILock[]{lock1, lock2}, 1, allRunnables, false);
            this.createRunnables(new ILock[]{lock2, lock3}, 1, allRunnables, false);
            this.createRunnables(new ILock[]{lock3, lock1}, 1, allRunnables, false);
            this.wait(allRunnables, lockManager);
        });
    }

    @Test
    public void testRuleLockInteraction() {
        final ILock lock = this.manager.newLock();
        final IdentityRule rule = new IdentityRule();
        final AtomicIntegerArray status = new AtomicIntegerArray(new int[2]);
        Thread first = new Thread("Test1"){

            @Override
            public void run() {
                lock.acquire();
                status.set(0, 1);
                Assert.assertTrue((String)"1.0", (boolean)DeadlockDetectionTest.this.getLockManager().isLockOwner());
                TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)0, (int)3);
                DeadlockDetectionTest.this.manager.beginRule(rule, null);
                Assert.assertTrue((String)"2.0", (boolean)DeadlockDetectionTest.this.getLockManager().isLockOwner());
                DeadlockDetectionTest.this.manager.endRule(rule);
                lock.release();
                status.set(0, 5);
            }
        };
        Thread second = new Thread("Test2"){

            @Override
            public void run() {
                DeadlockDetectionTest.this.manager.beginRule(rule, null);
                status.set(1, 1);
                Assert.assertTrue((String)"1.0", (boolean)DeadlockDetectionTest.this.getLockManager().isLockOwner());
                TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)1, (int)3);
                lock.acquire();
                Assert.assertTrue((String)"2.0", (boolean)DeadlockDetectionTest.this.getLockManager().isLockOwner());
                lock.release();
                DeadlockDetectionTest.this.manager.endRule(rule);
                status.set(1, 5);
            }
        };
        first.start();
        second.start();
        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)0, (int)1);
        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)1, (int)1);
        status.set(0, 3);
        status.set(1, 3);
        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)0, (int)5);
        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)1, (int)5);
        this.waitForThreadDeath(first);
        this.waitForThreadDeath(second);
        Assert.assertTrue((String)"3.0", (!first.isAlive() ? 1 : 0) != 0);
        Assert.assertTrue((String)"4.0", (!second.isAlive() ? 1 : 0) != 0);
        if (!this.getLockManager().isEmpty()) {
            Assert.assertTrue((String)"Jobs not removed from graph.", (boolean)this.getLockManager().isEmpty());
        }
    }

    @Test
    public void testJobRuleLockInteraction() {
        final AtomicIntegerArray status = new AtomicIntegerArray(new int[2]);
        IdentityRule rule1 = new IdentityRule();
        IdentityRule rule2 = new IdentityRule();
        final ILock lock = this.manager.newLock();
        Job first = new Job("Test1"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    Assert.assertTrue((String)"1.0", (boolean)DeadlockDetectionTest.this.getLockManager().isLockOwner());
                    monitor.beginTask("Testing", 1);
                    status.set(0, 1);
                    lock.acquire();
                    TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)0, (int)3);
                    Assert.assertTrue((String)"2.0", (boolean)DeadlockDetectionTest.this.getLockManager().isLockOwner());
                    lock.release();
                    monitor.worked(1);
                    status.set(0, 5);
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        Job second = new Job("Test2"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    Assert.assertTrue((String)"1.0", (boolean)DeadlockDetectionTest.this.getLockManager().isLockOwner());
                    monitor.beginTask("Testing", 1);
                    status.set(1, 1);
                    lock.acquire();
                    TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)1, (int)3);
                    Assert.assertTrue((String)"2.0", (boolean)DeadlockDetectionTest.this.getLockManager().isLockOwner());
                    lock.release();
                    monitor.worked(1);
                    status.set(1, 5);
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        first.setRule((ISchedulingRule)rule1);
        second.setRule((ISchedulingRule)rule2);
        first.schedule();
        second.schedule();
        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)0, (int)1);
        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)1, (int)1);
        status.set(0, 3);
        status.set(1, 3);
        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)0, (int)5);
        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)1, (int)5);
        this.waitForCompletion(first);
        this.waitForCompletion(second);
        Assert.assertEquals((String)"3.0", (long)0L, (long)first.getState());
        Assert.assertEquals((String)"3.1", (Object)Status.OK_STATUS, (Object)first.getResult());
        Assert.assertEquals((String)"4.0", (long)0L, (long)second.getState());
        Assert.assertEquals((String)"4.1", (Object)Status.OK_STATUS, (Object)second.getResult());
        Assert.assertTrue((String)"Jobs not removed from graph.", (boolean)this.getLockManager().isEmpty());
    }

    public static void fill(AtomicIntegerArray a, int val) {
        int i = 0;
        int len = a.length();
        while (i < len) {
            a.set(i, val);
            ++i;
        }
    }

    @Test
    public void testRuleHierarchyWaitReplace() {
        Job job;
        int NUM_JOBS = 3;
        final AtomicIntegerArray status = new AtomicIntegerArray(new int[3]);
        DeadlockDetectionTest.fill(status, 0);
        final ISchedulingRule[] rules = new ISchedulingRule[]{new PathRule("/testRuleHierarchyWaitReplace"), new PathRule("/testRuleHierarchyWaitReplace/B"), new PathRule("/testRuleHierarchyWaitReplace/C")};
        final ILock[] locks = new ILock[]{this.manager.newLock(), this.manager.newLock()};
        Job[] jobs = new Job[]{new Job("Test 0"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    monitor.beginTask("Testing", 1);
                    manager.beginRule(rules[0], null);
                    status.set(0, 2);
                    TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)0, (int)3);
                    manager.endRule(rules[0]);
                    monitor.worked(1);
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        }, new Job("Test 1"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    monitor.beginTask("Testing", 1);
                    locks[0].acquire();
                    TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)1, (int)1);
                    manager.beginRule(rules[1], (IProgressMonitor)new TestBlockingMonitor(status, 1));
                    status.set(1, 2);
                    locks[1].acquire();
                    locks[1].release();
                    TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)1, (int)3);
                    manager.endRule(rules[1]);
                    locks[0].release();
                    monitor.worked(1);
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        }, new Job("Test 2"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    monitor.beginTask("Testing", 1);
                    locks[1].acquire();
                    TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)2, (int)1);
                    manager.beginRule(rules[2], (IProgressMonitor)new TestBlockingMonitor(status, 2));
                    status.set(2, 2);
                    TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)2, (int)3);
                    manager.endRule(rules[2]);
                    locks[1].release();
                    monitor.worked(1);
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        }};
        Job[] jobArray = jobs;
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            job = jobArray[n2];
            job.schedule();
            ++n2;
        }
        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)0, (int)2);
        status.set(1, 1);
        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)1, (int)6);
        status.set(2, 1);
        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)2, (int)6);
        status.set(0, 3);
        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)1, (int)2);
        status.set(1, 3);
        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)2, (int)2);
        status.set(2, 3);
        jobArray = jobs;
        n = jobs.length;
        n2 = 0;
        while (n2 < n) {
            job = jobArray[n2];
            this.waitForCompletion(job);
            ++n2;
        }
        int i = 0;
        while (i < jobs.length) {
            Assert.assertEquals((String)("10." + i), (long)0L, (long)jobs[i].getState());
            Assert.assertEquals((String)("10." + i), (Object)Status.OK_STATUS, (Object)jobs[i].getResult());
            ++i;
        }
        Assert.assertTrue((String)"Jobs not removed from graph.", (boolean)this.getLockManager().isEmpty());
    }

    @Test
    public void testDetectDeadlock() {
        DeadlockDetector.runSilent(() -> {
            Job job;
            int NUM_JOBS = 3;
            final AtomicIntegerArray status = new AtomicIntegerArray(new int[3]);
            DeadlockDetectionTest.fill(status, 0);
            final ISchedulingRule[] rules = new ISchedulingRule[]{new PathRule("/testDetectDeadlock"), new PathRule("/testDetectDeadlock/B"), new PathRule("/testDetectDeadlock/C")};
            final ILock lock = this.manager.newLock();
            Job[] jobs = new Job[]{new Job("Test 0"){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        monitor.beginTask("Testing", 1);
                        manager.beginRule(rules[1], null);
                        status.set(0, 2);
                        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)0, (int)3);
                        manager.endRule(rules[1]);
                        monitor.worked(1);
                    }
                    finally {
                        monitor.done();
                    }
                    return Status.OK_STATUS;
                }
            }, new Job("Test 1"){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        monitor.beginTask("Testing", 1);
                        lock.acquire();
                        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)1, (int)1);
                        manager.beginRule(rules[0], (IProgressMonitor)new TestBlockingMonitor(status, 1));
                        status.set(1, 2);
                        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)1, (int)3);
                        manager.endRule(rules[0]);
                        lock.release();
                        monitor.worked(1);
                    }
                    finally {
                        monitor.done();
                    }
                    return Status.OK_STATUS;
                }
            }, new Job("Test 2"){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        monitor.beginTask("Testing", 1);
                        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)2, (int)1);
                        manager.beginRule(rules[2], null);
                        status.set(2, 2);
                        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)2, (int)3);
                        lock.acquire();
                        lock.release();
                        manager.endRule(rules[2]);
                        monitor.worked(1);
                    }
                    finally {
                        monitor.done();
                    }
                    return Status.OK_STATUS;
                }
            }};
            Job[] jobArray = jobs;
            int n = jobs.length;
            int n2 = 0;
            while (n2 < n) {
                job = jobArray[n2];
                job.schedule();
                ++n2;
            }
            TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)0, (int)2);
            status.set(2, 1);
            TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)2, (int)2);
            status.set(1, 1);
            TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)1, (int)6);
            status.set(2, 3);
            status.set(0, 3);
            TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)1, (int)2);
            status.set(1, 3);
            jobArray = jobs;
            n = jobs.length;
            n2 = 0;
            while (n2 < n) {
                job = jobArray[n2];
                this.waitForCompletion(job);
                ++n2;
            }
            int i = 0;
            while (i < jobs.length) {
                Assert.assertEquals((String)("10." + i), (long)0L, (long)jobs[i].getState());
                Assert.assertEquals((String)("10." + i), (Object)Status.OK_STATUS, (Object)jobs[i].getResult());
                ++i;
            }
            Assert.assertTrue((String)"Jobs not removed from graph.", (boolean)this.getLockManager().isEmpty());
        });
    }

    @Test
    public void testMultipleColumnRemoval() {
        Job job;
        int NUM_JOBS = 3;
        final AtomicIntegerArray status = new AtomicIntegerArray(new int[3]);
        DeadlockDetectionTest.fill(status, 0);
        final ISchedulingRule[] rules = new ISchedulingRule[]{new PathRule("/testMultipleColumnRemoval"), new PathRule("/testMultipleColumnRemoval/B"), new PathRule("/testMultipleColumnRemoval/C")};
        final TestBlockingMonitor first = new TestBlockingMonitor(status, 1);
        final TestBlockingMonitor second = new TestBlockingMonitor(status, 2);
        Job[] jobs = new Job[]{new Job("Test 0"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    monitor.beginTask("Testing", 1);
                    manager.beginRule(rules[0], null);
                    status.set(0, 2);
                    TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)0, (int)3);
                    manager.endRule(rules[0]);
                    monitor.worked(1);
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        }, new Job("Test 1"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    monitor.beginTask("Testing", 1);
                    TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)1, (int)1);
                    manager.beginRule(rules[1], first);
                    monitor.worked(1);
                }
                finally {
                    status.set(1, 5);
                    manager.endRule(rules[1]);
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        }, new Job("Test 2"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    monitor.beginTask("Testing", 1);
                    TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)2, (int)1);
                    manager.beginRule(rules[2], second);
                    monitor.worked(1);
                }
                finally {
                    status.set(2, 5);
                    manager.endRule(rules[2]);
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        }};
        Job[] jobArray = jobs;
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            job = jobArray[n2];
            job.schedule();
            ++n2;
        }
        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)0, (int)2);
        status.set(1, 1);
        status.set(2, 1);
        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)1, (int)6);
        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)2, (int)6);
        first.setCanceled(true);
        second.setCanceled(true);
        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)1, (int)5);
        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)2, (int)5);
        status.set(0, 3);
        jobArray = jobs;
        n = jobs.length;
        n2 = 0;
        while (n2 < n) {
            job = jobArray[n2];
            this.waitForCompletion(job);
            ++n2;
        }
        Assert.assertTrue((String)"Jobs not removed from graph.", (boolean)this.getLockManager().isEmpty());
    }

    @Test
    public void testBeginRuleCancelAfterWait() {
        final PathRule rule1 = new PathRule("/testBeginRuleCancelAfterWait");
        final PathRule rule2 = new PathRule("/testBeginRuleCancelAfterWait/B");
        final AtomicIntegerArray status = new AtomicIntegerArray(new int[2]);
        FussyProgressMonitor canceller = new FussyProgressMonitor();
        Job ruleOwner = new Job("Test1"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    status.set(0, 1);
                    manager.beginRule(rule1, null);
                    TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)0, (int)3);
                    manager.endRule(rule1);
                    monitor.worked(1);
                }
                finally {
                    monitor.done();
                    status.set(0, 5);
                }
                return Status.OK_STATUS;
            }
        };
        Job ruleWait = new Job("Test2", (IProgressMonitor)canceller){
            private final /* synthetic */ IProgressMonitor val$canceller;
            {
                this.val$canceller = iProgressMonitor;
                super($anonymous0);
            }

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    status.set(1, 3);
                    manager.beginRule(rule2, this.val$canceller);
                    monitor.worked(1);
                }
                finally {
                    manager.endRule(rule2);
                    monitor.done();
                    status.set(1, 5);
                }
                return Status.OK_STATUS;
            }
        };
        ruleOwner.schedule();
        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)1);
        ruleWait.schedule();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        canceller.setCanceled(true);
        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)1, (int)5);
        status.set(0, 3);
        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)5);
        this.waitForCompletion(ruleOwner);
        Assert.assertTrue((String)"Canceled rule not removed from graph.", (boolean)this.getLockManager().isEmpty());
    }

    @Test
    public void testImplicitRules() {
        int NUM_JOBS = 4;
        final AtomicIntegerArray status = new AtomicIntegerArray(new int[4]);
        DeadlockDetectionTest.fill(status, 0);
        final ISchedulingRule[] rules = new ISchedulingRule[]{new PathRule("/testImplicitRules"), new PathRule("/testImplicitRules/B"), new PathRule("/testImplicitRules/C"), new PathRule("/testImplicitRules/B/D")};
        Job[] jobs = new Job[]{new Job("Test 0"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    monitor.beginTask("Testing", 1);
                    manager.beginRule(rules[3], null);
                    status.set(0, 2);
                    TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)0, (int)3);
                    manager.endRule(rules[3]);
                    monitor.worked(1);
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        }, new Job("Test 1"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    monitor.beginTask("Testing", 1);
                    manager.beginRule(rules[2], null);
                    status.set(1, 2);
                    TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)1, (int)3);
                    manager.endRule(rules[2]);
                    monitor.worked(1);
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        }, new Job("Test 2"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    monitor.beginTask("Testing", 1);
                    TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)2, (int)1);
                    manager.beginRule(rules[0], (IProgressMonitor)new TestBlockingMonitor(status, 2));
                    status.set(2, 2);
                    TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)2, (int)3);
                    manager.endRule(rules[0]);
                    monitor.worked(1);
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        }, new Job("Test 3"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    monitor.beginTask("Testing", 1);
                    TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)3, (int)1);
                    manager.beginRule(rules[1], (IProgressMonitor)new TestBlockingMonitor(status, 3));
                    status.set(3, 2);
                    TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)3, (int)3);
                    manager.endRule(rules[1]);
                    monitor.worked(1);
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        }};
        Job[] jobArray = jobs;
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            Job job = jobArray[n2];
            job.schedule();
            ++n2;
        }
        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)0, (int)2);
        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)1, (int)2);
        status.set(2, 1);
        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)2, (int)6);
        status.set(3, 1);
        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)3, (int)6);
        status.set(0, 3);
        status.set(1, 3);
        int runningCount = 0;
        long waitStart = AbstractJobTest.now();
        while (runningCount < 2) {
            if (status.get(2) == 2) {
                ++runningCount;
                status.set(2, 3);
            }
            if (status.get(3) == 2) {
                ++runningCount;
                status.set(3, 3);
            }
            long elapsed = AbstractJobTest.now() - waitStart;
            Assert.assertTrue((String)("Timeout waiting for job to end: " + elapsed), (elapsed < 30000L ? 1 : 0) != 0);
        }
        Job[] jobArray2 = jobs;
        int n3 = jobs.length;
        int n4 = 0;
        while (n4 < n3) {
            Job job = jobArray2[n4];
            this.waitForCompletion(job);
            ++n4;
        }
        int i = 0;
        while (i < jobs.length) {
            Assert.assertEquals((String)("10." + i), (long)0L, (long)jobs[i].getState());
            Assert.assertEquals((String)("10." + i), (Object)Status.OK_STATUS, (Object)jobs[i].getResult());
            ++i;
        }
        Assert.assertTrue((String)"Jobs not removed from graph.", (boolean)this.getLockManager().isEmpty());
    }

    public void _testRuleHierarchyLockInteraction() {
        Job job;
        int NUM_JOBS = 5;
        final AtomicIntegerArray status = new AtomicIntegerArray(new int[5]);
        DeadlockDetectionTest.fill(status, 0);
        final ISchedulingRule[] rules = new ISchedulingRule[]{new PathRule("/A"), new PathRule("/A/B"), new PathRule("/A/C")};
        Job[] jobs = new Job[]{new Job("Test 0"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    monitor.beginTask("Testing", 1);
                    manager.beginRule(rules[1], null);
                    status.set(0, 2);
                    TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)0, (int)3);
                    manager.endRule(rules[1]);
                    monitor.worked(1);
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        }, new Job("Test 1"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    monitor.beginTask("Testing", 1);
                    TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)1, (int)1);
                    manager.beginRule(rules[2], null);
                    status.set(1, 2);
                    TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)1, (int)3);
                    manager.endRule(rules[2]);
                    monitor.worked(1);
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        }, new Job("Test 2"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    monitor.beginTask("Testing", 1);
                    TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)2, (int)1);
                    manager.beginRule(rules[0], (IProgressMonitor)new TestBlockingMonitor(status, 2));
                    status.set(2, 2);
                    TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)2, (int)3);
                    manager.endRule(rules[0]);
                    monitor.worked(1);
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        }, new Job("Test 3"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    monitor.beginTask("Testing", 1);
                    TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)3, (int)1);
                    manager.beginRule(rules[2], (IProgressMonitor)new TestBlockingMonitor(status, 3));
                    status.set(3, 2);
                    TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)3, (int)3);
                    manager.endRule(rules[2]);
                    monitor.worked(1);
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        }, new Job("Test 4"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    monitor.beginTask("Testing", 1);
                    TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)4, (int)1);
                    manager.beginRule(rules[2], (IProgressMonitor)new TestBlockingMonitor(status, 4));
                    status.set(4, 2);
                    TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)4, (int)3);
                    manager.endRule(rules[2]);
                    monitor.worked(1);
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        }};
        Job[] jobArray = jobs;
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            job = jobArray[n2];
            job.schedule();
            ++n2;
        }
        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)0, (int)2);
        status.set(1, 1);
        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)1, (int)2);
        status.set(2, 1);
        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)2, (int)6);
        status.set(3, 1);
        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)3, (int)6);
        status.set(0, 3);
        status.set(1, 3);
        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)2, (int)2);
        status.set(4, 1);
        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)4, (int)6);
        status.set(2, 3);
        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)3, (int)2);
        status.set(3, 3);
        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)4, (int)2);
        status.set(4, 3);
        jobArray = jobs;
        n = jobs.length;
        n2 = 0;
        while (n2 < n) {
            job = jobArray[n2];
            this.waitForCompletion(job);
            ++n2;
        }
        int i = 0;
        while (i < jobs.length) {
            Assert.assertEquals((String)("10." + i), (long)0L, (long)jobs[i].getState());
            Assert.assertEquals((String)("10." + i), (Object)Status.OK_STATUS, (Object)jobs[i].getResult());
            ++i;
        }
        Assert.assertTrue((String)"Jobs not removed from graph.", (boolean)this.getLockManager().isEmpty());
    }

    @Test
    public void testVeryComplex() {
        DeadlockDetector.runSilent(() -> {
            ArrayList<RandomTestRunnable> allRunnables = new ArrayList<RandomTestRunnable>();
            LockManager lockManager = new LockManager();
            OrderedLock lock1 = lockManager.newLock();
            OrderedLock lock2 = lockManager.newLock();
            OrderedLock lock3 = lockManager.newLock();
            OrderedLock lock4 = lockManager.newLock();
            OrderedLock lock5 = lockManager.newLock();
            OrderedLock lock6 = lockManager.newLock();
            this.createRunnables(new ILock[]{lock1, lock2, lock3}, 10, allRunnables, true);
            this.createRunnables(new ILock[]{lock2, lock3, lock4}, 10, allRunnables, true);
            this.createRunnables(new ILock[]{lock3, lock4, lock5}, 10, allRunnables, true);
            this.createRunnables(new ILock[]{lock4, lock5, lock6}, 10, allRunnables, true);
            this.createRunnables(new ILock[]{lock5, lock6, lock1}, 10, allRunnables, true);
            this.createRunnables(new ILock[]{lock6, lock1, lock2}, 10, allRunnables, true);
            this.wait(allRunnables, lockManager);
        });
    }

    private void waitForCompletion(Job job) {
        int i = 0;
        while (job.getState() != 0) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Assert.assertTrue((String)("Timeout waiting for job to end:" + String.valueOf(job)), (++i < 100 ? 1 : 0) != 0);
        }
    }

    private void waitForThreadDeath(Thread thread) {
        int i = 0;
        while (thread.isAlive()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Assert.assertTrue((String)"Timeout waiting for job to end.", (++i < 100 ? 1 : 0) != 0);
        }
    }

    public void _testComplexRuleLockInteraction() {
        int NUM_LOCKS = 5;
        final AtomicIntegerArray status = new AtomicIntegerArray(new int[1]);
        final ISchedulingRule[] rules = new ISchedulingRule[]{new PathRule("/A"), new PathRule("/A/B"), new PathRule("/A/C"), new PathRule("/A/B/D"), new PathRule("/A/C/E")};
        final ILock[] locks = new ILock[]{this.manager.newLock(), this.manager.newLock(), this.manager.newLock(), this.manager.newLock(), this.manager.newLock()};
        Job[] jobs = new Job[15];
        final Random random = new Random();
        int i22 = 0;
        while (i22 < jobs.length) {
            jobs[i22] = new Job("Test" + i22){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        try {
                            monitor.beginTask("Testing", -1);
                            while (status.get(0) != 5) {
                                int indexRule = random.nextInt(5);
                                int indexLock = random.nextInt(5);
                                int secondIndex = random.nextInt(5);
                                if (indexRule % 2 == 0) {
                                    manager.beginRule(rules[indexRule], null);
                                    locks[indexLock].acquire();
                                    locks[secondIndex].acquire();
                                    Assert.assertTrue((String)(indexRule + ".0"), (boolean)DeadlockDetectionTest.this.getLockManager().isLockOwner());
                                    locks[secondIndex].release();
                                    locks[indexLock].release();
                                    manager.endRule(rules[indexRule]);
                                } else {
                                    locks[indexLock].acquire();
                                    manager.beginRule(rules[indexRule], null);
                                    locks[secondIndex].acquire();
                                    Assert.assertTrue((String)(indexLock + ".0"), (boolean)DeadlockDetectionTest.this.getLockManager().isLockOwner());
                                    locks[secondIndex].release();
                                    manager.endRule(rules[indexRule]);
                                    locks[indexLock].release();
                                }
                                monitor.worked(1);
                            }
                        }
                        catch (RuntimeException e) {
                            e.printStackTrace();
                            monitor.done();
                        }
                    }
                    finally {
                        monitor.done();
                    }
                    return Status.OK_STATUS;
                }
            };
            jobs[i22].schedule();
            ++i22;
        }
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException i22) {
            // empty catch block
        }
        status.set(0, 5);
        Job[] jobArray = jobs;
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            Job job = jobArray[n2];
            int j = 0;
            while (job.getState() != 0) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Assert.assertTrue((String)"Timeout waiting for jobs to finish.", (++j < 1000 ? 1 : 0) != 0);
            }
            ++n2;
        }
        int i = 0;
        while (i < jobs.length) {
            Assert.assertEquals((String)("10." + i), (long)0L, (long)jobs[i].getState());
            Assert.assertEquals((String)("10." + i), (Object)Status.OK_STATUS, (Object)jobs[i].getResult());
            ++i;
        }
        Assert.assertTrue((String)"Jobs not removed from graph.", (boolean)this.getLockManager().isEmpty());
    }

    public void _testJobRuleCancellation() {
        IdentityRule rule = new IdentityRule();
        final AtomicIntegerArray status = new AtomicIntegerArray(new int[1]);
        Job first = new Job("Test1"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    Assert.assertTrue((String)"1.0", (boolean)DeadlockDetectionTest.this.getLockManager().isLockOwner());
                    status.set(0, 1);
                    TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)0, (int)3);
                    monitor.worked(1);
                }
                finally {
                    monitor.done();
                    status.set(0, 5);
                }
                return Status.OK_STATUS;
            }
        };
        Job second = new Job("Test2"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    Assert.assertTrue((String)"2.0", (boolean)DeadlockDetectionTest.this.getLockManager().isLockOwner());
                    monitor.worked(1);
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        first.setRule((ISchedulingRule)rule);
        second.setRule((ISchedulingRule)rule);
        first.schedule();
        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)1);
        second.schedule();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        second.cancel();
        status.set(0, 3);
        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)5);
        this.waitForCompletion(first);
        Assert.assertTrue((String)"Canceled job not removed from graph.", (boolean)this.getLockManager().isEmpty());
    }

    public void _testLockMultipleAcquireThenSuspend() {
        final IdentityRule rule = new IdentityRule();
        final ILock lock = this.manager.newLock();
        final AtomicIntegerArray status = new AtomicIntegerArray(new int[2]);
        Job first = new Job("Test1"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    manager.beginRule(rule, null);
                    status.set(0, 2);
                    TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)0, (int)1);
                    lock.acquire();
                    lock.release();
                    manager.endRule(rule);
                    monitor.worked(1);
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        Job second = new Job("Test2"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    lock.acquire();
                    lock.acquire();
                    lock.acquire();
                    lock.acquire();
                    status.set(1, 2);
                    TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)1, (int)1);
                    manager.beginRule(rule, null);
                    manager.endRule(rule);
                    lock.release();
                    status.set(1, 2);
                    TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)1, (int)3);
                    lock.release();
                    lock.release();
                    lock.release();
                    monitor.worked(1);
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        first.schedule();
        second.schedule();
        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)0, (int)2);
        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)1, (int)2);
        status.set(0, 1);
        status.set(1, 1);
        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)1, (int)2);
        Assert.assertTrue((String)"Held lock removed from graph.", (!this.getLockManager().isEmpty() ? 1 : 0) != 0);
        status.set(1, 3);
        this.waitForCompletion(first);
        this.waitForCompletion(second);
        Assert.assertTrue((String)"Jobs not removed from graph.", (boolean)this.getLockManager().isEmpty());
    }

    private void start(ArrayList<RandomTestRunnable> allRunnables) {
        for (RandomTestRunnable r : allRunnables) {
            r.start();
        }
    }
}

