/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.runtime.jobs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.tests.runtime.jobs.JobWatcher;
import org.junit.Assert;
import org.junit.jupiter.api.Test;

public class GithubBug_193 {
    static final Object JOB_FAMILY1 = " family 1";
    static final Object JOB_FAMILY2 = " family 2";
    static final Object JOB_FAMILY3 = " family 3";

    @Test
    public void testDoneEventReceivedBeforeSchedule() throws Exception {
        int jobCount = 1000;
        JobWatcher watcher = JobWatcher.startWatchingFor(JOB_FAMILY1, JOB_FAMILY2, JOB_FAMILY3);
        List<Job> fewJobs = this.startFewJobs(jobCount);
        Assert.assertEquals((String)"Unexpected number of started jobs.", (long)jobCount, (long)fewJobs.size());
        watcher.waitUntilJobsAreDone();
        Assert.assertEquals((String)"There are still uncompleted jobs.", Collections.emptyList(), watcher.getJobsToWaitFor());
        Assert.assertEquals((String)"Unexpected number of scheduled jobs.", (long)jobCount, (long)watcher.getScheduled());
        Assert.assertEquals((String)"Unexpected number of done jobs.", (long)jobCount, (long)watcher.getDone());
    }

    private List<Job> startFewJobs(int jobCount) {
        ArrayList<Job> jobs = new ArrayList<Job>();
        int i = 0;
        while (i < jobCount) {
            int jobId = i++;
            MyJob job = new MyJob("job " + jobId, jobId);
            job.schedule();
            jobs.add(job);
        }
        return jobs;
    }

    private static Object getFamily(int jobId) {
        int id = jobId % 13;
        switch (id) {
            case 0: {
                return JOB_FAMILY3;
            }
        }
        return jobId % 2 == 0 ? JOB_FAMILY2 : JOB_FAMILY1;
    }

    private final class MyJob
    extends Job {
        private final int jobId;
        Object myFamily;

        private MyJob(String name, int jobId) {
            super(name + String.valueOf(GithubBug_193.getFamily(jobId)));
            this.jobId = jobId;
            this.myFamily = GithubBug_193.getFamily(jobId);
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                if (this.myFamily != JOB_FAMILY3) {
                    if (this.myFamily == JOB_FAMILY2 && this.jobId % 3 == 0) {
                        Job.getJobManager().join(JOB_FAMILY3, null);
                    } else {
                        Thread.sleep(0L, this.jobId % 10);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
        }

        public boolean belongsTo(Object family) {
            return this.myFamily == family || this == family;
        }

        public String toString() {
            return this.getName();
        }
    }
}

