/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.runtime.jobs;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.stream.Stream;
import junit.framework.AssertionFailedError;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectArrayAssert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.core.runtime.jobs.LockListener;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.core.tests.harness.FussyProgressMonitor;
import org.eclipse.core.tests.harness.TestBarrier2;
import org.eclipse.core.tests.harness.TestJob;
import org.eclipse.core.tests.runtime.jobs.AbstractJobTest;
import org.eclipse.core.tests.runtime.jobs.FamilyTestJob;
import org.eclipse.core.tests.runtime.jobs.IdentityRule;
import org.eclipse.core.tests.runtime.jobs.JobRuleRunner;
import org.eclipse.core.tests.runtime.jobs.PathRule;
import org.eclipse.core.tests.runtime.jobs.RepeatingJob;
import org.eclipse.core.tests.runtime.jobs.SimpleRuleRunner;
import org.eclipse.core.tests.runtime.jobs.TestJobFamily;
import org.eclipse.core.tests.runtime.jobs.TestLockListener;
import org.junit.Assert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class IJobManagerTest
extends AbstractJobTest {
    private static final boolean PEDANTIC = false;
    protected AtomicInteger completedJobs;
    private IJobChangeListener[] jobListeners;
    protected AtomicInteger scheduledJobs;

    public void assertState(String msg, Job job, int expectedState) {
        int actualState = job.getState();
        if (actualState != expectedState) {
            Assert.assertTrue((String)(msg + ": expected state: " + this.printState(expectedState) + " actual state: " + this.printState(actualState)), (boolean)false);
        }
    }

    protected void cancel(ArrayList<Job> jobs) {
        for (Job job : jobs) {
            job.cancel();
        }
    }

    private String printState(int state) {
        switch (state) {
            case 0: {
                return "NONE";
            }
            case 2: {
                return "WAITING";
            }
            case 1: {
                return "SLEEPING";
            }
            case 4: {
                return "RUNNING";
            }
        }
        return "UNKNOWN";
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.completedJobs = new AtomicInteger();
        this.scheduledJobs = new AtomicInteger();
        IJobChangeListener[] iJobChangeListenerArray = this.jobListeners = new IJobChangeListener[]{new TestJobListener()};
        int n = this.jobListeners.length;
        int n2 = 0;
        while (n2 < n) {
            IJobChangeListener jobListener = iJobChangeListenerArray[n2];
            this.manager.addJobChangeListener(jobListener);
            ++n2;
        }
    }

    @AfterEach
    public void tearDown() throws Exception {
        IJobChangeListener jobListener;
        IJobChangeListener[] iJobChangeListenerArray = this.jobListeners;
        int n = this.jobListeners.length;
        int n2 = 0;
        while (n2 < n) {
            jobListener = iJobChangeListenerArray[n2];
            if (jobListener instanceof TestJobListener) {
                ((TestJobListener)jobListener).cancelAllJobs();
            }
            ++n2;
        }
        this.waitForCompletion();
        iJobChangeListenerArray = this.jobListeners;
        n = this.jobListeners.length;
        n2 = 0;
        while (n2 < n) {
            jobListener = iJobChangeListenerArray[n2];
            this.manager.removeJobChangeListener(jobListener);
            ++n2;
        }
    }

    @Test
    public void testBadGlobalListener() {
        final AtomicIntegerArray status = new AtomicIntegerArray(new int[]{-1});
        Job job = new Job("testBadGlobalListener"){

            protected IStatus run(IProgressMonitor monitor) {
                status.set(0, 3);
                return Status.OK_STATUS;
            }
        };
        JobChangeAdapter listener = new JobChangeAdapter(){

            public void running(IJobChangeEvent event) {
                throw new Error("Thrown from bad global listener");
            }
        };
        try {
            Job.getJobManager().addJobChangeListener((IJobChangeListener)listener);
            job.schedule();
            TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)3);
        }
        finally {
            Job.getJobManager().removeJobChangeListener((IJobChangeListener)listener);
        }
    }

    @Test
    public void testBadLocalListener() {
        final AtomicIntegerArray status = new AtomicIntegerArray(new int[]{-1});
        Job job = new Job("testBadLocalListener"){

            protected IStatus run(IProgressMonitor monitor) {
                status.set(0, 3);
                return Status.OK_STATUS;
            }
        };
        JobChangeAdapter listener = new JobChangeAdapter(){

            public void running(IJobChangeEvent event) {
                throw new Error("Thrown from bad local listener");
            }
        };
        try {
            job.addJobChangeListener((IJobChangeListener)listener);
            job.schedule();
            TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)3);
        }
        finally {
            job.removeJobChangeListener((IJobChangeListener)listener);
        }
    }

    @Test
    public void testBeginInvalidNestedRules() {
        final PathRule root = new PathRule("/");
        ISchedulingRule invalid = new ISchedulingRule(){

            public boolean isConflicting(ISchedulingRule rule) {
                return this == rule;
            }

            public boolean contains(ISchedulingRule rule) {
                return this == rule || root.contains(rule);
            }
        };
        try {
            Job.getJobManager().beginRule(invalid, null);
            Assert.assertThrows(IllegalArgumentException.class, () -> Job.getJobManager().beginRule(root, null));
            Job.getJobManager().endRule((ISchedulingRule)root);
        }
        finally {
            Job.getJobManager().endRule(invalid);
        }
    }

    @Test
    public void testCancellationPriorToBeginRuleWontHoldRule() throws Exception {
        boolean canceledExceptionThrown;
        Semaphore lockSemaphore;
        block5: {
            Semaphore mainThreadSemaphore = new Semaphore(0);
            lockSemaphore = new Semaphore(0);
            PathRule rule = new PathRule("testBeginRuleNoEnd");
            SubMonitor cancelledMonitor = SubMonitor.convert(null);
            cancelledMonitor.setCanceled(true);
            Job job = Job.create((String)"", monitor -> {
                mainThreadSemaphore.release();
                try {
                    lockSemaphore.acquire();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            });
            job.setRule((ISchedulingRule)rule);
            job.schedule();
            mainThreadSemaphore.acquire();
            canceledExceptionThrown = false;
            try {
                try {
                    this.manager.beginRule((ISchedulingRule)rule, (IProgressMonitor)cancelledMonitor);
                }
                catch (OperationCanceledException e) {
                    canceledExceptionThrown = true;
                    this.manager.endRule((ISchedulingRule)rule);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                this.manager.endRule((ISchedulingRule)rule);
                throw throwable;
            }
            this.manager.endRule((ISchedulingRule)rule);
        }
        lockSemaphore.release();
        boolean interrupted = Thread.interrupted();
        Assert.assertTrue((String)"An OperationCancelledException should have been thrown", (boolean)canceledExceptionThrown);
        Assert.assertFalse((String)"The Thread.interrupted() state leaked", (boolean)interrupted);
    }

    @Test
    public void testCancellationWhileWaitingOnRule() throws Exception {
        boolean canceledExceptionThrown;
        Semaphore lockSemaphore;
        block5: {
            Semaphore mainThreadSemaphore = new Semaphore(0);
            lockSemaphore = new Semaphore(0);
            PathRule rule = new PathRule("testBeginRuleNoEnd");
            NullProgressMonitor rootMonitor = new NullProgressMonitor();
            SubMonitor nestedMonitor = SubMonitor.convert((IProgressMonitor)rootMonitor);
            nestedMonitor.setCanceled(false);
            Job job = Job.create((String)"", monitor -> {
                mainThreadSemaphore.release();
                try {
                    lockSemaphore.acquire();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            });
            job.setRule((ISchedulingRule)rule);
            job.schedule();
            mainThreadSemaphore.acquire();
            Job cancellationJob = Job.create((String)"", monitor -> rootMonitor.setCanceled(true));
            cancellationJob.schedule(100L);
            canceledExceptionThrown = false;
            try {
                try {
                    this.manager.beginRule((ISchedulingRule)rule, (IProgressMonitor)nestedMonitor);
                }
                catch (OperationCanceledException e) {
                    canceledExceptionThrown = true;
                    this.manager.endRule((ISchedulingRule)rule);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                this.manager.endRule((ISchedulingRule)rule);
                throw throwable;
            }
            this.manager.endRule((ISchedulingRule)rule);
        }
        lockSemaphore.release();
        boolean interrupted = Thread.interrupted();
        Assert.assertTrue((String)"An OperationCancelledException should have been thrown", (boolean)canceledExceptionThrown);
        Assert.assertFalse((String)"The THread.interrupted() state leaked", (boolean)interrupted);
    }

    @Test
    public void testBeginRuleNoEnd() throws InterruptedException {
        final PathRule rule = new PathRule("testBeginRuleNoEnd");
        Job job = new Job("testBeginRuleNoEnd"){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(this.getName(), 1);
                try {
                    Job.getJobManager().beginRule((ISchedulingRule)rule, null);
                    monitor.worked(1);
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        job.join();
        try {
            this.manager.beginRule((ISchedulingRule)rule, null);
        }
        finally {
            this.manager.endRule((ISchedulingRule)rule);
        }
    }

    @Test
    public void testBug48073() {
        PathRule ruleA = new PathRule("/testBug48073");
        PathRule ruleB = new PathRule("/testBug48073/B");
        PathRule ruleC = new PathRule("/testBug48073/C");
        TestJob jobA = new TestJob("Job1", 1000, 100L);
        TestJob jobB = new TestJob("Job2", 1000, 100L);
        TestJob jobC = new TestJob("Job3", 1000, 100L);
        jobA.setRule((ISchedulingRule)ruleA);
        jobB.setRule((ISchedulingRule)ruleB);
        jobC.setRule((ISchedulingRule)ruleC);
        jobB.schedule();
        this.sleep(100L);
        jobA.schedule();
        this.sleep(100L);
        jobC.schedule();
        jobA.cancel();
        jobA.schedule();
        jobA.cancel();
        jobC.cancel();
        jobB.cancel();
    }

    @Test
    public void testBug57656() {
        TestJob jobA = new TestJob("Job1", 10000, 10L);
        TestJob jobB = new TestJob("Job2", 1, 1L);
        jobA.schedule(100L);
        jobB.schedule(101L);
        jobA.sleep();
        this.waitForCompletion((Job)jobB, Duration.ofSeconds(1L));
        jobA.terminate();
        jobA.cancel();
        this.waitForCompletion((Job)jobA, Duration.ofSeconds(5L));
    }

    @Test
    public void testCurrentJob() {
        final Thread[] thread = new Thread[1];
        final boolean[] done = new boolean[1];
        boolean[] success = new boolean[1];
        Job job = new Job("Test Job"){

            protected IStatus run(IProgressMonitor monitor) {
                this.setThread(thread[0]);
                done[0] = true;
                return ASYNC_FINISH;
            }
        };
        Runnable r = () -> {
            job.schedule();
            while (!done[0]) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            blArray2[0] = job == Job.getJobManager().currentJob();
            job.done(Status.OK_STATUS);
        };
        thread[0] = new Thread(r);
        thread[0].start();
        try {
            thread[0].join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertTrue((String)"1.0", (boolean)success[0]);
    }

    @Test
    public void testCurrentRule() {
        this.runRuleSequence();
        final ArrayList errors = new ArrayList();
        Job sequenceJob = new Job("testCurrentRule"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    IJobManagerTest.this.runRuleSequence();
                }
                catch (AssertionFailedError e) {
                    errors.add(e);
                }
                return Status.OK_STATUS;
            }
        };
        sequenceJob.schedule();
        this.waitForCompletion(sequenceJob);
        if (!errors.isEmpty()) {
            throw (AssertionFailedError)((Object)errors.iterator().next());
        }
        PathRule jobRule = new PathRule("/testCurrentRule");
        sequenceJob.setRule((ISchedulingRule)jobRule);
        sequenceJob.schedule();
        this.waitForCompletion(sequenceJob);
        if (!errors.isEmpty()) {
            throw (AssertionFailedError)((Object)errors.iterator().next());
        }
    }

    protected void runRuleSequence() {
        if (this.runRuleSequenceInJobWithRule()) {
            return;
        }
        PathRule parent = new PathRule("/testCurrentRule/parent");
        PathRule child = new PathRule("/testCurrentRule/parent/child");
        Assert.assertNull((Object)this.manager.currentRule());
        this.manager.beginRule(null, null);
        Assert.assertNull((Object)this.manager.currentRule());
        this.manager.endRule(null);
        Assert.assertNull((Object)this.manager.currentRule());
        this.manager.beginRule((ISchedulingRule)parent, null);
        Assert.assertEquals((Object)parent, (Object)this.manager.currentRule());
        this.manager.beginRule(null, null);
        Assert.assertEquals((Object)parent, (Object)this.manager.currentRule());
        this.manager.beginRule((ISchedulingRule)child, null);
        Assert.assertEquals((Object)parent, (Object)this.manager.currentRule());
        this.manager.endRule((ISchedulingRule)child);
        Assert.assertEquals((Object)parent, (Object)this.manager.currentRule());
        this.manager.endRule(null);
        Assert.assertEquals((Object)parent, (Object)this.manager.currentRule());
        this.manager.endRule((ISchedulingRule)parent);
        Assert.assertNull((Object)this.manager.currentRule());
    }

    private boolean runRuleSequenceInJobWithRule() {
        Job currentJob = this.manager.currentJob();
        if (currentJob == null) {
            return false;
        }
        ISchedulingRule jobRule = currentJob.getRule();
        if (jobRule == null) {
            return false;
        }
        PathRule parent = new PathRule("/testCurrentRule/parent");
        PathRule child = new PathRule("/testCurrentRule/parent/child");
        Assert.assertEquals((Object)jobRule, (Object)this.manager.currentRule());
        this.manager.beginRule(null, null);
        Assert.assertEquals((Object)jobRule, (Object)this.manager.currentRule());
        this.manager.endRule(null);
        Assert.assertEquals((Object)jobRule, (Object)this.manager.currentRule());
        this.manager.beginRule((ISchedulingRule)parent, null);
        Assert.assertEquals((Object)jobRule, (Object)this.manager.currentRule());
        this.manager.beginRule(null, null);
        Assert.assertEquals((Object)jobRule, (Object)this.manager.currentRule());
        this.manager.beginRule((ISchedulingRule)child, null);
        Assert.assertEquals((Object)jobRule, (Object)this.manager.currentRule());
        this.manager.endRule((ISchedulingRule)child);
        Assert.assertEquals((Object)jobRule, (Object)this.manager.currentRule());
        this.manager.endRule(null);
        Assert.assertEquals((Object)jobRule, (Object)this.manager.currentRule());
        this.manager.endRule((ISchedulingRule)parent);
        Assert.assertEquals((Object)jobRule, (Object)this.manager.currentRule());
        return true;
    }

    @Test
    public void testDelayedJob() {
        int[] nArray = new int[8];
        nArray[1] = 1;
        nArray[2] = 5;
        nArray[3] = 10;
        nArray[4] = 50;
        nArray[5] = 100;
        nArray[6] = 200;
        nArray[7] = 250;
        int[] sleepTimes = nArray;
        int i = 0;
        while (i < sleepTimes.length) {
            long start = IJobManagerTest.now();
            TestJob job = new TestJob("Noop", 0, 0L);
            Assert.assertEquals((String)"1.0", (long)0L, (long)job.getRunCount());
            job.schedule((long)sleepTimes[i]);
            this.waitForCompletion();
            Assert.assertEquals((String)("1.1." + i), (long)1L, (long)job.getRunCount());
            long duration = IJobManagerTest.now() - start;
            Assert.assertTrue((String)("1.2: duration: " + duration + " sleep: " + sleepTimes[i]), (duration >= (long)sleepTimes[i] ? 1 : 0) != 0);
            ++i;
        }
    }

    @Test
    public void testJobFamilyCancel() {
        int NUM_JOBS = 20;
        TestJob[] jobs = new TestJob[20];
        TestJobFamily first = new TestJobFamily(1);
        TestJobFamily second = new TestJobFamily(2);
        IdentityRule rule = new IdentityRule();
        int i = 0;
        while (i < 20) {
            jobs[i] = i % 2 == 0 ? new FamilyTestJob("TestFirstFamily", 1000000, 10, 1) : new FamilyTestJob("TestSecondFamily", 1000000, 10, 2);
            jobs[i].setRule((ISchedulingRule)rule);
            jobs[i].schedule();
            ++i;
        }
        this.waitForStart(jobs[0]);
        this.assertState("1.0", (Job)jobs[0], 4);
        i = 1;
        while (i < 20) {
            this.assertState("1." + i, (Job)jobs[i], 2);
            ++i;
        }
        this.manager.cancel((Object)first);
        this.waitForFamilyCancel((Job[])jobs, first);
        this.assertState("2.0", (Job)jobs[0], 0);
        this.waitForStart(jobs[1]);
        i = 2;
        while (i < 20) {
            if (jobs[i].belongsTo((Object)first)) {
                this.assertState("2." + i, (Job)jobs[i], 0);
                jobs[i].wakeUp();
                this.assertState("2." + i, (Job)jobs[i], 0);
                jobs[i].sleep();
                this.assertState("2." + i, (Job)jobs[i], 0);
            } else {
                this.assertState("3." + i, (Job)jobs[i], 2);
            }
            ++i;
        }
        i = 2;
        while (i < 20) {
            if (jobs[i].belongsTo((Object)second)) {
                this.assertState("4." + i, (Job)jobs[i], 2);
                Assert.assertTrue((String)("5." + i), (boolean)jobs[i].sleep());
                this.assertState("6." + i, (Job)jobs[i], 1);
            }
            ++i;
        }
        this.manager.cancel((Object)second);
        this.waitForFamilyCancel((Job[])jobs, second);
        this.assertState("7.0", (Job)jobs[1], 0);
        i = 0;
        while (i < 20) {
            this.assertState("8." + i, (Job)jobs[i], 0);
            ++i;
        }
    }

    @Test
    public void testJobFamilyFind() {
        int NUM_JOBS = 20;
        TestJob[] jobs = new TestJob[20];
        TestJobFamily first = new TestJobFamily(1);
        TestJobFamily second = new TestJobFamily(2);
        TestJobFamily third = new TestJobFamily(3);
        TestJobFamily fourth = new TestJobFamily(4);
        TestJobFamily fifth = new TestJobFamily(5);
        IdentityRule rule = new IdentityRule();
        int i = 0;
        while (i < 20) {
            switch (i % 5) {
                case 0: {
                    jobs[i] = new FamilyTestJob("TestFirstFamily", 1000000, 10, 1);
                    break;
                }
                case 1: {
                    jobs[i] = new FamilyTestJob("TestSecondFamily", 1000000, 10, 2);
                    break;
                }
                case 2: {
                    jobs[i] = new FamilyTestJob("TestThirdFamily", 1000000, 10, 3);
                    break;
                }
                case 3: {
                    jobs[i] = new FamilyTestJob("TestFourthFamily", 1000000, 10, 4);
                    break;
                }
                default: {
                    jobs[i] = new FamilyTestJob("TestFifthFamily", 1000000, 10, 5);
                }
            }
            jobs[i].setRule((ISchedulingRule)rule);
            jobs[i].schedule();
            ++i;
        }
        this.waitForStart(jobs[0]);
        HashSet<TestJob> allJobs = new HashSet<TestJob>(Arrays.asList(jobs));
        ((ObjectArrayAssert)((ObjectArrayAssert)Assertions.assertThat((Object[])this.manager.find(null)).hasSizeGreaterThanOrEqualTo(20)).filteredOn(job -> allJobs.remove(job))).allMatch(job -> job.belongsTo((Object)first) || job.belongsTo((Object)second) || job.belongsTo((Object)third) || job.belongsTo((Object)fourth) || job.belongsTo((Object)fifth));
        Assertions.assertThat(allJobs).isEmpty();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])this.manager.find((Object)first)).hasSize(4)).allMatch(it -> it.belongsTo((Object)first));
        ((ObjectArrayAssert)Assertions.assertThat((Object[])this.manager.find((Object)second)).hasSize(4)).allMatch(it -> it.belongsTo((Object)second));
        ((ObjectArrayAssert)Assertions.assertThat((Object[])this.manager.find((Object)third)).hasSize(4)).allMatch(it -> it.belongsTo((Object)third));
        ((ObjectArrayAssert)Assertions.assertThat((Object[])this.manager.find((Object)fourth)).hasSize(4)).allMatch(it -> it.belongsTo((Object)fourth));
        ((ObjectArrayAssert)Assertions.assertThat((Object[])this.manager.find((Object)fifth)).hasSize(4)).allMatch(it -> it.belongsTo((Object)fifth));
        this.assertState("7.0", (Job)jobs[0], 4);
        this.manager.sleep((Object)second);
        this.manager.cancel((Object)first);
        this.waitForStart(jobs[2]);
        this.assertState("7.1", (Job)jobs[2], 4);
        Assertions.assertThat((Object[])this.manager.find((Object)first)).isEmpty();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])this.manager.find((Object)second)).hasSize(4)).allMatch(it -> it.belongsTo((Object)second));
        this.manager.cancel((Object)second);
        Assertions.assertThat((Object[])this.manager.find((Object)second)).isEmpty();
        this.manager.cancel((Object)fourth);
        Assertions.assertThat((Object[])this.manager.find((Object)fourth)).isEmpty();
        this.manager.sleep((Object)third);
        this.assertState("9.2", (Job)jobs[2], 4);
        jobs[17].wakeUp();
        this.assertState("9.3", (Job)jobs[17], 2);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])this.manager.find((Object)third)).hasSize(4)).allMatch(it -> it.belongsTo((Object)third));
        allJobs.addAll(Arrays.asList(jobs));
        ((ObjectArrayAssert)((ObjectArrayAssert)Assertions.assertThat((Object[])this.manager.find(null)).hasSizeGreaterThanOrEqualTo(8)).filteredOn(job -> allJobs.remove(job))).allMatch(job -> job.belongsTo((Object)third) || job.belongsTo((Object)fifth));
        Assertions.assertThat(allJobs).hasSize(12);
        allJobs.clear();
        this.manager.cancel((Object)fifth);
        this.manager.cancel((Object)third);
        this.waitForFamilyCancel((Job[])jobs, third);
        int i2 = 0;
        while (i2 < 20) {
            this.assertState("12." + i2, (Job)jobs[i2], 0);
            ++i2;
        }
        allJobs.addAll(Arrays.asList(jobs));
        Assertions.assertThat((Object[])this.manager.find(null)).hasSizeGreaterThanOrEqualTo(0);
        Assertions.assertThat((Object[])this.manager.find(null)).allMatch(job -> !allJobs.remove(job));
        Assertions.assertThat(allJobs).hasSize(20);
        allJobs.clear();
    }

    @Test
    public void testJobFamilyJoin() {
        AtomicIntegerArray status = new AtomicIntegerArray(new int[1]);
        status.set(0, 0);
        int NUM_JOBS = 20;
        Job[] jobs = new Job[20];
        TestJobFamily first = new TestJobFamily(1);
        TestJobFamily second = new TestJobFamily(2);
        IdentityRule rule1 = new IdentityRule();
        IdentityRule rule2 = new IdentityRule();
        int i = 0;
        while (i < 20) {
            if (i % 2 == 0) {
                jobs[i] = new FamilyTestJob("TestFirstFamily", 10, 1, 1);
                jobs[i].setRule((ISchedulingRule)rule1);
                jobs[i].schedule(1000000L);
            } else {
                jobs[i] = new FamilyTestJob("TestSecondFamily", 1000000, 1, 2);
                jobs[i].setRule((ISchedulingRule)rule2);
                jobs[i].schedule();
            }
            ++i;
        }
        Thread t = new Thread(() -> {
            status.set(0, 1);
            try {
                TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)0, (int)2);
                status.set(0, 3);
                this.manager.join((Object)first, null);
            }
            catch (InterruptedException | OperationCanceledException throwable) {
                // empty catch block
            }
            status.set(0, 5);
        });
        t.start();
        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)0, (int)1);
        status.set(0, 2);
        this.manager.wakeUp((Object)first);
        int i2 = 0;
        while (i2 < 10000) {
            int currentStatus = status.get(0);
            Object[] result = this.manager.find((Object)first);
            if (currentStatus == 5) {
                ((ObjectArrayAssert)Assertions.assertThat((Object[])result).as("failed in iteration " + i2, new Object[0])).isEmpty();
                break;
            }
            this.sleep(1L);
            ++i2;
        }
        ((AbstractIntegerAssert)Assertions.assertThat((int)i2).withFailMessage("did not timeout", new Object[0])).isLessThan(10000);
        this.manager.cancel((Object)second);
        this.waitForFamilyCancel(jobs, second);
        int j = 0;
        while (j < 20) {
            this.assertState("3." + j, jobs[j], 0);
            ++j;
        }
    }

    @Test
    public void testJobFamilyJoinCancelJobs() {
        AtomicIntegerArray status = new AtomicIntegerArray(new int[1]);
        status.set(0, 0);
        int NUM_JOBS = 20;
        TestJob[] jobs = new TestJob[20];
        TestJobFamily first = new TestJobFamily(1);
        TestJobFamily second = new TestJobFamily(2);
        IdentityRule rule1 = new IdentityRule();
        IdentityRule rule2 = new IdentityRule();
        int i = 0;
        while (i < 20) {
            if (i % 2 == 0) {
                jobs[i] = new FamilyTestJob("TestFirstFamily", 1000000, 10, 1);
                jobs[i].setRule((ISchedulingRule)rule1);
            } else {
                jobs[i] = new FamilyTestJob("TestSecondFamily", 1000000, 10, 2);
                jobs[i].setRule((ISchedulingRule)rule2);
            }
            jobs[i].schedule();
            ++i;
        }
        Thread t = new Thread(() -> {
            status.set(0, 1);
            try {
                TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)0, (int)2);
                status.set(0, 3);
                this.manager.join((Object)first, null);
            }
            catch (InterruptedException | OperationCanceledException throwable) {
                // empty catch block
            }
            status.set(0, 5);
        });
        t.start();
        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)0, (int)1);
        status.set(0, 2);
        this.waitForStart(jobs[0]);
        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)0, (int)3);
        this.assertState("2.0", (Job)jobs[0], 4);
        Assert.assertEquals((String)"2.1", (long)3L, (long)status.get(0));
        this.manager.cancel((Object)first);
        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)0, (int)5);
        Assertions.assertThat((Object[])this.manager.find((Object)first)).isEmpty();
        this.manager.cancel((Object)second);
        this.waitForFamilyCancel((Job[])jobs, second);
        int j = 0;
        while (j < 20) {
            this.assertState("3." + j, (Job)jobs[j], 0);
            ++j;
        }
    }

    @Test
    public void testJobFamilyJoinCancelManager() {
        AtomicIntegerArray status = new AtomicIntegerArray(new int[1]);
        status.set(0, 0);
        int NUM_JOBS = 20;
        TestJob[] jobs = new TestJob[20];
        FussyProgressMonitor canceller = new FussyProgressMonitor();
        TestJobFamily first = new TestJobFamily(1);
        TestJobFamily second = new TestJobFamily(2);
        IdentityRule rule1 = new IdentityRule();
        IdentityRule rule2 = new IdentityRule();
        int i = 0;
        while (i < 20) {
            if (i % 2 == 0) {
                jobs[i] = new FamilyTestJob("TestFirstFamily", 1000000, 10, 1);
                jobs[i].setRule((ISchedulingRule)rule1);
            } else {
                jobs[i] = new FamilyTestJob("TestSecondFamily", 1000000, 10, 2);
                jobs[i].setRule((ISchedulingRule)rule2);
            }
            jobs[i].schedule();
            ++i;
        }
        Thread t = new Thread(() -> this.lambda$19(status, first, (IProgressMonitor)canceller));
        t.start();
        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)0, (int)1);
        status.set(0, 2);
        this.waitForStart(jobs[0]);
        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)0, (int)3);
        this.assertState("2.0", (Job)jobs[0], 4);
        Assert.assertEquals((String)"2.1", (long)3L, (long)status.get(0));
        canceller.setCanceled(true);
        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)0, (int)5);
        this.assertState("2.2", (Job)jobs[0], 4);
        Assert.assertEquals((String)"2.3", (long)5L, (long)status.get(0));
        Assertions.assertThat((Object[])this.manager.find((Object)first)).isNotEmpty();
        this.manager.cancel((Object)second);
        this.waitForFamilyCancel((Job[])jobs, second);
        this.manager.cancel((Object)first);
        this.waitForFamilyCancel((Job[])jobs, first);
        int j = 0;
        while (j < 20) {
            this.assertState("3." + j, (Job)jobs[j], 0);
            ++j;
        }
    }

    @Test
    public void testJobFamilyJoinLockListener() throws OperationCanceledException, InterruptedException {
        TestJobFamily family = new TestJobFamily(1);
        int count = 5;
        TestJob[] jobs = new TestJob[count];
        int i = 0;
        while (i < jobs.length) {
            jobs[i] = new FamilyTestJob("TestJobFamilyJoinLockListener" + i, 100000, 10, family.getType());
            jobs[i].schedule();
            ++i;
        }
        TestLockListener lockListener = new TestLockListener(() -> Stream.of(jobs).forEach(TestJob::terminate));
        try {
            this.manager.setLockListener((LockListener)lockListener);
            this.manager.join((Object)family, (IProgressMonitor)new FussyProgressMonitor());
        }
        finally {
            this.manager.setLockListener(null);
        }
        lockListener.assertHasBeenWaiting("JobManager has not been waiting for lock");
        lockListener.assertNotWaiting("JobManager has not finished waiting for lock");
    }

    @Test
    public void testJobFamilyJoinNothing() throws OperationCanceledException, InterruptedException {
        FussyProgressMonitor monitor = new FussyProgressMonitor();
        monitor.prepare();
        this.manager.join(new Object(), (IProgressMonitor)monitor);
        monitor.sanityCheck();
        monitor.assertUsedUp();
    }

    @Test
    public void testJobFamilyJoinRepeating() throws OperationCanceledException, InterruptedException {
        Object family = new Object();
        int count = 25;
        RepeatingJob job = new RepeatingJob("testJobFamilyJoinRepeating", count);
        job.setFamily(family);
        job.schedule();
        Job.getJobManager().join(family, null);
        Assert.assertEquals((String)"1.2", (long)count, (long)job.getRunCount());
    }

    @Test
    public void testJobFamilyJoinShouldSchedule() throws OperationCanceledException, InterruptedException {
        Object family = new Object();
        boolean count = true;
        RepeatingJob job = new RepeatingJob("testJobFamilyJoinShouldSchedule", 1){

            public boolean shouldSchedule() {
                return this.shouldRun();
            }
        };
        job.setFamily(family);
        job.schedule();
        Job.getJobManager().join(family, null);
        Assert.assertEquals((String)"1.2", (long)1L, (long)job.getRunCount());
    }

    @Test
    public void testJobFamilyJoinSimple() {
        AtomicIntegerArray status = new AtomicIntegerArray(new int[1]);
        status.set(0, 0);
        int NUM_JOBS = 20;
        TestJob[] jobs = new TestJob[20];
        TestJobFamily first = new TestJobFamily(1);
        TestJobFamily second = new TestJobFamily(2);
        TestJobFamily third = new TestJobFamily(3);
        IdentityRule rule1 = new IdentityRule();
        IdentityRule rule2 = new IdentityRule();
        int i = 0;
        while (i < 20) {
            if (i % 2 == 0) {
                jobs[i] = new FamilyTestJob("TestFirstFamily", 1000000, 10, 1);
                jobs[i].setRule((ISchedulingRule)rule1);
            } else {
                jobs[i] = new FamilyTestJob("TestSecondFamily", 1000000, 10, 2);
                jobs[i].setRule((ISchedulingRule)rule2);
            }
            jobs[i].schedule();
            ++i;
        }
        Thread t = new Thread(() -> {
            status.set(0, 1);
            try {
                TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)0, (int)2);
                status.set(0, 3);
                this.manager.join((Object)third, null);
            }
            catch (InterruptedException | OperationCanceledException throwable) {
                // empty catch block
            }
            status.set(0, 5);
        });
        this.waitForStart(jobs[0]);
        t.start();
        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)0, (int)1);
        Assert.assertEquals((String)"1.0", (long)1L, (long)status.get(0));
        long startTime = IJobManagerTest.now();
        status.set(0, 2);
        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)0, (int)5);
        long endTime = IJobManagerTest.now();
        Assert.assertEquals((String)"2.0", (long)5L, (long)status.get(0));
        Assert.assertTrue((String)"2.1", (endTime >= startTime ? 1 : 0) != 0);
        this.manager.cancel((Object)first);
        this.manager.cancel((Object)second);
        this.waitForFamilyCancel((Job[])jobs, first);
        this.waitForFamilyCancel((Job[])jobs, second);
        int j = 0;
        while (j < 20) {
            this.assertState("3." + j, (Job)jobs[j], 0);
            ++j;
        }
    }

    @Test
    public void testJobFamilyJoinWhenSuspended_1() throws InterruptedException {
        TestJobFamily family = new TestJobFamily(1);
        int[] familyJobsCount = new int[]{-1};
        final TestBarrier2 barrier = new TestBarrier2();
        FamilyTestJob waiting = new FamilyTestJob("waiting job", 1000000, 10, 1);
        final FamilyTestJob running = new FamilyTestJob("running job", 1000000, 10, 1);
        JobChangeAdapter listener = new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getJob() == running) {
                    barrier.waitForStatus(4);
                }
            }

            public void running(IJobChangeEvent event) {
                if (event.getJob() == running) {
                    barrier.setStatus(3);
                }
            }
        };
        Job job = new Job("main job", (IJobChangeListener)listener, running, waiting, barrier, family, familyJobsCount){
            private final /* synthetic */ IJobChangeListener val$listener;
            private final /* synthetic */ TestJob val$running;
            private final /* synthetic */ TestJob val$waiting;
            private final /* synthetic */ TestBarrier2 val$barrier;
            private final /* synthetic */ Object val$family;
            private final /* synthetic */ int[] val$familyJobsCount;
            {
                this.val$listener = iJobChangeListener;
                this.val$running = testJob;
                this.val$waiting = testJob2;
                this.val$barrier = testBarrier2;
                this.val$family = object;
                this.val$familyJobsCount = nArray;
                super($anonymous0);
            }

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    try {
                        manager.addJobChangeListener(this.val$listener);
                        this.val$running.schedule();
                        this.val$barrier.waitForStatus(3);
                        manager.setLockListener(new LockListener(){
                            private final boolean scheduled = false;

                            public boolean aboutToWait(Thread lockOwner) {
                                val$running.terminate();
                                val$waiting.schedule();
                                val$barrier.setStatus(4);
                                return super.aboutToWait(lockOwner);
                            }
                        });
                        manager.suspend();
                        manager.join(this.val$family, null);
                        this.val$familyJobsCount[0] = manager.find(this.val$family).length;
                        this.val$barrier.setStatus(5);
                    }
                    catch (InterruptedException interruptedException) {
                        manager.removeJobChangeListener(this.val$listener);
                        manager.setLockListener(null);
                        this.val$running.cancel();
                        this.val$waiting.cancel();
                        try {
                            this.val$running.join();
                            this.val$waiting.join();
                        }
                        catch (InterruptedException interruptedException2) {
                            // empty catch block
                        }
                        manager.resume();
                    }
                }
                finally {
                    manager.removeJobChangeListener(this.val$listener);
                    manager.setLockListener(null);
                    this.val$running.cancel();
                    this.val$waiting.cancel();
                    try {
                        this.val$running.join();
                        this.val$waiting.join();
                    }
                    catch (InterruptedException interruptedException) {}
                    manager.resume();
                }
                return Status.OK_STATUS;
            }
        };
        try {
            try {
                job.schedule();
                barrier.waitForStatus(5);
                Assert.assertEquals((long)1L, (long)familyJobsCount[0]);
            }
            catch (AssertionFailedError e) {
                Thread thread = job.getThread();
                if (thread != null) {
                    thread.interrupt();
                }
                throw e;
            }
        }
        finally {
            job.join();
        }
    }

    @Test
    public void testJobFamilyJoinWhenSuspended_2() throws InterruptedException {
        TestJobFamily family = new TestJobFamily(1);
        int[] familyJobsCount = new int[]{-1};
        final TestBarrier2 barrier = new TestBarrier2();
        FamilyTestJob waiting = new FamilyTestJob("waiting job", 1000000, 10, 1);
        final FamilyTestJob running = new FamilyTestJob("running job", 1000000, 10, 1);
        JobChangeAdapter listener = new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getJob() == running) {
                    barrier.waitForStatus(4);
                }
            }

            public void running(IJobChangeEvent event) {
                if (event.getJob() == running) {
                    barrier.setStatus(3);
                }
            }
        };
        Job job = new Job("main job", (IJobChangeListener)listener, running, waiting, barrier, family, familyJobsCount){
            private final /* synthetic */ IJobChangeListener val$listener;
            private final /* synthetic */ TestJob val$running;
            private final /* synthetic */ TestJob val$waiting;
            private final /* synthetic */ TestBarrier2 val$barrier;
            private final /* synthetic */ Object val$family;
            private final /* synthetic */ int[] val$familyJobsCount;
            {
                this.val$listener = iJobChangeListener;
                this.val$running = testJob;
                this.val$waiting = testJob2;
                this.val$barrier = testBarrier2;
                this.val$family = object;
                this.val$familyJobsCount = nArray;
                super($anonymous0);
            }

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    try {
                        manager.addJobChangeListener(this.val$listener);
                        this.val$running.schedule();
                        this.val$barrier.waitForStatus(3);
                        manager.setLockListener(new LockListener(){
                            private final boolean scheduled = false;

                            public boolean aboutToWait(Thread lockOwner) {
                                13.getJobManager().suspend();
                                val$running.terminate();
                                val$waiting.schedule();
                                val$barrier.setStatus(4);
                                return super.aboutToWait(lockOwner);
                            }
                        });
                        manager.join(this.val$family, null);
                        this.val$familyJobsCount[0] = manager.find(this.val$family).length;
                        this.val$barrier.setStatus(5);
                    }
                    catch (InterruptedException interruptedException) {
                        manager.removeJobChangeListener(this.val$listener);
                        manager.setLockListener(null);
                        this.val$running.cancel();
                        this.val$waiting.cancel();
                        try {
                            this.val$running.join();
                            this.val$waiting.join();
                        }
                        catch (InterruptedException interruptedException2) {
                            // empty catch block
                        }
                        manager.resume();
                    }
                }
                finally {
                    manager.removeJobChangeListener(this.val$listener);
                    manager.setLockListener(null);
                    this.val$running.cancel();
                    this.val$waiting.cancel();
                    try {
                        this.val$running.join();
                        this.val$waiting.join();
                    }
                    catch (InterruptedException interruptedException) {}
                    manager.resume();
                }
                return Status.OK_STATUS;
            }
        };
        try {
            try {
                job.schedule();
                barrier.waitForStatus(5);
                Assert.assertEquals((long)1L, (long)familyJobsCount[0]);
            }
            catch (AssertionFailedError e) {
                Thread thread = job.getThread();
                if (thread != null) {
                    thread.interrupt();
                }
                throw e;
            }
        }
        finally {
            job.join();
        }
    }

    @Test
    public void testJobFamilyJoinWhenSuspended_3() throws InterruptedException {
        TestJobFamily family = new TestJobFamily(1);
        final TestBarrier2 barrier = new TestBarrier2();
        final FamilyTestJob waiting = new FamilyTestJob("waiting job", 1000000, 10, 1);
        final FamilyTestJob running = new FamilyTestJob("running job", 1000000, 10, 1);
        JobChangeAdapter listener = new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getJob() == running) {
                    barrier.waitForStatus(4);
                }
            }

            public void running(IJobChangeEvent event) {
                if (event.getJob() == running) {
                    barrier.setStatus(3);
                } else if (event.getJob() == waiting) {
                    barrier.setStatus(4);
                }
            }
        };
        try {
            this.manager.addJobChangeListener((IJobChangeListener)listener);
            running.schedule();
            barrier.waitForStatus(3);
            this.manager.setLockListener(new LockListener(){
                private boolean scheduled = false;

                public boolean aboutToWait(Thread lockOwner) {
                    if (!this.scheduled) {
                        IJobManagerTest.this.manager.suspend();
                        waiting.schedule();
                        IJobManagerTest.this.manager.resume();
                        running.terminate();
                        waiting.terminate();
                        this.scheduled = true;
                    }
                    return super.aboutToWait(lockOwner);
                }
            });
            this.manager.join((Object)family, null);
            Assertions.assertThat((Object[])this.manager.find((Object)family)).isEmpty();
        }
        finally {
            this.manager.removeJobChangeListener((IJobChangeListener)listener);
            this.manager.setLockListener(null);
            running.cancel();
            waiting.cancel();
            running.join();
            waiting.join();
            this.manager.resume();
        }
    }

    @Test
    public void testJobFamilyNULL() {
        int NUM_JOBS = 20;
        TestJob[] jobs = new TestJob[20];
        TestJobFamily first = new TestJobFamily(1);
        TestJobFamily second = new TestJobFamily(2);
        IdentityRule rule = new IdentityRule();
        int i = 0;
        while (i < 20) {
            jobs[i] = i % 2 == 0 ? new FamilyTestJob("TestFirstFamily", 1000000, 10, 1) : new FamilyTestJob("TestSecondFamily", 1000000, 10, 2);
            jobs[i].setRule((ISchedulingRule)rule);
            jobs[i].schedule();
            ++i;
        }
        this.waitForStart(jobs[0]);
        this.assertState("1.0", (Job)jobs[0], 4);
        this.manager.sleep(null);
        this.assertState("2.0", (Job)jobs[0], 4);
        i = 1;
        while (i < 20) {
            this.assertState("2." + i, (Job)jobs[i], 1);
            ++i;
        }
        this.manager.wakeUp(null);
        this.assertState("3.0", (Job)jobs[0], 4);
        i = 1;
        while (i < 20) {
            this.assertState("3." + i, (Job)jobs[i], 2);
            ++i;
        }
        this.manager.cancel((Object)first);
        this.manager.cancel((Object)second);
        this.waitForFamilyCancel((Job[])jobs, first);
        this.waitForFamilyCancel((Job[])jobs, second);
        i = 0;
        while (i < 20) {
            this.assertState("4." + i, (Job)jobs[i], 0);
            ++i;
        }
    }

    @Test
    public void testJobFamilySleep() {
        int NUM_JOBS = 20;
        TestJob[] jobs = new TestJob[20];
        TestJobFamily first = new TestJobFamily(1);
        TestJobFamily second = new TestJobFamily(2);
        IdentityRule rule = new IdentityRule();
        int i = 0;
        while (i < 20) {
            jobs[i] = i % 2 == 0 ? new FamilyTestJob("TestFirstFamily", 1000000, 10, 1) : new FamilyTestJob("TestSecondFamily", 1000000, 10, 2);
            jobs[i].setRule((ISchedulingRule)rule);
            jobs[i].schedule();
            ++i;
        }
        this.waitForStart(jobs[0]);
        this.assertState("1.0", (Job)jobs[0], 4);
        i = 1;
        while (i < 20) {
            this.assertState("1." + i, (Job)jobs[i], 2);
            ++i;
        }
        this.manager.sleep((Object)first);
        this.assertState("2.0", (Job)jobs[0], 4);
        i = 1;
        while (i < 20) {
            if (jobs[i].belongsTo((Object)first)) {
                this.assertState("2." + i, (Job)jobs[i], 1);
                jobs[i].cancel();
            } else {
                this.assertState("3." + i, (Job)jobs[i], 2);
            }
            ++i;
        }
        this.manager.sleep((Object)second);
        jobs[0].cancel();
        this.waitForCancel((Job)jobs[0]);
        Assert.assertNull((String)"4.0", (Object)this.manager.currentJob());
        i = 1;
        while (i < 20) {
            if (jobs[i].belongsTo((Object)second)) {
                this.assertState("4." + i, (Job)jobs[i], 1);
                jobs[i].cancel();
            }
            ++i;
        }
        i = 0;
        while (i < 20) {
            this.assertState("5." + i, (Job)jobs[i], 0);
            ++i;
        }
    }

    @Test
    public void testJobFamilyWakeUp() {
        int state;
        int JOBS_PER_FAMILY = 10;
        Job[] family1 = new Job[10];
        Job[] family2 = new Job[10];
        TestJobFamily first = new TestJobFamily(1);
        TestJobFamily second = new TestJobFamily(2);
        IdentityRule rule = new IdentityRule();
        FamilyTestJob seedJob = new FamilyTestJob("SeedJob", 1000000, 1, 3);
        seedJob.setRule(rule);
        seedJob.schedule();
        this.waitForStart(seedJob);
        this.assertState("1.0", (Job)seedJob, 4);
        int i = 0;
        while (i < 10) {
            family1[i] = new FamilyTestJob("TestFirstFamily", 1000000, 1, 1);
            family1[i].setRule((ISchedulingRule)rule);
            family1[i].schedule();
            this.assertState("1.1." + i, family1[i], 2);
            Assert.assertTrue((String)("1.2." + i), (boolean)family1[i].sleep());
            this.assertState("1.3." + i, family1[i], 1);
            ++i;
        }
        i = 0;
        while (i < 10) {
            family2[i] = new FamilyTestJob("TestSecondFamily", 1000000, 1, 2);
            family2[i].setRule((ISchedulingRule)rule);
            family2[i].schedule();
            this.assertState("2.1." + i, family2[i], 2);
            Assert.assertTrue((String)("2.2." + i), (boolean)family2[i].sleep());
            this.assertState("2.3." + i, family2[i], 1);
            ++i;
        }
        seedJob.cancel();
        this.waitForCancel((Job)seedJob);
        this.assertState("3.0", (Job)seedJob, 0);
        i = 0;
        while (i < 10) {
            this.assertState("3.1." + i, family1[i], 1);
            ++i;
        }
        i = 0;
        while (i < 10) {
            this.assertState("3.2." + i, family2[i], 1);
            ++i;
        }
        this.manager.wakeUp((Object)second);
        i = 0;
        while (i < 10) {
            this.assertState("4.1." + i, family1[i], 1);
            ++i;
        }
        int runningCount = 0;
        int i2 = 0;
        while (i2 < 10) {
            state = family2[i2].getState();
            if (state == 4) {
                ++runningCount;
            } else if (state != 2) {
                Assert.assertTrue((String)("4.2." + i2 + ": expected state: " + this.printState(2) + " actual state: " + this.printState(state)), (boolean)false);
            }
            ++i2;
        }
        Assert.assertTrue((String)"4.running", (runningCount <= 1 ? 1 : 0) != 0);
        i2 = 0;
        while (i2 < 10) {
            if (!family2[i2].cancel()) {
                this.waitForCancel(family2[i2]);
            }
            this.assertState("5." + i2, family2[i2], 0);
            ++i2;
        }
        i2 = 0;
        while (i2 < 10) {
            this.assertState("6.1." + i2, family1[i2], 1);
            ++i2;
        }
        this.manager.wakeUp((Object)first);
        runningCount = 0;
        i2 = 0;
        while (i2 < 10) {
            state = family1[i2].getState();
            if (state == 4) {
                ++runningCount;
            } else if (state != 2) {
                Assert.assertTrue((String)("7.1." + i2 + ": expected state: " + this.printState(2) + " actual state: " + this.printState(state)), (boolean)false);
            }
            ++i2;
        }
        Assert.assertTrue((String)"7.running", (runningCount <= 1 ? 1 : 0) != 0);
        i2 = 0;
        while (i2 < 10) {
            if (!family1[i2].cancel()) {
                this.waitForCancel(family1[i2]);
            }
            this.assertState("8." + i2, family1[i2], 0);
            ++i2;
        }
        i2 = 0;
        while (i2 < 10) {
            this.assertState("9.1." + i2, family1[i2], 0);
            ++i2;
        }
        i2 = 0;
        while (i2 < 10) {
            this.assertState("9.2." + i2, family2[i2], 0);
            ++i2;
        }
    }

    @Test
    public void testMutexRule() {
        int JOB_COUNT = 10;
        TestJob[] jobs = new TestJob[10];
        IdentityRule mutex = new IdentityRule();
        int i = 0;
        while (i < 10) {
            jobs[i] = new TestJob("testMutexRule", 1000000, 1L);
            jobs[i].setRule((ISchedulingRule)mutex);
            jobs[i].schedule();
            ++i;
        }
        this.waitForStart(jobs[0]);
        this.assertState("1.0", (Job)jobs[0], 4);
        i = 1;
        while (i < 10) {
            this.assertState("1.1." + i, (Job)jobs[i], 2);
            ++i;
        }
        i = 0;
        while (i < 9) {
            jobs[i].cancel();
            this.waitForStart(jobs[i + 1]);
            this.assertState("2.0." + i, (Job)jobs[i + 1], 4);
            int j = i + 2;
            while (j < 10) {
                this.assertState("2.1" + i + "." + j, (Job)jobs[j], 2);
                ++j;
            }
            ++i;
        }
        jobs[9].cancel();
    }

    @Test
    public void testOrder() throws Exception {
        int[] nArray = new int[8];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 5;
        nArray[4] = 10;
        nArray[5] = 15;
        nArray[6] = 25;
        nArray[7] = 50;
        int[] sleepTimes = nArray;
        LinkedList<16> allJobs = new LinkedList<16>();
        final List jobsRunningBeforePrevious = Collections.synchronizedList(new ArrayList());
        int[] nArray2 = sleepTimes;
        int n = sleepTimes.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray2[n2];
            final Job previouslyScheduledJob = allJobs.isEmpty() ? null : (Job)allJobs.getLast();
            Job currentJob = new Job("testOrder job to be run with sleep time " + n3){

                protected IStatus run(IProgressMonitor monitor) {
                    if (!this.hasPreviousJobStartedRunning()) {
                        jobsRunningBeforePrevious.add(this);
                    }
                    return Status.OK_STATUS;
                }

                private boolean hasPreviousJobStartedRunning() {
                    return previouslyScheduledJob == null || previouslyScheduledJob.getState() == 4 || previouslyScheduledJob.getState() == 0;
                }
            };
            currentJob.schedule((long)n3);
            allJobs.add(currentJob);
            ++n2;
        }
        for (Job job : allJobs) {
            job.join();
        }
        ((ListAssert)Assertions.assertThat(jobsRunningBeforePrevious).as("job started running before a previously scheduled one", new Object[0])).isEmpty();
    }

    @Test
    public void testReverseOrder() throws InterruptedException {
        TestJob directlyExecutedJob = new TestJob("Directly executed job", 0, 0L);
        TestJob delayedJob = new TestJob("Delayed job", 0, 0L);
        long delayInSeconds = 20L;
        delayedJob.schedule(delayInSeconds * 1000L);
        directlyExecutedJob.schedule(1L);
        directlyExecutedJob.join(delayInSeconds * 1000L / 2L, null);
        int delayedJobState = delayedJob.getState();
        delayedJob.cancel();
        ((AbstractIntegerAssert)Assertions.assertThat((int)delayedJobState).as("state of delayed job that should be waiting", new Object[0])).isEqualTo(1);
    }

    @Test
    public void testScheduleRace() throws InterruptedException {
        final int[] count = new int[1];
        final boolean[] running = new boolean[1];
        final boolean[] failure = new boolean[1];
        final Job testJob = new Job("testScheduleRace"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            protected IStatus run(IProgressMonitor monitor) {
                try {
                    try {
                        boolean[] blArray = running;
                        synchronized (running) {
                            if (running[0]) {
                                failure[0] = true;
                            } else {
                                running[0] = true;
                            }
                            // ** MonitorExit[var2_2] (shouldn't be in output)
                            Thread.sleep(100L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        boolean[] blArray = running;
                        synchronized (running) {
                            running[0] = false;
                            // ** MonitorExit[var4_4] (shouldn't be in output)
                            return Status.OK_STATUS;
                        }
                    }
                }
                catch (Throwable throwable) {
                    boolean[] blArray = running;
                    synchronized (running) {
                        running[0] = false;
                        // ** MonitorExit[var4_5] (shouldn't be in output)
                        throw throwable;
                    }
                }
                {
                    boolean[] blArray = running;
                    synchronized (running) {
                        running[0] = false;
                        // ** MonitorExit[var4_6] (shouldn't be in output)
                        return Status.OK_STATUS;
                    }
                }
            }
        };
        testJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            /*
             * Handled impossible loop by duplicating code
             * Enabled aggressive block sorting
             */
            public void scheduled(IJobChangeEvent event) {
                block3: {
                    int n;
                    block2: {
                        if (!true) break block2;
                        n = count[0];
                        count[0] = n + 1;
                        if (n >= 2) break block3;
                    }
                    do {
                        testJob.schedule();
                        n = count[0];
                        count[0] = n + 1;
                    } while (n < 2);
                }
            }
        });
        testJob.schedule();
        testJob.join();
        this.waitForCompletion(testJob, Duration.ofSeconds(5L));
        Assert.assertTrue((String)"1.0", (!failure[0] ? 1 : 0) != 0);
    }

    @Test
    public void testSimple() {
        int JOB_COUNT = 10;
        int i = 0;
        while (i < 10) {
            new TestJob("testSimple", 1, 1L).schedule();
            ++i;
        }
        this.waitForCompletion();
        i = 0;
        while (i < 10) {
            new TestJob("testSimple", 1, 1L).schedule(50L);
            ++i;
        }
        this.waitForCompletion();
    }

    @Test
    public void testSetInvalidRule() {
        class InvalidRule
        implements ISchedulingRule {
            InvalidRule() {
            }

            public boolean isConflicting(ISchedulingRule rule) {
                return false;
            }

            public boolean contains(ISchedulingRule rule) {
                return false;
            }
        }
        InvalidRule rule1 = new InvalidRule();
        InvalidRule rule2 = new InvalidRule();
        ISchedulingRule multi = MultiRule.combine((ISchedulingRule)rule1, (ISchedulingRule)rule2);
        Job job = new Job("job with invalid rule"){

            protected IStatus run(IProgressMonitor monitor) {
                return Status.OK_STATUS;
            }
        };
        Assert.assertThrows(IllegalArgumentException.class, () -> job.setRule((ISchedulingRule)rule1));
        Assert.assertThrows(IllegalArgumentException.class, () -> job.setRule((ISchedulingRule)rule2));
        Assert.assertThrows(IllegalArgumentException.class, () -> job.setRule(multi));
    }

    @Test
    public void testSleep() {
        TestJob job = new TestJob("ParentJob", 1000000, 10L);
        Assert.assertEquals((String)"1.0", (long)0L, (long)job.getState());
        Assert.assertTrue((String)"1.1", (boolean)job.sleep());
        Assert.assertEquals((String)"1.2", (long)0L, (long)job.getState());
        job.schedule();
        this.waitForStart(job);
        this.assertState("2.0", (Job)job, 4);
        Assert.assertTrue((String)"2.1", (!job.sleep() ? 1 : 0) != 0);
        this.assertState("2.2", (Job)job, 4);
        job.terminate();
        this.waitForCompletion();
        job.schedule(10000L);
        this.assertState("3.0", (Job)job, 1);
        Assert.assertTrue((String)"3.1", (boolean)job.sleep());
        this.assertState("3.2", (Job)job, 1);
        Thread.yield();
        this.sleep(60L);
        Thread.yield();
        this.assertState("3.3", (Job)job, 1);
        Assert.assertTrue((String)"3.4", (boolean)job.cancel());
    }

    @Test
    public void testSleepOnWait() {
        PathRule rule = new PathRule("testSleepOnWait");
        TestJob blockingJob = new TestJob("Long Job", 1000000, 10L);
        blockingJob.setRule((ISchedulingRule)rule);
        blockingJob.schedule();
        TestJob job = new TestJob("Long Job", 1000000, 10L);
        job.setRule((ISchedulingRule)rule);
        job.schedule();
        this.assertState("1.0", (Job)job, 2);
        Assert.assertTrue((String)"1.1", (boolean)job.sleep());
        this.assertState("1.2", (Job)job, 1);
        blockingJob.cancel();
        this.assertState("1.3", (Job)job, 1);
        job.wakeUp();
        this.waitForStart(job);
        this.assertState("2.0", (Job)job, 4);
        job.cancel();
        this.waitForCompletion((Job)job);
    }

    @Test
    public void testSuspend() {
        Assert.assertTrue((String)"1.0", (!this.manager.isSuspended() ? 1 : 0) != 0);
        this.manager.suspend();
        try {
            Assert.assertTrue((String)"1.1", (boolean)this.manager.isSuspended());
        }
        finally {
            this.manager.resume();
        }
        Assert.assertTrue((String)"1.1", (!this.manager.isSuspended() ? 1 : 0) != 0);
    }

    @Deprecated
    @Test
    public void testSuspendMismatchedBegins() {
        PathRule rule1 = new PathRule("/TestSuspendMismatchedBegins");
        PathRule rule2 = new PathRule("/TestSuspendMismatchedBegins/Child");
        this.manager.suspend((ISchedulingRule)rule1, null);
        TestBarrier2 barrier = new TestBarrier2();
        JobRuleRunner runner = new JobRuleRunner("TestSuspendJob", rule2, barrier, 1, true);
        runner.schedule();
        barrier.waitForStatus(1);
        barrier.setStatus(2);
        barrier.waitForStatus(3);
        this.manager.resume((ISchedulingRule)rule1);
        barrier.setStatus(4);
        barrier.waitForStatus(5);
        this.waitForCompletion(runner);
    }

    @Deprecated
    @Test
    public void testSuspendMultiThreadAccess() {
        PathRule rule1 = new PathRule("/TestSuspend");
        PathRule rule2 = new PathRule("/TestSuspend/Child");
        this.manager.suspend((ISchedulingRule)rule1, null);
        Job job = new Job("TestSuspend"){

            protected IStatus run(IProgressMonitor monitor) {
                return Status.OK_STATUS;
            }
        };
        job.setRule((ISchedulingRule)rule1);
        job.schedule();
        this.sleep(200L);
        Assert.assertNull((String)"1.0", (Object)job.getResult());
        AtomicIntegerArray status = new AtomicIntegerArray(new int[1]);
        SimpleRuleRunner runner = new SimpleRuleRunner(rule1, status, null);
        new Thread(runner).start();
        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)5);
        status.set(0, 0);
        runner = new SimpleRuleRunner(rule2, status, null);
        new Thread(runner).start();
        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)5);
        this.manager.beginRule((ISchedulingRule)rule1, null);
        status.set(0, 0);
        runner = new SimpleRuleRunner(rule1, status, null);
        new Thread(runner).start();
        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)5);
        this.sleep(100L);
        Assert.assertNull((String)"1.1", (Object)job.getResult());
        this.manager.endRule((ISchedulingRule)rule1);
        this.sleep(100L);
        Assert.assertNull((String)"1.2", (Object)job.getResult());
        status.set(0, 0);
        runner = new SimpleRuleRunner(rule1, status, null);
        new Thread(runner).start();
        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)5);
        this.manager.resume((ISchedulingRule)rule1);
        this.waitForCompletion(job);
    }

    @Test
    public void testTransferFailure() throws InterruptedException {
        PathRule rule = new PathRule("/testTransferFailure");
        PathRule subRule = new PathRule("/testTransferFailure/Sub");
        Thread other = new Thread();
        Assert.assertThrows(RuntimeException.class, () -> this.manager.transferRule((ISchedulingRule)rule, other));
        try {
            this.manager.beginRule((ISchedulingRule)rule, null);
            Assert.assertThrows(RuntimeException.class, () -> this.manager.transferRule((ISchedulingRule)subRule, other));
            TestBarrier2 barrier = new TestBarrier2();
            PathRule unrelatedRule = new PathRule("UnrelatedRule");
            JobRuleRunner ruleRunner = new JobRuleRunner("testTransferFailure", unrelatedRule, barrier, 1, false);
            ruleRunner.schedule();
            barrier.waitForStatus(1);
            barrier.setStatus(2);
            barrier.waitForStatus(3);
            Assert.assertThrows(RuntimeException.class, () -> this.manager.transferRule((ISchedulingRule)rule, ruleRunner.getThread()));
            barrier.setStatus(4);
            barrier.waitForStatus(5);
            ruleRunner.join();
        }
        finally {
            this.manager.endRule((ISchedulingRule)rule);
        }
    }

    @Test
    public void testTransferJobToJob() throws CoreException {
        final PathRule ruleToTransfer = new PathRule("testTransferJobToJob");
        final TestBarrier2 barrier = new TestBarrier2();
        final Thread[] sourceThread = new Thread[1];
        final Job destination = new Job("testTransferJobToJob.destination"){

            protected IStatus run(IProgressMonitor monitor) {
                barrier.setStatus(3);
                barrier.waitForStatus(4);
                return Status.OK_STATUS;
            }
        };
        Job source = new Job("testTransferJobToJob.source"){

            protected IStatus run(IProgressMonitor monitor) {
                sourceThread[0] = Thread.currentThread();
                destination.schedule();
                barrier.waitForStatus(3);
                IJobManagerTest.this.sleep(100L);
                manager.transferRule((ISchedulingRule)ruleToTransfer, destination.getThread());
                return Status.OK_STATUS;
            }
        };
        source.setRule((ISchedulingRule)ruleToTransfer);
        source.schedule();
        this.waitForCompletion(source);
        Assert.assertTrue((String)"1.0", (!source.getResult().isOK() ? 1 : 0) != 0);
        Assert.assertTrue((String)"1.1", (boolean)(source.getResult().getException() instanceof RuntimeException));
        barrier.setStatus(4);
        this.waitForCompletion(destination);
        if (!destination.getResult().isOK()) {
            throw new CoreException(destination.getResult());
        }
    }

    @Test
    public void testTransferSameThread() {
        PathRule rule = new PathRule("testTransferSameThread");
        try {
            this.manager.beginRule((ISchedulingRule)rule, null);
            this.manager.transferRule((ISchedulingRule)rule, Thread.currentThread());
        }
        finally {
            this.manager.endRule((ISchedulingRule)rule);
        }
    }

    @Test
    public void testTransferSimple() throws Exception {
        PathRule rule = new PathRule("testTransferSimple");
        this.manager.beginRule((ISchedulingRule)rule, null);
        class RuleEnder
        implements Runnable {
            Exception error;
            private final ISchedulingRule rule;

            RuleEnder(ISchedulingRule rule) {
                this.rule = rule;
            }

            @Override
            public void run() {
                try {
                    IJobManagerTest.this.manager.endRule(this.rule);
                }
                catch (Exception e) {
                    this.error = e;
                }
            }
        }
        RuleEnder ender = new RuleEnder(rule);
        Thread destination = new Thread(ender);
        this.manager.transferRule((ISchedulingRule)rule, destination);
        destination.start();
        destination.join();
        if (ender.error != null) {
            throw ender.error;
        }
    }

    @Test
    public void testTransferToJob() throws Exception {
        final PathRule rule = new PathRule("testTransferToJob");
        final TestBarrier2 barrier = new TestBarrier2();
        barrier.setStatus(0);
        final Exception[] failure = new Exception[1];
        final Thread testThread = Thread.currentThread();
        Job job = new Job("testTransferSimple"){

            protected IStatus run(IProgressMonitor monitor) {
                barrier.setStatus(3);
                barrier.waitForStatus(4);
                IJobManagerTest.this.sleep(100L);
                try {
                    manager.transferRule((ISchedulingRule)rule, testThread);
                }
                catch (RuntimeException e) {
                    failure[0] = e;
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        barrier.waitForStatus(3);
        this.manager.beginRule((ISchedulingRule)rule, null);
        this.manager.transferRule((ISchedulingRule)rule, job.getThread());
        barrier.setStatus(4);
        this.manager.beginRule((ISchedulingRule)rule, null);
        this.manager.endRule((ISchedulingRule)rule);
        if (failure[0] != null) {
            throw failure[0];
        }
        this.manager.endRule((ISchedulingRule)rule);
    }

    @Test
    public void testTransferToJobWaitingOnChildRule() throws Exception {
        final PathRule rule = new PathRule("testTransferToJobWaitingOnChildRule");
        final TestBarrier2 barrier = new TestBarrier2();
        barrier.setStatus(0);
        final Exception[] failure = new Exception[1];
        final Thread testThread = Thread.currentThread();
        Job job = new Job("testTransferToJobWaitingOnChildRule"){

            protected IStatus run(IProgressMonitor monitor) {
                barrier.setStatus(3);
                PathRule child = new PathRule(rule.getFullPath().append("child"));
                try {
                    manager.beginRule((ISchedulingRule)child, null);
                }
                finally {
                    manager.endRule((ISchedulingRule)child);
                }
                try {
                    manager.transferRule((ISchedulingRule)rule, testThread);
                }
                catch (RuntimeException e) {
                    failure[0] = e;
                }
                return Status.OK_STATUS;
            }
        };
        this.manager.beginRule((ISchedulingRule)rule, null);
        job.schedule();
        barrier.waitForStatus(3);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.manager.transferRule((ISchedulingRule)rule, job.getThread());
        this.waitForCompletion(job);
        if (failure[0] != null) {
            throw failure[0];
        }
        this.manager.endRule((ISchedulingRule)rule);
    }

    @Test
    public void testTransferToWaitingJob() throws Exception {
        final PathRule rule = new PathRule("testTransferToWaitingJob");
        final TestBarrier2 barrier = new TestBarrier2();
        barrier.setStatus(0);
        final Exception[] failure = new Exception[1];
        final Thread testThread = Thread.currentThread();
        Job job = new Job("testTransferToWaitingJob"){

            protected IStatus run(IProgressMonitor monitor) {
                barrier.setStatus(3);
                try {
                    manager.beginRule((ISchedulingRule)rule, null);
                }
                finally {
                    manager.endRule((ISchedulingRule)rule);
                }
                try {
                    manager.transferRule((ISchedulingRule)rule, testThread);
                }
                catch (RuntimeException e) {
                    failure[0] = e;
                }
                return Status.OK_STATUS;
            }
        };
        this.manager.beginRule((ISchedulingRule)rule, null);
        job.schedule();
        barrier.waitForStatus(3);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.manager.transferRule((ISchedulingRule)rule, job.getThread());
        this.waitForCompletion(job);
        if (failure[0] != null) {
            throw failure[0];
        }
        this.manager.endRule((ISchedulingRule)rule);
    }

    @Test
    public void testTwoRules() {
        int JOB_COUNT = 10;
        TestJob[] jobs = new TestJob[10];
        IdentityRule evens = new IdentityRule();
        IdentityRule odds = new IdentityRule();
        int i = 0;
        while (i < 10) {
            jobs[i] = new TestJob("testSimpleRules", 1000000, 1L);
            jobs[i].setRule((ISchedulingRule)((i & 1) == 0 ? evens : odds));
            jobs[i].schedule();
            ++i;
        }
        this.waitForStart(jobs[0]);
        this.waitForStart(jobs[1]);
        this.assertState("1.0", (Job)jobs[0], 4);
        this.assertState("1.1", (Job)jobs[1], 4);
        i = 2;
        while (i < 10) {
            this.assertState("1.2." + i, (Job)jobs[i], 2);
            ++i;
        }
        i = 0;
        while (i < 10) {
            jobs[i].cancel();
            try {
                this.waitForStart(jobs[i + 1]);
                this.assertState("2.0." + i, (Job)jobs[i + 1], 4);
                this.waitForStart(jobs[i + 2]);
                this.assertState("2.1." + i, (Job)jobs[i + 2], 4);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            int j = i + 3;
            while (j < 10) {
                this.assertState("2.2." + i + "." + j, (Job)jobs[j], 2);
                ++j;
            }
            ++i;
        }
    }

    private void waitForCancel(Job job) {
        int i = 0;
        while (job.getState() == 4) {
            Thread.yield();
            this.sleep(100L);
            Thread.yield();
            if (i++ <= 1000) continue;
            this.dumpState();
            Assert.assertTrue((String)"Timeout waiting for job to cancel", (boolean)false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForCompletion() {
        int i = 0;
        Assert.assertTrue((String)"Jobs completed that weren't scheduled", (this.completedJobs.get() <= this.scheduledJobs.get() ? 1 : 0) != 0);
        while (this.completedJobs.get() < this.scheduledJobs.get()) {
            try {
                IJobManagerTest iJobManagerTest = this;
                synchronized (iJobManagerTest) {
                    this.wait(1L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (i++ <= 100000) continue;
            this.dumpState();
            Assert.assertTrue((String)"Timeout waiting for job to complete", (boolean)false);
        }
    }

    private void waitForFamilyCancel(Job[] jobs, TestJobFamily type) {
        Job[] jobArray = jobs;
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            Job job = jobArray[n2];
            int i = 0;
            while (job.belongsTo((Object)type) && job.getState() != 0) {
                Thread.yield();
                this.sleep(100L);
                Thread.yield();
                if (i++ <= 100) continue;
                this.dumpState();
                Assert.assertTrue((String)("Timeout waiting for job in family " + type.getType() + "to be canceled "), (boolean)false);
            }
            ++n2;
        }
    }

    private void waitForRunCount(TestJob job, int runCount) {
        int i = 0;
        while (job.getRunCount() < runCount) {
            Thread.yield();
            this.sleep(100L);
            Thread.yield();
            if (i++ < 1000) continue;
            this.dumpState();
            Assert.assertTrue((String)("Timeout waiting for job to start. Job: " + String.valueOf(job) + ", state: " + job.getState()), (boolean)false);
        }
    }

    private void waitForStart(TestJob job) {
        this.waitForRunCount(job, 1);
    }

    private /* synthetic */ void lambda$19(AtomicIntegerArray atomicIntegerArray, TestJobFamily testJobFamily, IProgressMonitor iProgressMonitor) {
        atomicIntegerArray.set(0, 1);
        try {
            TestBarrier2.waitForStatus((AtomicIntegerArray)atomicIntegerArray, (int)0, (int)2);
            atomicIntegerArray.set(0, 3);
            this.manager.join((Object)testJobFamily, iProgressMonitor);
        }
        catch (InterruptedException | OperationCanceledException throwable) {
            // empty catch block
        }
        atomicIntegerArray.set(0, 5);
    }

    class TestJobListener
    extends JobChangeAdapter {
        private final Set<Job> scheduled = Collections.synchronizedSet(new HashSet());

        TestJobListener() {
        }

        public void cancelAllJobs() {
            Job[] jobs;
            Job[] jobArray = jobs = this.scheduled.toArray(new Job[0]);
            int n = jobs.length;
            int n2 = 0;
            while (n2 < n) {
                Job job = jobArray[n2];
                job.cancel();
                ++n2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void done(IJobChangeEvent event) {
            IJobManagerTest iJobManagerTest = IJobManagerTest.this;
            synchronized (iJobManagerTest) {
                if (this.scheduled.remove(event.getJob())) {
                    IJobManagerTest.this.completedJobs.incrementAndGet();
                    IJobManagerTest.this.notify();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void scheduled(IJobChangeEvent event) {
            Job job = event.getJob();
            IJobManagerTest iJobManagerTest = IJobManagerTest.this;
            synchronized (iJobManagerTest) {
                if (job instanceof TestJob) {
                    IJobManagerTest.this.scheduledJobs.incrementAndGet();
                    this.scheduled.add(job);
                }
            }
        }
    }
}

