/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.runtime.jobs;

import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.internal.jobs.JobListeners;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.core.tests.harness.TestBarrier2;
import org.eclipse.core.tests.runtime.jobs.AbstractJobTest;
import org.eclipse.core.tests.runtime.jobs.OrderAsserter;
import org.junit.Assert;
import org.junit.jupiter.api.Test;

public class JobEventTest
extends AbstractJobTest {
    @Test
    public void testScheduleOrderOfEvents() {
        final OrderAsserter asserter = new OrderAsserter();
        OrderAsserter.Event START = asserter.getNext("START");
        final OrderAsserter.Event SCHEDULED = asserter.getNext("IJobChangeEvent.scheduled()");
        final OrderAsserter.Event ABOUTTORUN = asserter.getNext("IJobChangeEvent.aboutToRun()");
        final OrderAsserter.Event RUNNING = asserter.getNext("IJobChangeEvent.running()");
        final OrderAsserter.Event RUN = asserter.getNext("Job.run()");
        final OrderAsserter.Event DONE = asserter.getNext("IJobChangeEvent.done()");
        OrderAsserter.Event RETURN_FROM_JOIN = asserter.getNext("RETURN FROM Job.join()");
        final OrderAsserter.Event SLEEPING = asserter.never("IJobChangeEvent.sleeping()");
        final OrderAsserter.Event AWAKE = asserter.never("IJobChangeEvent.awake()");
        Job job = new Job("testScheduleOrderOfEvents"){

            protected IStatus run(IProgressMonitor monitor) {
                asserter.expect(RUN);
                return Status.OK_STATUS;
            }
        };
        asserter.expect(START);
        IJobChangeListener jobListener = new IJobChangeListener(){

            public void scheduled(IJobChangeEvent event) {
                asserter.expect(SCHEDULED);
            }

            public void sleeping(IJobChangeEvent event) {
                asserter.expect(SLEEPING);
            }

            public void awake(IJobChangeEvent event) {
                asserter.expect(AWAKE);
            }

            public void aboutToRun(IJobChangeEvent event) {
                asserter.expect(ABOUTTORUN);
            }

            public void running(IJobChangeEvent event) {
                asserter.expect(RUNNING);
            }

            public void done(IJobChangeEvent event) {
                asserter.expect(DONE);
            }
        };
        job.addJobChangeListener(jobListener);
        try {
            job.schedule();
            try {
                job.join();
            }
            catch (InterruptedException e) {
                asserter.addError(e);
            }
            asserter.expect(RETURN_FROM_JOIN);
            asserter.assertNoErrors();
        }
        finally {
            job.removeJobChangeListener(jobListener);
        }
    }

    @Test
    public void testSelfRescheduleOrderOfEvents() {
        final OrderAsserter asserter = new OrderAsserter();
        final OrderAsserter.Event SCHEDULED1 = asserter.getNext("First IJobChangeEvent.scheduled()");
        final OrderAsserter.Event ABOUTTORUN1 = asserter.getNext("First IJobChangeEvent.aboutToRun()");
        final OrderAsserter.Event RUNNING1 = asserter.getNext("First IJobChangeEvent.running()");
        final OrderAsserter.Event RUN1 = asserter.getNext("First Job.run()");
        final OrderAsserter.Event DONE1 = asserter.getNext("First IJobChangeEvent.done()");
        final OrderAsserter.Event SCHEDULED2 = asserter.getNext("Second IJobChangeEvent.scheduled()");
        final OrderAsserter.Event ABOUTTORUN2 = asserter.getNext("Second IJobChangeEvent.aboutToRun()");
        final OrderAsserter.Event RUNNING2 = asserter.getNext("Second IJobChangeEvent.running()");
        final OrderAsserter.Event RUN2 = asserter.getNext("Second Job.run()");
        final OrderAsserter.Event DONE2 = asserter.getNext("Second IJobChangeEvent.done()");
        OrderAsserter.Event RETURN_FROM_JOIN2 = asserter.getNext("Second RETURN FROM Job.join()");
        final OrderAsserter.Event SLEEPING = asserter.never("IJobChangeEvent.sleeping()");
        final OrderAsserter.Event AWAKE = asserter.never("IJobChangeEvent.awake()");
        Job job = new Job("testScheduleOrderOfEvents"){
            private final AtomicInteger runCount;
            {
                super($anonymous0);
                this.runCount = new AtomicInteger();
            }

            protected IStatus run(IProgressMonitor monitor) {
                switch (this.runCount.incrementAndGet()) {
                    case 1: {
                        asserter.expect(RUN1);
                        this.schedule();
                        break;
                    }
                    case 2: {
                        asserter.expect(RUN2);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        IJobChangeListener jobListener = new IJobChangeListener(){
            private final AtomicInteger scheduledCount = new AtomicInteger();
            private final AtomicInteger aboutToRunCount = new AtomicInteger();
            private final AtomicInteger runningCount = new AtomicInteger();
            private final AtomicInteger doneCount = new AtomicInteger();

            public void scheduled(IJobChangeEvent event) {
                switch (this.scheduledCount.incrementAndGet()) {
                    case 1: {
                        asserter.expect(SCHEDULED1);
                        break;
                    }
                    case 2: {
                        asserter.expect(SCHEDULED2);
                    }
                }
            }

            public void sleeping(IJobChangeEvent event) {
                asserter.expect(SLEEPING);
            }

            public void awake(IJobChangeEvent event) {
                asserter.expect(AWAKE);
            }

            public void aboutToRun(IJobChangeEvent event) {
                switch (this.aboutToRunCount.incrementAndGet()) {
                    case 1: {
                        asserter.expect(ABOUTTORUN1);
                        break;
                    }
                    case 2: {
                        asserter.expect(ABOUTTORUN2);
                    }
                }
            }

            public void running(IJobChangeEvent event) {
                switch (this.runningCount.incrementAndGet()) {
                    case 1: {
                        asserter.expect(RUNNING1);
                        break;
                    }
                    case 2: {
                        asserter.expect(RUNNING2);
                    }
                }
            }

            public void done(IJobChangeEvent event) {
                switch (this.doneCount.incrementAndGet()) {
                    case 1: {
                        asserter.expect(DONE1);
                        break;
                    }
                    case 2: {
                        asserter.expect(DONE2);
                    }
                }
            }
        };
        job.addJobChangeListener(jobListener);
        try {
            job.schedule();
            try {
                job.join();
            }
            catch (InterruptedException e) {
                asserter.addError(e);
            }
            try {
                job.join();
            }
            catch (InterruptedException e) {
                asserter.addError(e);
            }
            asserter.expect(RETURN_FROM_JOIN2);
            asserter.assertNoErrors();
        }
        finally {
            job.removeJobChangeListener(jobListener);
        }
    }

    @Test
    public void testSleepOrderOfEvents() {
        final OrderAsserter asserter = new OrderAsserter();
        final OrderAsserter.Event SCHEDULED = asserter.getNext("IJobChangeEvent.scheduled()");
        final OrderAsserter.Event ABOUTTORUN1 = asserter.getNext("First IJobChangeEvent.aboutToRun()");
        final OrderAsserter.Event SLEEPING = asserter.getNext("IJobChangeEvent.sleeping()");
        final OrderAsserter.Event AWAKE = asserter.getNext("IJobChangeEvent.awake()");
        final OrderAsserter.Event ABOUTTORUN2 = asserter.getNext("Second IJobChangeEvent.aboutToRun()");
        final OrderAsserter.Event RUNNING = asserter.getNext("IJobChangeEvent.running()");
        final OrderAsserter.Event RUN = asserter.getNext("Job.run()");
        final OrderAsserter.Event DONE = asserter.getNext("IJobChangeEvent.done()");
        OrderAsserter.Event RETURN_FROM_JOIN = asserter.getNext("RETURN FROM Job.join()");
        final Job job = new Job("testSleepOrderOfEvents"){

            protected IStatus run(IProgressMonitor monitor) {
                asserter.expect(RUN);
                return Status.OK_STATUS;
            }
        };
        IJobChangeListener jobListener = new IJobChangeListener(){
            private final AtomicInteger aboutToRunCount = new AtomicInteger();

            public void scheduled(IJobChangeEvent event) {
                asserter.expect(SCHEDULED);
            }

            public void sleeping(IJobChangeEvent event) {
                asserter.expect(SLEEPING);
            }

            public void awake(IJobChangeEvent event) {
                asserter.expect(AWAKE);
            }

            public void aboutToRun(IJobChangeEvent event) {
                switch (this.aboutToRunCount.incrementAndGet()) {
                    case 1: {
                        asserter.expect(ABOUTTORUN1);
                        job.sleep();
                        job.wakeUp();
                        break;
                    }
                    case 2: {
                        asserter.expect(ABOUTTORUN2);
                    }
                }
            }

            public void running(IJobChangeEvent event) {
                asserter.expect(RUNNING);
            }

            public void done(IJobChangeEvent event) {
                asserter.expect(DONE);
            }
        };
        job.addJobChangeListener(jobListener);
        try {
            job.schedule();
            try {
                job.join();
            }
            catch (InterruptedException e) {
                asserter.addError(e);
            }
            asserter.expect(RETURN_FROM_JOIN);
            asserter.assertNoErrors();
        }
        finally {
            job.removeJobChangeListener(jobListener);
        }
    }

    @Test
    public void testCancelOrderOfEvents() {
        final OrderAsserter asserter = new OrderAsserter();
        final OrderAsserter.Event SCHEDULED = asserter.getNext("IJobChangeEvent.scheduled()");
        final OrderAsserter.Event ABOUTTORUN = asserter.getNext("IJobChangeEvent.aboutToRun()");
        final OrderAsserter.Event SLEEPING = asserter.never("IJobChangeEvent.sleeping()");
        final OrderAsserter.Event AWAKE = asserter.never("IJobChangeEvent.awake()");
        final OrderAsserter.Event RUNNING = asserter.never("IJobChangeEvent.running()");
        final OrderAsserter.Event RUN = asserter.never("Job.run()");
        final OrderAsserter.Event DONE = asserter.getNext("IJobChangeEvent.done()");
        final Job job = new Job("testCancelOrderOfEvents"){

            protected IStatus run(IProgressMonitor monitor) {
                asserter.expect(RUN);
                return Status.OK_STATUS;
            }
        };
        IJobChangeListener jobListener = new IJobChangeListener(){

            public void scheduled(IJobChangeEvent event) {
                asserter.expect(SCHEDULED);
            }

            public void sleeping(IJobChangeEvent event) {
                asserter.expect(SLEEPING);
            }

            public void awake(IJobChangeEvent event) {
                asserter.expect(AWAKE);
            }

            public void aboutToRun(IJobChangeEvent event) {
                asserter.expect(ABOUTTORUN);
                job.cancel();
                job.wakeUp();
            }

            public void running(IJobChangeEvent event) {
                asserter.expect(RUNNING);
            }

            public void done(IJobChangeEvent event) {
                asserter.expect(DONE);
            }
        };
        job.addJobChangeListener(jobListener);
        try {
            job.schedule();
            try {
                job.join();
            }
            catch (InterruptedException e) {
                asserter.addError(e);
            }
            asserter.assertNoErrors();
        }
        finally {
            job.removeJobChangeListener(jobListener);
        }
    }

    @Test
    public void testDeadlockRecovery() throws Exception {
        final Object commonLockObject = new Object();
        final TestBarrier2 waitingForJobListenerBarrier = new TestBarrier2();
        final TestBarrier2 waitingForBlockBarrier = new TestBarrier2();
        final Job jobWithListener = new Job("Job-Listener-Triggering Job"){

            protected IStatus run(IProgressMonitor monitor) {
                return Status.OK_STATUS;
            }
        };
        JobChangeAdapter jobListener = new JobChangeAdapter(){

            /*
             * Enabled aggressive block sorting
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            public void done(IJobChangeEvent event) {
                waitingForJobListenerBarrier.setStatus(3);
                waitingForBlockBarrier.waitForStatus(6);
                Object object = commonLockObject;
                // MONITORENTER : object
                // MONITOREXIT : object
            }
        };
        jobWithListener.addJobChangeListener((IJobChangeListener)jobListener);
        Thread threadDeadlockingWithJobListener = new Thread("Deadlocking Thread"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                waitingForJobListenerBarrier.waitForStatus(3);
                Object object = commonLockObject;
                synchronized (object) {
                    waitingForBlockBarrier.setStatus(6);
                    jobWithListener.schedule();
                }
            }
        };
        int DEADLOCK_TIMEOUT = 250;
        int ABORT_TEST_TIMEOUT = 60000;
        try {
            this.assertNoTimeoutOccurred();
            JobListeners.setJobListenerTimeout((int)250);
            threadDeadlockingWithJobListener.start();
            jobWithListener.schedule();
            waitingForBlockBarrier.waitForStatus(6);
            threadDeadlockingWithJobListener.join(60000L);
            Assert.assertEquals((long)0L, (long)JobListeners.getJobListenerTimeout());
        }
        finally {
            JobListeners.resetJobListenerTimeout();
            jobWithListener.removeJobChangeListener((IJobChangeListener)jobListener);
        }
    }
}

