/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.runtime.jobs;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLong;
import junit.framework.AssertionFailedError;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectArrayAssert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.core.runtime.jobs.JobGroup;
import org.eclipse.core.tests.harness.FussyProgressMonitor;
import org.eclipse.core.tests.harness.TestBarrier2;
import org.eclipse.core.tests.harness.TestJob;
import org.eclipse.core.tests.runtime.jobs.AbstractJobTest;
import org.eclipse.core.tests.runtime.jobs.RepeatingJob;
import org.junit.Assert;
import org.junit.jupiter.api.Test;

public class JobGroupTest
extends AbstractJobTest {
    @Test
    public void testThrottlingWhenAllJobsAreKnown() {
        int NUM_JOBS = 100;
        int MAX_THREADS = 10;
        TestJob[] jobs = new TestJob[100];
        JobGroup jobGroup = new JobGroup("JobGroup", 10, 100);
        int[] maxThreadsUsed = new int[1];
        TestBarrier2 barrier = new TestBarrier2();
        int i = 0;
        while (i < 100) {
            jobs[i] = new TestJob("TestJob", 1000000, 1L);
            jobs[i].setJobGroup(jobGroup);
            jobs[i].schedule();
            ++i;
        }
        maxThreadsUsed[0] = 0;
        Thread t = new Thread(() -> {
            barrier.setStatus(3);
            while (jobGroup.getState() != 0) {
                ArrayList<TestJob> runningJobs = new ArrayList<TestJob>();
                for (Job activeJob : jobGroup.getActiveJobs()) {
                    if (activeJob.getState() != 4) continue;
                    runningJobs.add((TestJob)activeJob);
                }
                int runningJobsSize = runningJobs.size();
                if (runningJobsSize > maxThreadsUsed[0]) {
                    nArray[0] = runningJobsSize;
                }
                for (Job job : runningJobs) {
                    job.cancel();
                    this.waitForCompletion(job);
                }
            }
            barrier.setStatus(5);
        });
        Assert.assertEquals((String)"1.0", (long)1L, (long)jobGroup.getState());
        t.start();
        barrier.waitForStatus(3);
        barrier.waitForStatus(5);
        Assert.assertEquals((String)"2.0", (long)0L, (long)jobGroup.getState());
        Assert.assertTrue((String)"3.0", (maxThreadsUsed[0] > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"4.0", (maxThreadsUsed[0] <= 10 ? 1 : 0) != 0);
    }

    @Test
    public void testSeedJobsWhenAllJobsAreKnown() {
        int NUM_SEED_JOBS = 3;
        JobGroup jobGroup = new JobGroup("JobGroup", 1, 3);
        int i = 1;
        while (i <= 3) {
            TestJob job = new TestJob("TestJob", 1000000, 1L);
            job.setJobGroup(jobGroup);
            job.schedule();
            this.waitForStart(job);
            Assert.assertEquals((String)("1." + i), (long)1L, (long)jobGroup.getActiveJobs().size());
            Assert.assertEquals((String)("2." + i), (long)1L, (long)jobGroup.getState());
            job.cancel();
            this.waitForCompletion((Job)job);
            Assert.assertEquals((String)("3." + i), (long)0L, (long)jobGroup.getActiveJobs().size());
            if (i < 3) {
                Assert.assertEquals((String)("4." + i), (long)1L, (long)jobGroup.getState());
            } else {
                this.waitForCompletion(jobGroup);
                Assert.assertEquals((String)("4." + i), (long)0L, (long)jobGroup.getState());
            }
            ++i;
        }
    }

    @Test
    public void testSeedJobsWhenSeedJobsAddNewJobs() {
        int NUM_SEED_JOBS = 10;
        int NUM_CHILD_JOBS = 10;
        JobGroup jobGroup = new JobGroup("JobGroup", 10, 10);
        int i = 1;
        while (i <= 10) {
            Job job = new Job("SeedJob"){

                public IStatus run(IProgressMonitor monitor) {
                    int j = 0;
                    while (j < 10) {
                        TestJob childJob = new TestJob("ChildTestJob", 1000000, 1L);
                        childJob.setJobGroup(this.getJobGroup());
                        childJob.schedule();
                        ++j;
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setJobGroup(jobGroup);
            job.schedule();
            this.waitForCompletion(job);
            Assert.assertEquals((String)("1." + i), (long)10L, (long)jobGroup.getActiveJobs().size());
            Assert.assertEquals((String)("2." + i), (long)1L, (long)jobGroup.getState());
            for (Job activeJob : jobGroup.getActiveJobs()) {
                activeJob.cancel();
                this.waitForCompletion(activeJob);
            }
            Assert.assertEquals((String)("3." + i), (long)0L, (long)jobGroup.getActiveJobs().size());
            if (i < 10) {
                Assert.assertEquals((String)("4." + i), (long)1L, (long)jobGroup.getState());
            } else {
                this.waitForCompletion(jobGroup);
                Assert.assertEquals((String)("4." + i), (long)0L, (long)jobGroup.getState());
            }
            ++i;
        }
    }

    @Test
    public void testSeedJobsWithRepeatingJobs() {
        int NUM_SEED_JOBS = 10;
        int REPEATING_COUNT = 5;
        JobGroup jobGroup = new JobGroup("JobGroup", 1, 10);
        RepeatingJob[] jobs = new RepeatingJob[10];
        int i = 0;
        while (i < 10) {
            RepeatingJob job;
            jobs[i] = job = new RepeatingJob("RepeatingJob", 5);
            job.setJobGroup(jobGroup);
            job.schedule();
            ++i;
        }
        this.waitForCompletion(jobGroup);
        i = 0;
        while (i < 10) {
            Assert.assertEquals((String)("1." + i), (long)5L, (long)jobs[i].getRunCount());
            ++i;
        }
    }

    @Test
    public void testCancel() {
        int NUM_JOBS = 20;
        TestJob[] jobs = new TestJob[20];
        JobGroup firstJobGroup = new JobGroup("FirstJobGroup", 1, 10);
        JobGroup secondJobGroup = new JobGroup("SecondJobGroup", 1, 10);
        int i = 0;
        while (i < 20) {
            if (i % 2 == 0) {
                jobs[i] = new TestJob("TestFirstJobGroup", 1000000, 10L);
                jobs[i].setJobGroup(firstJobGroup);
            } else {
                jobs[i] = new TestJob("TestSecondJobGroup", 1000000, 10L);
                jobs[i].setJobGroup(secondJobGroup);
            }
            jobs[i].schedule();
            ++i;
        }
        this.waitForStart(jobs[0]);
        this.assertState("1.0", (Job)jobs[0], 4);
        this.waitForStart(jobs[1]);
        this.assertState("2.0", (Job)jobs[1], 4);
        i = 2;
        while (i < 20) {
            this.assertState("1." + i, (Job)jobs[i], 2);
            ++i;
        }
        firstJobGroup.cancel();
        this.waitForCompletion(firstJobGroup);
        this.assertState("2.0", (Job)jobs[0], 0);
        i = 2;
        while (i < 20) {
            if (jobs[i].getJobGroup() == firstJobGroup) {
                this.assertState("2." + i, (Job)jobs[i], 0);
                jobs[i].wakeUp();
                this.assertState("2." + i, (Job)jobs[i], 0);
                jobs[i].sleep();
                this.assertState("2." + i, (Job)jobs[i], 0);
            } else {
                this.assertState("3." + i, (Job)jobs[i], 2);
            }
            ++i;
        }
        secondJobGroup.cancel();
        this.waitForCompletion(secondJobGroup);
        this.assertState("7.0", (Job)jobs[1], 0);
        i = 0;
        while (i < 20) {
            this.assertState("8." + i, (Job)jobs[i], 0);
            ++i;
        }
    }

    @Test
    public void testGetActiveJobs() {
        int NUM_JOBS = 20;
        int JOBS_PER_GROUP = 4;
        TestJob[] jobs = new TestJob[20];
        JobGroup firstJobGroup = new JobGroup("FirstJobGroup", 1, 4);
        JobGroup secondJobGroup = new JobGroup("SecondJobGroup", 1, 4);
        JobGroup thirdJobGroup = new JobGroup("ThirdJobGroup", 1, 4);
        JobGroup fourthJobGroup = new JobGroup("FourthJobGrroup", 1, 4);
        JobGroup fifthJobGroup = new JobGroup("FifthJobGroup", 1, 4);
        int i = 0;
        while (i < 20) {
            switch (i % 5) {
                case 0: {
                    jobs[i] = new TestJob("TestFirstJobGroup", 1000000, 10L);
                    jobs[i].setJobGroup(firstJobGroup);
                    break;
                }
                case 1: {
                    jobs[i] = new TestJob("TestSecondJobGroup", 1000000, 10L);
                    jobs[i].setJobGroup(secondJobGroup);
                    break;
                }
                case 2: {
                    jobs[i] = new TestJob("TestThirdJobGroup", 1000000, 10L);
                    jobs[i].setJobGroup(thirdJobGroup);
                    break;
                }
                case 3: {
                    jobs[i] = new TestJob("TestFourthJobGroup", 1000000, 10L);
                    jobs[i].setJobGroup(fourthJobGroup);
                    break;
                }
                default: {
                    jobs[i] = new TestJob("TestFifthJobGroup", 1000000, 10L);
                    jobs[i].setJobGroup(fifthJobGroup);
                }
            }
            jobs[i].schedule();
            ++i;
        }
        i = 0;
        while (i < 5) {
            this.waitForStart(jobs[i]);
            ++i;
        }
        HashSet<TestJob> testJobs = new HashSet<TestJob>(Arrays.asList(jobs));
        ((ObjectArrayAssert)((ObjectArrayAssert)Assertions.assertThat((Object[])this.manager.find(null)).hasSizeGreaterThanOrEqualTo(20)).filteredOn(job -> testJobs.remove(job))).allSatisfy(job -> {
            AbstractAssert abstractAssert = Assertions.assertThat((Object)job.getJobGroup()).isIn(new Object[]{firstJobGroup, secondJobGroup, thirdJobGroup, fourthJobGroup, fifthJobGroup});
        });
        Assertions.assertThat(testJobs).isEmpty();
        ((ListAssert)Assertions.assertThat((List)firstJobGroup.getActiveJobs()).hasSize(4)).allSatisfy(it -> {
            AbstractAssert abstractAssert = Assertions.assertThat((Object)it.getJobGroup()).isEqualTo((Object)firstJobGroup);
        });
        ((ListAssert)Assertions.assertThat((List)secondJobGroup.getActiveJobs()).hasSize(4)).allSatisfy(it -> {
            AbstractAssert abstractAssert = Assertions.assertThat((Object)it.getJobGroup()).isEqualTo((Object)secondJobGroup);
        });
        ((ListAssert)Assertions.assertThat((List)thirdJobGroup.getActiveJobs()).hasSize(4)).allSatisfy(it -> {
            AbstractAssert abstractAssert = Assertions.assertThat((Object)it.getJobGroup()).isEqualTo((Object)thirdJobGroup);
        });
        ((ListAssert)Assertions.assertThat((List)fourthJobGroup.getActiveJobs()).hasSize(4)).allSatisfy(it -> {
            AbstractAssert abstractAssert = Assertions.assertThat((Object)it.getJobGroup()).isEqualTo((Object)fourthJobGroup);
        });
        ((ListAssert)Assertions.assertThat((List)fifthJobGroup.getActiveJobs()).hasSize(4)).allSatisfy(it -> {
            AbstractAssert abstractAssert = Assertions.assertThat((Object)it.getJobGroup()).isEqualTo((Object)fifthJobGroup);
        });
        int i2 = 0;
        while (i2 < 5) {
            this.assertState("7.0", (Job)jobs[i2], 4);
            ++i2;
        }
        firstJobGroup.cancel();
        this.waitForCompletion(firstJobGroup);
        Assertions.assertThat((List)firstJobGroup.getActiveJobs()).isEmpty();
        secondJobGroup.cancel();
        this.waitForCompletion(secondJobGroup);
        Assertions.assertThat((List)secondJobGroup.getActiveJobs()).isEmpty();
        fourthJobGroup.cancel();
        this.waitForCompletion(fourthJobGroup);
        Assertions.assertThat((List)fourthJobGroup.getActiveJobs()).isEmpty();
        testJobs.addAll(Arrays.asList(jobs));
        ((ObjectArrayAssert)((ObjectArrayAssert)Assertions.assertThat((Object[])this.manager.find(null)).hasSizeGreaterThanOrEqualTo(8)).filteredOn(job -> testJobs.remove(job))).allSatisfy(job -> {
            AbstractAssert abstractAssert = Assertions.assertThat((Object)job.getJobGroup()).isIn(new Object[]{thirdJobGroup, fifthJobGroup});
        });
        Assertions.assertThat(testJobs).hasSize(12);
        testJobs.clear();
        fifthJobGroup.cancel();
        this.waitForCompletion(fifthJobGroup);
        thirdJobGroup.cancel();
        this.waitForCompletion(thirdJobGroup);
        i2 = 0;
        while (i2 < 20) {
            this.assertState("12." + i2, (Job)jobs[i2], 0);
            ++i2;
        }
        testJobs.addAll(Arrays.asList(jobs));
        Assertions.assertThat((Object[])this.manager.find(null)).allMatch(job -> !testJobs.remove(job), "job is none of the ones we started");
        Assertions.assertThat(testJobs).hasSize(20);
        testJobs.clear();
    }

    @Test
    public void testJoinWithoutTimeout() {
        AtomicIntegerArray status = new AtomicIntegerArray(new int[1]);
        status.set(0, 0);
        int NUM_JOBS = 20;
        Job[] jobs = new Job[20];
        JobGroup firstJobGroup = new JobGroup("FirstJobGroup", 1, 10);
        JobGroup secondJobGroup = new JobGroup("SecondJobGroup", 1, 10);
        int i = 0;
        while (i < 20) {
            if (i % 2 == 0) {
                jobs[i] = new TestJob("TestFirstJobGroup", 1, 1L);
                jobs[i].setJobGroup(firstJobGroup);
                jobs[i].schedule(1000000L);
            } else {
                jobs[i] = new TestJob("TestSecondJobGroup", 1000000, 10L);
                jobs[i].setJobGroup(secondJobGroup);
                jobs[i].schedule();
            }
            ++i;
        }
        Thread t = new Thread(() -> {
            status.set(0, 1);
            try {
                TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)0, (int)2);
                status.set(0, 3);
                firstJobGroup.join(0L, null);
            }
            catch (InterruptedException | OperationCanceledException throwable) {
                // empty catch block
            }
            status.set(0, 5);
        });
        t.start();
        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)0, (int)1);
        status.set(0, 2);
        for (Job job : firstJobGroup.getActiveJobs()) {
            job.wakeUp();
        }
        int i2 = 0;
        while (i2 < 10000) {
            int currentStatus = status.get(0);
            List result = firstJobGroup.getActiveJobs();
            if (currentStatus == 5) {
                Assert.assertTrue((String)("1." + i2), (boolean)result.isEmpty());
                break;
            }
            this.sleep(1L);
            ++i2;
        }
        Assert.assertTrue((String)"2.0", (i2 < 10000 ? 1 : 0) != 0);
        secondJobGroup.cancel();
        this.waitForCompletion(secondJobGroup);
        int j = 0;
        while (j < 20) {
            this.assertState("3." + j, jobs[j], 0);
            ++j;
        }
    }

    @Test
    public void testJoinWithTimeout() {
        TestBarrier2 barrier = new TestBarrier2(0);
        int NUM_JOBS = 20;
        Job[] jobs = new Job[20];
        JobGroup firstJobGroup = new JobGroup("FirstJobGroup", 5, 10);
        JobGroup secondJobGroup = new JobGroup("SecondJobGroup", 5, 10);
        int i = 0;
        while (i < 20) {
            if (i % 2 == 0) {
                jobs[i] = new TestJob("TestFirstGroup", 1000000, 1L);
                jobs[i].setJobGroup(firstJobGroup);
                jobs[i].schedule();
            } else {
                jobs[i] = new TestJob("TestSecondGroup", 1000000, 1L);
                jobs[i].setJobGroup(secondJobGroup);
                jobs[i].schedule();
            }
            ++i;
        }
        long timeout = 100L;
        long[] duration = new long[]{-1L};
        Thread t = new Thread(() -> {
            try {
                long start = JobGroupTest.now();
                firstJobGroup.join(100L, null);
                lArray[0] = JobGroupTest.now() - start;
            }
            catch (InterruptedException e1) {
                Assert.fail((String)"Unexpected interrupt occurred while joining job group");
            }
            catch (OperationCanceledException e2) {
                Assert.fail((String)"Join was unexpectedly canceled");
            }
            barrier.setStatus(5);
        });
        t.start();
        barrier.waitForStatus(5);
        Assert.assertNotEquals((String)"Waiting for join to time out failed", (long)-1L, (long)duration[0]);
        Assert.assertEquals((String)"Group with long running jobs should still be active after join timed out", (long)1L, (long)firstJobGroup.getState());
        String durationAndTimoutMessage = "duration: " + duration[0] + " timeout: 100";
        Assert.assertTrue((String)("Join did not run into timeout; " + durationAndTimoutMessage), (duration[0] >= 100L ? 1 : 0) != 0);
        firstJobGroup.cancel();
        this.waitForCompletion(firstJobGroup);
        secondJobGroup.cancel();
        this.waitForCompletion(secondJobGroup);
        int j = 0;
        while (j < 20) {
            this.assertState("Job " + j, jobs[j], 0);
            ++j;
        }
    }

    @Test
    public void testJoinWithCancelingJobs() {
        AtomicIntegerArray status = new AtomicIntegerArray(new int[1]);
        status.set(0, 0);
        int NUM_JOBS = 20;
        TestJob[] jobs = new TestJob[20];
        JobGroup firstJobGroup = new JobGroup("FirstJobGroup", 1, 10);
        JobGroup secondJobGroup = new JobGroup("SecondJobGroup", 1, 10);
        int i = 0;
        while (i < 20) {
            if (i % 2 == 0) {
                jobs[i] = new TestJob("TestFirstJobGroup", 1000000, 10L);
                jobs[i].setJobGroup(firstJobGroup);
            } else {
                jobs[i] = new TestJob("TestSecondJobGroup", 1000000, 10L);
                jobs[i].setJobGroup(secondJobGroup);
            }
            jobs[i].schedule();
            ++i;
        }
        Thread t = new Thread(() -> {
            status.set(0, 1);
            try {
                TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)0, (int)2);
                status.set(0, 3);
                firstJobGroup.join(0L, null);
            }
            catch (InterruptedException | OperationCanceledException throwable) {
                // empty catch block
            }
            status.set(0, 5);
        });
        t.start();
        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)0, (int)1);
        status.set(0, 2);
        this.waitForStart(jobs[0]);
        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)0, (int)3);
        this.assertState("2.0", (Job)jobs[0], 4);
        Assert.assertEquals((String)"2.1", (long)3L, (long)status.get(0));
        firstJobGroup.cancel();
        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)0, (int)5);
        Assert.assertTrue((String)"2.2", (boolean)firstJobGroup.getActiveJobs().isEmpty());
        secondJobGroup.cancel();
        this.waitForCompletion(secondJobGroup);
        int j = 0;
        while (j < 20) {
            this.assertState("3." + j, (Job)jobs[j], 0);
            ++j;
        }
    }

    @Test
    public void testJoinWithCancelingMonitor() {
        AtomicIntegerArray status = new AtomicIntegerArray(new int[1]);
        status.set(0, 0);
        int NUM_JOBS = 20;
        TestJob[] jobs = new TestJob[20];
        FussyProgressMonitor canceler = new FussyProgressMonitor();
        JobGroup firstJobGroup = new JobGroup("FirstJobGroup", 1, 10);
        JobGroup secondJobGroup = new JobGroup("SecondJobGroup", 1, 10);
        int i = 0;
        while (i < 20) {
            if (i % 2 == 0) {
                jobs[i] = new TestJob("TestFirstJobGroup", 1000000, 10L);
                jobs[i].setJobGroup(firstJobGroup);
            } else {
                jobs[i] = new TestJob("TestSecondJobGroup", 1000000, 10L);
                jobs[i].setJobGroup(secondJobGroup);
            }
            jobs[i].schedule();
            ++i;
        }
        Thread t = new Thread(() -> JobGroupTest.lambda$14(status, firstJobGroup, (IProgressMonitor)canceler));
        t.start();
        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)0, (int)1);
        status.set(0, 2);
        this.waitForStart(jobs[0]);
        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)0, (int)3);
        this.assertState("2.0", (Job)jobs[0], 4);
        Assert.assertEquals((String)"2.1", (long)3L, (long)status.get(0));
        canceler.setCanceled(true);
        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)0, (int)5);
        this.assertState("2.2", (Job)jobs[0], 4);
        Assert.assertEquals((String)"2.3", (long)5L, (long)status.get(0));
        Assert.assertFalse((String)"2.4", (boolean)firstJobGroup.getActiveJobs().isEmpty());
        secondJobGroup.cancel();
        this.waitForCompletion(secondJobGroup);
        firstJobGroup.cancel();
        this.waitForCompletion(firstJobGroup);
        int j = 0;
        while (j < 20) {
            this.assertState("3." + j, (Job)jobs[j], 0);
            ++j;
        }
    }

    @Test
    public void testJoinWithRepeatingJobs() throws OperationCanceledException, InterruptedException {
        JobGroup jobGroup = new JobGroup("JobGroup", 1, 1);
        int count = 25;
        RepeatingJob job = new RepeatingJob("RepeatingJob", count);
        job.setJobGroup(jobGroup);
        job.schedule();
        jobGroup.join(0L, null);
        Assert.assertEquals((String)"1.2", (long)count, (long)job.getRunCount());
    }

    @Test
    public void testJoiningAJobInTheSameJobGroupFails() {
        JobGroup jobGroup = new JobGroup("JobGroup", 2, 2);
        final TestJob firstJob = new TestJob("FirstJob", 1000000, 10L);
        firstJob.setJobGroup(jobGroup);
        firstJob.schedule();
        this.waitForStart(firstJob);
        final boolean[] joinFailed = new boolean[1];
        Job secondJob = new Job("SecondJob"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    firstJob.join();
                }
                catch (InterruptedException interruptedException) {
                }
                catch (IllegalStateException ise) {
                    joinFailed[0] = true;
                }
                return Status.OK_STATUS;
            }
        };
        secondJob.setJobGroup(jobGroup);
        secondJob.schedule();
        this.waitForCompletion(secondJob);
        Assert.assertTrue((String)"1.0", (boolean)joinFailed[0]);
        firstJob.cancel();
        this.waitForCompletion(jobGroup);
    }

    @Test
    public void testJoinWithProgressMonitor() {
        int NUM_JOBS = 100;
        JobGroup jobGroup = new JobGroup("JobGroup", 10, 100);
        final TestBarrier2 barrier = new TestBarrier2();
        int i = 0;
        while (i < 100) {
            TestJob testJob = new TestJob("TestJob", 1, 10L){

                public IStatus run(IProgressMonitor monitor) {
                    barrier.waitForStatus(1);
                    return super.run(monitor);
                }
            };
            testJob.setJobGroup(jobGroup);
            testJob.schedule();
            ++i;
        }
        FussyProgressMonitor monitor = new FussyProgressMonitor();
        barrier.setStatus(1);
        try {
            jobGroup.join(0L, (IProgressMonitor)monitor);
        }
        catch (InterruptedException | OperationCanceledException throwable) {
            // empty catch block
        }
        monitor.sanityCheck();
        monitor.assertUsedUp();
    }

    @Test
    public void testJoinIfJobCoundExceedsSeedCount() throws Exception {
        class ExclusiveRule
        implements ISchedulingRule {
            ExclusiveRule() {
            }

            public boolean contains(ISchedulingRule rule) {
                return this.isConflicting(rule);
            }

            public boolean isConflicting(ISchedulingRule rule) {
                return rule instanceof ExclusiveRule;
            }
        }
        ExclusiveRule rule = new ExclusiveRule();
        int SEED_JOBS = 2;
        final AtomicLong count = new AtomicLong(0L);
        JobGroup jobGroup = new JobGroup("JobGroup", 2, 2);
        int i = 0;
        while (i < 2) {
            TestJob testJob = new TestJob("TestJob", 0, 0L){

                public IStatus run(IProgressMonitor monitor) {
                    return new Status(1, "hello", "" + count.incrementAndGet());
                }
            };
            testJob.setRule((ISchedulingRule)rule);
            testJob.setJobGroup(jobGroup);
            testJob.schedule();
            ++i;
        }
        jobGroup.join(0L, null);
        Object[] children = jobGroup.getResult().getChildren();
        Assertions.assertThat((Object[])children).hasSize(2);
        Integer[] results = (Integer[])Arrays.stream(children).map(s -> Integer.valueOf(s.getMessage())).toArray(Integer[]::new);
        int i2 = 0;
        while (i2 < results.length) {
            Assert.assertEquals((String)"Job result in unexpected order", (long)(i2 + 1), (long)results[i2].intValue());
            ++i2;
        }
        TestJob testJob = new TestJob("TestJob", 1, 10L){

            public IStatus run(IProgressMonitor monitor) {
                return new Status(1, "hello", "" + count.incrementAndGet());
            }
        };
        testJob.setRule((ISchedulingRule)rule);
        testJob.setJobGroup(jobGroup);
        testJob.schedule();
        FussyProgressMonitor monitor = new FussyProgressMonitor();
        jobGroup.join(0L, (IProgressMonitor)monitor);
        children = jobGroup.getResult().getChildren();
        Assertions.assertThat((Object[])children).hasSize(3);
        results = (Integer[])Arrays.stream(children).map(s -> Integer.valueOf(s.getMessage())).toArray(Integer[]::new);
        int i3 = 0;
        while (i3 < results.length) {
            Assert.assertEquals((String)"Job result in unexpected order", (long)(i3 + 1), (long)results[i3].intValue());
            ++i3;
        }
        monitor.sanityCheck();
        monitor.assertUsedUp();
        testJob.setJobGroup(jobGroup);
        testJob.schedule();
        monitor = new FussyProgressMonitor();
        jobGroup.join(0L, (IProgressMonitor)monitor);
        children = jobGroup.getResult().getChildren();
        Assertions.assertThat((Object[])children).hasSize(4);
        results = (Integer[])Arrays.stream(children).map(s -> Integer.valueOf(s.getMessage())).toArray(Integer[]::new);
        i3 = 0;
        while (i3 < results.length) {
            Assert.assertEquals((String)"Job result in unexpected order", (long)(i3 + 1), (long)results[i3].intValue());
            ++i3;
        }
        monitor.sanityCheck();
        monitor.assertUsedUp();
    }

    @Test
    public void testJoinWithJobManagerSuspended_1() throws InterruptedException {
        final JobGroup jobGroup = new JobGroup("JobGroup", 1, 1);
        final TestBarrier2 barrier = new TestBarrier2();
        final int[] groupJobsCount = new int[]{-1};
        final TestJob waiting = new TestJob("WaitingJob", 1000000, 1L);
        waiting.setJobGroup(jobGroup);
        final TestJob running = new TestJob("RunningJob", 2, 1L);
        running.setJobGroup(jobGroup);
        Job job = new Job("MainJob"){

            protected IStatus run(IProgressMonitor monitor) {
                block11: {
                    barrier.setStatus(1);
                    try {
                        try {
                            running.schedule();
                            JobGroupTest.this.waitForStart(running);
                            manager.suspend();
                            waiting.schedule();
                            running.join();
                            jobGroup.join(0L, null);
                            groupJobsCount[0] = jobGroup.getActiveJobs().size();
                        }
                        catch (InterruptedException interruptedException) {
                            waiting.cancel();
                            try {
                                waiting.join();
                            }
                            catch (InterruptedException interruptedException2) {
                                // empty catch block
                            }
                            manager.resume();
                            break block11;
                        }
                    }
                    catch (Throwable throwable) {
                        waiting.cancel();
                        try {
                            waiting.join();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        manager.resume();
                        throw throwable;
                    }
                    waiting.cancel();
                    try {
                        waiting.join();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    manager.resume();
                }
                barrier.setStatus(5);
                return Status.OK_STATUS;
            }
        };
        try {
            try {
                job.schedule();
                barrier.waitForStatus(5);
                Assert.assertEquals((long)1L, (long)groupJobsCount[0]);
            }
            catch (AssertionFailedError e) {
                Thread thread = job.getThread();
                if (thread != null) {
                    thread.interrupt();
                }
                throw e;
            }
        }
        finally {
            job.join();
        }
    }

    @Test
    public void testJoinWithJobManagerSuspended_2() throws InterruptedException {
        final JobGroup jobGroup = new JobGroup("JobGroup", 1, 1);
        final TestBarrier2 barrier = new TestBarrier2();
        final int[] groupJobsCount = new int[]{-1};
        final TestJob waiting = new TestJob("WaitingJob", 1000000, 10L);
        waiting.setJobGroup(jobGroup);
        final TestJob running = new TestJob("RunningJob", 1000000, 10L);
        running.setJobGroup(jobGroup);
        final Thread t = new Thread(() -> {
            barrier.setStatus(3);
            try {
                jobGroup.join(0L, null);
            }
            catch (InterruptedException | OperationCanceledException throwable) {
                // empty catch block
            }
            barrier.setStatus(4);
        });
        Job job = new Job("MainJob"){

            protected IStatus run(IProgressMonitor monitor) {
                barrier.setStatus(1);
                try {
                    running.schedule();
                    JobGroupTest.this.waitForStart(running);
                    t.start();
                    barrier.waitForStatus(3);
                    manager.suspend();
                    waiting.schedule();
                    running.cancel();
                    barrier.waitForStatus(4);
                    groupJobsCount[0] = jobGroup.getActiveJobs().size();
                    barrier.setStatus(5);
                }
                finally {
                    waiting.cancel();
                    try {
                        waiting.join();
                    }
                    catch (InterruptedException interruptedException) {}
                    manager.resume();
                }
                return Status.OK_STATUS;
            }
        };
        try {
            try {
                job.schedule();
                barrier.waitForStatus(5);
                Assert.assertEquals((long)1L, (long)groupJobsCount[0]);
            }
            catch (AssertionFailedError e) {
                Thread thread = job.getThread();
                if (thread != null) {
                    thread.interrupt();
                }
                throw e;
            }
        }
        finally {
            job.join();
        }
    }

    @Test
    public void testJoinWithJobManagerSuspended_3() throws InterruptedException {
        final JobGroup jobGroup = new JobGroup("JobGroup", 1, 1);
        final TestBarrier2 barrier = new TestBarrier2();
        final int[] groupJobsCount = new int[]{-1};
        final TestJob waiting = new TestJob("waiting job", 1000000, 10L);
        waiting.setJobGroup(jobGroup);
        final TestJob running = new TestJob("running job", 1000000, 10L);
        running.setJobGroup(jobGroup);
        final Thread t = new Thread(() -> {
            barrier.setStatus(3);
            try {
                jobGroup.join(0L, null);
            }
            catch (InterruptedException | OperationCanceledException throwable) {
                // empty catch block
            }
            barrier.setStatus(4);
        });
        Job job = new Job("MainJob"){

            protected IStatus run(IProgressMonitor monitor) {
                barrier.setStatus(1);
                running.schedule();
                JobGroupTest.this.waitForStart(running);
                t.start();
                barrier.waitForStatus(3);
                manager.suspend();
                waiting.schedule();
                manager.resume();
                running.cancel();
                JobGroupTest.this.waitForStart(waiting);
                waiting.cancel();
                barrier.waitForStatus(4);
                groupJobsCount[0] = jobGroup.getActiveJobs().size();
                barrier.setStatus(5);
                return Status.OK_STATUS;
            }
        };
        try {
            try {
                job.schedule();
                barrier.waitForStatus(5);
                Assert.assertEquals((long)0L, (long)groupJobsCount[0]);
            }
            catch (AssertionFailedError e) {
                Thread thread = job.getThread();
                if (thread != null) {
                    thread.interrupt();
                }
                throw e;
            }
        }
        finally {
            job.join();
        }
    }

    @Test
    public void testShouldCancel_1() {
        Job failedJob;
        int NUM_SEED_JOBS = 10;
        int NUM_ADDITIONAL_JOBs = 10;
        Job[] jobs = new Job[20];
        JobGroup jobGroup = new JobGroup("JobGroup", 10, 10);
        int i = 0;
        while (i < 9) {
            TestJob job = new TestJob("TestJob", 1000000, 1L);
            jobs[i] = job;
            job.setJobGroup(jobGroup);
            job.schedule();
            this.waitForStart(job);
            ++i;
        }
        Assert.assertEquals((String)"1.0", (long)1L, (long)jobGroup.getState());
        Assert.assertEquals((String)"1.1", (long)9L, (long)jobGroup.getActiveJobs().size());
        i = 0;
        while (i < 9) {
            this.assertState("2." + i, jobs[i], 4);
            ++i;
        }
        final TestBarrier2 barrier = new TestBarrier2();
        jobs[9] = failedJob = new Job("FailedJob"){

            protected IStatus run(IProgressMonitor monitor) {
                barrier.setStatus(2);
                barrier.waitForStatus(3);
                return new Status(4, "org.eclipse.core.jobs", "Error");
            }
        };
        failedJob.setJobGroup(jobGroup);
        failedJob.schedule();
        barrier.waitForStatus(2);
        Assert.assertEquals((String)"3.0", (long)10L, (long)jobGroup.getActiveJobs().size());
        this.assertState("3.1", failedJob, 4);
        int i2 = 10;
        while (i2 < 20) {
            TestJob job = new TestJob("AdditionalJob", 1000000, 1L);
            jobs[i2] = job;
            job.setJobGroup(jobGroup);
            job.schedule();
            ++i2;
        }
        Assert.assertEquals((String)"4.0", (long)20L, (long)jobGroup.getActiveJobs().size());
        i2 = 10;
        while (i2 < 20) {
            this.assertState("5." + i2, jobs[i2], 2);
            ++i2;
        }
        barrier.setStatus(3);
        this.waitForCompletion(jobGroup);
        i2 = 0;
        while (i2 < 20) {
            this.assertState("6." + i2, jobs[i2], 0);
            if (i2 < 9) {
                Assert.assertEquals((String)("6." + i2), (long)8L, (long)jobs[i2].getResult().getSeverity());
            } else if (i2 == 9) {
                Assert.assertEquals((String)("6." + i2), (long)4L, (long)jobs[i2].getResult().getSeverity());
            } else if (i2 == 10) {
                IStatus result = jobs[i2].getResult();
                if (result != null) {
                    Assert.assertEquals((String)("6." + i2), (long)8L, (long)result.getSeverity());
                }
            } else {
                Assert.assertNull((String)("6." + i2), (Object)jobs[i2].getResult());
            }
            ++i2;
        }
    }

    @Test
    public void testShouldCancel_2() {
        int NUM_JOBS = 10;
        final int[] numShouldCancelCalled = new int[1];
        JobGroup jobGroup = new JobGroup("JobGroup", 1, 10){

            protected boolean shouldCancel(IStatus lastCompletedJobResult, int numberOfFailedJobs, int numberOfCanceledJobs) {
                numShouldCancelCalled[0] = numShouldCancelCalled[0] + 1;
                return super.shouldCancel(lastCompletedJobResult, numberOfFailedJobs, numberOfCanceledJobs);
            }
        };
        int i = 0;
        while (i < 10) {
            TestJob job = new TestJob("TestJob", 1, 1L);
            job.setJobGroup(jobGroup);
            job.schedule();
            ++i;
        }
        this.waitForCompletion(jobGroup);
        Assert.assertEquals((String)"1.0", (long)9L, (long)numShouldCancelCalled[0]);
    }

    @Test
    public void testShouldCancel_3() {
        int[] nArray = new int[6];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 4;
        nArray[4] = 8;
        final int[] status = nArray;
        final int[] numShouldCancelCalled = new int[1];
        final int[] failedJobsCount = new int[1];
        final int[] canceledJobsCount = new int[1];
        Status[] completedJobResult = new Status[1];
        TestBarrier2 barrier = new TestBarrier2();
        JobGroup jobGroup = new JobGroup("JobGroup", 1, status.length, (IStatus[])completedJobResult, barrier){
            private final /* synthetic */ IStatus[] val$completedJobResult;
            private final /* synthetic */ TestBarrier2 val$barrier;
            {
                this.val$completedJobResult = iStatusArray;
                this.val$barrier = testBarrier2;
                super($anonymous0, $anonymous1, $anonymous2);
            }

            protected boolean shouldCancel(IStatus lastCompletedJobResult, int numberOfFailedJobs, int numberOfCanceledJobs) {
                numShouldCancelCalled[0] = numShouldCancelCalled[0] + 1;
                failedJobsCount[0] = numberOfFailedJobs;
                canceledJobsCount[0] = numberOfCanceledJobs;
                this.val$completedJobResult[0] = lastCompletedJobResult;
                this.val$barrier.setStatus(5);
                return false;
            }
        };
        int i = 0;
        while (i < status.length) {
            final int jobNumber = i;
            final IStatus[] returnedStatus = new IStatus[1];
            TestJob job = new TestJob("TestJob", 1, 1L){

                public IStatus run(IProgressMonitor monitor) {
                    super.run(monitor);
                    returnedStatus[0] = new Status(status[jobNumber], "org.eclipse.core.jobs", "Job " + jobNumber);
                    return returnedStatus[0];
                }
            };
            job.setJobGroup(jobGroup);
            barrier.setStatus(4);
            job.schedule();
            if (i != status.length - 1) {
                barrier.waitForStatus(5);
                Assert.assertEquals((String)("1." + i), (long)(i + 1), (long)numShouldCancelCalled[0]);
                Assert.assertEquals((String)("2." + i), (Object)returnedStatus[0], (Object)completedJobResult[0]);
                if (i < 3) {
                    Assert.assertEquals((String)("3." + i), (long)0L, (long)failedJobsCount[0]);
                } else {
                    Assert.assertEquals((String)("3." + i), (long)1L, (long)failedJobsCount[0]);
                }
                if (i < 4) {
                    Assert.assertEquals((String)("4." + i), (long)0L, (long)canceledJobsCount[0]);
                } else {
                    Assert.assertEquals((String)("4." + i), (long)1L, (long)canceledJobsCount[0]);
                }
            }
            ++i;
        }
        this.waitForCompletion(jobGroup);
    }

    @Test
    public void testShouldCancel_4() {
        int NUM_JOBS = 1000;
        int NUM_JOBS_LIMIT = 100;
        final int[] numShouldCancelCalled = new int[1];
        final TestBarrier2 barrier = new TestBarrier2();
        JobGroup jobGroup = new JobGroup("JobGroup", 10, 1000){

            protected boolean shouldCancel(IStatus lastCompletedJobResult, int numberOfFailedJobs, int numberOfCanceledJobs) {
                numShouldCancelCalled[0] = numShouldCancelCalled[0] + 1;
                return numShouldCancelCalled[0] == 100;
            }
        };
        int i = 0;
        while (i < 1000) {
            final int jobNumber = i++;
            TestJob job = new TestJob("TestJob", 1, 1L){

                public IStatus run(IProgressMonitor monitor) {
                    barrier.waitForStatus(1);
                    super.run(monitor);
                    return new Status(1, "org.eclipse.core.jobs", "Job " + jobNumber);
                }
            };
            job.setJobGroup(jobGroup);
            job.schedule();
        }
        barrier.setStatus(1);
        this.waitForCompletion(jobGroup);
        Assert.assertTrue((String)"1.0", (numShouldCancelCalled[0] >= 100 ? 1 : 0) != 0);
        Assert.assertTrue((String)"2.0", (numShouldCancelCalled[0] < 110 ? 1 : 0) != 0);
    }

    @Test
    public void testShouldCancel_5() {
        JobGroup jobGroup = new JobGroup("JobGroup", 2, 2){

            protected boolean shouldCancel(IStatus lastCompletedJobResult, int numberOfFailedJobs, int numberOfCanceledJobs) {
                return numberOfCanceledJobs > 0;
            }
        };
        final TestBarrier2 returnsCancelStatusBarrier = new TestBarrier2();
        final TestBarrier2 canceledJobBarrier = new TestBarrier2();
        Job returnsCancelStatusJob = Job.create((String)"The one that cancels", __ -> {
            returnsCancelStatusBarrier.setStatus(3);
            canceledJobBarrier.waitForStatus(3);
            return Status.CANCEL_STATUS;
        });
        Job canceledJob = new Job("The one that is explicitly canceled"){

            protected IStatus run(IProgressMonitor monitor) {
                canceledJobBarrier.setStatus(3);
                returnsCancelStatusBarrier.waitForStatus(3);
                canceledJobBarrier.waitForStatus(5);
                return Status.OK_STATUS;
            }

            protected void canceling() {
                canceledJobBarrier.setStatus(5);
            }
        };
        returnsCancelStatusJob.setJobGroup(jobGroup);
        returnsCancelStatusJob.schedule();
        canceledJob.setJobGroup(jobGroup);
        canceledJob.schedule();
        canceledJobBarrier.waitForStatus(5);
        this.waitForCompletion(jobGroup);
    }

    @Test
    public void testDefaultComputeGroupResult() {
        int[] nArray = new int[5];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 4;
        nArray[4] = 8;
        final int[] status = nArray;
        JobGroup jobGroup = new JobGroup("JobGroup", 1, status.length){

            protected boolean shouldCancel(IStatus lastCompletedJobResult, int numberOfFailedJobs, int numberOfCanceledJobs) {
                return false;
            }
        };
        int i = 0;
        while (i < status.length) {
            final int jobNumber = i++;
            TestJob job = new TestJob("TestJob", 10, 10L){

                public IStatus run(IProgressMonitor monitor) {
                    super.run(monitor);
                    return new Status(status[jobNumber], "org.eclipse.core.jobs", "Job " + jobNumber);
                }
            };
            job.setJobGroup(jobGroup);
            job.schedule();
        }
        this.waitForCompletion(jobGroup);
        Object[] jobResults = jobGroup.getResult().getChildren();
        Assertions.assertThat((Object[])jobResults).hasSize(status.length - 1);
        int i2 = 1;
        while (i2 < status.length) {
            Assert.assertEquals((String)("2." + i2), (long)status[i2], (long)jobResults[i2 - 1].getSeverity());
            ++i2;
        }
    }

    @Test
    public void testCustomComputeGroupResult() {
        final MultiStatus[] returnedGroupResult = new MultiStatus[1];
        final IStatus[][] originalJobResults = new IStatus[][]{new IStatus[0]};
        int[] nArray = new int[5];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 4;
        nArray[4] = 8;
        final int[] status = nArray;
        JobGroup jobGroup = new JobGroup("group", 1, status.length){

            protected boolean shouldCancel(IStatus lastCompletedJobResult, int numberOfFailedJobs, int numberOfCanceledJobs) {
                return false;
            }

            protected MultiStatus computeGroupResult(List<IStatus> jobResults) {
                originalJobResults[0] = jobResults.toArray(new IStatus[jobResults.size()]);
                returnedGroupResult[0] = new MultiStatus("org.eclipse.core.jobs", 0, new IStatus[0], "custom result", null);
                return returnedGroupResult[0];
            }
        };
        int i = 0;
        while (i < status.length) {
            final int jobNumber = i++;
            TestJob job = new TestJob("TestJob", 10, 10L){

                public IStatus run(IProgressMonitor monitor) {
                    super.run(monitor);
                    return new Status(status[jobNumber], "org.eclipse.core.jobs", "Job " + jobNumber);
                }
            };
            job.setJobGroup(jobGroup);
            job.schedule();
        }
        this.waitForCompletion(jobGroup);
        Assertions.assertThat((Object[])originalJobResults[0]).hasSameSizeAs((Object)status);
        i = 0;
        while (i < status.length) {
            Assert.assertEquals((String)("3." + i), (long)status[i], (long)originalJobResults[0][i].getSeverity());
            ++i;
        }
        Assert.assertEquals((String)"4.0", (Object)returnedGroupResult[0], (Object)jobGroup.getResult());
    }

    @Test
    public void testSlowComputeGroupResult() throws Exception {
        JobGroup jobGroup = new JobGroup("group", 1, 1){

            protected MultiStatus computeGroupResult(List<IStatus> jobResults) {
                JobGroupTest.this.sleep(500L);
                return new MultiStatus("org.eclipse.core.jobs", 0, new IStatus[0], "custom result", null);
            }
        };
        Job job = new Job("TestJob"){

            public IStatus run(IProgressMonitor monitor) {
                return Status.OK_STATUS;
            }
        };
        job.setJobGroup(jobGroup);
        job.schedule();
        this.waitForCompletion(job, Duration.ofMillis(100L));
        boolean completed = jobGroup.join(1000L, null);
        Assert.assertTrue((String)"2.0", (boolean)completed);
        MultiStatus result = jobGroup.getResult();
        Assert.assertNotNull((String)"3.0", (Object)result);
    }

    @Test
    public void testJobGroupAlongWithNormalJobs() {
        int NUM_GROUP_JOBS = 1000;
        int NUM_NORMAL_JOBS = 100;
        JobGroup jobGroup = new JobGroup("JobGroup", 1, 1000);
        int i = 0;
        while (i < 1000) {
            TestJob testJob = new TestJob("GroupJob", 1000000, 10L);
            testJob.setJobGroup(jobGroup);
            testJob.schedule();
            ++i;
        }
        Assert.assertEquals((String)"1.0", (long)1L, (long)jobGroup.getState());
        Assert.assertEquals((String)"2.0", (long)1000L, (long)jobGroup.getActiveJobs().size());
        TestJob[] normalJobs = new TestJob[100];
        int i2 = 0;
        while (i2 < 100) {
            TestJob testJob;
            normalJobs[i2] = testJob = new TestJob("NormalJob", 10, 10L);
            testJob.schedule();
            ++i2;
        }
        i2 = 0;
        while (i2 < 100) {
            this.waitForCompletion((Job)normalJobs[i2]);
            ++i2;
        }
        Assert.assertEquals((String)"3.0", (long)1L, (long)jobGroup.getState());
        Assert.assertEquals((String)"4.0", (long)1000L, (long)jobGroup.getActiveJobs().size());
        jobGroup.cancel();
        this.waitForCompletion(jobGroup);
    }

    @Test
    public void testJobManagerPublishesJobGroupResults() throws InterruptedException {
        int NUM_GROUP_JOBS = 3;
        String GROUP_NAME = "TestJobGroup";
        final JobGroup jobGroup = new JobGroup("TestJobGroup", 1, 3);
        final ConcurrentLinkedQueue eventQueue = new ConcurrentLinkedQueue();
        JobChangeAdapter listener = new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getJob().getJobGroup() == jobGroup) {
                    eventQueue.add(event);
                }
            }
        };
        this.manager.addJobChangeListener((IJobChangeListener)listener);
        try {
            int i = 0;
            while (i < 3) {
                TestJob testJob = new TestJob("GroupJob", 10, 1L);
                testJob.setJobGroup(jobGroup);
                testJob.schedule();
                ++i;
            }
            this.waitForCompletion(jobGroup);
            i = 0;
            while (i < 1000 && eventQueue.size() < 3) {
                Thread.sleep(1L);
                ++i;
            }
            ArrayList events = new ArrayList();
            eventQueue.forEach(events::add);
            Assert.assertEquals((String)"Should have seen as many job completion events as the count of jobs in the job group.", (long)3L, (long)events.size());
            int i2 = 0;
            while (i2 < 3) {
                IJobChangeEvent event = (IJobChangeEvent)events.get(i2);
                Assert.assertNotNull((String)"All job completion events should have a job status.", (Object)event.getResult());
                if (i2 < 2) {
                    Assert.assertNull((String)"Only the last job competion event shoud have a job group status.", (Object)event.getJobGroupResult());
                } else {
                    Assert.assertNotNull((String)"The last job competion event shoud have a job group status.", (Object)event.getJobGroupResult());
                }
                ++i2;
            }
        }
        finally {
            this.manager.removeJobChangeListener((IJobChangeListener)listener);
        }
    }

    private void assertState(String msg, Job job, int expectedState) {
        int actualState = job.getState();
        Assert.assertSame((String)(msg + ": expected state: " + this.printState(expectedState) + " actual state: " + this.printState(actualState)), (Object)actualState, (Object)expectedState);
    }

    private String printState(int state) {
        switch (state) {
            case 0: {
                return "NONE";
            }
            case 2: {
                return "WAITING";
            }
            case 1: {
                return "SLEEPING";
            }
            case 4: {
                return "RUNNING";
            }
        }
        return "UNKNOWN";
    }

    private void waitForStart(TestJob job) {
        int i = 0;
        while (job.getRunCount() < 1) {
            Thread.yield();
            this.sleep(100L);
            Thread.yield();
            if (i++ < 100) continue;
            this.dumpState();
            Assert.fail((String)("Timeout waiting for job to start. Job: " + String.valueOf(job) + ", state: " + job.getState()));
        }
    }

    private void waitForCompletion(JobGroup jobGroup) {
        int i = 0;
        while (jobGroup.getState() != 0) {
            Thread.yield();
            this.sleep(1L);
            Thread.yield();
            if (i++ < 10000) continue;
            this.dumpState();
            Assert.fail((String)("Timeout waiting for job group " + jobGroup.getName() + " to be completed"));
        }
    }

    private static /* synthetic */ void lambda$14(AtomicIntegerArray atomicIntegerArray, JobGroup jobGroup, IProgressMonitor iProgressMonitor) {
        atomicIntegerArray.set(0, 1);
        try {
            TestBarrier2.waitForStatus((AtomicIntegerArray)atomicIntegerArray, (int)0, (int)2);
            atomicIntegerArray.set(0, 3);
            jobGroup.join(0L, iProgressMonitor);
        }
        catch (InterruptedException | OperationCanceledException throwable) {
            // empty catch block
        }
        atomicIntegerArray.set(0, 5);
    }
}

