/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.runtime.jobs;

import org.eclipse.core.internal.jobs.InternalJob;
import org.eclipse.core.internal.jobs.JobQueue;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.junit.Assert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class JobQueueTest {
    private JobQueue queue;

    @BeforeEach
    public void setUp() throws Exception {
        this.queue = new JobQueue(false);
    }

    @Test
    public void testEqualValues() {
        int NUM_ENTRIES = 10;
        Entry[] entries = new Entry[10];
        int i = 0;
        while (i < entries.length) {
            entries[i] = new Entry(30);
            this.queue.enqueue((InternalJob)entries[i]);
            Assert.assertEquals((String)("1.0." + i), (Object)((Object)entries[0]), (Object)this.queue.peek());
            ++i;
        }
        i = 0;
        while (i < entries.length) {
            Assert.assertEquals((String)("2.0." + i), (Object)((Object)entries[i]), (Object)this.queue.dequeue());
            ++i;
        }
    }

    @Test
    public void testBasic() {
        Entry[] entries = this.createEntries();
        Assert.assertTrue((String)"1.0", (boolean)this.queue.isEmpty());
        Assert.assertNull((String)"1.1", (Object)this.queue.dequeue());
        Assert.assertNull((String)"1.2", (Object)this.queue.peek());
        Entry[] entryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            Entry entry = entryArray[n2];
            this.queue.enqueue((InternalJob)entry);
            Assert.assertNotNull((String)"1.3", (Object)this.queue.peek());
            ++n2;
        }
        int i = 0;
        while (i < entries.length) {
            this.queue.remove((InternalJob)entries[i]);
            if (i + 1 < entries.length) {
                Assert.assertNotNull((String)("1.4." + i), (Object)this.queue.peek());
            }
            ++i;
        }
        Assert.assertTrue((String)"2.0", (boolean)this.queue.isEmpty());
        Assert.assertNull((String)"2.1", (Object)this.queue.dequeue());
        Assert.assertNull((String)"2.2", (Object)this.queue.peek());
        entryArray = entries;
        n = entries.length;
        n2 = 0;
        while (n2 < n) {
            Entry entry = entryArray[n2];
            this.queue.enqueue((InternalJob)entry);
            ++n2;
        }
        int count = entries.length;
        while (!this.queue.isEmpty()) {
            InternalJob peek = this.queue.peek();
            InternalJob removed = this.queue.dequeue();
            Assert.assertEquals((String)("3.0." + count), (Object)peek, (Object)removed);
            --count;
        }
        Assert.assertEquals((String)"3.1", (long)0L, (long)count);
    }

    private Entry[] createEntries() {
        return new Entry[]{new Entry(10), new Entry(40), new Entry(10), new Entry(20), new Entry(50), new Entry(30), new Entry(20), new Entry(40), new Entry(30), new Entry(50)};
    }

    class Entry
    extends InternalJob {
        Entry(int value) {
            super("Entry");
            this.setPriority(value);
        }

        protected IStatus run(IProgressMonitor monitor) {
            return Status.OK_STATUS;
        }
    }
}

