/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.runtime.jobs;

import java.util.concurrent.atomic.AtomicIntegerArray;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.tests.harness.TestBarrier2;
import org.eclipse.core.tests.runtime.jobs.TestBlockingMonitor;

class JobRuleRunner
extends Job {
    private final ISchedulingRule rule;
    private final TestBarrier2 barrier;
    private final int numRepeats;
    private final boolean reportBlocking;

    public JobRuleRunner(String name, ISchedulingRule rule, AtomicIntegerArray status, int index, int numRepeats, boolean reportBlocking) {
        this(name, rule, new TestBarrier2(status, index), numRepeats, reportBlocking);
    }

    public JobRuleRunner(String name, ISchedulingRule rule, TestBarrier2 barrier, int numRepeats, boolean reportBlocking) {
        super(name);
        this.rule = rule;
        this.barrier = barrier;
        this.numRepeats = numRepeats;
        this.reportBlocking = reportBlocking;
    }

    public JobRuleRunner(String name, ISchedulingRule rule, TestBarrier2 barrier) {
        this(name, rule, barrier, 1, false);
    }

    protected IStatus run(IProgressMonitor monitor) {
        monitor.beginTask(this.getName(), this.numRepeats);
        try {
            this.barrier.setStatus(1);
            int i = 0;
            while (i < this.numRepeats) {
                monitor.worked(1);
                this.barrier.waitForStatusNoFail(2);
                TestBlockingMonitor bMonitor = null;
                if (this.reportBlocking) {
                    bMonitor = new TestBlockingMonitor(this.barrier);
                }
                manager.beginRule(this.rule, bMonitor);
                this.barrier.setStatus(3);
                if (monitor.isCanceled()) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                this.barrier.waitForStatusNoFail(4);
                manager.endRule(this.rule);
                this.barrier.setStatus(5);
                Thread.yield();
                ++i;
            }
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }
}

