/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.runtime.jobs;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectArrayAssert;
import org.assertj.core.api.ObjectAssert;
import org.eclipse.core.internal.jobs.InternalJob;
import org.eclipse.core.internal.jobs.JobListeners;
import org.eclipse.core.internal.jobs.JobManager;
import org.eclipse.core.internal.jobs.Worker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.core.runtime.jobs.LockListener;
import org.eclipse.core.tests.harness.FussyProgressMonitor;
import org.eclipse.core.tests.harness.TestBarrier2;
import org.eclipse.core.tests.harness.TestJob;
import org.eclipse.core.tests.runtime.jobs.AbstractJobTest;
import org.eclipse.core.tests.runtime.jobs.AsynchExecThread;
import org.eclipse.core.tests.runtime.jobs.AsynchTestJob;
import org.eclipse.core.tests.runtime.jobs.IdentityRule;
import org.eclipse.core.tests.runtime.jobs.PathRule;
import org.eclipse.core.tests.runtime.jobs.TestLockListener;
import org.junit.Assert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class JobTest
extends AbstractJobTest {
    protected Job longJob;
    protected Job shortJob;

    @Test
    @Disabled(value="see bug 43591")
    public void testDone() {
        this.shortJob.done(Status.OK_STATUS);
        Assert.assertTrue((String)"1.0", (this.shortJob.getResult() == null ? 1 : 0) != 0);
        this.shortJob.done(Status.CANCEL_STATUS);
        Assert.assertTrue((String)"2.0", (this.shortJob.getResult() == null ? 1 : 0) != 0);
        this.shortJob.schedule();
        this.shortJob.done(Status.CANCEL_STATUS);
        this.waitForState(this.shortJob, 0);
        Assert.assertTrue((String)"3.0", (this.shortJob.getResult().getSeverity() == 0 ? 1 : 0) != 0);
        this.shortJob.done(Status.CANCEL_STATUS);
        Assert.assertTrue((String)"4.0", (this.shortJob.getResult().getSeverity() == 0 ? 1 : 0) != 0);
        this.longJob.schedule();
        this.waitForState(this.longJob, 4);
        this.longJob.done(Status.OK_STATUS);
        this.longJob.cancel();
        this.waitForState(this.longJob, 0);
        Assert.assertEquals((String)"5.0", (long)8L, (long)this.longJob.getResult().getSeverity());
        this.longJob.done(Status.OK_STATUS);
        Assert.assertEquals((String)"6.0", (long)8L, (long)this.longJob.getResult().getSeverity());
    }

    private void cancel(Job[] jobs) {
        Job[] jobArray = jobs;
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            Job job = jobArray[n2];
            job.cancel();
            ++n2;
        }
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.shortJob = new TestJob("Short Test Job", 10, 1L);
        this.longJob = new TestJob("Long Test Job", 10000000, 10L);
    }

    @AfterEach
    public void tearDown() throws Exception {
        Job.getJobManager().setProgressProvider(null);
        Job.getJobManager().setLockListener(null);
        this.shortJob.cancel();
        this.waitForState(this.shortJob, 0);
        this.longJob.cancel();
        this.waitForState(this.longJob, 0);
    }

    @Test
    public void testAsynchJob() {
        AsynchTestJob main = new AsynchTestJob("Test Asynch Finish");
        Assert.assertNull((Object)main.getThread());
        Assert.assertNull((Object)main.getResult());
        main.schedule();
        main.jobBarrier.waitForStatus(1);
        this.waitForState(main, 4);
        JobTest.assertThreadType(main, Worker.class);
        main.jobBarrier.upgradeTo(2);
        main.jobBarrier.waitForStatus(3);
        JobTest.assertThreadType(main, Worker.class);
        main.threadBarrier.upgradeTo(2);
        main.threadBarrier.waitForStatus(3);
        JobTest.assertThreadType(main, AsynchExecThread.class);
        main.threadBarrier.upgradeTo(4);
        main.threadBarrier.waitForStatus(5);
        this.waitForState(main, 0);
        Assert.assertEquals((String)"job finished with unexpected result", (long)0L, (long)main.getResult().getSeverity());
        Assert.assertNull((Object)main.getThread());
        main.threadBarrier.setStatus(0);
        main.jobBarrier.setStatus(0);
        main.schedule();
        main.jobBarrier.waitForStatus(1);
        this.waitForState(main, 4);
        JobTest.assertThreadType(main, Worker.class);
        main.jobBarrier.upgradeTo(2);
        main.jobBarrier.waitForStatus(3);
        JobTest.assertThreadType(main, Worker.class);
        main.threadBarrier.upgradeTo(2);
        main.threadBarrier.waitForStatus(3);
        JobTest.assertThreadType(main, AsynchExecThread.class);
        main.cancel();
        main.threadBarrier.upgradeTo(4);
        main.threadBarrier.waitForStatus(5);
        this.waitForState(main, 0);
        Assert.assertEquals((String)"job finished with unexpected result", (long)8L, (long)main.getResult().getSeverity());
        Assert.assertNull((Object)main.getThread());
    }

    @Test
    public void testAsynchJobComplex() throws InterruptedException {
        AsynchTestJob[] jobs = new AsynchTestJob[5];
        int i = 0;
        while (i < jobs.length) {
            jobs[i] = new AsynchTestJob("TestJob" + (i + 1));
            Assert.assertNull((String)("job unexpectedly has thread assigned: " + String.valueOf((Object)jobs[i])), (Object)jobs[i].getThread());
            Assert.assertNull((String)("job unexpectedly has a result: " + String.valueOf((Object)jobs[i])), (Object)jobs[i].getResult());
            jobs[i].schedule();
            ++i;
        }
        AsynchTestJob[] asynchTestJobArray = jobs;
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            AsynchTestJob job = asynchTestJobArray[n2];
            job.jobBarrier.waitForStatus(1);
            ++n2;
        }
        asynchTestJobArray = jobs;
        n = jobs.length;
        n2 = 0;
        while (n2 < n) {
            AsynchTestJob job = asynchTestJobArray[n2];
            JobTest.assertThreadType(job, Worker.class);
            job.jobBarrier.upgradeTo(2);
            ++n2;
        }
        asynchTestJobArray = jobs;
        n = jobs.length;
        n2 = 0;
        while (n2 < n) {
            AsynchTestJob job = asynchTestJobArray[n2];
            job.jobBarrier.waitForStatus(3);
            ++n2;
        }
        asynchTestJobArray = jobs;
        n = jobs.length;
        n2 = 0;
        while (n2 < n) {
            AsynchTestJob job = asynchTestJobArray[n2];
            JobTest.assertThreadType(job, Worker.class);
            job.threadBarrier.upgradeTo(2);
            ++n2;
        }
        asynchTestJobArray = jobs;
        n = jobs.length;
        n2 = 0;
        while (n2 < n) {
            AsynchTestJob job = asynchTestJobArray[n2];
            job.threadBarrier.waitForStatus(3);
            ++n2;
        }
        asynchTestJobArray = jobs;
        n = jobs.length;
        n2 = 0;
        while (n2 < n) {
            AsynchTestJob job = asynchTestJobArray[n2];
            JobTest.assertThreadType(job, AsynchExecThread.class);
            job.threadBarrier.upgradeTo(4);
            ++n2;
        }
        asynchTestJobArray = jobs;
        n = jobs.length;
        n2 = 0;
        while (n2 < n) {
            AsynchTestJob job = asynchTestJobArray[n2];
            job.threadBarrier.waitForStatus(5);
            ++n2;
        }
        asynchTestJobArray = jobs;
        n = jobs.length;
        n2 = 0;
        while (n2 < n) {
            AsynchTestJob job = asynchTestJobArray[n2];
            job.join();
            ++n2;
        }
        asynchTestJobArray = jobs;
        n = jobs.length;
        n2 = 0;
        while (n2 < n) {
            AsynchTestJob job = asynchTestJobArray[n2];
            this.waitForState(job, 0);
            Assert.assertEquals((String)("job finished with unexpected state: " + String.valueOf((Object)job)), (long)0L, (long)job.getResult().getSeverity());
            Assert.assertNull((String)("job still has a thread assigned: " + String.valueOf((Object)job)), (Object)job.getThread());
            ++n2;
        }
    }

    @Test
    public void testAsynchJobConflict() {
        AsynchTestJob job;
        AsynchTestJob[] jobs = new AsynchTestJob[5];
        IdentityRule rule = new IdentityRule();
        int i = 0;
        while (i < jobs.length) {
            jobs[i] = new AsynchTestJob("TestJob" + (i + 1));
            Assert.assertNull((String)("job unexpectedly has thread assigned: " + String.valueOf((Object)jobs[i])), (Object)jobs[i].getThread());
            Assert.assertNull((String)("job unexpectedly has a result: " + String.valueOf((Object)jobs[i])), (Object)jobs[i].getResult());
            if (i < 2) {
                jobs[i].schedule();
            } else if (i > 2) {
                jobs[i].setRule(rule);
            } else {
                jobs[i].setRule(rule);
                jobs[i].schedule();
            }
            ++i;
        }
        i = 0;
        while (i < 3) {
            job = jobs[i];
            job.jobBarrier.waitForStatus(1);
            this.waitForState(job, 4);
            JobTest.assertThreadType(job, Worker.class);
            job.jobBarrier.upgradeTo(2);
            ++i;
        }
        i = 0;
        while (i < 3) {
            jobs[i].jobBarrier.waitForStatus(3);
            ++i;
        }
        i = 0;
        while (i < 3) {
            JobTest.assertThreadType(jobs[i], Worker.class);
            jobs[i].threadBarrier.upgradeTo(2);
            ++i;
        }
        i = 0;
        while (i < 3) {
            jobs[i].threadBarrier.waitForStatus(3);
            ++i;
        }
        jobs[3].schedule();
        jobs[4].schedule();
        this.waitForState(jobs[3], 2);
        Assert.assertNull((String)("job unexpectedly has a thread assigned: " + String.valueOf((Object)jobs[3])), (Object)jobs[3].getThread());
        this.waitForState(jobs[4], 2);
        Assert.assertNull((String)("job unexpectedly has a thread assigned: " + String.valueOf((Object)jobs[4])), (Object)jobs[4].getThread());
        i = 0;
        while (i < 2) {
            JobTest.assertThreadType(jobs[i], AsynchExecThread.class);
            jobs[i].threadBarrier.upgradeTo(4);
            ++i;
        }
        jobs[1].threadBarrier.waitForStatus(5);
        this.waitForState(jobs[2], 4);
        this.waitForState(jobs[3], 2);
        this.waitForState(jobs[4], 2);
        JobTest.assertThreadType(jobs[2], AsynchExecThread.class);
        jobs[2].threadBarrier.upgradeTo(4);
        jobs[2].threadBarrier.waitForStatus(5);
        jobs[3].jobBarrier.waitForStatus(1);
        this.waitForState(jobs[3], 4);
        this.waitForState(jobs[4], 2);
        jobs[3].jobBarrier.upgradeTo(2);
        this.waitForState(jobs[4], 2);
        jobs[3].jobBarrier.waitForStatus(3);
        jobs[3].threadBarrier.upgradeTo(2);
        this.waitForState(jobs[4], 2);
        jobs[3].threadBarrier.waitForStatus(3);
        this.waitForState(jobs[4], 2);
        jobs[4].cancel();
        JobTest.assertThreadType(jobs[3], AsynchExecThread.class);
        jobs[3].threadBarrier.upgradeTo(4);
        jobs[3].threadBarrier.waitForStatus(5);
        i = 0;
        while (i < 4) {
            job = jobs[i];
            this.waitForState(job, 0);
            Assert.assertEquals((String)("job finished with unexpected state: " + String.valueOf((Object)job)), (long)0L, (long)job.getResult().getSeverity());
            Assert.assertNull((String)("job still has a thread assigned: " + String.valueOf((Object)job)), (Object)job.getThread());
            ++i;
        }
        this.waitForState(jobs[3], 0);
        Assert.assertNull((String)("job should not have a result: " + String.valueOf((Object)jobs[4])), (Object)jobs[4].getResult());
        Assert.assertNull((String)("job still has a thread assigned: " + String.valueOf((Object)jobs[4])), (Object)jobs[4].getThread());
    }

    private static void assertThreadType(Job job, Class<?> threadType) {
        ((ObjectAssert)Assertions.assertThat((Object)job.getThread()).as("type of job %s", new Object[]{job})).isInstanceOf(threadType);
    }

    @Test
    public void testCancelFromAboutToRun() throws InterruptedException {
        final int[] doneCount = new int[1];
        final int[] runningCount = new int[1];
        TestJob job = new TestJob("testCancelFromAboutToRun", 0, 0L);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void aboutToRun(IJobChangeEvent event) {
                event.getJob().cancel();
            }

            public void done(IJobChangeEvent event) {
                doneCount[0] = doneCount[0] + 1;
            }

            public void running(IJobChangeEvent event) {
                runningCount[0] = runningCount[0] + 1;
            }
        });
        job.schedule();
        job.join();
        Assert.assertEquals((String)"1.0", (long)0L, (long)job.getRunCount());
        Assert.assertEquals((String)"1.1", (long)1L, (long)doneCount[0]);
        Assert.assertEquals((String)"1.2", (long)0L, (long)runningCount[0]);
    }

    @Test
    public void testShouldRun() throws InterruptedException {
        class ShouldRunJob
        extends Job {
            int runCount;

            public ShouldRunJob() {
                super("ShouldRunJob");
                this.runCount = 0;
            }

            protected IStatus run(IProgressMonitor monitor) {
                ++this.runCount;
                return Status.OK_STATUS;
            }

            public boolean shouldRun() {
                return false;
            }
        }
        ShouldRunJob j = new ShouldRunJob();
        j.schedule();
        j.join();
        Assert.assertEquals((long)0L, (long)j.runCount);
    }

    @Test
    public void testShouldRunFailure() {
        class ShouldRunJob
        extends Job {
            int runCount;

            public ShouldRunJob() {
                super("ShouldRunJob");
                this.runCount = 0;
            }

            protected IStatus run(IProgressMonitor monitor) {
                ++this.runCount;
                return Status.OK_STATUS;
            }

            public boolean shouldRun() {
                throw new TestException();
            }
        }
        ShouldRunJob j = new ShouldRunJob();
        j.schedule();
        this.waitForState(j, 0);
        Assert.assertEquals((long)0L, (long)j.runCount);
    }

    @Test
    public void testCancelShouldRun() throws OperationCanceledException, InterruptedException {
        final String[] failure = new String[1];
        Job j = new Job("Test"){
            AtomicInteger runningCount;
            boolean cancelled;
            {
                super($anonymous0);
                this.runningCount = new AtomicInteger();
            }

            protected IStatus run(IProgressMonitor monitor) {
                if (this.runningCount.incrementAndGet() > 1) {
                    failure[0] = "Multiple running at once!";
                }
                try {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (this.runningCount.decrementAndGet() != 0) {
                            failure[0] = "Multiple were running at once!";
                        }
                    }
                }
                finally {
                    if (this.runningCount.decrementAndGet() != 0) {
                        failure[0] = "Multiple were running at once!";
                    }
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return JobTest.this == family;
            }

            public boolean shouldRun() {
                if (!this.cancelled) {
                    this.cancelled = true;
                    this.sleep();
                    this.cancel();
                    this.schedule();
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                return true;
            }
        };
        j.schedule();
        Thread.sleep(1000L);
        Job.getJobManager().join((Object)this, null);
        Assert.assertNull((String)failure[0], (Object)failure[0]);
    }

    @Test
    public void testCanceling() {
        final TestBarrier2 barrier = new TestBarrier2();
        barrier.setStatus(0);
        final int[] canceling = new int[1];
        Job job = new Job("Testing#testCanceling"){

            protected void canceling() {
                canceling[0] = canceling[0] + 1;
            }

            protected IStatus run(IProgressMonitor monitor) {
                barrier.setStatus(2);
                barrier.waitForStatus(3);
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        barrier.waitForStatus(2);
        Assert.assertEquals((String)"1.0", (long)0L, (long)canceling[0]);
        job.cancel();
        Assert.assertEquals((String)"1.1", (long)1L, (long)canceling[0]);
        job.cancel();
        Assert.assertEquals((String)"1.2", (long)1L, (long)canceling[0]);
        barrier.setStatus(3);
        this.waitForState(job, 0);
    }

    @Test
    public void testCancelingByMonitor() {
        final TestBarrier2 barrier = new TestBarrier2();
        barrier.setStatus(0);
        final int[] canceling = new int[1];
        final IProgressMonitor[] jobmonitor = new IProgressMonitor[1];
        Job job = new Job("Testing#testCancelingByMonitor"){

            protected void canceling() {
                canceling[0] = canceling[0] + 1;
            }

            protected IStatus run(IProgressMonitor monitor) {
                jobmonitor[0] = monitor;
                barrier.setStatus(2);
                barrier.waitForStatus(3);
                return Status.OK_STATUS;
            }
        };
        int i = 0;
        while (i < 2) {
            canceling[0] = 0;
            job.schedule();
            barrier.waitForStatus(2);
            Assert.assertEquals((String)(i + ".1.0"), (long)0L, (long)canceling[0]);
            jobmonitor[0].setCanceled(true);
            Assert.assertEquals((String)(i + ".1.1"), (long)1L, (long)canceling[0]);
            jobmonitor[0].setCanceled(true);
            Assert.assertEquals((String)(i + ".1.2"), (long)1L, (long)canceling[0]);
            barrier.setStatus(3);
            this.waitForState(job, 0);
            ++i;
        }
    }

    @Test
    public void testCancelAboutToScheduleLegacy() throws InterruptedException {
        JobListeners.setJobListenerTimeout((int)0);
        this.testCancelAboutToSchedule();
        JobListeners.resetJobListenerTimeout();
    }

    @Test
    public void testCancelAboutToSchedule() throws InterruptedException {
        final boolean[] failure = new boolean[1];
        final Job j = new Job("testCancelAboutToSchedule"){
            AtomicInteger runningCount;
            {
                super($anonymous0);
                this.runningCount = new AtomicInteger();
            }

            protected IStatus run(IProgressMonitor monitor) {
                if (this.runningCount.incrementAndGet() > 1) {
                    failure[0] = true;
                }
                try {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        if (this.runningCount.decrementAndGet() != 0) {
                            failure[0] = true;
                        }
                    }
                }
                finally {
                    if (this.runningCount.decrementAndGet() != 0) {
                        failure[0] = true;
                    }
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return JobTest.this == family;
            }
        };
        JobChangeAdapter listener = new JobChangeAdapter(){
            boolean canceled = false;

            public void scheduled(IJobChangeEvent event) {
                if (event.getJob().belongsTo((Object)JobTest.this) && !this.canceled) {
                    this.canceled = true;
                    j.cancel();
                    j.schedule();
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        Job.getJobManager().addJobChangeListener((IJobChangeListener)listener);
        try {
            j.schedule();
            Thread.sleep(1000L);
            Job.getJobManager().join((Object)this, null);
            Assert.assertFalse((String)"1.0", (boolean)failure[0]);
        }
        finally {
            Job.getJobManager().removeJobChangeListener((IJobChangeListener)listener);
        }
    }

    @Test
    public void testGetName() {
        Assert.assertEquals((String)"1.0", (Object)"Short Test Job", (Object)this.shortJob.getName());
        Assert.assertEquals((String)"1.1", (Object)"Long Test Job", (Object)this.longJob.getName());
        Assert.assertThrows(RuntimeException.class, () -> {
            TestJob testJob = new TestJob(null);
        });
    }

    @Test
    public void testGetPriority() {
        int[] priority = new int[]{20, 30, 10, 40, 50};
        int i = 0;
        while (i < priority.length) {
            this.shortJob.setPriority(priority[i]);
            Assert.assertEquals((String)("1." + i), (long)priority[i], (long)this.shortJob.getPriority());
            ++i;
        }
    }

    @Test
    public void testGetProperty() {
        QualifiedName n1 = new QualifiedName("org.eclipse.core.tests.runtime", "p1");
        QualifiedName n2 = new QualifiedName("org.eclipse.core.tests.runtime", "p2");
        Assert.assertNull((String)"1.0", (Object)this.shortJob.getProperty(n1));
        this.shortJob.setProperty(n1, null);
        Assert.assertNull((String)"1.1", (Object)this.shortJob.getProperty(n1));
        this.shortJob.setProperty(n1, (Object)this.shortJob);
        Assert.assertEquals((String)"1.2", (Object)this.shortJob.getProperty(n1), (Object)this.shortJob);
        Assert.assertNull((String)"1.3", (Object)this.shortJob.getProperty(n2));
        this.shortJob.setProperty(n1, (Object)"hello");
        Assert.assertEquals((String)"1.4", (Object)"hello", (Object)this.shortJob.getProperty(n1));
        this.shortJob.setProperty(n1, null);
        Assert.assertNull((String)"1.5", (Object)this.shortJob.getProperty(n1));
        Assert.assertNull((String)"1.6", (Object)this.shortJob.getProperty(n2));
    }

    @Test
    public void testGetResult() {
        Assert.assertNull((String)"1.0", (Object)this.shortJob.getResult());
        this.shortJob.schedule();
        this.waitForState(this.shortJob, 0);
        Assert.assertEquals((String)"1.1", (long)0L, (long)this.shortJob.getResult().getSeverity());
        this.waitForState(this.longJob, 0);
        this.longJob.schedule();
        this.waitForState(this.longJob, 4);
        this.longJob.cancel();
        this.waitForState(this.longJob, 0);
        Assert.assertEquals((String)"2.0", (long)8L, (long)this.longJob.getResult().getSeverity());
    }

    @Test
    public void testGetRule() {
        Assert.assertNull((String)"1.0", (Object)this.shortJob.getRule());
        this.shortJob.setRule((ISchedulingRule)new IdentityRule());
        Assert.assertTrue((String)"1.1", (boolean)(this.shortJob.getRule() instanceof IdentityRule));
        PathRule rule = new PathRule("/testGetRule");
        this.shortJob.setRule((ISchedulingRule)rule);
        Assert.assertEquals((String)"1.2", (Object)this.shortJob.getRule(), (Object)rule);
        this.shortJob.setRule(null);
        Assert.assertNull((String)"1.3", (Object)this.shortJob.getRule());
    }

    @Test
    public void testGetThread() {
        Assert.assertNull((String)"1.0", (Object)this.shortJob.getThread());
        Thread t = new Thread();
        this.shortJob.setThread(t);
        Assert.assertEquals((String)"1.1", (Object)this.shortJob.getThread(), (Object)t);
        this.shortJob.setThread(new Thread());
        Assert.assertNotEquals((String)"1.2", (Object)this.shortJob.getThread(), (Object)t);
        this.shortJob.setThread(null);
        Assert.assertNull((String)"1.3", (Object)this.shortJob.getThread());
    }

    @Test
    public void testIsBlocking() {
        IdentityRule rule = new IdentityRule();
        TestJob high = new TestJob("TestIsBlocking.long", 10000, 100L);
        high.setRule((ISchedulingRule)rule);
        high.setPriority(30);
        TestJob medium = new TestJob("TestIsBlocking.build", 10000, 100L);
        medium.setRule((ISchedulingRule)rule);
        medium.setPriority(40);
        TestJob low = new TestJob("TestIsBlocking.decorate", 10000, 100L);
        low.setRule((ISchedulingRule)rule);
        low.setPriority(50);
        medium.schedule();
        this.waitForState((Job)medium, 4);
        Assert.assertTrue((String)"1.0", (!medium.isBlocking() ? 1 : 0) != 0);
        low.schedule();
        Assert.assertTrue((String)"1.1", (!medium.isBlocking() ? 1 : 0) != 0);
        high.schedule();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertTrue((String)"1.2", (boolean)medium.isBlocking());
        Job[] jobs = new Job[]{high, medium, low};
        this.cancel(jobs);
        this.waitForState(jobs, 0);
        high.setSystem(true);
        medium.schedule();
        this.waitForState((Job)medium, 4);
        high.schedule();
        Assert.assertTrue((String)"2.0", (!medium.isBlocking() ? 1 : 0) != 0);
        this.cancel(jobs);
        this.waitForState(jobs, 0);
    }

    @Test
    public void testIsBlocking2() throws InterruptedException {
        final IdentityRule rule = new IdentityRule();
        Thread thread = new Thread("testIsBlocking2"){

            @Override
            public void run() {
                try {
                    JobTest.this.manager.beginRule(rule, null);
                }
                finally {
                    JobTest.this.manager.endRule(rule);
                }
            }
        };
        try {
            this.manager.beginRule((ISchedulingRule)rule, null);
            thread.start();
            while (thread.getState() != Thread.State.WAITING) {
                Thread.sleep(50L);
            }
            Assert.assertTrue((boolean)this.manager.currentJob().isBlocking());
        }
        finally {
            this.manager.endRule((ISchedulingRule)rule);
            thread.join();
        }
    }

    @Test
    public void testIsSystem() {
        this.shortJob.setUser(false);
        this.shortJob.setSystem(false);
        Assert.assertTrue((String)"1.0", (!this.shortJob.isUser() ? 1 : 0) != 0);
        Assert.assertTrue((String)"1.1", (!this.shortJob.isSystem() ? 1 : 0) != 0);
        this.shortJob.setSystem(true);
        Assert.assertTrue((String)"1.2", (!this.shortJob.isUser() ? 1 : 0) != 0);
        Assert.assertTrue((String)"1.3", (boolean)this.shortJob.isSystem());
        this.shortJob.setSystem(false);
        Assert.assertTrue((String)"1.4", (!this.shortJob.isUser() ? 1 : 0) != 0);
        Assert.assertTrue((String)"1.5", (!this.shortJob.isSystem() ? 1 : 0) != 0);
    }

    @Test
    public void testIsUser() {
        this.shortJob.setUser(false);
        this.shortJob.setSystem(false);
        Assert.assertTrue((String)"1.0", (!this.shortJob.isUser() ? 1 : 0) != 0);
        Assert.assertTrue((String)"1.1", (!this.shortJob.isSystem() ? 1 : 0) != 0);
        this.shortJob.setUser(true);
        Assert.assertTrue((String)"1.2", (boolean)this.shortJob.isUser());
        Assert.assertTrue((String)"1.3", (!this.shortJob.isSystem() ? 1 : 0) != 0);
        this.shortJob.setUser(false);
        Assert.assertTrue((String)"1.4", (!this.shortJob.isUser() ? 1 : 0) != 0);
        Assert.assertTrue((String)"1.5", (!this.shortJob.isSystem() ? 1 : 0) != 0);
    }

    @Test
    public void testJoin() throws InterruptedException {
        this.longJob.schedule(100000L);
        AtomicIntegerArray status = new AtomicIntegerArray(new int[1]);
        status.set(0, 0);
        AtomicReference exceptionInThread = new AtomicReference();
        Thread t = new Thread(() -> {
            status.set(0, 1);
            try {
                this.longJob.join();
            }
            catch (InterruptedException e) {
                exceptionInThread.set(e);
            }
            status.set(0, 5);
        });
        t.start();
        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)1);
        Assert.assertEquals((String)"1.0", (long)1L, (long)status.get(0));
        this.longJob.sleep();
        this.sleep(100L);
        Assert.assertEquals((String)"1.0", (long)1L, (long)status.get(0));
        this.longJob.wakeUp(100000L);
        this.sleep(100L);
        Assert.assertEquals((String)"1.0", (long)1L, (long)status.get(0));
        this.longJob.cancel();
        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)5);
        if (exceptionInThread.get() != null) {
            throw (InterruptedException)exceptionInThread.get();
        }
    }

    @Test
    public void testJoinWithTimeout() throws Exception {
        this.longJob.schedule();
        this.waitForState(this.longJob, 4);
        long timeout = 1000L;
        long[] duration = new long[]{-1L};
        TestBarrier2 barrier = new TestBarrier2(0);
        AtomicReference exceptionInThread = new AtomicReference();
        Thread t = new Thread(() -> {
            try {
                long start = JobTest.now();
                this.longJob.join(1000L, null);
                lArray[0] = JobTest.now() - start;
            }
            catch (InterruptedException | OperationCanceledException e) {
                exceptionInThread.set(e);
            }
            barrier.setStatus(5);
        });
        t.start();
        barrier.waitForStatus(5);
        Assert.assertNotEquals((String)"Waiting for join to time out failed", (long)-1L, (long)duration[0]);
        Assert.assertEquals((String)"Long running job should still be running after join timed out", (long)4L, (long)this.longJob.getState());
        String durationAndTimoutMessage = "duration: " + duration[0] + " timeout: 1000";
        Assert.assertTrue((String)("Join did not run into timeout; " + durationAndTimoutMessage), (duration[0] >= 1000L ? 1 : 0) != 0);
        this.longJob.cancel();
        this.waitForCompletion(this.longJob);
        if (exceptionInThread.get() != null) {
            throw (Exception)exceptionInThread.get();
        }
    }

    @Test
    public void testJoinWithProgressMonitor() throws Exception {
        this.shortJob.schedule(100000L);
        FussyProgressMonitor monitor = new FussyProgressMonitor();
        AtomicIntegerArray status = new AtomicIntegerArray(new int[1]);
        status.set(0, 0);
        AtomicReference exceptionInThread = new AtomicReference();
        Thread t = new Thread(() -> {
            status.set(0, 1);
            try {
                this.shortJob.join(0L, (IProgressMonitor)monitor);
            }
            catch (InterruptedException | OperationCanceledException e) {
                exceptionInThread.set(e);
            }
            status.set(0, 5);
        });
        t.start();
        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)1);
        Assert.assertEquals((String)"1.0", (long)1L, (long)status.get(0));
        this.shortJob.wakeUp();
        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)5);
        monitor.sanityCheck();
        if (exceptionInThread.get() != null) {
            throw (Exception)exceptionInThread.get();
        }
    }

    @Test
    public void testJoinWithCancelingMonitor() throws InterruptedException {
        this.longJob.schedule();
        this.waitForState(this.longJob, 4);
        FussyProgressMonitor monitor = new FussyProgressMonitor();
        AtomicIntegerArray status = new AtomicIntegerArray(new int[1]);
        status.set(0, 0);
        AtomicReference exceptionInThread = new AtomicReference();
        Thread t = new Thread(() -> {
            status.set(0, 1);
            try {
                this.longJob.join(0L, (IProgressMonitor)monitor);
            }
            catch (InterruptedException e) {
                exceptionInThread.set(e);
            }
            catch (OperationCanceledException operationCanceledException) {
                // empty catch block
            }
            status.set(0, 5);
        });
        t.start();
        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)1);
        monitor.setCanceled(true);
        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)0, (int)5);
        monitor.sanityCheck();
        Assert.assertEquals((String)"job unexpectedly stopped running after join call", (long)4L, (long)this.longJob.getState());
        this.longJob.cancel();
        this.waitForCompletion(this.longJob);
        if (exceptionInThread.get() != null) {
            throw (InterruptedException)exceptionInThread.get();
        }
    }

    @Test
    public void testJoinInterruptNonUIThread() throws InterruptedException {
        final TestBarrier2 barrier = new TestBarrier2();
        Job.getJobManager().setLockListener(new LockListener(){

            public boolean aboutToWait(Thread lockOwner) {
                barrier.setStatus(2);
                return super.aboutToWait(lockOwner);
            }
        });
        TestJob job = new TestJob("job", 50000, 100L);
        Thread t = new Thread(() -> {
            job.schedule();
            try {
                job.join();
            }
            catch (InterruptedException e) {
                job.terminate();
            }
        });
        t.start();
        barrier.waitForStatus(2);
        t.interrupt();
        job.join();
        Assert.assertEquals((String)"Thread not interrupted", (Object)Status.OK_STATUS, (Object)job.getResult());
    }

    @Test
    public void testJoinInterruptUIThread() throws InterruptedException {
        TestJob job = new TestJob("job", 3, 100L);
        Thread t = new Thread(() -> JobTest.lambda$6((Job)job));
        Job.getJobManager().setLockListener(new LockListener(){

            public boolean canBlock() {
                return false;
            }
        });
        t.start();
        this.waitForState((Job)job, 4);
        t.interrupt();
        job.join();
        Assert.assertEquals((String)"Thread interrupted", (Object)Status.OK_STATUS, (Object)job.getResult());
    }

    @Test
    public void testJoinLockListener() throws InterruptedException {
        TestJob longRunningTestJob = new TestJob("testJoinLockListener", 100000, 10L);
        longRunningTestJob.schedule();
        TestLockListener lockListener = new TestLockListener(() -> longRunningTestJob.terminate());
        Job.getJobManager().setLockListener((LockListener)lockListener);
        longRunningTestJob.join();
        lockListener.assertHasBeenWaiting("JobManager has not been waiting for lock");
        lockListener.assertNotWaiting("JobManager has not finished waiting for lock");
    }

    @Test
    public void testJoinFailingListener() throws InterruptedException {
        this.shortJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                throw new TestException();
            }
        });
        AtomicIntegerArray status = new AtomicIntegerArray(new int[1]);
        AtomicReference exceptionInThread = new AtomicReference();
        Thread t = new Thread(() -> {
            status.set(0, 1);
            try {
                this.shortJob.join();
            }
            catch (InterruptedException e) {
                exceptionInThread.set(e);
            }
            status.set(0, 5);
        });
        this.shortJob.schedule();
        t.start();
        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)5);
        if (exceptionInThread.get() != null) {
            throw (InterruptedException)exceptionInThread.get();
        }
    }

    @Test
    public void testJoinSelf() throws InterruptedException {
        final Exception[] failure = new Exception[1];
        Job selfJoiner = new Job("testJoinSelf"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    this.join();
                }
                catch (InterruptedException | RuntimeException e) {
                    failure[0] = e;
                }
                return Status.OK_STATUS;
            }
        };
        selfJoiner.schedule();
        selfJoiner.join();
        Assert.assertNotNull((String)"1.0", (Object)failure[0]);
    }

    @Test
    public void testJoinRemoveListener() throws InterruptedException {
        JobChangeAdapter listener = new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                JobTest.this.shortJob.removeJobChangeListener((IJobChangeListener)this);
            }
        };
        this.shortJob.addJobChangeListener((IJobChangeListener)listener);
        AtomicIntegerArray status = new AtomicIntegerArray(new int[1]);
        AtomicReference exceptionInThread = new AtomicReference();
        Thread t = new Thread(() -> {
            status.set(0, 1);
            try {
                this.shortJob.join();
            }
            catch (InterruptedException e) {
                exceptionInThread.set(e);
            }
            status.set(0, 5);
        });
        this.shortJob.schedule();
        t.start();
        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)5);
        if (exceptionInThread.get() != null) {
            throw (InterruptedException)exceptionInThread.get();
        }
    }

    @Test
    public void testRescheduleCancel() {
        final AtomicIntegerArray status = new AtomicIntegerArray(new int[1]);
        Job job = new Job("Testing"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    monitor.beginTask("Testing", 1);
                    status.set(0, 2);
                    TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)3);
                    monitor.worked(1);
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)2);
        job.cancel();
        job.schedule();
        status.set(0, 3);
        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)2);
        status.set(0, 3);
        this.waitForState(job, 0);
    }

    @Test
    public void testRescheduleComplex() {
        final AtomicIntegerArray status = new AtomicIntegerArray(new int[1]);
        final int[] runCount = new int[1];
        Job job = new Job("Testing"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    monitor.beginTask("Testing", 1);
                    status.set(0, 2);
                    TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)3);
                    monitor.worked(1);
                }
                finally {
                    runCount[0] = runCount[0] + 1;
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)2);
        job.schedule(1000000L);
        job.schedule(3000L);
        job.schedule(200000000L);
        job.schedule();
        status.set(0, 3);
        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)2);
        Assert.assertEquals((String)"1.0", (long)1L, (long)runCount[0]);
        status.set(0, 3);
        this.waitForState(job, 0);
        Assert.assertEquals((String)"1.0", (long)2L, (long)runCount[0]);
    }

    @Test
    public void testRescheduleDelay() {
        final AtomicIntegerArray status = new AtomicIntegerArray(new int[1]);
        final int[] runCount = new int[1];
        Job job = new Job("Testing"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    monitor.beginTask("Testing", 1);
                    status.set(0, 2);
                    TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)3);
                    monitor.worked(1);
                }
                finally {
                    runCount[0] = runCount[0] + 1;
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)2);
        job.schedule(1000000L);
        status.set(0, 3);
        this.waitForState(job, 1);
        Assert.assertEquals((String)"1.0", (long)1L, (long)runCount[0]);
        job.schedule();
        job.wakeUp();
        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)2);
        status.set(0, 3);
        this.waitForState(job, 0);
        Assert.assertEquals((String)"1.0", (long)0L, (long)job.getState());
        Assert.assertEquals((String)"1.0", (long)2L, (long)runCount[0]);
    }

    @Test
    public void testRescheduleRepeat() {
        final int[] count = new int[1];
        int REPEATS = 10;
        Job job = new Job("testRescheduleRepeat"){

            protected IStatus run(IProgressMonitor monitor) {
                count[0] = count[0] + 1;
                this.schedule();
                return Status.OK_STATUS;
            }

            public boolean shouldSchedule() {
                return count[0] < 10;
            }
        };
        job.schedule();
        int timeout = 0;
        while (timeout++ < 100 && count[0] < 10) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Assert.assertTrue((String)"1.0", (timeout < 100 ? 1 : 0) != 0);
        Assert.assertEquals((String)"1.1", (long)10L, (long)count[0]);
    }

    @Test
    public void testRescheduleRepeating() {
        final AtomicLong runCount = new AtomicLong();
        final AtomicLong scheduledCount = new AtomicLong();
        final AtomicBoolean keepRunning = new AtomicBoolean(true);
        Job job = new Job("testRescheduleRepeat"){

            protected IStatus run(IProgressMonitor monitor) {
                runCount.incrementAndGet();
                while (!monitor.isCanceled() && keepRunning.get()) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        Thread.interrupted();
                        return Status.CANCEL_STATUS;
                    }
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return family == this;
            }
        };
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void scheduled(IJobChangeEvent event) {
                scheduledCount.incrementAndGet();
            }
        });
        job.schedule();
        int timeout = 0;
        while (timeout++ < 100 && scheduledCount.get() == 0L) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        int i = 0;
        while (i < 100) {
            job.schedule((long)i);
            ++i;
        }
        timeout = 0;
        while (timeout++ < 100 && runCount.get() < 1L) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        try {
            ((ObjectArrayAssert)Assertions.assertThat((Object[])Job.getJobManager().find((Object)job)).as("check job still runs", new Object[0])).contains((Object[])new Job[]{job});
            ((AbstractLongAssert)Assertions.assertThat((long)runCount.get()).as("expected to see exact one job execution", new Object[0])).isEqualTo(1L);
        }
        finally {
            keepRunning.set(false);
        }
    }

    @Test
    public void testRescheduleRepeatWithDelay() {
        final int[] count = new int[1];
        int REPEATS = 10;
        Job job = new Job("testRescheduleRepeat"){

            protected IStatus run(IProgressMonitor monitor) {
                count[0] = count[0] + 1;
                this.schedule(10L);
                return Status.OK_STATUS;
            }

            public boolean shouldSchedule() {
                return count[0] < 10;
            }
        };
        job.schedule();
        int timeout = 0;
        while (timeout++ < 100 && count[0] < 10) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Assert.assertTrue((String)"1.0", (timeout < 100 ? 1 : 0) != 0);
        Assert.assertEquals((String)"1.1", (long)10L, (long)count[0]);
    }

    @Test
    public void testRescheduleSimple() {
        final AtomicIntegerArray status = new AtomicIntegerArray(new int[1]);
        Job job = new Job("testRescheduleSimple"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    monitor.beginTask("Testing", 1);
                    status.set(0, 2);
                    TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)3);
                    monitor.worked(1);
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)2);
        job.schedule();
        status.set(0, 3);
        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)2);
        status.set(0, 3);
        this.waitForState(job, 0);
        job.schedule();
        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)2);
        status.set(0, 3);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.waitForState(job, 0);
    }

    @Test
    public void testRescheduleWaiting() {
        final AtomicIntegerArray status = new AtomicIntegerArray(new int[2]);
        final int[] runCount = new int[1];
        IdentityRule rule = new IdentityRule();
        Job first = new Job("Testing1"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    monitor.beginTask("Testing", 1);
                    status.set(0, 2);
                    TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)0, (int)3);
                    monitor.worked(1);
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        Job second = new Job("Testing2"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    monitor.beginTask("Testing", 1);
                    status.set(1, 2);
                    TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)1, (int)3);
                    monitor.worked(1);
                }
                finally {
                    runCount[0] = runCount[0] + 1;
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        first.setRule((ISchedulingRule)rule);
        first.schedule();
        second.setRule((ISchedulingRule)rule);
        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)0, (int)2);
        second.schedule();
        this.waitForState(second, 2);
        second.schedule();
        status.set(0, 3);
        TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)1, (int)2);
        status.set(1, 3);
        this.waitForState(second, 0);
        Assert.assertEquals((String)"2.0", (long)0L, (long)second.getState());
        Assert.assertEquals((String)"2.1", (long)1L, (long)runCount[0]);
    }

    @Test
    public void testRescheduleFromDone() throws InterruptedException {
        final AtomicInteger runningCount = new AtomicInteger();
        final Job j = new Job("testCancelAboutToSchedule"){

            protected IStatus run(IProgressMonitor monitor) {
                runningCount.incrementAndGet();
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return JobTest.this == family;
            }
        };
        JobChangeAdapter listener = new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (runningCount.get() < 3) {
                    j.schedule();
                }
            }
        };
        Job.getJobManager().addJobChangeListener((IJobChangeListener)listener);
        try {
            j.schedule();
            int ONE_SECOND = 1000000000;
            long n0 = System.nanoTime();
            while (runningCount.get() < 3) {
                Thread.yield();
                Assert.assertTrue((String)("timeout runningCount=" + runningCount.get()), (System.nanoTime() - n0 < (long)ONE_SECOND ? 1 : 0) != 0);
            }
            j.join();
            Assert.assertEquals((long)3L, (long)runningCount.get());
        }
        finally {
            Job.getJobManager().removeJobChangeListener((IJobChangeListener)listener);
        }
    }

    @Test
    public void testSetPriority() {
        int[] nArray = new int[6];
        nArray[0] = 1000;
        nArray[1] = -50;
        nArray[2] = 25;
        nArray[4] = 5;
        nArray[5] = -30;
        int[] wrongPriority = nArray;
        int i = 0;
        while (i < wrongPriority.length) {
            int currentIndex = i++;
            Assert.assertThrows(RuntimeException.class, () -> this.shortJob.setPriority(wrongPriority[currentIndex]));
        }
    }

    @Test
    public void testSetProgressGroup_withNullGroup() {
        Assert.assertThrows(RuntimeException.class, () -> new TestJob("testSetProgressGroup_withNullGroup").setProgressGroup(null, 5));
    }

    @Test
    public void testSetProgressGroup_withProperGroup() throws InterruptedException {
        TestJob job = new TestJob("testSetProgressGroup_withProperGroup"){

            public IStatus run(IProgressMonitor monitor) {
                monitor.setCanceled(true);
                return super.run(monitor);
            }
        };
        IProgressMonitor group = Job.getJobManager().createProgressGroup();
        group.beginTask("Group task name", 10);
        job.setProgressGroup(group, 0);
        job.schedule();
        job.join();
        ((ObjectAssert)Assertions.assertThat((Object)group).withFailMessage("job progress has not been reported to group monitor", new Object[0])).matches(IProgressMonitor::isCanceled);
        group.done();
    }

    @Test
    public void testSetProgressGroup_ignoreWhileWaiting() throws InterruptedException {
        TestJob job = new TestJob("testSetProgressGroup_ignoreWhileWaiting"){

            public IStatus run(IProgressMonitor monitor) {
                monitor.setCanceled(true);
                return super.run(monitor);
            }
        };
        IProgressMonitor group = Job.getJobManager().createProgressGroup();
        job.schedule(10000L);
        job.setProgressGroup(group, 0);
        job.wakeUp();
        job.join();
        ((ObjectAssert)Assertions.assertThat((Object)group).withFailMessage("job progress has unexpectedly been reported to group monitor", new Object[0])).matches(Predicate.not(IProgressMonitor::isCanceled));
    }

    @Test
    public void testSetProgressGroup_ignoreWhileRunning() throws InterruptedException {
        final TestBarrier2 barrier = new TestBarrier2();
        TestJob job = new TestJob("testSetProgressGroup_ignoreWhileRunning"){

            public IStatus run(IProgressMonitor monitor) {
                barrier.upgradeTo(3);
                monitor.setCanceled(true);
                return super.run(monitor);
            }
        };
        IProgressMonitor group = Job.getJobManager().createProgressGroup();
        job.schedule();
        barrier.waitForStatus(3);
        job.setProgressGroup(group, 0);
        job.join();
        ((ObjectAssert)Assertions.assertThat((Object)group).withFailMessage("job progress has unexpectedly been reported to group monitor", new Object[0])).matches(Predicate.not(IProgressMonitor::isCanceled));
    }

    @Test
    public void testSetProgressGroup_cancellationPropagatedToMonitor() {
        final TestBarrier2 barrier = new TestBarrier2();
        Job job = new Job("testSetProgressGroup_cancellationStillWorks"){

            protected IStatus run(IProgressMonitor monitor) {
                barrier.setStatus(3);
                barrier.waitForStatus(4);
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        IProgressMonitor group = Job.getJobManager().createProgressGroup();
        job.setProgressGroup(group, 0);
        job.schedule();
        barrier.waitForStatus(3);
        job.cancel();
        barrier.setStatus(4);
        this.waitForState(job, 0);
        ((ObjectAssert)Assertions.assertThat((Object)group).withFailMessage("job progress has not been reported to group monitor", new Object[0])).matches(IProgressMonitor::isCanceled);
        Assert.assertEquals((String)"job was unexpectedly not canceled", (long)8L, (long)job.getResult().getSeverity());
    }

    @Test
    public void testSetProgressGroup_propagatesGroupCancellation() throws InterruptedException {
        Job checkMonitorJob = this.createJobReactingToCancelRequest();
        IProgressMonitor progressGroup = Job.getJobManager().createProgressGroup();
        progressGroup.beginTask("", 2);
        checkMonitorJob.setProgressGroup(progressGroup, 1);
        progressGroup.setCanceled(true);
        checkMonitorJob.schedule();
        checkMonitorJob.join();
        Assert.assertEquals((String)"The job should have been canceled", (long)8L, (long)checkMonitorJob.getResult().getSeverity());
    }

    private Job createJobReactingToCancelRequest() {
        return new Job("Check if own monitor is canceled"){

            protected IStatus run(IProgressMonitor monitor) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
    }

    @Test
    public void testSetRule() throws InterruptedException {
        this.longJob.setRule((ISchedulingRule)new IdentityRule());
        Assertions.assertThat((Object)this.longJob.getRule()).isInstanceOf(IdentityRule.class);
        this.longJob.schedule(1000000L);
        Assert.assertThrows(RuntimeException.class, () -> this.longJob.setRule((ISchedulingRule)new PathRule("/testSetRule")));
        this.longJob.wakeUp();
        this.waitForState(this.longJob, 4);
        Assert.assertThrows(RuntimeException.class, () -> this.longJob.setRule((ISchedulingRule)new PathRule("/testSetRule/B")));
        this.longJob.cancel();
        this.longJob.join();
        this.longJob.setRule((ISchedulingRule)new PathRule("/testSetRule/B/C/D"));
        Assertions.assertThat((Object)this.longJob.getRule()).isInstanceOf(PathRule.class);
        this.longJob.setRule(null);
        Assert.assertNull((String)("job still has a rule assigned: " + String.valueOf(this.longJob)), (Object)this.longJob.getRule());
    }

    @Test
    public void testSetThread() {
        Assert.assertNull((String)"0.0", (Object)this.longJob.getThread());
        this.longJob.setThread(Thread.currentThread());
        Assert.assertEquals((String)"1.0", (Object)this.longJob.getThread(), (Object)Thread.currentThread());
        this.longJob.schedule();
        this.waitForState(this.longJob, 4);
        Assert.assertNotEquals((String)"2.0", (Object)this.longJob.getThread(), (Object)Thread.currentThread());
        this.longJob.cancel();
        this.waitForState(this.longJob, 0);
        Assert.assertNull((String)"3.0", (Object)this.longJob.getThread());
        this.longJob.setThread(null);
        Assert.assertNull((String)"4.0", (Object)this.longJob.getThread());
        this.longJob.schedule();
        this.waitForState(this.longJob, 4);
        Assert.assertNotNull((String)("5.0 (state=" + JobManager.printState((int)this.longJob.getState()) + ")"), (Object)this.longJob.getThread());
        this.longJob.cancel();
        this.waitForState(this.longJob, 0);
        Assert.assertNull((String)"6.0", (Object)this.longJob.getThread());
        Thread t = new Thread();
        this.longJob.setThread(t);
        Assert.assertEquals((String)"7.0", (Object)this.longJob.getThread(), (Object)t);
        this.longJob.schedule();
        this.waitForState(this.longJob, 4);
        Assert.assertNotEquals((String)"8.0", (Object)this.longJob.getThread(), (Object)t);
        this.longJob.cancel();
        this.waitForState(this.longJob, 0);
        Assert.assertNull((String)"9.0", (Object)this.longJob.getThread());
        final Thread[] thread = new Thread[1];
        JobChangeAdapter listener = new JobChangeAdapter(){

            public void running(IJobChangeEvent event) {
                thread[0] = event.getJob().getThread();
            }
        };
        this.longJob.addJobChangeListener((IJobChangeListener)listener);
        this.longJob.schedule();
        this.waitForState(this.longJob, 4);
        this.longJob.cancel();
        this.longJob.removeJobChangeListener((IJobChangeListener)listener);
        this.waitForState(this.longJob, 0);
        Assert.assertNotNull((String)"10.0", (Object)thread[0]);
    }

    private void waitForState(Job job, int state) {
        long timeoutInMs = 10000L;
        long start = System.nanoTime();
        try {
            Method internalGetState = InternalJob.class.getDeclaredMethod("internalGetState", new Class[0]);
            internalGetState.setAccessible(true);
            while ((state == 4 ? ((Integer)internalGetState.invoke((Object)job, new Object[0])).intValue() : job.getState()) != state) {
                Thread.yield();
                long elapsed = (System.nanoTime() - start) / 1000000L;
                ((AbstractLongAssert)Assertions.assertThat((long)elapsed).as("timeout waiting for job to change state to " + state + " (current: " + job.getState() + "): " + String.valueOf(job), new Object[0])).isLessThan(timeoutInMs);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private void waitForState(Job[] jobs, int state) {
        Job[] jobArray = jobs;
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            Job job = jobArray[n2];
            this.waitForState(job, state);
            ++n2;
        }
    }

    private static /* synthetic */ void lambda$6(Job job) {
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException e) {
            job.cancel();
        }
    }

    static class TestException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        TestException() {
        }
    }
}

