/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.runtime.jobs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.junit.Assert;

class JobWatcher {
    private final Object[] families;
    private final AtomicLong sheduled;
    private final AtomicLong done;
    private final List<Job> jobsToWaitFor = new LinkedList<Job>();
    private CountDownLatch testDoneSignal;
    Collection<String> errors = new ConcurrentLinkedQueue<String>();
    private final JobChangeAdapter jobListener = new JobChangeAdapter(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void scheduled(IJobChangeEvent event) {
            Job scheduledJob = event.getJob();
            if (JobWatcher.this.jobNeedsToBeWatched(scheduledJob)) {
                List<Job> list = JobWatcher.this.jobsToWaitFor;
                synchronized (list) {
                    this.rememberScheduled(scheduledJob);
                    boolean wasEmpty = JobWatcher.this.jobsToWaitFor.isEmpty();
                    JobWatcher.this.jobsToWaitFor.add(scheduledJob);
                    if (wasEmpty) {
                        JobWatcher.this.testDoneSignal = new CountDownLatch(1);
                    }
                }
            }
        }

        private void rememberScheduled(Job job) {
            JobWatcher.this.sheduled.addAndGet(1L);
        }

        private void rememberDone(Job job) {
            JobWatcher.this.done.addAndGet(1L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void done(IJobChangeEvent event) {
            List<Job> list = JobWatcher.this.jobsToWaitFor;
            synchronized (list) {
                Job job = event.getJob();
                this.rememberDone(job);
                boolean removed = JobWatcher.this.jobsToWaitFor.remove(job);
                if (!removed && JobWatcher.this.testDoneSignal != null && JobWatcher.this.jobNeedsToBeWatched(job)) {
                    JobWatcher.this.errors.add("received 'done' before 'schedule' for " + String.valueOf(job));
                    JobWatcher.this.testDoneSignal.countDown();
                }
                if (!JobWatcher.this.jobsToWaitFor.isEmpty()) {
                    return;
                }
                if (JobWatcher.this.testDoneSignal != null) {
                    JobWatcher.this.testDoneSignal.countDown();
                    JobWatcher.this.testDoneSignal = null;
                }
            }
        }
    };

    public static JobWatcher startWatchingFor(Object ... families) {
        JobWatcher watcher = new JobWatcher(families);
        watcher.startWatchingJobs();
        return watcher;
    }

    private JobWatcher(Object ... families) {
        this.families = families;
        this.sheduled = new AtomicLong();
        this.done = new AtomicLong();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startWatchingJobs() {
        JobWatcher jobWatcher = this;
        synchronized (jobWatcher) {
            Job.getJobManager().addJobChangeListener((IJobChangeListener)this.jobListener);
        }
    }

    private boolean jobNeedsToBeWatched(Job job) {
        Object[] objectArray = this.families;
        int n = this.families.length;
        int n2 = 0;
        while (n2 < n) {
            Object family = objectArray[n2];
            if (job.belongsTo(family)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopWatching() {
        Object object = this;
        synchronized (object) {
            Job.getJobManager().removeJobChangeListener((IJobChangeListener)this.jobListener);
        }
        object = this.jobsToWaitFor;
        synchronized (object) {
            if (this.testDoneSignal != null) {
                this.testDoneSignal.countDown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilJobsAreDone() {
        CountDownLatch latchToWaitFor;
        List<Job> list = this.jobsToWaitFor;
        synchronized (list) {
            if (this.jobsToWaitFor.isEmpty()) {
                return;
            }
            latchToWaitFor = this.testDoneSignal;
        }
        if (latchToWaitFor != null) {
            try {
                latchToWaitFor.await(1L, TimeUnit.MINUTES);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.errors.forEach(e -> {
                throw new AssertionError(e);
            });
            Assert.assertEquals((String)("Jobs delivered in wrong order for " + String.valueOf(this.getJobsToWaitFor())), (long)0L, (long)latchToWaitFor.getCount());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Job> getJobsToWaitFor() {
        List<Job> list = this.jobsToWaitFor;
        synchronized (list) {
            return new ArrayList<Job>(this.jobsToWaitFor);
        }
    }

    public long getScheduled() {
        return this.sheduled.get();
    }

    public long getDone() {
        return this.done.get();
    }
}

