/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.runtime.jobs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.jobs.ILock;

public class LockAcquiringRunnable
implements Runnable {
    private final ILock[] locks;
    private volatile RandomOrder rnd;

    public LockAcquiringRunnable(ILock[] locks) {
        this.locks = locks;
    }

    @Override
    public void run() {
        while (this.rnd.randomWait(this)) {
            ILock[] iLockArray = this.locks;
            int n = this.locks.length;
            int n2 = 0;
            while (n2 < n) {
                ILock lock = iLockArray[n2];
                this.rnd.busy(() -> ((ILock)lock).acquire());
                this.rnd.randomWait(this);
                ++n2;
            }
            int i = this.locks.length;
            while (--i >= 0) {
                this.locks[i].release();
            }
        }
    }

    public void setRandomOrder(RandomOrder rnd) {
        this.rnd = rnd;
    }

    static class RandomOrder {
        private final Queue<LockAcquiringRunnable> randomRunnables = new ConcurrentLinkedQueue<LockAcquiringRunnable>();
        private final int workerCount;
        private final AtomicInteger waiting = new AtomicInteger();
        private final AtomicInteger busy = new AtomicInteger();

        RandomOrder(ArrayList<LockAcquiringRunnable> allRunnables, int maxRounds) {
            this.workerCount = allRunnables.size();
            ArrayList<LockAcquiringRunnable> randomOrder = new ArrayList<LockAcquiringRunnable>();
            for (LockAcquiringRunnable l : allRunnables) {
                int i = 1;
                while (i < maxRounds * (1 + l.locks.length)) {
                    randomOrder.add(l);
                    ++i;
                }
            }
            Collections.shuffle(randomOrder);
            this.randomRunnables.addAll(randomOrder);
        }

        /*
         * Exception decompiling
         */
        public boolean randomWait(LockAcquiringRunnable me) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 0[TRYBLOCK]], but top level block is 11[WHILELOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public void waitForEnd() {
            while (!this.randomRunnables.isEmpty()) {
                Thread.yield();
            }
        }

        public void busy(Runnable runner) {
            this.busy.incrementAndGet();
            try {
                runner.run();
            }
            finally {
                this.busy.decrementAndGet();
            }
        }
    }
}

