/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.runtime.jobs;

import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.core.tests.runtime.jobs.AbstractJobTest;
import org.eclipse.core.tests.runtime.jobs.PathRule;
import org.junit.Assert;
import org.junit.jupiter.api.Test;

public class MultiRuleTest
extends AbstractJobTest {
    @Test
    public void testCombine() {
        PathRule child1 = new PathRule("/a");
        PathRule child2 = new PathRule("/b/c");
        PathRule childOfChild1 = new PathRule("/a/b");
        PathRule nonChild = new PathRule("/z/d");
        MultiRule multi1 = new MultiRule(new ISchedulingRule[]{child1, child2});
        Assert.assertEquals((String)"1.0", (Object)multi1, (Object)MultiRule.combine((ISchedulingRule[])new ISchedulingRule[]{multi1}));
        Assert.assertEquals((String)"1.1", (Object)multi1, (Object)MultiRule.combine((ISchedulingRule[])new ISchedulingRule[]{multi1, child1, child2, childOfChild1}));
        Assert.assertEquals((String)"1.2", (Object)multi1, (Object)MultiRule.combine((ISchedulingRule)multi1, (ISchedulingRule)child2));
        Assert.assertEquals((String)"1.3", (Object)multi1, (Object)MultiRule.combine((ISchedulingRule)childOfChild1, (ISchedulingRule)multi1));
        Assert.assertEquals((String)"1.4", null, (Object)MultiRule.combine(null, null));
        Assert.assertEquals((String)"1.5", (Object)multi1, (Object)MultiRule.combine(null, (ISchedulingRule)multi1));
        Assert.assertEquals((String)"1.6", (Object)child1, (Object)MultiRule.combine((ISchedulingRule)child1, null));
        MultiRule result = (MultiRule)MultiRule.combine((ISchedulingRule)multi1, (ISchedulingRule)nonChild);
        Assert.assertTrue((String)("2.0" + String.valueOf(result)), (boolean)result.contains((ISchedulingRule)multi1));
        Assert.assertTrue((String)"2.1", (boolean)result.contains((ISchedulingRule)nonChild));
    }

    @Test
    public void testContains() {
        PathRule child1 = new PathRule("/a");
        PathRule child2 = new PathRule("/b/c");
        PathRule childOfChild1 = new PathRule("/a/b");
        PathRule nonChild = new PathRule("/z/d");
        MultiRule multi1 = new MultiRule(new ISchedulingRule[]{child1, child2});
        MultiRule multi2 = new MultiRule(new ISchedulingRule[]{childOfChild1});
        Assert.assertTrue((String)"1.0", (boolean)multi1.contains((ISchedulingRule)child1));
        Assert.assertTrue((String)"1.1", (boolean)multi1.contains((ISchedulingRule)child2));
        Assert.assertTrue((String)"1.2", (!multi1.contains((ISchedulingRule)nonChild) ? 1 : 0) != 0);
        Assert.assertTrue((String)"1.3", (boolean)multi1.contains((ISchedulingRule)childOfChild1));
        Assert.assertTrue((String)"1.4", (boolean)multi1.contains((ISchedulingRule)multi2));
        Assert.assertTrue((String)"1.5", (!multi2.contains((ISchedulingRule)multi1) ? 1 : 0) != 0);
        Assert.assertTrue((String)"1.6", (boolean)multi1.contains((ISchedulingRule)multi1));
    }

    @Test
    public void testIsConflicting() {
        PathRule child1 = new PathRule("/a");
        PathRule child2 = new PathRule("/b/c");
        PathRule childOfChild1 = new PathRule("/a/b");
        PathRule nonChild = new PathRule("/z/d");
        MultiRule multi1 = new MultiRule(new ISchedulingRule[]{child1, child2});
        MultiRule multi2 = new MultiRule(new ISchedulingRule[]{childOfChild1, nonChild});
        Assert.assertTrue((String)"1.0", (boolean)multi1.isConflicting((ISchedulingRule)child1));
        Assert.assertTrue((String)"1.1", (boolean)multi1.isConflicting((ISchedulingRule)child2));
        Assert.assertTrue((String)"1.2", (!multi1.isConflicting((ISchedulingRule)nonChild) ? 1 : 0) != 0);
        Assert.assertTrue((String)"1.3", (boolean)multi1.isConflicting((ISchedulingRule)childOfChild1));
        Assert.assertTrue((String)"1.4", (boolean)multi1.isConflicting((ISchedulingRule)multi2));
        Assert.assertTrue((String)"1.5", (boolean)multi2.isConflicting((ISchedulingRule)multi1));
        Assert.assertTrue((String)"1.6", (boolean)multi1.isConflicting((ISchedulingRule)multi1));
    }
}

