/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.runtime.jobs;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.core.tests.harness.TestBarrier2;
import org.junit.Assert;

public class OrderAsserter {
    private final AtomicInteger preparation = new AtomicInteger();
    private final AtomicInteger progress = new AtomicInteger();
    private final Collection<Throwable> errors = new ConcurrentLinkedQueue<Throwable>();
    private final Map<Integer, Event> eventsByEventNumber = new ConcurrentHashMap<Integer, Event>();
    private final ReentrantLock lock = new ReentrantLock();
    private final long defaultWaitMs;
    volatile Exception potentialDeadlock;

    public OrderAsserter() {
        this(1L);
    }

    public OrderAsserter(long defaultWaitMs) {
        this.defaultWaitMs = defaultWaitMs;
    }

    public void expect(Event event) {
        this.expect(event, this.defaultWaitMs);
    }

    public void expect(Event event, long waitMs) {
        if (!this.errors.isEmpty()) {
            return;
        }
        try {
            int currentProgress = this.progress.incrementAndGet();
            Assert.assertNotNull((String)("Should not happen but was event number " + this.getEventString(currentProgress)), (Object)event);
            if (!this.lock.tryLock()) {
                throw new AssertionError("Race condition at " + String.valueOf(event), this.potentialDeadlock);
            }
            try {
                this.potentialDeadlock = new IllegalStateException("Race condition with " + String.valueOf(event) + " in Thread '" + Thread.currentThread().getName() + "'");
                Thread.sleep(waitMs);
            }
            finally {
                this.potentialDeadlock = null;
                this.lock.unlock();
            }
            Assert.assertFalse((String)("Too late. Expected to happen as " + String.valueOf(event) + " but was " + this.getEventString(currentProgress)), (currentProgress > event.eventNumber ? 1 : 0) != 0);
            Assert.assertFalse((String)("Too early. Expected to happen as " + String.valueOf(event) + " but was " + this.getEventString(currentProgress)), (currentProgress < event.eventNumber ? 1 : 0) != 0);
        }
        catch (Throwable e) {
            this.addError(e);
        }
    }

    private String getEventString(Integer eventNumber) {
        Event event = this.eventsByEventNumber.get(eventNumber);
        if (event != null) {
            return event.toString();
        }
        return "eventNumber=" + String.valueOf(eventNumber);
    }

    public void runCollectingError(Runnable runnable) {
        if (!this.errors.isEmpty()) {
            return;
        }
        try {
            runnable.run();
        }
        catch (Throwable e) {
            this.addError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addError(Throwable e) {
        Collection<Throwable> collection = this.errors;
        synchronized (collection) {
            e = new AssertionError(((Throwable)e).getLocalizedMessage() + " in Thread '" + Thread.currentThread().getName() + "'", (Throwable)e);
            if (!this.errors.isEmpty()) {
                return;
            }
            String threadDump = TestBarrier2.getThreadDump();
            this.errors.add((Throwable)e);
            ((Throwable)e).printStackTrace();
            System.err.println(threadDump);
        }
    }

    public void assertNoErrors() {
        this.errors.forEach(e -> {
            throw new AssertionError(e);
        });
    }

    public Event never(String name) {
        return new Event(name, null);
    }

    public Event getNext(String name) {
        int eventNumber = this.preparation.incrementAndGet();
        Event event = new Event(name, eventNumber);
        this.eventsByEventNumber.put(eventNumber, event);
        return event;
    }

    public class Event {
        final String name;
        final Integer eventNumber;

        Event(String name, Integer eventNumber) {
            this.eventNumber = eventNumber;
            this.name = name;
        }

        public String toString() {
            return "Event " + String.valueOf(this.eventNumber) + " " + this.name;
        }
    }
}

