/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.runtime.jobs;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.core.internal.jobs.DeadlockDetector;
import org.eclipse.core.internal.jobs.LockManager;
import org.eclipse.core.internal.jobs.OrderedLock;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.LockListener;
import org.eclipse.core.tests.harness.TestBarrier2;
import org.eclipse.core.tests.runtime.jobs.LockAcquiringRunnable;
import org.junit.Assert;
import org.junit.jupiter.api.RepeatedTest;

public class OrderedLockTest {
    private static final int REPETITIONS = 10;

    private void createRunnables(ILock[] locks, int n, ArrayList<LockAcquiringRunnable> allRunnables) {
        int i = 0;
        while (i < n) {
            allRunnables.add(new LockAcquiringRunnable(locks));
            ++i;
        }
    }

    @RepeatedTest(value=10)
    public void testComplex() {
        DeadlockDetector.runSilent(() -> {
            ArrayList<LockAcquiringRunnable> allRunnables = new ArrayList<LockAcquiringRunnable>();
            LockManager manager = new LockManager();
            OrderedLock lock1 = manager.newLock();
            OrderedLock lock2 = manager.newLock();
            OrderedLock lock3 = manager.newLock();
            this.createRunnables(new ILock[]{lock1, lock2, lock3}, 5, allRunnables);
            this.createRunnables(new ILock[]{lock3, lock2, lock1}, 5, allRunnables);
            this.createRunnables(new ILock[]{lock1, lock3, lock2}, 5, allRunnables);
            this.createRunnables(new ILock[]{lock2, lock3, lock1}, 5, allRunnables);
            this.execute(allRunnables);
            Assert.assertTrue((String)"Locks not removed from graph.", (boolean)manager.isEmpty());
        });
    }

    @RepeatedTest(value=10)
    public void testManyLocksAndThreads() {
        int numberOfLocks = 10;
        int numberOfThreads = 10;
        DeadlockDetector.runSilent(() -> {
            ArrayList<LockAcquiringRunnable> allRunnables = new ArrayList<LockAcquiringRunnable>();
            LockManager manager = new LockManager();
            manager.setLockListener(new LockListener(){

                public boolean aboutToWait(Thread lockOwner) {
                    Thread.yield();
                    return false;
                }
            });
            ArrayList<OrderedLock> locks = new ArrayList<OrderedLock>();
            int i = 0;
            while (i < numberOfLocks) {
                locks.add(manager.newLock());
                ++i;
            }
            i = 0;
            while (i < numberOfThreads / 5) {
                Collections.shuffle(locks);
                this.createRunnables((ILock[])locks.toArray(OrderedLock[]::new), 5, allRunnables);
                ++i;
            }
            this.execute(allRunnables);
            Assert.assertTrue((String)"Locks not removed from graph.", (boolean)manager.isEmpty());
        });
    }

    @RepeatedTest(value=10)
    public void testSimple() {
        DeadlockDetector.runSilent(() -> {
            ArrayList<LockAcquiringRunnable> allRunnables = new ArrayList<LockAcquiringRunnable>();
            LockManager manager = new LockManager();
            OrderedLock lock1 = manager.newLock();
            OrderedLock lock2 = manager.newLock();
            OrderedLock lock3 = manager.newLock();
            this.createRunnables(new ILock[]{lock1, lock2, lock3}, 1, allRunnables);
            this.createRunnables(new ILock[]{lock3, lock2, lock1}, 1, allRunnables);
            this.execute(allRunnables);
            Assert.assertTrue((String)"Locks not removed from graph.", (boolean)manager.isEmpty());
        });
    }

    @RepeatedTest(value=10)
    public void testLockAcquireInterrupt() throws InterruptedException {
        final TestBarrier2 barrier = new TestBarrier2();
        LockManager manager = new LockManager();
        OrderedLock lock = manager.newLock();
        boolean[] wasInterupted = new boolean[1];
        Thread t = new Thread((ILock)lock, wasInterupted){
            private final /* synthetic */ ILock val$lock;
            private final /* synthetic */ boolean[] val$wasInterupted;
            {
                this.val$lock = iLock;
                this.val$wasInterupted = blArray;
            }

            @Override
            public void run() {
                barrier.setStatus(3);
                barrier.waitForStatus(0);
                barrier.setStatus(4);
                this.val$lock.acquire();
                this.val$wasInterupted[0] = Thread.currentThread().isInterrupted();
                this.val$lock.release();
            }
        };
        t.start();
        barrier.waitForStatus(3);
        lock.acquire();
        barrier.setStatus(0);
        barrier.waitForStatus(4);
        Thread.yield();
        t.interrupt();
        lock.release();
        t.join();
        Assert.assertTrue((String)"1.0", (boolean)wasInterupted[0]);
    }

    @RepeatedTest(value=10)
    public void testLockTimeout() {
        LockManager manager = new LockManager();
        OrderedLock lock = manager.newLock();
        TestBarrier2 status = new TestBarrier2(1);
        boolean[] alive = new boolean[]{true};
        Runnable getLock = () -> {
            lock.acquire();
            status.upgradeTo(3);
            while (alive[0]) {
                Thread.yield();
            }
            lock.release();
            status.upgradeTo(5);
        };
        Runnable tryForLock = () -> {
            boolean success = false;
            try {
                success = lock.acquire(0L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Assert.assertTrue((String)"1.0", (!success ? 1 : 0) != 0);
            Assert.assertTrue((String)"1.1", (!manager.isLockOwner() ? 1 : 0) != 0);
            status.upgradeTo(4);
        };
        Thread first = new Thread(getLock);
        Thread second = new Thread(tryForLock);
        first.start();
        status.waitForStatus(3);
        second.start();
        status.waitForStatus(4);
        alive[0] = false;
        status.waitForStatus(5);
        Assert.assertTrue((String)"Locks not removed from graph.", (boolean)manager.isEmpty());
    }

    @RepeatedTest(value=10)
    public void testLockRequestDisappearence() {
        final LockManager manager = new LockManager();
        final OrderedLock lock = manager.newLock();
        final TestBarrier2 status0main = new TestBarrier2(0);
        final TestBarrier2 status1getLock = new TestBarrier2(0);
        final TestBarrier2 status2waitForLock = new TestBarrier2(0);
        final TestBarrier2 status3forceGetLock = new TestBarrier2(0);
        final ConcurrentLinkedQueue errors = new ConcurrentLinkedQueue();
        Thread thread1getLock = new Thread("thread1getLock"){

            @Override
            public void run() {
                try {
                    lock.acquire();
                    status1getLock.upgradeTo(1);
                    status0main.waitForStatus(3);
                    lock.release();
                    status1getLock.upgradeTo(5);
                }
                catch (Throwable t) {
                    errors.add(t);
                }
            }
        };
        final Thread thread2waitForLock = new Thread("thread2waitForLock"){

            @Override
            public void run() {
                try {
                    status2waitForLock.upgradeTo(1);
                    lock.acquire();
                    Assert.assertTrue((String)"1.0", (boolean)manager.isLockOwner());
                    lock.release();
                    status2waitForLock.upgradeTo(5);
                }
                catch (Throwable t) {
                    errors.add(t);
                }
            }
        };
        Thread thread3forceGetLock = new Thread("thread3forceGetLock"){

            @Override
            public void run() {
                try {
                    lock.acquire();
                    lock.release();
                    status3forceGetLock.upgradeTo(5);
                }
                catch (Throwable t) {
                    errors.add(t);
                }
            }
        };
        LockListener listener = new LockListener(){

            public boolean aboutToWait(Thread lockOwner) {
                return true;
            }
        };
        LockListener waitListener = new LockListener(){

            public boolean aboutToWait(Thread lockOwner) {
                if (Thread.currentThread() == thread2waitForLock) {
                    status0main.waitForStatus(2);
                    status2waitForLock.upgradeTo(4);
                }
                return false;
            }
        };
        thread1getLock.start();
        manager.setLockListener(waitListener);
        status1getLock.waitForStatus(1);
        thread2waitForLock.start();
        status2waitForLock.waitForStatus(1);
        status0main.upgradeTo(2);
        status2waitForLock.waitForStatus(4);
        manager.setLockListener(listener);
        thread3forceGetLock.start();
        status3forceGetLock.waitForStatus(5);
        status0main.upgradeTo(3);
        status1getLock.waitForStatus(5);
        status2waitForLock.waitForStatus(5);
        Assert.assertTrue((String)"Locks not removed from graph.", (boolean)manager.isEmpty());
        errors.forEach(Throwable::printStackTrace);
        Assert.assertTrue((String)("Error happend: " + errors.stream().map(e -> String.valueOf(e)).collect(Collectors.joining(", "))), (boolean)errors.isEmpty());
    }

    private void execute(ArrayList<LockAcquiringRunnable> allRunnables) {
        LockAcquiringRunnable.RandomOrder randomOrder = new LockAcquiringRunnable.RandomOrder(allRunnables, 2);
        for (LockAcquiringRunnable lockAcquiringRunnable : allRunnables) {
            lockAcquiringRunnable.setRandomOrder(randomOrder);
        }
        ArrayList<Thread> threads = new ArrayList<Thread>();
        for (LockAcquiringRunnable lockAcquiringRunnable : allRunnables) {
            Thread thread = new Thread(lockAcquiringRunnable);
            threads.add(thread);
            thread.start();
        }
        randomOrder.waitForEnd();
        Duration timeoutTime = Duration.ofMillis(System.currentTimeMillis()).plusSeconds(5L);
        for (Thread thread : threads) {
            try {
                Duration remainingTime = timeoutTime.minusMillis(System.currentTimeMillis());
                thread.join(remainingTime.toMillis());
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
            this.checkTimeout(timeoutTime);
            Assertions.assertThat((Object)thread).matches(Predicate.not(Thread::isAlive), "is not alive");
        }
    }

    public void checkTimeout(Duration timeoutTime) {
        Duration currentTime = Duration.ofMillis(System.currentTimeMillis());
        if (timeoutTime.minus(currentTime).toMillis() <= 0L) {
            ((AbstractLongAssert)Assertions.assertThat((long)currentTime.toMillis()).as("threads did not end in time. All thread infos begin: ----\n" + OrderedLockTest.getThreadDump() + "---- All thread infos end.\n", new Object[0])).isLessThan(timeoutTime.toMillis());
        }
    }

    public static String getThreadDump() {
        StringBuilder b = new StringBuilder();
        ThreadInfo[] threadInfoArray = ManagementFactory.getThreadMXBean().dumpAllThreads(true, true);
        int n = threadInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            ThreadInfo info = threadInfoArray[n2];
            b.append(info);
            ++n2;
        }
        return b.toString();
    }
}

