/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.runtime.jobs;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public class PathRule
implements ISchedulingRule {
    private final IPath path;

    public PathRule(IPath path) {
        this.path = path;
    }

    public PathRule(String pathString) {
        this.path = IPath.fromOSString((String)pathString);
    }

    public boolean contains(ISchedulingRule rule) {
        if (this == rule) {
            return true;
        }
        if (!(rule instanceof PathRule)) {
            return false;
        }
        return this.path.isPrefixOf(((PathRule)rule).getFullPath());
    }

    public boolean isConflicting(ISchedulingRule rule) {
        if (!(rule instanceof PathRule)) {
            return false;
        }
        IPath otherPath = ((PathRule)rule).getFullPath();
        return this.path.isPrefixOf(otherPath) || otherPath.isPrefixOf(this.path);
    }

    public IPath getFullPath() {
        return this.path;
    }

    public String toString() {
        return "PathRule(" + String.valueOf(this.path) + ")";
    }
}

