/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.runtime.jobs;

import java.util.Random;
import org.eclipse.core.runtime.jobs.ILock;

public class RandomTestRunnable
extends Thread {
    private final ILock[] locks;
    private final Random random = new Random();
    private boolean alive;
    private final boolean needRandomization;
    volatile int runs;

    public RandomTestRunnable(ILock[] locks, String name, boolean addRandomness) {
        super(name);
        this.locks = new ILock[locks.length];
        System.arraycopy(locks, 0, this.locks, 0, locks.length);
        this.alive = true;
        this.needRandomization = addRandomness;
    }

    public void kill() {
        this.alive = false;
    }

    @Override
    public void run() {
        while (this.alive) {
            int i;
            if (this.needRandomization) {
                i = 0;
                while (i < this.locks.length) {
                    int nextFlip = this.random.nextInt(this.locks.length);
                    ILock temp = this.locks[i];
                    this.locks[i] = this.locks[nextFlip];
                    this.locks[nextFlip] = temp;
                    ++i;
                }
            }
            ILock[] iLockArray = this.locks;
            int n = this.locks.length;
            int n2 = 0;
            while (n2 < n) {
                ILock lock = iLockArray[n2];
                lock.acquire();
                try {
                    int r = this.random.nextInt(3);
                    if (r > 0) {
                        Thread.sleep(r);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++n2;
            }
            i = this.locks.length;
            while (--i >= 0) {
                this.locks[i].release();
            }
            ++this.runs;
        }
    }
}

