/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.runtime.jobs;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.jobs.ILock;

public class ReadWriteMonitor {
    private final Set<Thread> blockedThreads = Collections.synchronizedSet(new HashSet());
    private final ILock lock;
    private int status = 0;

    public ReadWriteMonitor(ILock lock) {
        this.lock = lock;
    }

    public void enterRead() {
        if (!this.incrementRead()) {
            this.blockedThreads.add(Thread.currentThread());
            while (!this.incrementRead()) {
                try {
                    this.lock.acquire(Long.MAX_VALUE);
                    this.setStatus(1);
                    break;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.blockedThreads.remove(Thread.currentThread());
        }
        this.interruptBlockedThreads();
    }

    public void enterWrite() {
        this.blockedThreads.add(Thread.currentThread());
        while (true) {
            try {
                this.lock.acquire(Long.MAX_VALUE);
                this.setStatus(-1);
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
        this.blockedThreads.remove(Thread.currentThread());
    }

    private synchronized void setStatus(int s) {
        this.status = s;
    }

    public synchronized void exitRead() {
        Assert.isTrue((this.status > 0 ? 1 : 0) != 0, (String)"exitRead without enterRead");
        if (--this.status == 0) {
            this.lock.release();
            this.interruptBlockedThreads();
        }
    }

    public synchronized void exitWrite() {
        Assert.isTrue((this.status == -1 ? 1 : 0) != 0, (String)"exitWrite without enterWrite");
        this.status = 0;
        this.lock.release();
        this.interruptBlockedThreads();
    }

    public synchronized void exitWriteEnterRead() {
        this.status = 1;
        this.interruptBlockedThreads();
    }

    private synchronized boolean incrementRead() {
        if (this.status <= 0) {
            return false;
        }
        ++this.status;
        return true;
    }

    private void interruptBlockedThreads() {
        for (Thread thread : this.blockedThreads) {
            thread.interrupt();
        }
    }
}

