/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.runtime.jobs;

import java.util.function.Function;
import org.eclipse.core.runtime.jobs.LockListener;
import org.junit.Assert;

public class TestLockListener
extends LockListener {
    private boolean hasBeenWaiting;
    private boolean waiting;
    private final Runnable executeWhenAboutToWait;

    public TestLockListener() {
        this(Function::identity);
    }

    public TestLockListener(Runnable executeWhenAboutToWait) {
        this.executeWhenAboutToWait = executeWhenAboutToWait;
    }

    public synchronized void aboutToRelease() {
        this.waiting = false;
    }

    public synchronized boolean aboutToWait(Thread lockOwner) {
        this.hasBeenWaiting = true;
        this.waiting = true;
        this.executeWhenAboutToWait.run();
        return false;
    }

    public synchronized void assertNotWaiting(String message) {
        Assert.assertTrue((String)message, (!this.waiting ? 1 : 0) != 0);
    }

    public synchronized void assertHasBeenWaiting(String message) {
        Assert.assertTrue((String)message, (boolean)this.hasBeenWaiting);
    }
}

