/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.runtime.jobs;

import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.core.internal.jobs.Worker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.junit.Assert;
import org.junit.jupiter.api.Test;

public class WorkerPoolTest {
    private static final int MAX_ALLOWED_IDLE_WORKER_THREADS = 50;
    private static final int THREAD_MULTIPLIER = 10;
    private static final int BARRIER_TIMEOUT_IN_SEC = 100;
    private static final int WORKER_TIMEOUT_IN_MSEC = 5000;

    @Test
    public void testIdleWorkerCap() throws Exception {
        int totalJobs = 500;
        final CyclicBarrier parallelJobStartBarrier = new CyclicBarrier(501);
        int i = 0;
        while (i < 500) {
            new Job("testIdleWorkerCap-" + i){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        parallelJobStartBarrier.await();
                    }
                    catch (InterruptedException | BrokenBarrierException e) {
                        return Status.CANCEL_STATUS;
                    }
                    return Status.OK_STATUS;
                }
            }.schedule();
            ++i;
        }
        parallelJobStartBarrier.await(100L, TimeUnit.SECONDS);
        long startTimeInMSec = System.currentTimeMillis();
        int workerThreadCount = this.getWorkerThreadCount();
        while (workerThreadCount > 50) {
            if (System.currentTimeMillis() - startTimeInMSec > 5000L) {
                Assert.fail((String)("Timeout reached! Too many worker threads active: " + workerThreadCount + ", expected <= 50"));
            }
            Thread.yield();
            workerThreadCount = this.getWorkerThreadCount();
        }
    }

    private int getWorkerThreadCount() {
        Thread[] threads = new Thread[Thread.activeCount() * 2];
        int enumeratedThreadCount = Thread.enumerate(threads);
        ((AbstractIntegerAssert)Assertions.assertThat((int)enumeratedThreadCount).as("check not too many active threads", new Object[0])).isLessThan(threads.length);
        int workerThreadCount = 0;
        int i = 0;
        while (i < enumeratedThreadCount) {
            if (threads[i] instanceof Worker) {
                ++workerThreadCount;
            }
            ++i;
        }
        return workerThreadCount;
    }
}

