/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.runtime.jobs;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicIntegerArray;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.core.tests.harness.TestBarrier2;
import org.eclipse.core.tests.harness.TestJob;
import org.eclipse.core.tests.runtime.jobs.AbstractJobTest;
import org.eclipse.core.tests.runtime.jobs.PathRule;
import org.junit.Assert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class YieldTest
extends AbstractJobTest {
    protected int completedJobs;
    private IJobChangeListener[] jobListeners;
    protected int scheduledJobs;
    private String testName;

    @BeforeEach
    public void setUp(TestInfo testInfo) throws Exception {
        this.testName = testInfo.getDisplayName();
        this.completedJobs = 0;
        this.scheduledJobs = 0;
        IJobChangeListener[] iJobChangeListenerArray = this.jobListeners = new IJobChangeListener[]{new TestJobListener()};
        int n = this.jobListeners.length;
        int n2 = 0;
        while (n2 < n) {
            IJobChangeListener jobListener = iJobChangeListenerArray[n2];
            this.manager.addJobChangeListener(jobListener);
            ++n2;
        }
    }

    @AfterEach
    public void tearDown() throws Exception {
        IJobChangeListener jobListener;
        IJobChangeListener[] iJobChangeListenerArray = this.jobListeners;
        int n = this.jobListeners.length;
        int n2 = 0;
        while (n2 < n) {
            jobListener = iJobChangeListenerArray[n2];
            if (jobListener instanceof TestJobListener) {
                ((TestJobListener)jobListener).cancelAllJobs();
            }
            ++n2;
        }
        this.waitForCompletion();
        iJobChangeListenerArray = this.jobListeners;
        n = this.jobListeners.length;
        n2 = 0;
        while (n2 < n) {
            jobListener = iJobChangeListenerArray[n2];
            this.manager.removeJobChangeListener(jobListener);
            ++n2;
        }
    }

    @Test
    public void testExceptionWhenYieldingNotOwner() {
        AtomicIntegerArray location = new AtomicIntegerArray(new int[2]);
        final TestBarrier2 barrier1 = new TestBarrier2(location, 0);
        final TestBarrier2 barrier2 = new TestBarrier2(location, 1);
        final Job yielding = new Job(this.testName + " Yielding"){

            protected IStatus run(IProgressMonitor monitor) {
                barrier2.setStatus(1);
                barrier1.waitForStatus(1);
                return Status.OK_STATUS;
            }
        };
        Job otherJob = new Job(this.testName + " ShouldFault"){

            protected IStatus run(IProgressMonitor monitor) {
                barrier2.waitForStatus(1);
                try {
                    try {
                        yielding.yieldRule(null);
                    }
                    catch (IllegalArgumentException e) {
                        Status status = new Status(4, "org.eclipse.core.tests.runtime", "Expected failure");
                        barrier1.setStatus(1);
                        return status;
                    }
                }
                finally {
                    barrier1.setStatus(1);
                }
                return Status.OK_STATUS;
            }
        };
        yielding.schedule();
        otherJob.schedule();
        this.waitForCompletion(otherJob);
        Assert.assertTrue((!otherJob.getResult().isOK() ? 1 : 0) != 0);
        this.waitForCompletion(yielding);
    }

    @Test
    public void testExceptionWhenYieldingNotRunning() {
        Job yielding = new Job(this.testName + " Yielding"){

            protected IStatus run(IProgressMonitor monitor) {
                return Status.OK_STATUS;
            }
        };
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Job job2 = yielding.yieldRule(null);
        });
    }

    @Test
    public void testThreadRestored() {
        Job conflictingJob;
        Job yieldJob;
        PathRule rule = new PathRule(this.testName);
        final Job[] jobs = new Job[2];
        jobs[0] = yieldJob = new Job(this.testName + " Yielding"){

            protected IStatus run(IProgressMonitor monitor) {
                Assert.assertNull((String)("Conflicting job result is not null: " + String.valueOf(jobs[1].getResult())), (Object)jobs[1].getResult());
                Thread before = this.getThread();
                while (this.yieldRule(null) == null) {
                }
                YieldTest.this.waitForCompletion(jobs[1]);
                Thread after = this.getThread();
                Assert.assertEquals((String)"Thread not restored", (Object)before, (Object)after);
                Assert.assertTrue((String)"Conflicting job not done", (boolean)jobs[1].getResult().isOK());
                Assert.assertEquals((String)"Conflicting job still running", (long)0L, (long)jobs[1].getState());
                return Status.OK_STATUS;
            }
        };
        yieldJob.setRule((ISchedulingRule)rule);
        jobs[1] = conflictingJob = new Job(this.testName + " Conflicting"){

            protected IStatus run(IProgressMonitor monitor) {
                Assert.assertEquals((long)2L, (long)jobs[0].getState());
                Assert.assertNull((Object)jobs[0].getResult());
                return Status.OK_STATUS;
            }
        };
        conflictingJob.setRule((ISchedulingRule)rule);
        yieldJob.schedule();
        conflictingJob.schedule();
        this.waitForCompletion(yieldJob);
        Assert.assertTrue((String)("Result is not ok: " + String.valueOf(yieldJob.getResult())), (boolean)yieldJob.getResult().isOK());
        this.waitForCompletion(conflictingJob);
        Assert.assertTrue((boolean)conflictingJob.getResult().isOK());
    }

    @Test
    public void testYieldJobToJob() throws Throwable {
        Job conflictingJob;
        Job yieldJob;
        PathRule rule = new PathRule(this.testName);
        final Job[] jobs = new Job[2];
        jobs[0] = yieldJob = new Job(this.testName + " Yielding"){

            protected IStatus run(IProgressMonitor monitor) {
                Assert.assertNull((Object)jobs[1].getResult());
                while (this.yieldRule(null) == null) {
                }
                YieldTest.this.waitForCompletion(jobs[1]);
                Assert.assertTrue((boolean)jobs[1].getResult().isOK());
                Assert.assertEquals((long)0L, (long)jobs[1].getState());
                return Status.OK_STATUS;
            }
        };
        yieldJob.setRule((ISchedulingRule)rule);
        jobs[1] = conflictingJob = new Job(this.testName + " Conflicting"){

            protected IStatus run(IProgressMonitor monitor) {
                Assert.assertEquals((long)2L, (long)jobs[0].getState());
                Assert.assertNull((Object)jobs[0].getResult());
                return Status.OK_STATUS;
            }
        };
        conflictingJob.setRule((ISchedulingRule)rule);
        yieldJob.schedule();
        conflictingJob.schedule();
        this.waitForCompletion(yieldJob);
        IStatus yieldResult = yieldJob.getResult();
        if (!yieldResult.isOK()) {
            Throwable t = yieldResult.getException();
            if (t != null) {
                throw t;
            }
            throw new CoreException(yieldResult);
        }
        this.waitForCompletion(conflictingJob);
        Assert.assertTrue((boolean)conflictingJob.getResult().isOK());
    }

    @Test
    public void testYieldJobToJobAndEnsureConflictingRunsBeforeResume() {
        Job yieldJob;
        PathRule rule = new PathRule(this.testName);
        AtomicIntegerArray location = new AtomicIntegerArray(new int[2]);
        final TestBarrier2 barrier1 = new TestBarrier2(location, 0);
        Job[] jobs = new Job[2];
        jobs[0] = yieldJob = new Job(this.testName + " Yielding"){

            protected IStatus run(IProgressMonitor monitor) {
                barrier1.waitForStatus(1);
                barrier1.setStatus(3);
                while (this.yieldRule(null) == null) {
                }
                barrier1.waitForStatus(5);
                return Status.OK_STATUS;
            }
        };
        yieldJob.setRule((ISchedulingRule)rule);
        Job conflictingJob1 = new Job(this.testName + " Conflicting"){

            protected IStatus run(IProgressMonitor monitor) {
                barrier1.setStatus(5);
                return Status.OK_STATUS;
            }
        };
        conflictingJob1.setRule((ISchedulingRule)rule);
        Job nonConflict = new Job(this.testName + " Non-conflicting"){

            protected IStatus run(IProgressMonitor monitor) {
                return Status.OK_STATUS;
            }
        };
        yieldJob.schedule();
        conflictingJob1.schedule();
        barrier1.setStatus(1);
        nonConflict.schedule(1L);
        this.waitForCompletion(yieldJob);
        this.waitForCompletion(conflictingJob1);
        this.waitForCompletion(nonConflict);
        Assert.assertTrue((boolean)yieldJob.getResult().isOK());
        Assert.assertTrue((boolean)conflictingJob1.getResult().isOK());
        Assert.assertTrue((boolean)nonConflict.getResult().isOK());
    }

    @Test
    public void testYieldJobToThread() {
        final PathRule rule = new PathRule(this.testName);
        final TestBarrier2 barrier = new TestBarrier2();
        Job yielding = new Job(this.testName + " Yielding"){

            protected IStatus run(IProgressMonitor monitor) {
                barrier.setStatus(1);
                while (this.yieldRule(null) == null) {
                }
                barrier.waitForStatus(5);
                return Status.OK_STATUS;
            }
        };
        yielding.setRule((ISchedulingRule)rule);
        Thread t = new Thread(this.testName + " Conflicting"){

            @Override
            public void run() {
                try {
                    Job.getJobManager().beginRule((ISchedulingRule)rule, null);
                    barrier.setStatus(5);
                }
                finally {
                    Job.getJobManager().endRule((ISchedulingRule)rule);
                }
            }
        };
        yielding.schedule();
        barrier.waitForStatus(1);
        t.start();
        this.waitForCompletion(yielding);
        Assert.assertTrue((boolean)yielding.getResult().isOK());
    }

    @Test
    public void testYieldThreadJobToThread() {
        final PathRule rule = new PathRule(this.testName);
        final TestBarrier2 barrier = new TestBarrier2();
        Job yielding = new Job(this.testName + " Yielding"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    Job.getJobManager().beginRule((ISchedulingRule)rule, null);
                    barrier.setStatus(1);
                    while (this.yieldRule(null) == null) {
                    }
                    barrier.waitForStatus(5);
                }
                finally {
                    Job.getJobManager().endRule((ISchedulingRule)rule);
                }
                return Status.OK_STATUS;
            }
        };
        Thread t = new Thread(this.testName + " Conflicting"){

            @Override
            public void run() {
                try {
                    Job.getJobManager().beginRule((ISchedulingRule)rule, null);
                    barrier.setStatus(5);
                }
                finally {
                    Job.getJobManager().endRule((ISchedulingRule)rule);
                }
            }
        };
        yielding.schedule();
        barrier.waitForStatus(1);
        t.start();
        this.waitForCompletion(yielding, Duration.ofSeconds(5L));
        Assert.assertTrue((boolean)yielding.getResult().isOK());
    }

    @Test
    public void testYieldThreadToJob() {
        final PathRule rule = new PathRule(this.testName);
        final TestBarrier2 barrier = new TestBarrier2();
        Thread t = new Thread(){

            @Override
            public void run() {
                IJobManager m = Job.getJobManager();
                try {
                    m.beginRule((ISchedulingRule)rule, null);
                    Job j = m.currentJob();
                    barrier.setStatus(1);
                    barrier.waitForStatus(0);
                    while (j.yieldRule(null) == null) {
                    }
                    barrier.waitForStatus(5);
                }
                finally {
                    m.endRule((ISchedulingRule)rule);
                    barrier.setStatus(4);
                }
            }
        };
        Job conflictingJob = new Job(this.testName + " Conflicting"){

            protected IStatus run(IProgressMonitor monitor) {
                barrier.setStatus(5);
                return Status.OK_STATUS;
            }
        };
        t.start();
        barrier.waitForStatus(1);
        conflictingJob.setRule((ISchedulingRule)rule);
        conflictingJob.schedule();
        barrier.setStatus(0);
        barrier.waitForStatus(4);
        this.waitForCompletion(conflictingJob);
        Assert.assertTrue((boolean)conflictingJob.getResult().isOK());
    }

    @Test
    public void testYieldThreadToThreadJob() {
        final PathRule rule = new PathRule(this.testName);
        final TestBarrier2 barrier = new TestBarrier2();
        Thread t = new Thread(this.testName + " Yielding"){

            @Override
            public void run() {
                try {
                    Job.getJobManager().beginRule((ISchedulingRule)rule, null);
                    barrier.setStatus(1);
                    while (Job.getJobManager().currentJob().yieldRule(null) == null) {
                    }
                    barrier.waitForStatus(5);
                }
                finally {
                    Job.getJobManager().endRule((ISchedulingRule)rule);
                }
                barrier.setStatus(6);
            }
        };
        Job conflicting = new Job(this.testName + " Conflicting"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    Job.getJobManager().beginRule((ISchedulingRule)rule, null);
                }
                finally {
                    Job.getJobManager().endRule((ISchedulingRule)rule);
                }
                barrier.setStatus(5);
                return Status.OK_STATUS;
            }
        };
        t.start();
        barrier.waitForStatus(1);
        conflicting.schedule();
        this.waitForCompletion(conflicting, Duration.ofSeconds(5L));
        Assert.assertTrue((boolean)conflicting.getResult().isOK());
        barrier.waitForStatus(6);
    }

    private synchronized void waitForCompletion() {
        int i = 0;
        Assert.assertTrue((String)"Jobs completed that weren't scheduled", (this.completedJobs <= this.scheduledJobs ? 1 : 0) != 0);
        while (this.completedJobs < this.scheduledJobs) {
            try {
                this.wait(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (i++ <= 1000) continue;
            this.dumpState();
            Assert.assertTrue((String)"Timeout waiting for job to complete", (boolean)false);
        }
    }

    public void transferRuleToYieldingThreadJobException() {
        final TestBarrier2 barrier = new TestBarrier2();
        final PathRule rule = new PathRule(this.testName);
        final Thread A = new Thread(){

            @Override
            public void run() {
                try {
                    Job.getJobManager().beginRule((ISchedulingRule)rule, null);
                    barrier.setStatus(3);
                    while (Job.getJobManager().currentJob().yieldRule(null) == null) {
                    }
                }
                finally {
                    Job.getJobManager().endRule((ISchedulingRule)rule);
                }
            }
        };
        Thread B = new Thread(){

            @Override
            public void run() {
                barrier.waitForStatus(3);
                try {
                    Job.getJobManager().beginRule((ISchedulingRule)rule, null);
                    try {
                        Job.getJobManager().transferRule((ISchedulingRule)rule, A);
                    }
                    catch (Exception e) {
                        barrier.setStatus(5);
                    }
                }
                finally {
                    Job.getJobManager().endRule((ISchedulingRule)rule);
                }
            }
        };
        A.start();
        B.start();
        barrier.waitForStatus(5);
    }

    public void transferRuleToYieldingJobException() {
        final TestBarrier2 barrier = new TestBarrier2();
        final PathRule rule = new PathRule(this.testName);
        final Thread[] t = new Thread[1];
        Job A = new Job(this.testName + "A"){

            protected IStatus run(IProgressMonitor monitor) {
                t[0] = this.getThread();
                try {
                    Job.getJobManager().beginRule((ISchedulingRule)rule, null);
                    barrier.setStatus(3);
                    while (Job.getJobManager().currentJob().yieldRule(null) == null) {
                    }
                }
                finally {
                    Job.getJobManager().endRule((ISchedulingRule)rule);
                }
                return Status.OK_STATUS;
            }
        };
        Job B = new Job(this.testName + "B"){

            protected IStatus run(IProgressMonitor monitor) {
                barrier.waitForStatus(3);
                try {
                    Job.getJobManager().beginRule((ISchedulingRule)rule, null);
                    try {
                        Job.getJobManager().transferRule((ISchedulingRule)rule, t[0]);
                    }
                    catch (Exception e) {
                        barrier.setStatus(5);
                    }
                }
                finally {
                    Job.getJobManager().endRule((ISchedulingRule)rule);
                }
                return Status.OK_STATUS;
            }
        };
        A.schedule();
        B.schedule();
        barrier.waitForStatus(5);
    }

    @Test
    public void testYieldPingPong() throws Throwable {
        Job conflictingJob;
        Job yieldJob;
        PathRule rule = new PathRule(this.testName);
        final Job[] jobs = new Job[2];
        jobs[0] = yieldJob = new Job(this.testName + " Yielding"){

            protected IStatus run(IProgressMonitor monitor) {
                Assert.assertNull((Object)jobs[1].getResult());
                while (this.yieldRule(null) == null) {
                }
                Assert.assertEquals((long)2L, (long)jobs[1].getState());
                return Status.OK_STATUS;
            }
        };
        yieldJob.setRule((ISchedulingRule)rule);
        jobs[1] = conflictingJob = new Job(this.testName + " ConflictingJob1"){

            protected IStatus run(IProgressMonitor monitor) {
                Assert.assertEquals((long)2L, (long)jobs[0].getState());
                while (this.yieldRule(null) == null) {
                }
                Assert.assertEquals((long)0L, (long)jobs[0].getState());
                return Status.OK_STATUS;
            }
        };
        conflictingJob.setRule((ISchedulingRule)rule);
        yieldJob.schedule();
        conflictingJob.schedule();
        this.waitForCompletion(yieldJob);
        IStatus yieldResult = yieldJob.getResult();
        if (!yieldResult.isOK()) {
            Throwable t = yieldResult.getException();
            if (t != null) {
                throw t;
            }
            throw new CoreException(yieldResult);
        }
        this.waitForCompletion(conflictingJob);
        Assert.assertTrue((String)conflictingJob.toString(), (boolean)conflictingJob.getResult().isOK());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Test
    public void testYieldPingPongBetweenMultipleJobs() throws Throwable {
        void var7_8;
        final TestBarrier2 barrier = new TestBarrier2();
        PathRule rule = new PathRule(this.testName);
        final Object SYNC = new Object();
        int count = 100;
        final Integer[] started = new Integer[]{0};
        final ArrayList<25> jobs = new ArrayList<25>();
        boolean bl = false;
        while (var7_8 < 100) {
            Job conflictingJob = new Job(this.testName + " ConflictingJob" + (int)var7_8){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected IStatus run(IProgressMonitor monitor) {
                    Object object = SYNC;
                    synchronized (object) {
                        started[0] = started[0] + 1;
                        SYNC.notifyAll();
                    }
                    barrier.waitForStatus(0);
                    while (this.yieldRule(null) == null) {
                        if (YieldTest.this.getFinishedJobs(jobs.toArray(new Job[jobs.size()])).size() != 99) continue;
                        System.out.println(String.valueOf((Object)this) + " Ended via no more jobs to yield");
                        break;
                    }
                    return Status.OK_STATUS;
                }
            };
            conflictingJob.setRule((ISchedulingRule)rule);
            jobs.add(conflictingJob);
            ++var7_8;
        }
        for (Job job : jobs) {
            job.schedule();
        }
        Object object = SYNC;
        synchronized (object) {
            while (started[0] != 100) {
                SYNC.wait();
            }
        }
        barrier.setStatus(0);
        this.waitForJobsCompletion(jobs.toArray(new Job[jobs.size()]), 5000);
        for (Job job : jobs) {
            Assert.assertNotNull((String)("Null result for " + String.valueOf(job)), (Object)job.getResult());
            Assert.assertTrue((boolean)job.getResult().isOK());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Test
    public void testParallelYieldPingPongBetweenMultipleJobs() throws Throwable {
        void var12_17;
        void var7_8;
        int count = 10;
        final TestBarrier2 barrier_A = new TestBarrier2();
        PathRule rule_A = new PathRule(this.testName + "_ruleA");
        final Object SYNC_A = new Object();
        final Integer[] started_A = new Integer[]{0};
        final ArrayList jobs_A = new ArrayList();
        boolean bl = false;
        while (var7_8 < 10) {
            Iterator conflictingJob = new Job(this.testName + " ConflictingJob_A_" + (int)var7_8){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected IStatus run(IProgressMonitor monitor) {
                    Object object = SYNC_A;
                    synchronized (object) {
                        started_A[0] = started_A[0] + 1;
                        SYNC_A.notifyAll();
                    }
                    barrier_A.waitForStatus(0);
                    while (this.yieldRule(null) == null) {
                        if (YieldTest.this.getFinishedJobs(jobs_A.toArray(new Job[jobs_A.size()])).size() != 9) continue;
                        System.out.println(String.valueOf((Object)this) + " Ended via no more jobs to yield");
                        break;
                    }
                    return Status.OK_STATUS;
                }
            };
            conflictingJob.setRule(rule_A);
            jobs_A.add(conflictingJob);
            ++var7_8;
        }
        for (Job job : jobs_A) {
            job.schedule();
        }
        Object object = SYNC_A;
        synchronized (object) {
            while (started_A[0] != 10) {
                SYNC_A.wait();
            }
        }
        barrier_A.setStatus(0);
        final TestBarrier2 testBarrier2 = new TestBarrier2();
        PathRule rule_B = new PathRule(this.testName + "_ruleB");
        final Object SYNC_B = new Object();
        final Integer[] started_B = new Integer[]{0};
        final ArrayList<27> jobs_B = new ArrayList<27>();
        boolean bl2 = false;
        while (var12_17 < 10) {
            Job conflictingJob = new Job(this.testName + " ConflictingJob_B_" + (int)var12_17){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected IStatus run(IProgressMonitor monitor) {
                    Object object = SYNC_B;
                    synchronized (object) {
                        started_B[0] = started_B[0] + 1;
                        SYNC_B.notifyAll();
                    }
                    testBarrier2.waitForStatus(0);
                    while (this.yieldRule(null) == null) {
                        if (YieldTest.this.getFinishedJobs(jobs_B.toArray(new Job[jobs_B.size()])).size() != 9) continue;
                        System.out.println(String.valueOf((Object)this) + " Ended via no more jobs to yield");
                        break;
                    }
                    return Status.OK_STATUS;
                }
            };
            conflictingJob.setRule((ISchedulingRule)rule_B);
            jobs_B.add(conflictingJob);
            ++var12_17;
        }
        for (Job job : jobs_B) {
            job.schedule();
        }
        Object object2 = SYNC_B;
        synchronized (object2) {
            while (started_B[0] != 10) {
                SYNC_B.wait();
            }
        }
        testBarrier2.setStatus(0);
        this.waitForJobsCompletion(jobs_A.toArray(new Job[jobs_A.size()]), 5000);
        this.waitForJobsCompletion(jobs_B.toArray(new Job[jobs_B.size()]), 5000);
        for (Job job : jobs_A) {
            Assert.assertNotNull((String)("Null result for " + String.valueOf(job)), (Object)job.getResult());
            Assert.assertTrue((boolean)job.getResult().isOK());
        }
        for (Job job : jobs_B) {
            Assert.assertNotNull((String)("Null result for " + String.valueOf(job)), (Object)job.getResult());
            Assert.assertTrue((boolean)job.getResult().isOK());
        }
    }

    @Test
    public void testYieldIsInterruptable() throws Exception {
        final Semaphore semaphoreA = new Semaphore(0);
        final Semaphore semaphoreB = new Semaphore(0);
        final Semaphore mainThreadSemaphore = new Semaphore(0);
        PathRule rule = new PathRule(this.testName);
        final String[] failureMessage = new String[1];
        final boolean[] operationWasCanceled = new boolean[1];
        final Job yieldB = new Job(this.testName + " YieldingB"){

            protected IStatus run(IProgressMonitor monitor) {
                semaphoreA.release();
                try {
                    semaphoreB.acquire();
                }
                catch (InterruptedException e) {
                    failureMessage[0] = "yieldB was interrupted too early";
                    return Status.OK_STATUS;
                }
                mainThreadSemaphore.release();
                return Status.OK_STATUS;
            }
        };
        Job yieldA = new Job(this.testName + " YieldingA"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    semaphoreA.acquire();
                }
                catch (InterruptedException e) {
                    failureMessage[0] = "yieldA was interrupted too early";
                    return Status.OK_STATUS;
                }
                Thread.currentThread().interrupt();
                try {
                    while (this.yieldRule(null) != yieldB) {
                    }
                }
                catch (OperationCanceledException e) {
                    operationWasCanceled[0] = true;
                }
                if (Thread.interrupted()) {
                    failureMessage[0] = "The thread was interrupted after yieldRule returned";
                }
                try {
                    semaphoreA.acquire();
                }
                catch (InterruptedException e) {
                    failureMessage[0] = "yieldA was interrupted too early";
                    return Status.OK_STATUS;
                }
                semaphoreB.release();
                mainThreadSemaphore.release();
                return Status.OK_STATUS;
            }
        };
        yieldA.setRule((ISchedulingRule)rule);
        yieldA.schedule();
        yieldB.setRule((ISchedulingRule)rule);
        yieldB.schedule();
        semaphoreA.release();
        mainThreadSemaphore.acquire(2);
        if (failureMessage[0] != null) {
            Assert.assertNull((String)failureMessage[0], (Object)failureMessage[0]);
        }
        Assert.assertTrue((String)"yieldRule should have thrown OperationCanceledException", (boolean)operationWasCanceled[0]);
    }

    @Test
    public void testYieldJobToJobsInterleaved() throws InterruptedException {
        final TestBarrier2 barrier = new TestBarrier2();
        PathRule rule = new PathRule(this.testName);
        int count = 50;
        Job yieldA = new Job(this.testName + " YieldingA"){

            protected IStatus run(IProgressMonitor monitor) {
                barrier.waitForStatus(1);
                int yields = 0;
                while (yields < 50) {
                    if (this.yieldRule(null) == null) continue;
                    ++yields;
                }
                return Status.OK_STATUS;
            }
        };
        yieldA.setRule((ISchedulingRule)rule);
        yieldA.schedule();
        Job yieldB = new Job(this.testName + " YieldingB"){

            protected IStatus run(IProgressMonitor monitor) {
                barrier.waitForStatus(1);
                int yields = 0;
                while (yields < 50) {
                    if (this.yieldRule(null) == null) continue;
                    ++yields;
                }
                return Status.OK_STATUS;
            }
        };
        yieldB.setRule((ISchedulingRule)rule);
        yieldB.schedule();
        barrier.setStatus(1);
        ArrayList<Job> jobs = new ArrayList<Job>();
        jobs.add(yieldA);
        jobs.add(yieldB);
        Thread.sleep(1000L);
        this.waitForJobsCompletion(jobs.toArray(new Job[jobs.size()]), 20000);
        for (Job conflict : jobs) {
            Assert.assertTrue((boolean)conflict.getResult().isOK());
        }
    }

    @Test
    public void testYieldThreadJobToBlockedConflictingJob() throws Exception {
        final PathRule rule = new PathRule(this.testName);
        final TestBarrier2 b = new TestBarrier2(1);
        Job yieldA = new Job(this.testName){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    Job.getJobManager().beginRule((ISchedulingRule)rule, monitor);
                    b.setStatus(3);
                    while (this.yieldRule(null) == null) {
                        if (!monitor.isCanceled()) continue;
                        break;
                    }
                }
                finally {
                    Job.getJobManager().endRule((ISchedulingRule)rule);
                }
                return Status.OK_STATUS;
            }
        };
        Job conflicting = new Job(this.testName + " Conflicting"){

            protected IStatus run(IProgressMonitor monitor) {
                return Status.OK_STATUS;
            }
        };
        conflicting.setRule((ISchedulingRule)rule);
        yieldA.schedule();
        b.waitForStatus(3);
        conflicting.schedule();
        try {
            this.waitForCompletion(yieldA);
            this.waitForCompletion(conflicting);
        }
        finally {
            yieldA.cancel();
        }
    }

    @Test
    public void testResumingThreadJobIsNotRescheduled() {
        final PathRule rule = new PathRule(this.testName);
        final TestBarrier2 b = new TestBarrier2(1);
        final Job yieldA = new Job(this.testName){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    Job.getJobManager().beginRule((ISchedulingRule)rule, monitor);
                    b.setStatus(3);
                    while (this.yieldRule(null) == null) {
                        if (!monitor.isCanceled()) continue;
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                }
                finally {
                    Job.getJobManager().endRule((ISchedulingRule)rule);
                }
                return Status.OK_STATUS;
            }
        };
        Job conflicting = new Job(this.testName + " Conflicting"){

            protected IStatus run(IProgressMonitor monitor) {
                return Status.OK_STATUS;
            }
        };
        conflicting.setRule((ISchedulingRule)rule);
        final int[] count = new int[1];
        JobChangeAdapter a = new JobChangeAdapter(){

            public void running(IJobChangeEvent event) {
                if (event.getJob() == yieldA) {
                    count[0] = count[0] + 1;
                }
            }
        };
        Job.getJobManager().addJobChangeListener((IJobChangeListener)a);
        yieldA.schedule();
        b.waitForStatus(3);
        conflicting.schedule();
        try {
            this.waitForCompletion(yieldA);
            this.waitForCompletion(conflicting);
            Assert.assertEquals((String)"While resuming from yieldRule, implicit Job should only run once", (long)1L, (long)count[0]);
        }
        finally {
            yieldA.cancel();
            Job.getJobManager().removeJobChangeListener((IJobChangeListener)a);
        }
    }

    @Test
    public void testNestedAcquireJobIsNotRescheduled() {
        PathRule rule = new PathRule(this.testName);
        final PathRule subRule = new PathRule(this.testName + "/subRule");
        final TestBarrier2 b = new TestBarrier2(1);
        Job yieldA = new Job(this.testName){

            protected IStatus run(IProgressMonitor monitor) {
                b.setStatus(3);
                try {
                    Job.getJobManager().beginRule((ISchedulingRule)subRule, null);
                    while (this.yieldRule(null) == null) {
                    }
                }
                finally {
                    Job.getJobManager().endRule((ISchedulingRule)subRule);
                }
                return Status.OK_STATUS;
            }
        };
        yieldA.setRule((ISchedulingRule)rule);
        final Job conflicting = new Job(this.testName + " Conflicting"){

            protected IStatus run(IProgressMonitor monitor) {
                return Status.OK_STATUS;
            }
        };
        conflicting.setRule((ISchedulingRule)rule);
        final int[] count = new int[1];
        JobChangeAdapter a = new JobChangeAdapter(){

            public void running(IJobChangeEvent event) {
                if (event.getJob() == conflicting) {
                    count[0] = count[0] + 1;
                }
            }
        };
        Job.getJobManager().addJobChangeListener((IJobChangeListener)a);
        try {
            yieldA.schedule();
            b.waitForStatus(3);
            conflicting.schedule();
            this.waitForCompletion(yieldA);
            this.waitForCompletion(conflicting);
            Assert.assertEquals((String)"While resuming from yieldRule, conflicting job should only run once", (long)1L, (long)count[0]);
        }
        finally {
            Job.getJobManager().removeJobChangeListener((IJobChangeListener)a);
        }
    }

    private List<Job> getFinishedJobs(Job[] jobs) {
        ArrayList<Job> joblist = new ArrayList<Job>(Arrays.asList(jobs));
        Iterator iterator = joblist.iterator();
        while (iterator.hasNext()) {
            Job job = (Job)iterator.next();
            if (job.getState() == 0) continue;
            iterator.remove();
        }
        return joblist;
    }

    private void waitForJobsCompletion(Job[] jobs, int waitTime) {
        ArrayList<Job> jobList = new ArrayList<Job>(Arrays.asList(jobs));
        int i = 0;
        int tickLength = 10;
        int ticks = waitTime / tickLength;
        while (!jobList.isEmpty()) {
            this.sleep(tickLength);
            if (i++ > ticks) {
                this.dumpState();
                Assert.assertTrue((String)"Timeout waiting for job to complete", (boolean)false);
            }
            Iterator iterator = jobList.iterator();
            while (iterator.hasNext()) {
                if (((Job)iterator.next()).getState() != 0) continue;
                iterator.remove();
            }
        }
    }

    class TestJobListener
    extends JobChangeAdapter {
        private final Set<Job> scheduled = Collections.synchronizedSet(new HashSet());

        TestJobListener() {
        }

        public void cancelAllJobs() {
            Job[] jobs;
            Job[] jobArray = jobs = this.scheduled.toArray(new Job[0]);
            int n = jobs.length;
            int n2 = 0;
            while (n2 < n) {
                Job job = jobArray[n2];
                job.cancel();
                ++n2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void done(IJobChangeEvent event) {
            YieldTest yieldTest = YieldTest.this;
            synchronized (yieldTest) {
                if (this.scheduled.remove(event.getJob())) {
                    ++YieldTest.this.completedJobs;
                    YieldTest.this.notify();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void scheduled(IJobChangeEvent event) {
            Job job = event.getJob();
            YieldTest yieldTest = YieldTest.this;
            synchronized (yieldTest) {
                if (job instanceof TestJob) {
                    ++YieldTest.this.scheduledJobs;
                    this.scheduled.add(job);
                }
            }
        }
    }
}

