/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.runtime.perf;

import java.util.HashMap;
import junit.framework.TestCase;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.tests.harness.PerformanceTestRunner;

public class BenchPath
extends TestCase {
    public BenchPath() {
    }

    public BenchPath(String testName) {
        super(testName);
    }

    public void testHash() {
        int REPEAT = 500000;
        final IPath[] paths = this.generateVariousPaths();
        final HashMap<IPath, String> map = new HashMap<IPath, String>(32);
        IPath[] iPathArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            IPath path = iPathArray[n2];
            map.put(path, "");
            ++n2;
        }
        final int numPaths = paths.length;
        new PerformanceTestRunner(){

            protected void test() {
                int p = 0;
                while (p < numPaths) {
                    map.get(paths[p]);
                    ++p;
                }
            }
        }.run((TestCase)this, 10, 500000);
    }

    public void testPathCreation() {
        int REPEAT = 50000;
        new PerformanceTestRunner(){

            protected void test() {
                IPath.fromOSString((String)"/");
                IPath.fromOSString((String)"/Foo");
                IPath.fromOSString((String)"/Foo/bar");
                IPath.fromOSString((String)"/Foo/bar/baz");
                IPath.fromOSString((String)"/Foo/bar/baz/blap");
                IPath.fromOSString((String)"/Foo/abc.txt");
                IPath.fromOSString((String)"/Foo/bar/abc.txt");
                IPath.fromOSString((String)"/Foo/bar/baz/abc.txt");
                IPath.fromOSString((String)"/Foo/bar/baz/blap/abc.txt");
                IPath.fromOSString((String)"/Foo/bar/abc.txt");
                IPath.fromOSString((String)"/Foo/bar/baz/abc.txt");
                IPath.fromOSString((String)"/Foo/bar/baz/blap/abc.txt");
                IPath.fromOSString((String)"/Foo/bar/baz/abc.txt");
                IPath.fromOSString((String)"/Foo/bar/baz/blap/abc.txt");
                IPath.fromOSString((String)"/Foo/bar/baz/abc.txt");
                IPath.fromOSString((String)"/Foo/bar/baz/blap/abc.txt");
                IPath.fromOSString((String)"/Foo/bar/baz/abc.txt");
                IPath.fromOSString((String)"/Foo/bar/baz/blap/abc.txt");
                IPath.fromOSString((String)"/Foo/bar/baz/blap/blam/abc.txt");
                IPath.fromOSString((String)"/Foo/bar/baz/blap/blam/blip/boop/abc.txt");
            }
        }.run((TestCase)this, 20, 50000);
    }

    public void testToOSString() {
        int REPEAT = 50000;
        final IPath[] paths = this.generateVariousPaths();
        new PerformanceTestRunner(){

            protected void test() {
                int p = paths.length;
                while (--p >= 0) {
                    paths[p].toOSString();
                }
            }
        }.run((TestCase)this, 10, 50000);
    }

    public void testToString() {
        int REPEAT = 50000;
        final IPath[] paths = this.generateVariousPaths();
        new PerformanceTestRunner(){

            protected void test() {
                int p = paths.length;
                while (--p >= 0) {
                    paths[p].toString();
                }
            }
        }.run((TestCase)this, 10, 50000);
    }

    private IPath[] generateVariousPaths() {
        IPath[] paths = new IPath[20];
        int i = 0;
        paths[i++] = IPath.fromOSString((String)"/");
        paths[i++] = IPath.fromOSString((String)"/Foo");
        paths[i++] = IPath.fromOSString((String)"/Foo/bar");
        paths[i++] = IPath.fromOSString((String)"/Foo/bar/baz");
        paths[i++] = IPath.fromOSString((String)"/Foo/bar/baz/blap");
        paths[i++] = IPath.fromOSString((String)"/Foo/abc.txt");
        paths[i++] = IPath.fromOSString((String)"/Foo/bar/abc.txt");
        paths[i++] = IPath.fromOSString((String)"/Foo/bar/baz/abc.txt");
        paths[i++] = IPath.fromOSString((String)"/Foo/bar/baz/blap/abc.txt");
        paths[i++] = IPath.fromOSString((String)"/Foo/bar/abc.txt");
        paths[i++] = IPath.fromOSString((String)"/Foo/bar/baz/abc.txt");
        paths[i++] = IPath.fromOSString((String)"/Foo/bar/baz/blap/abc.txt");
        paths[i++] = IPath.fromOSString((String)"/Foo/bar/baz/abc.txt");
        paths[i++] = IPath.fromOSString((String)"/Foo/bar/baz/blap/abc.txt");
        paths[i++] = IPath.fromOSString((String)"/Foo/bar/baz/abc.txt");
        paths[i++] = IPath.fromOSString((String)"/Foo/bar/baz/blap/abc.txt");
        paths[i++] = IPath.fromOSString((String)"/Foo/bar/baz/abc.txt");
        paths[i++] = IPath.fromOSString((String)"/Foo/bar/baz/blap/abc.txt");
        paths[i++] = IPath.fromOSString((String)"/Foo/bar/baz/blap/blam/abc.txt");
        paths[i++] = IPath.fromOSString((String)"/Foo/bar/baz/blap/blam/blip/boop/abc.txt");
        return paths;
    }
}

