/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.runtime.perf;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URL;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectArrayAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.eclipse.core.internal.content.ContentTypeHandler;
import org.eclipse.core.internal.content.Util;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.BinarySignatureDescriber;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.core.tests.harness.BundleTestingHelper;
import org.eclipse.core.tests.harness.FileSystemHelper;
import org.eclipse.core.tests.harness.PerformanceTestRunner;
import org.eclipse.core.tests.harness.TestRegistryChangeListener;
import org.eclipse.core.tests.runtime.RuntimeTestsPlugin;
import org.eclipse.core.tests.session.PerformanceSessionTestSuite;
import org.eclipse.core.tests.session.SessionTestSuite;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class ContentTypePerformanceTest
extends TestCase {
    private static final String CONTENT_TYPE_PREF_NODE = "org.eclipse.core.runtime/content-types";
    private static final String DEFAULT_NAME = "file_" + ContentTypePerformanceTest.class.getName();
    private static final int ELEMENTS_PER_LEVEL = 4;
    private static final int NUMBER_OF_LEVELS = 4;
    private static final String TEST_DATA_ID = "org.eclipse.core.tests.runtime.contenttype.perf.testdata";
    private static final int TOTAL_NUMBER_OF_ELEMENTS = ContentTypePerformanceTest.computeTotalTypes(4, 4);

    private static int computeTotalTypes(int levels, int elementsPerLevel) {
        double sum = 0.0;
        int i = 0;
        while (i <= levels) {
            sum += Math.pow(elementsPerLevel, i);
            ++i;
        }
        return (int)sum;
    }

    private static String createContentType(Writer writer, int number, String baseTypeId) throws IOException {
        String id = "performance" + number;
        String definition = ContentTypePerformanceTest.generateContentType(number, id, baseTypeId, new String[]{DEFAULT_NAME}, null);
        writer.write(definition);
        writer.write(System.lineSeparator());
        return id;
    }

    public static int createContentTypes(Writer writer, String baseTypeId, int created, int numberOfLevels, int nodesPerLevel) throws IOException {
        if (numberOfLevels == 0) {
            return 0;
        }
        int local = nodesPerLevel;
        int i = 0;
        while (i < nodesPerLevel) {
            String id = ContentTypePerformanceTest.createContentType(writer, created + i, baseTypeId);
            local += ContentTypePerformanceTest.createContentTypes(writer, id, created + local, numberOfLevels - 1, nodesPerLevel);
            ++i;
        }
        return local;
    }

    private static String generateContentType(int number, String id, String baseTypeId, String[] fileNames, String[] fileExtensions) {
        String fileNameList;
        StringBuilder result = new StringBuilder();
        result.append("<content-type id=\"");
        result.append(id);
        result.append("\" name=\"");
        result.append(id);
        result.append("\" ");
        if (baseTypeId != null) {
            result.append("base-type=\"");
            result.append(baseTypeId);
            result.append("\" ");
        }
        if ((fileNameList = Util.toListString((Object[])fileNames)) != null) {
            result.append("file-names=\"");
            result.append(fileNameList);
            result.append("\" ");
        }
        String fileExtensionsList = Util.toListString((Object[])fileExtensions);
        if (fileExtensions != null && fileExtensions.length > 0) {
            result.append("file-extensions=\"");
            result.append(fileExtensionsList);
            result.append("\" ");
        }
        result.append("describer=\"");
        result.append(BinarySignatureDescriber.class.getName());
        result.append(":");
        result.append(ContentTypePerformanceTest.getSignatureString(number));
        result.append("\"/>");
        return result.toString();
    }

    private static String getContentTypeId(int i) {
        return "org.eclipse.core.tests.runtime.contenttype.perf.testdata.performance" + i;
    }

    private static byte[] getSignature(int number) {
        byte[] result = new byte[4];
        int i = 0;
        while (i < result.length) {
            result[i] = (byte)((long)(number >> i * 8) & 0xFFL);
            ++i;
        }
        return result;
    }

    private static String getSignatureString(int number) {
        byte[] signature = ContentTypePerformanceTest.getSignature(number);
        StringBuilder result = new StringBuilder(signature.length * 3 - 1);
        byte[] byArray = signature;
        int n = signature.length;
        int n2 = 0;
        while (n2 < n) {
            byte element = byArray[n2];
            result.append(Integer.toHexString(0xFF & element));
            result.append(' ');
            ++n2;
        }
        result.deleteCharAt(result.length() - 1);
        return result.toString();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(ContentTypePerformanceTest.class.getName());
        SessionTestSuite setUp = new SessionTestSuite("org.eclipse.core.tests.runtime", "testDoSetUp");
        setUp.addTest((Test)new ContentTypePerformanceTest("testDoSetUp"));
        suite.addTest((Test)setUp);
        PerformanceSessionTestSuite singleRun = new PerformanceSessionTestSuite("org.eclipse.core.tests.runtime", 1, "singleSessionTests");
        singleRun.addTest((Test)new ContentTypePerformanceTest("testContentMatching"));
        singleRun.addTest((Test)new ContentTypePerformanceTest("testNameMatching"));
        singleRun.addTest((Test)new ContentTypePerformanceTest("testIsKindOf"));
        suite.addTest((Test)singleRun);
        PerformanceSessionTestSuite loadCatalog = new PerformanceSessionTestSuite("org.eclipse.core.tests.runtime", 10, "multipleSessionTests");
        loadCatalog.addTest((Test)new ContentTypePerformanceTest("testLoadCatalog"));
        suite.addTest((Test)loadCatalog);
        SessionTestSuite tearDown = new SessionTestSuite("org.eclipse.core.tests.runtime", "testDoTearDown");
        tearDown.addTest((Test)new ContentTypePerformanceTest("testDoTearDown"));
        suite.addTest((Test)tearDown);
        return suite;
    }

    public ContentTypePerformanceTest(String name) {
        super(name);
    }

    private int countTestContentTypes(IContentType[] all) {
        String namespace = "org.eclipse.core.tests.runtime.contenttype.perf.testdata.";
        int count = 0;
        IContentType[] iContentTypeArray = all;
        int n = all.length;
        int n2 = 0;
        while (n2 < n) {
            IContentType element = iContentTypeArray[n2];
            if (element.getId().startsWith(namespace)) {
                ++count;
            }
            ++n2;
        }
        return count;
    }

    public IPath getExtraPluginLocation() {
        return FileSystemHelper.getTempDir().append(TEST_DATA_ID);
    }

    private Bundle installContentTypes(String tag, int numberOfLevels, int nodesPerLevel) throws IOException, BundleException {
        TestRegistryChangeListener listener = new TestRegistryChangeListener("org.eclipse.core.runtime", "contentTypes", null, null);
        Bundle installed = null;
        listener.register();
        try {
            BufferedWriter writer;
            IPath pluginLocation = this.getExtraPluginLocation();
            ContentTypePerformanceTest.assertTrue((boolean)pluginLocation.toFile().mkdirs());
            ContentTypePerformanceTest.assertTrue((boolean)pluginLocation.append("META-INF").toFile().mkdirs());
            URL installURL = pluginLocation.toFile().toURI().toURL();
            String eol = System.lineSeparator();
            Throwable throwable = null;
            Object var10_12 = null;
            try {
                writer = new BufferedWriter(new FileWriter(pluginLocation.append("plugin.xml").toFile()), 65536);
                try {
                    writer.write("<plugin>");
                    writer.write(eol);
                    writer.write("<extension point=\"org.eclipse.core.runtime.contentTypes\">");
                    writer.write(eol);
                    String root = ContentTypePerformanceTest.createContentType(writer, 0, null);
                    ContentTypePerformanceTest.createContentTypes(writer, root, 1, numberOfLevels, nodesPerLevel);
                    writer.write("</extension></plugin>");
                }
                finally {
                    if (writer != null) {
                        ((Writer)writer).close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            throwable = null;
            var10_12 = null;
            try {
                writer = new BufferedWriter(new FileWriter(pluginLocation.append("META-INF").append("MANIFEST.MF").toFile()), 65536);
                try {
                    writer.write("Manifest-Version: 1.0");
                    writer.write(eol);
                    writer.write("Bundle-ManifestVersion: 2");
                    writer.write(eol);
                    writer.write("Bundle-Name: Content Type Performance Test Data");
                    writer.write(eol);
                    writer.write("Bundle-SymbolicName: org.eclipse.core.tests.runtime.contenttype.perf.testdata; singleton:=true");
                    writer.write(eol);
                    writer.write("Bundle-Version: 1.0\n");
                    writer.write("Require-Bundle: org.eclipse.core.tests.runtime");
                    writer.write(eol);
                }
                finally {
                    if (writer != null) {
                        ((Writer)writer).close();
                    }
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
            installed = RuntimeTestsPlugin.getContext().installBundle(installURL.toExternalForm());
            BundleTestingHelper.refreshPackages((BundleContext)RuntimeTestsPlugin.getContext(), (Bundle[])new Bundle[]{installed});
            ContentTypePerformanceTest.assertTrue((String)(tag + ".4.0"), (boolean)listener.eventReceived(10000L));
        }
        finally {
            listener.unregister();
        }
        return installed;
    }

    private void loadChildren() {
        IContentType[] allTypes;
        IContentTypeManager manager = Platform.getContentTypeManager();
        IContentType[] iContentTypeArray = allTypes = manager.getAllContentTypes();
        int n = allTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String[] fileExtensions;
            String[] fileNames;
            IContentType allType = iContentTypeArray[n2];
            String[] stringArray = fileNames = allType.getFileSpecs(6);
            int n3 = fileNames.length;
            int n4 = 0;
            while (n4 < n3) {
                String fileName = stringArray[n4];
                manager.findContentTypeFor(fileName);
                ++n4;
            }
            String[] stringArray2 = fileExtensions = allType.getFileSpecs(10);
            int n5 = fileExtensions.length;
            n3 = 0;
            while (n3 < n5) {
                String fileExtension = stringArray2[n3];
                manager.findContentTypeFor("anyname." + fileExtension);
                ++n3;
            }
            ++n2;
        }
    }

    private IContentTypeManager loadContentTypeManager() {
        Platform.getContentTypeManager().getContentType("org.eclipse.core.runtime.text");
        return Platform.getContentTypeManager();
    }

    private void loadDescribers() {
        IContentType[] allTypes;
        IContentTypeManager manager = Platform.getContentTypeManager();
        IContentType[] iContentTypeArray = allTypes = manager.getAllContentTypes();
        int n = allTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IContentType allType = iContentTypeArray[n2];
            ((ContentTypeHandler)allType).getTarget().getDescriber();
            ++n2;
        }
    }

    private void loadPreferences() {
        InstanceScope.INSTANCE.getNode(CONTENT_TYPE_PREF_NODE);
    }

    public void testContentMatching() {
        this.loadPreferences();
        final IContentTypeManager manager = this.loadContentTypeManager();
        this.loadDescribers();
        this.loadChildren();
        new PerformanceTestRunner(){

            protected void test() {
                int i = 0;
                while (i < TOTAL_NUMBER_OF_ELEMENTS) {
                    Object[] result;
                    String id = ContentTypePerformanceTest.getContentTypeId(i);
                    try {
                        result = manager.findContentTypesFor((InputStream)new ByteArrayInputStream(ContentTypePerformanceTest.getSignature(i)), DEFAULT_NAME);
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("unexpected exception occurred", e);
                    }
                    ((ObjectArrayAssert)Assertions.assertThat((Object[])result).as("content types for element " + i, new Object[0])).singleElement().satisfies(new ThrowingConsumer[]{it -> {
                        AbstractStringAssert abstractStringAssert = ((AbstractStringAssert)Assertions.assertThat((String)it.getId()).as("id", new Object[0])).isEqualTo(id);
                    }});
                    ++i;
                }
            }
        }.run((TestCase)this, 10, 2);
    }

    protected void setUp() throws Exception {
        super.setUp();
        if (this.getName().equals("testDoSetUp") || this.getName().equals("testDoTearDown")) {
            return;
        }
        Bundle installed = RuntimeTestsPlugin.getContext().installBundle(this.getExtraPluginLocation().toFile().toURI().toURL().toExternalForm());
        BundleTestingHelper.refreshPackages((BundleContext)RuntimeTestsPlugin.getContext(), (Bundle[])new Bundle[]{installed});
    }

    public void testDoSetUp() throws IOException, BundleException {
        this.installContentTypes("1.0", 4, 4);
    }

    public void testDoTearDown() {
        FileSystemHelper.clear((File)this.getExtraPluginLocation().toFile());
    }

    public void testIsKindOf() {
        this.loadPreferences();
        final IContentTypeManager manager = this.loadContentTypeManager();
        this.loadChildren();
        final IContentType root = manager.getContentType(ContentTypePerformanceTest.getContentTypeId(0));
        ContentTypePerformanceTest.assertNotNull((String)"2.0", (Object)root);
        new PerformanceTestRunner(){

            protected void test() {
                int i = 0;
                while (i < TOTAL_NUMBER_OF_ELEMENTS) {
                    IContentType type = manager.getContentType(ContentTypePerformanceTest.getContentTypeId(i));
                    ContentTypePerformanceTest.assertNotNull((String)("3.0." + i), (Object)type);
                    ContentTypePerformanceTest.assertTrue((String)("3.1." + i), (boolean)type.isKindOf(root));
                    ++i;
                }
            }
        }.run((TestCase)this, 10, 500);
    }

    public void testLoadCatalog() {
        this.loadPreferences();
        PerformanceTestRunner runner = new PerformanceTestRunner(){

            protected void test() {
                Platform.getContentTypeManager().getContentType("org.eclipse.core.runtime.text");
            }
        };
        runner.run((TestCase)this, 1, 1);
        ContentTypePerformanceTest.assertEquals((String)"missing content types", (int)TOTAL_NUMBER_OF_ELEMENTS, (int)this.countTestContentTypes(Platform.getContentTypeManager().getAllContentTypes()));
    }

    public void testNameMatching() {
        this.loadPreferences();
        final IContentTypeManager manager = this.loadContentTypeManager();
        this.loadDescribers();
        this.loadChildren();
        new PerformanceTestRunner(){

            protected void test() {
                IContentType[] associated = manager.findContentTypesFor("foo.txt");
                ContentTypePerformanceTest.assertTrue((String)"2.0", (associated.length >= 1 ? 1 : 0) != 0);
                ContentTypePerformanceTest.assertEquals((String)"2.1", (String)"org.eclipse.core.runtime.text", (String)associated[0].getId());
            }
        }.run((TestCase)this, 10, 200000);
    }
}

