/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.runtime.perf;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.UUID;
import junit.framework.TestCase;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.tests.harness.PerformanceTestRunner;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class PreferencePerformanceTest
extends TestCase {
    private static final int INNER_LOOP = 10000;
    private static final int KEYS_PER_NODE = 1000;

    public PreferencePerformanceTest() {
    }

    public PreferencePerformanceTest(String testName) {
        super(testName);
    }

    private String[][] getCommonPrefixKeys(int size, String prefix) {
        ArrayList<CallSite> keyList = new ArrayList<CallSite>();
        ArrayList<String> valueList = new ArrayList<String>();
        int i = 0;
        while (i < size) {
            keyList.add((CallSite)((Object)(prefix + "." + i + this.getUniqueString())));
            valueList.add(Integer.toString(i));
            ++i;
        }
        String[][] result = new String[][]{keyList.toArray(new String[keyList.size()]), valueList.toArray(new String[valueList.size()])};
        return result;
    }

    private IEclipsePreferences getScopeRoot() {
        return (IEclipsePreferences)Platform.getPreferencesService().getRootNode().node("test");
    }

    private String[][] getSequentialKeys(int size) {
        ArrayList<String> keyList = new ArrayList<String>();
        ArrayList<String> valueList = new ArrayList<String>();
        int i = 0;
        while (i < size) {
            keyList.add(Integer.toString(i));
            valueList.add(Integer.toString(i));
            ++i;
        }
        String[][] result = new String[][]{keyList.toArray(new String[keyList.size()]), valueList.toArray(new String[valueList.size()])};
        return result;
    }

    private String[][] getUniqueKeys(int size) {
        ArrayList<CallSite> keyList = new ArrayList<CallSite>();
        ArrayList<String> valueList = new ArrayList<String>();
        int i = 0;
        while (i < size) {
            keyList.add((CallSite)((Object)(i + this.getUniqueString())));
            valueList.add(Integer.toString(i));
            ++i;
        }
        String[][] result = new String[][]{keyList.toArray(new String[keyList.size()]), valueList.toArray(new String[valueList.size()])};
        return result;
    }

    public void testGetStringCommonPrefixKeys() {
        final String qualifier = this.getUniqueString();
        String[][] kvp = this.getCommonPrefixKeys(1000, qualifier);
        final String[] keys = kvp[0];
        final String[] values = kvp[1];
        PerformanceTestRunner runner = new PerformanceTestRunner(){
            Preferences prefs;

            protected void setUp() {
                this.prefs = PreferencePerformanceTest.this.getScopeRoot().node(qualifier);
                int i = 0;
                while (i < keys.length) {
                    this.prefs.put(keys[i], values[i]);
                    ++i;
                }
            }

            protected void tearDown() throws BackingStoreException {
                this.prefs.removeNode();
            }

            protected void test() {
                String[] stringArray = keys;
                int n = keys.length;
                int n2 = 0;
                while (n2 < n) {
                    String key = stringArray[n2];
                    this.prefs.get(key, null);
                    ++n2;
                }
            }
        };
        runner.setFingerprintName("Retrieve preference values");
        runner.run((TestCase)this, 10, 10000);
    }

    public void testGetStringMisses() {
        final String qualifier = this.getUniqueString();
        String[][] kvp = this.getUniqueKeys(1000);
        final String[] keys = kvp[0];
        final String[] values = kvp[1];
        final String[] missingKeys = this.getUniqueKeys(1000)[0];
        new PerformanceTestRunner(){
            Preferences prefs;

            protected void setUp() {
                this.prefs = PreferencePerformanceTest.this.getScopeRoot().node(qualifier);
                int i = 0;
                while (i < keys.length) {
                    this.prefs.put(keys[i], values[i]);
                    ++i;
                }
            }

            protected void tearDown() throws BackingStoreException {
                this.prefs.removeNode();
            }

            protected void test() {
                int i = 0;
                while (i < keys.length) {
                    this.prefs.get(missingKeys[i], null);
                    ++i;
                }
            }
        }.run((TestCase)this, 10, 10000);
    }

    public void testGetStringSequentialKeys() {
        final String qualifier = this.getUniqueString();
        String[][] kvp = this.getSequentialKeys(1000);
        final String[] keys = kvp[0];
        final String[] values = kvp[1];
        new PerformanceTestRunner(){
            Preferences prefs;

            protected void setUp() {
                this.prefs = PreferencePerformanceTest.this.getScopeRoot().node(qualifier);
                int i = 0;
                while (i < keys.length) {
                    this.prefs.put(keys[i], values[i]);
                    ++i;
                }
            }

            protected void tearDown() throws BackingStoreException {
                this.prefs.removeNode();
            }

            protected void test() {
                String[] stringArray = keys;
                int n = keys.length;
                int n2 = 0;
                while (n2 < n) {
                    String key = stringArray[n2];
                    this.prefs.get(key, null);
                    ++n2;
                }
            }
        }.run((TestCase)this, 10, 10000);
    }

    public void testGetStringUniqueKeys() {
        final String qualifier = this.getUniqueString();
        String[][] kvp = this.getUniqueKeys(1000);
        final String[] keys = kvp[0];
        final String[] values = kvp[1];
        new PerformanceTestRunner(){
            Preferences prefs;

            protected void setUp() {
                this.prefs = PreferencePerformanceTest.this.getScopeRoot().node(qualifier);
                int i = 0;
                while (i < keys.length) {
                    this.prefs.put(keys[i], values[i]);
                    ++i;
                }
            }

            protected void tearDown() throws BackingStoreException {
                this.prefs.removeNode();
            }

            protected void test() {
                String[] stringArray = keys;
                int n = keys.length;
                int n2 = 0;
                while (n2 < n) {
                    String key = stringArray[n2];
                    this.prefs.get(key, null);
                    ++n2;
                }
            }
        }.run((TestCase)this, 10, 10000);
    }

    public void testPutStringKeys() {
        final String qualifier = this.getUniqueString();
        ArrayList<CallSite> keyList = new ArrayList<CallSite>();
        ArrayList<String> valueList = new ArrayList<String>();
        int i = 0;
        while (i < 1000) {
            keyList.add((CallSite)((Object)(this.getUniqueString() + i)));
            valueList.add(Integer.toString(i));
            ++i;
        }
        final String[] keys = keyList.toArray(new String[keyList.size()]);
        final String[] values = valueList.toArray(new String[valueList.size()]);
        new PerformanceTestRunner(){
            Preferences prefs;

            protected void setUp() {
                this.prefs = PreferencePerformanceTest.this.getScopeRoot().node(qualifier);
            }

            protected void tearDown() throws BackingStoreException {
                this.prefs.removeNode();
            }

            protected void test() {
                int i = 0;
                while (i < keys.length) {
                    this.prefs.put(keys[i], values[i]);
                    ++i;
                }
            }
        }.run((TestCase)this, 10, 10000);
    }

    public void testRemoveStringKeys() {
        final String qualifier = this.getUniqueString();
        ArrayList<CallSite> keyList = new ArrayList<CallSite>();
        ArrayList<String> valueList = new ArrayList<String>();
        int i = 0;
        while (i < 1000) {
            keyList.add((CallSite)((Object)(this.getUniqueString() + i)));
            valueList.add(Integer.toString(i));
            ++i;
        }
        final String[] keys = keyList.toArray(new String[keyList.size()]);
        final String[] values = valueList.toArray(new String[valueList.size()]);
        new PerformanceTestRunner(){
            Preferences prefs;

            protected void setUp() {
                this.prefs = PreferencePerformanceTest.this.getScopeRoot().node(qualifier);
                int i = 0;
                while (i < keys.length) {
                    this.prefs.put(keys[i], values[i]);
                    ++i;
                }
            }

            protected void tearDown() throws BackingStoreException {
                this.prefs.removeNode();
            }

            protected void test() {
                String[] stringArray = keys;
                int n = keys.length;
                int n2 = 0;
                while (n2 < n) {
                    String key = stringArray[n2];
                    this.prefs.remove(key);
                    ++n2;
                }
            }
        }.run((TestCase)this, 50, 1);
    }

    private String getUniqueString() {
        return UUID.randomUUID().toString();
    }
}

